/*
 * include/chos.h
 * 
 * Choose-OS common definitions.
 *
 * Copyright (c) Tuomo Valkonen 1996-1998.
 */
#ifndef _CHOS_H
#define _CHOS_H

#ifndef __ASSEMBLY__

 #include <linux/major.h>
 
 // These should be somewhere standard...
 #define ulong	unsigned long
 #define uint	unsigned int
 #define ushort	unsigned short
 #define uchar	unsigned char
#endif


#define CHOS_MAJOR	0		// major			
#define CHOS_MINOR	84		// minor			
#define CHOS_VERSIONSTR	"0.84"		// as a string			

#define CHOS_BSECT	1
#define CHOS_LOADER	2
#define CHOS_MAPFILE	3
#define CHOS_MODULE(x)	((x)|0x10)

#define	PARTTABLE_OFF	446		// where partition table starts
#define BOOTSECT_VALID	0xAA55		// valid bootsector signature	

#define SECTORSIZE	512l

#define STAGE2SECTS	5		// changes needed if bigger

#define MAX_INITRD_SIZE	65535		// in sectors

// Boot image Types
//
#define BIT_UNKNOWN	0		// unknown = invalid
#define BIT_BOOTSECT	1		// boot sector	(DOS)  
#define BIT_LINUX	2		// Linux

// Devices
//
#define	MAJOR_FD	FLOPPY_MAJOR	// floppy major
#define MAJOR_HD	IDE0_MAJOR		// ide hd major
#ifndef SCSI_DISK0_MAJOR
 #define MAJOR_SD	SCSI_DISK_MAJOR // scsi hd major
#else
 #define MAJOR_SD	SCSI_DISK0_MAJOR// scsi hd major
#endif
#define MAJOR_XT	XT_DISK_MAJOR	// hmmm....
#define MAJOR_IDE1	IDE1_MAJOR		// second ide interface
#define MAJOR_IDE2	IDE2_MAJOR		// third ide interface
#define MAJOR_IDE3	IDE3_MAJOR		// third ide interface

#define INT13H_LOAD		0x2
#define INT13H_WRITE 	0x3
#define INT13H_RESET	0x0
#define INT13H_GEO		0x8

#ifndef __ASSEMBLY__
typedef struct{
	char	code[2];
	char	id[3];
	char	type;
	char	major,minor;
}ChosHeader;
#endif
#endif /* _CHOS_H */
