/* 
  (C) Nelson Murilo - 2000/09/18
  Version 0.4
  C port from chkproc.pl code from Klaus Steding-Jessen <jessen@nic.br>
  and Cristine Hoepers <cristine@nic.br> +little output changes.
*/
#if !defined(__linux__) && !defined(__FreeBSD__)
main (){ return 0; }
#else
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>

#define MAX_PROCESSES 65535
#define MAX_BUF 1024
#define PS "ps auxwww" 

int psproc [MAX_PROCESSES+1];
int dirproc[MAX_PROCESSES+1];

main(int argc, char **argv)
{
   char buf[MAX_BUF], *p;
   FILE *ps  = popen(PS, "r");
   DIR *proc = opendir("/proc");
   struct dirent *dir;
   int i, retps, retdir;
   int verbose = 0;

   if (!ps || !proc) 
   {
      perror("ps or proc");
      exit (1);
   }

   if (argc > 1 && !memcmp(argv[1], "-v", 2))
      verbose++;

   fgets(buf, MAX_BUF, ps); /* Skip header */
   if (!isalpha(*buf)) 
   {
     fprintf(stderr, "OooPS!\n");
     exit(2);
   }
   for (i = 1; i <= MAX_PROCESSES; i++) /* init matrix */
     psproc[i] = dirproc[i] = 0;

   while (fgets(buf, MAX_BUF, ps))
   {
      p = buf;
      while (*p != ' ') /* Skip USER */
          p++;
      while (*p == ' ') /* Skip spaces */
          p++;
      psproc[atol(p)]=1;   
   }
   pclose(ps);

   while (dir = readdir(proc))
   {
      if (!strcmp(dir->d_name, ".") || !strcmp(dir->d_name, "..") ||
         !isdigit(*dir->d_name))
         continue;
      dirproc[atol(dir->d_name)]=1;
   } 
   closedir(proc);

   /* Brute force */
   strcpy(buf, "/proc/");
   retps = retdir = 0;
   for (i = 1; i <= MAX_PROCESSES; i++)
   {
      snprintf(&buf[6], 6, "%d", i); 
      if (!chdir(buf))
      {
         if (!dirproc[i])
         {
            retdir++;
            if (verbose)
	       printf ("PID %5d: not in readdir output\n", i);
         }
         if (!psproc[i])
         {
            retps++;
            if (verbose)
	       printf ("PID %5d: not in ps output\n", i);
         }
      }
   }
   if (retdir)
      printf("You have % 5d process hidden for readdir command\n", retdir);
   if (retps)
      printf("You have % 5d process hidden for ps command\n", retps);
   return (retps+retps);
}
#endif
