#import "SimpleSound.h"

#import <OpenAL/al.h>
#import <OpenAL/alc.h>

static char hitSoundSamples[] = "/-+\037\327\331\332\351!\037\036\016\345\346\346\366\031\031\031\006\346\346\346\374\030\030\030\377\347\347\347\003\030\030\030\371\347\347\347\t\030\030\030\363\347\350\350\016\027\027\027\356\350\350\350\024\027\027\027\350\350\350\353\027\027\027\021\350\351\351\361\026\026\026\v\351\351\351\367\026\026\026\005\351\351\351\375\026\026\026\377\352\352\352\002\025\025\025\372\352\352\352\b\025\025\025\365\352\352\352\r\025\024\024\360\353\353\353\022\024\024\024\353\353\353\356\024\024\024\017\353\353\353\363\024\023\023\t\354\354\354\370\023\023\023\004\354\354\354\375\023\023\023\000\354\354\354\002\022\022\022\373\355\355\355\006\022\022\022\366\355\355\355\v\022\022\022\362\355\355\356\017\021\021\021\356\356\356\360\021\021\021\r\356\356\356\365\021\021\021\b\356\357\357\371\020\020\020\004\357\357\357\375\020\020\020\000\357\357\357\002\020\020\020\373\360\360\360\005\017\017\017\370\360\360\360\t\017\017\017\364\360\360\360\r\017\017\016\361\361\361\363\016\016\016\n\361\361\361\366\016\016\016\a\361\361\361\372\016\r\r\003\362\362\362\376\r\r\r\000\362\362\362\001\r\r\r\374\362\362\362\004\f\f\f\371\363\363\363\a\f\f\f\366\363\363\363\n\f\f\f\363\363\363\365\v\v\v\b\364\364\364\370\v\v\v\005\364\364\364\373\v\v\v\002\364\364\365\376\n\n\n\000\365\365\365\001\n\n\n\375\365\365\365\003\n\n\n\372\366\366\366\006\t\t\t\370\366\366\366\b\t\t\t\366\366\366\367\t\t\t\006\367\367\367\372\b\b\b\004\367\367\367\374\b\b\b\002\367\367\367\376\b\b\a\000\370\370\370\000\a\a\a\376\370\370\370\002\a\a\a\374\370\370\370\004\006\006\006\372\371\371\371\005\006\006\006\371\371\371\372\006\006\006\004\371\371\371\374\005\005\005\002\372\372\372\375\005\005\005\001\372\372\372\377\005\005\005\000\372\372\373\000\004\004\004\376\373\373\373\001\004\004\004\375\373\373\373\002\004\004\004\374\373\374\374\003\003\003\003\374\374\374\374\003\003\003\002\374\374\374\375\003\003\003\001\375\375\375\376\002\002\002\000\375\375\375\377\002\002\002\000\375\375\375\000\002\002\001\377\376\376\376\000\001\001\001\377\376\376\376\000\001\001\001\377\376\376\376\000\001\000\000\377\377\377\377\000\000\000\000\377\377\377\377\000\000";

static ALuint hitSoundBuffer, hitSoundSource;

@implementation SimpleSound

static void
LogErrors(void){
	ALenum alerr;
	while(alerr = alGetError())
		NSLog(@"OpenAL error 0x%X\n", alerr);
}

+ (void)initialize
{
	static BOOL done = FALSE;
	if(done) return;

	alGenBuffers(1, &hitSoundBuffer);
	alBufferData(hitSoundBuffer, AL_FORMAT_MONO16, hitSoundSamples, sizeof(hitSoundSamples)/sizeof(char), 11025);
	
	alGenSources(1, &hitSoundSource);
	alSourcei(hitSoundSource, AL_BUFFER, hitSoundBuffer);
	
	LogErrors();
	
	done = TRUE;
}

+ (void)playSoundWithVolume:(float)volume {
	alSourcef(hitSoundSource, AL_GAIN, volume);
	alSourcePlay(hitSoundSource);
	
	LogErrors();
}

@end
