/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999-2000 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include "all.h"

void HZenterLoop(void)
{
	XEvent report;
	/* get events, use first to display text and graphics */
	while (1)  {
		//if handwriting mode time expired
		if(!XPending(display) && hwmode == True){
			usleep(100);
			if(!flag_checked && expire_time(hw_timeout)){
                                //recognize now
				HZhwToEngineNewLine();
                                HZhwRecognize();
                                HZhwDrawPanel();
                                HZhwDrawWindow();
                                flag_checked = True;
                                record_time();
			}
			continue;
		}
		XNextEvent(display, &report);
		if (XFilterEvent(&report, None) == True) {
                	//fprintf(stderr, "window %ld\n",report.xany.window);
                	continue;
        	}
		switch  (report.type) {
		case Expose:
			/* get all other Expose events on the queue */
			while (XCheckTypedEvent(display, Expose, &report));
			if(dmode == HZSERVER_DMODE_ROOT){
				HZrootFlush();
			} else if(dmode == HZSERVER_DMODE_OVERSPOT){
				HZoverspotFlush();
			} else if(dmode == HZSERVER_DMODE_ONSPOT){
				HZonspotFlush();
			} else if(dmode == HZSERVER_DMODE_OFFSPOT){
				HZoffspotFlush();
			}
			if(hwmode == True){
				HZhwFlush();
			}
			//redraw virtual keypad, if mapped
			if(HZServer.hzVKwin.onflag){
				HZvkDrawPanel();
				HZvkDrawWindow();
			}
			break;

		/* it seems that no input is available.... but I think
		   one can add a hack to this, ... e.g. create a virtual
		   window and set focus to that window, send keypress event
		   to this window */

			break;
		case KeyPress:
			HZprocKey(report);	
			break;

		case ButtonPress:
			/* Left mouse button may drag the window or
			   press down a button on panel */
			if (report.xbutton.button == Button1)
			    HZprocLeftButton(report);

			/* Right mouse button popup virtual keyboard */
			else if(report.xbutton.button == Button3)
			    HZprocRightButton();
			break;


		case VisibilityNotify:
		case ConfigureNotify:

			//XRaiseWindow(display, window1);
			//XRaiseWindow(display, window4);
			//XRaiseWindow(display, window5);
			//XRaiseWindow(display, window6);
			break;

		case ClientMessage:
			if (report.xclient.message_type == hz_input_atom) {
				HZrecvInput(&report.xclient);
			} else if(report.xclient.message_type == 
				hz_query_atom){
				HZrecvQuery(&report.xclient);
			} else if(report.xclient.message_type 
				== hz_config_atom) {
				HZrecvConfig(&report.xclient);
			}
			break;
		case EnterNotify:
		case FocusIn:
			XRaiseWindow(display, window4);
			XRaiseWindow(display, window5);
			XRaiseWindow(display, window6);
			break;
		case MotionNotify:
			XRaiseWindow(display, window4);
			XRaiseWindow(display, window5);
			XRaiseWindow(display, window6);
			if(report.xmotion.window == window2)
				HZprocCandidateWindow(report.xmotion.x, report.xmotion.y);
			break;
		default:
			break;
		} /* end switch */
	} /* end while */

}

