/*
 * Cheops Network User Interface
 *
 * Copyright (C) 1999, Adtran, Inc.
 * 
 * Distributed under the terms of the GNU GPL
 *
 */

#include <gtk/gtk.h>
#include <netinet/in.h>
#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include "cheops.h"

/* We always want to be first */
static char *service = "aping";

static char *label = "Availability (Ping)";

struct ping_monitor {
	int level;		/* level of error we should report */
	struct net_page *np;	/* Page our object is on */
	struct net_object *no;	/* Pointer to the object we're monitoring */
};

GList *pingers = NULL;		/* List of who we will ping */

char *plugin_name() {
	return service;
}

char *plugin_label() {
	return label;
}

int plugin_type() {
	return TYPE_MONITOR;
}

int default_level() {
	return MONITOR_CRITICAL;
}

static void destroy(struct ping_monitor *hm)
{
	pingers = g_list_remove(pingers, hm);
	g_free(hm);
}

void ping_handler(struct net_object *no)
{
	/* We'll get the network code to call us when ping replies
	   come in */
	GList *l;
	struct ping_monitor *hm;
	l = pingers;
#if 0
	printf("Ping reply!\n");
#endif
	while(l) {
		hm =(struct ping_monitor *)(l->data);
		if (hm->no == no) {
			monitor_report(hm->no, hm->np, MONITOR_NOMINAL, service, "Nominal condition");
			break;
		}
		l = g_list_next(l);
	}
}

void monitor(struct net_object *no, int level, void **data, void *setupdata)
{
	struct ping_monitor *hm = (struct ping_monitor *)(*data);
	
	/* Ping is an unusual monitor because  there is no state, unlike
	   the tcp monitors.  We simply ask the network code to call our
	   ping callback (if we haven't already) and then send out
	   a ping by queuing int with init_scan_host. */
	
#if 0
	fprintf(stdout, "Monitoring PING!\n");
#endif
	if (!*data) {
		if (!ping_callback)
			ping_callback = ping_handler;
#if 0
		fprintf(stdout, "Making new monitor structure for %s\n", no->hostname);
#endif
		hm = g_new(struct ping_monitor, 1);
		hm->no = no;
		hm->np = no->np;
		*data = hm;
	}
	hm->level = level;
	
	pingers = g_list_append(pingers, hm);
	
	init_scan_host(no->ip_addr, no->np);
}

void cleanup(void **data)
{
	/* Here, we clean up our http_monitor structure and 
	   remove any pending inputs we had, since we are no longer
	   being asked to work */
	   
	struct ping_monitor *hm = (struct ping_monitor *)(*data);
	destroy(hm);
	*data = NULL;
#if 0
	fprintf(stdout, "Cleaned up!\n");
#endif
}

/* No setup info */

void timeout_callback(struct net_object *no, void **data, int expired)
{
	struct ping_monitor *hm = (struct ping_monitor *)(*data);
	/* Here we have a timeout */
#if 0
	fprintf(stdout, "Ping timeout!\n");
#endif
	monitor_report(no, no->np, hm->level, service, "Ping timeout");
	if (expired) {
#if 0
		fprintf(stderr, "Last acceptable failure!\n");
#endif
	}
}
