#ifndef __INPUT_H
#define __INPUT_H

#include "chinese.h"
#include "vga.h"

typedef struct {
  /* all system */
  CHAR _pbuf[MAX_READ_BUFFER];
  int _method;
  int _state;
  CHAR _f11buf[9] ;
  CHAR *_tokbuf;
  CHAR *_cachebuf;
  int _full:1;
  /* BIG 5 */
  int _parn;
  int _bakparn;
  int _par;
  /* Multitable */
  int _multi_init;
  MultipleTable *_nowtab;
  CHAR _buf[5];
  HITEMLIST *_hlist;
  int _starti;
  int _loc[10];
  int _ii;
  int _swap_input_method;
  /* Phone */
  int _key;
  int _mule;
  WORD _firstmatch;
  int _debug;
  int _lastspecial;
  int _chstate;
  int _color;
  char _grbuf[10];
  int _grpara[10];
  char _grnum;
  char _grstat;
} ConsoleSystemTable;

extern ConsoleSystemTable *nowconsole;
#define pbuf         (nowconsole->_pbuf)
#define method       (nowconsole->_method)
#define state        (nowconsole->_state)
#define f11buf       (nowconsole->_f11buf)
#define tokbuf       (nowconsole->_tokbuf)
#define cachebuf     (nowconsole->_cachebuf)
#define parn         (nowconsole->_parn)
#define bakparn      (nowconsole->_bakparn)
#define par          (nowconsole->_par)
#define nowtab       (nowconsole->_nowtab)
#define mbuf          (nowconsole->_buf)
#define hlist        (nowconsole->_hlist)
#define starti       (nowconsole->_starti)
#define mloc          (nowconsole->_loc)
#define ii           (nowconsole->_ii)
#define multi_init   (nowconsole->_multi_init)
#define swap_input_method (nowconsole->_swap_input_method)
#define isfull       (nowconsole->_full)
#define mkey         (nowconsole->_key)
#define firstmatch   (nowconsole->_firstmatch)
#define mule         (nowconsole->_mule)
#define debug        (nowconsole->_debug)
#define lastspecial  (nowconsole->_lastspecial)
#define chstate      (nowconsole->_chstate)
#define tmpcolor     (nowconsole->_color)
#define grbug        (nowconsole->_grbuf)
#define grpara       (nowconsole->_grpara)
#define grnum        (nowconsole->_grnum)
#define grstat       (nowconsole->_grstat)

static char *addfull(char *,char c);
void clear_inputmethod();
void clearslot_inputmethod();
#define TAG_X 19
#define ERROR_X 75
#define BIG5_0 0xa2af
#define BIG5_A 0xa2cf
extern FILE *debugfile;
void mark_inputmethod(char *);
int ch_input_status();


#define STATE_NORMAL 0
#define STATE_ESC  1
#define STATE_FN   2
#define STATE_F9   3
#define STATE_F10  4
#define STATE_F11  5
#define STATE_F12  6
#define STATE_FS1  7
#define STATE_FS2  8
#define STATE_FS3  14
#define STATE_SPEC1 10
#define STATE_SPEC2 11
#define STATE_SELE  12
#define STATE_CHCOMMAND 13
#define STATE_SWITCH_CONSOLE 15
#define STATE_DEBUG 16
#define STATE_DEBUG1 17
#define STATE_SETCOLOR0 18
#define STATE_SETCOLOR1 19
#define STATE_SETCOLOR2 20
#define STATE_SETCOLOR3 21
#define STATE_PROTECT   22
#define STATE_MACROKEY 23
#define STATE_METHOD 24
#define STATE_LINE 25
#define STATE_CIRCLE 26
#define STATE_PAINT 27


#define GR_NONE 0
#define GR_LINE 1
#define GR_RECTANGLE 2
#define GR_FILLREC 3
#define GR_CIRCLE 4
#define GR_ELLIPSE 5
#define GR_ARC 6
#define GR_PIE 7


int ch_read_from_buffer(CHAR *sbuf,CHAR *dbuf,int len);

/* macrokey.c */
void Init_macrokey();
char *add_macrokey(char *tok,char *buf);

#endif
