/* functions.m
 * Common Cenon functions
 *
 * Copyright (C) 1996-2003 by vhf interservice GmbH
 * Author:   Georg Fleischmann
 *
 * created:  1996-01-25
 * modified: 2003-05-14
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the vhf Public License as
 * published by vhf interservice GmbH. Among other things, the
 * License requires that the copyright notices and this notice
 * be preserved on all copies.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the vhf Public License for more details.
 *
 * You should have received a copy of the vhf Public License along
 * with this program; see the file LICENSE. If not, write to vhf.
 *
 * vhf interservice GmbH, Im Marxle 3, 72119 Altingen, Germany
 * eMail: info@vhf.de
 * http://www.vhf.de
 */

#include <AppKit/AppKit.h>
#include <VHFShared/types.h>
#include <VHFShared/vhfCommonFunctions.h>
#include <VHFShared/VHFDictionaryAdditions.h>
#include "functions.h"
#include "locations.h"

/* return library paths
 */
NSString *localLibrary(void)
{
#if defined(GNUSTEP_BASE_VERSION) || defined(__APPLE__)
    return [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSLocalDomainMask, YES) objectAtIndex:0]
            stringByAppendingPathComponent:APPNAME];
#else
    return LOCALLIBRARY;
#endif
}
NSString *userLibrary(void)
{
#if defined(GNUSTEP_BASE_VERSION) || defined(__APPLE__)
    return [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0]
            stringByAppendingPathComponent:APPNAME];
#else
    return [NSString stringWithFormat:@"%@%@", vhfHomeDirectory(), HOMELIBRARY];
#endif
}

NSString *localBundlePath(void)
{
#if defined(GNUSTEP_BASE_VERSION) || defined(__APPLE__)
    return [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSLocalDomainMask, YES) objectAtIndex:0]
            stringByAppendingPathComponent:BUNDLEFOLDER];
#else
    return [NSString stringWithFormat:@"/LocalLibrary/%@", BUNDLEFOLDER];
#endif
}
NSString *userBundlePath(void)
{
#if defined(GNUSTEP_BASE_VERSION) || defined(__APPLE__)
    return [[NSSearchPathForDirectoriesInDomains(NSLibraryDirectory, NSUserDomainMask, YES) objectAtIndex:0]
            stringByAppendingPathComponent:BUNDLEFOLDER];
#else
    return [NSString stringWithFormat:@"%@Library/%@", vhfHomeDirectory(), BUNDLEFOLDER];
#endif
}

/*
 * fill the device popup 'devicePopup' with menu cells
 * containing all devices ".dev" inside the appropriate folder ("Devices/xyz").
 * Search the folder 'path' in all possible directories.
 *
 * begin:    1993-01-17
 * modified: 2004-03-29
 *
 * popup	the popup button
 * folder	the folder
 * ext 		the extension of the files
 * removeIx     the index of the first item of the popuplist to be removed
 */
void fillPopup(NSPopUpButton *popup, NSString *folder, NSString *ext, int removeIx )
{   NSString		*path;
    int			i, j, cnt, selectedIx = [popup indexOfSelectedItem];
    NSFileManager	*defaultManager = [NSFileManager defaultManager];

    if (!folder)
    {	[popup setEnabled:NO];
        return;
    }

    /* remove entries from popup list, but keep items before removeIx */
    if (removeIx == 0)
        [popup removeAllItems];
    else
        while ( [popup numberOfItems] > removeIx )
            [popup removeItemAtIndex:[popup numberOfItems]-1];

    /* search the files in several directories
     * add devices in these folders to popup list
     */
    for (i=0;  ;i++)
    {	NSArray	*array;

        if (!i)		// application bundle
            path = [[NSBundle mainBundle] resourcePath];
        else if (i==1)	// local library
            path = localLibrary();
        else if (i==2)	// user local library
            path = userLibrary();
        else
            break;
        path = [path stringByAppendingFormat:@"/%@", folder];

        array = [defaultManager directoryContentsAtPath:path];
        cnt = [array count];
        for ( j=0; j<cnt; j++ )
        {   NSString	*name = [array objectAtIndex:j];

            if ( [name hasSuffix:ext] )
            {   NSString *title;

                title = [name substringToIndex:[name rangeOfString:ext].location];
                if ([popup indexOfItemWithTitle:title] < 0)
                  [popup addItemWithTitle:title];
            }
        }
    }
    sortPopup( popup, removeIx );

    /* enable popup list when having any entries */
    [popup setEnabled:([popup numberOfItems]) ? YES : NO];
    if ( [popup numberOfItems] > selectedIx )
        [popup selectItemAtIndex:selectedIx];
}

NSDictionary *dictionaryFromFolder(NSString *folder, NSString *name)
{   NSDictionary	*dict;
    int			i;

    for (i=0;  ;i++)
    {   NSString	*path;

        if (!i)		// application directory
            path = [[NSBundle mainBundle] bundlePath];
        else if (i==1)	// local library
            path = localLibrary();
        else if (i==2)	// user local library
            path = userLibrary();
        else
            break;
        path = [path stringByAppendingFormat:@"/%@/%@", folder, name];

        if ( (dict = [NSDictionary dictionaryWithContentsOfFile:path]) )
            return dict;
    }

    return nil;
}


/*
 * converts a value from internal unit (1/72 inch) to the current unit
 */
float convertToUnit(float value)
{
    switch ( [[NSUserDefaults standardUserDefaults] integerForKey:@"unit"] )
    {
        case UNIT_MM:		return (value*25.4/72.0);
        case UNIT_INCH:		return (value / 72.0);
        case UNIT_POINT:	return value;
    }
    return value;
}

/*
 * converts a value from the current unit to internal unit (1/72 inch)
 */
float convertFromUnit(float value)
{
    switch ( [[NSUserDefaults standardUserDefaults] integerForKey:@"unit"] )
    {
        case UNIT_MM:		return (value/25.4*72.0);
        case UNIT_INCH:		return (value * 72.0);
        case UNIT_POINT:	return value;
    }
    return value;
}

/*
 * converts a value from mm to the current unit
 */
float convertMMToUnit(float value)
{
    switch ( [[NSUserDefaults standardUserDefaults] integerForKey:@"unit"] )
    {
        case UNIT_MM:		return value;
        case UNIT_INCH:		return value / 25.4;
        case UNIT_POINT:	return value*72.0/25.4;
    }
    return value;
}

/*
 * converts a value from the current unit to mm
 */
float convertUnitToMM(float value)
{
    switch ( [[NSUserDefaults standardUserDefaults] integerForKey:@"unit"] )
    {
        case UNIT_MM:		return value;
        case UNIT_INCH:		return value * 25.4;
        case UNIT_POINT:	return value/72.0*25.4;
    }
    return value;
}

/* color/string functions
 */
NSString *vhfStringFromRGBColor(NSColor *color)
{
    if (![[color colorSpaceName] isEqualToString:NSCalibratedRGBColorSpace])
        color = [color colorUsingColorSpaceName:NSCalibratedRGBColorSpace];
    return [NSString stringWithFormat:@"%.3f %.3f %.3f", [color redComponent], [color greenComponent], [color blueComponent]];
}
NSColor *vhfRGBColorFromString(NSString *string)
{   NSScanner	*scanner;
    float	r, g, b;

    if (!string)
    {   NSLog(@"vhfRGBColorFromString(): string != nil expected !");
        return nil;
    }
    scanner = [NSScanner scannerWithString:string];
    [scanner scanFloat:&r];
    [scanner scanFloat:&g];
    [scanner scanFloat:&b];
    return [NSColor colorWithCalibratedRed:r green:g blue:b alpha:1.0];
}
