#
# 	Initialisation de l'environnement TCL pour Cecilia
# 	(c) 1995-7 Alexandre Burton & Jean Piche
# 	v. 1.80a (10/08/97)
#
#       EDITED BY Hans-Christoph Steiner <hans@eds.org>
#       $Id $

proc doCecilia {argv} { 
    wm withdraw .

    
    global ceclib user homedir  tcl_platform helpLine set internal tkrefLine\
	    CSversion env color submodules  prefs modir graphidx longnom scorerefLine\
	    couleur path  tcl_precision limite classNewId tableSize nchnls \
	    oplist tklist inserterOrc inserterSco inserterTk son soundWriteName \
	    module currentdir  midifile soundName click soundOutInfo fDat dafold \
	    nomModuleCourrant lastvalue showconsole refLine dpi _db cfont windowNames \
	    opsDatabase refHelp mod
	    
    ###

    set ceclib [file join [file nativename $ceclib] files]
    set env(TEMP) [file join $env(HOME) files Scratch]

    set _db(menu,id)         0
    set _db(csound,main)     100
    set _db(cecilia,V)       20.00
    set _db(html)            html
    set _db(cecilia,rev)     .5
    set _db(cecilia,version) "Cecilia 2.0$_db(cecilia,rev) for $tcl_platform(os) (running on $tcl_platform(osVersion))"    
	set CSversion "Cecilia 2.0$_db(cecilia,rev) for $tcl_platform(os) ($tcl_platform(osVersion))"
    set _db(undo,disable)    0
    set _db(sound,previous)  {}
    
    if [info exists env(USER)] {set user $env(USER)} {set user user}
    set homedir $env(HOME)
    
    wm title . $_db(cecilia,version)
    wm protocol . WM_DELETE_WINDOW quitte
    
    initPrefs
        
    if {$tcl_platform(platform) == "windows"} {acquireSHARC}
    
    bug loading images:
    foreach im {
    	
    		stop play edi cycle dump closebox
    		sines square  drunks rand  scatt
    		up1  down1 comp normal
    		cut copy paste reset imp exp
    		
    	} {
		modebug "loading image:"  $im
		image create photo $im -file [file join $ceclib graphics $dpi $im.gif]
    }      
    
    switch -- $tcl_platform(os) {
		    "IRIX" {

		    set _db(mod,a) Alt
			set prefs(cecfont)  "small-font"
			if {$prefs(cecfont) == "small-font"} {
			    set cfont(big) {-adobe-helvetica-bold-o-*-*-14-*-75-75-*-*-*-*}
			    set cfont(small) {-*-helvetica-bold-o-normal--11-*-*-*-*-*-*-*}
			} else {
			    set cfont(big) {-adobe-helvetica-bold-o-*-*-18-*-75-75-*-*-*-*}
			    set cfont(small) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}
			}

			option add *background        			${color}2

			option add *Button*background 			${color}3
	    		option add *Checkbutton*background 		${color}2
	    		option add *Radiobutton*background 		${color}2
	    		option add *Menubutton*background 		${color}3
			option add *Menu*background        		${color}2

			option add *Button*BorderWidth	  		3
			option add *Checkbutton*BorderWidth	  	2
			option add *Radiobutton*BorderWidth	  	3
			option add *Menubutton*BorderWidth	  	3

			option add *Button*activeBackground		${color}4
	    		option add *Checkbutton*activeBackground 	${color}2
	    		option add *Radiobutton*activeBackground 	${color}2
	    		option add *Menubutton*activeBackground 	${color}4
			option add *Menu*activeBackground       	${color}3

			option add *Button*disabledForeground		gray50
	    		option add *Checkbutton*disabledForeground 	gray50
	    		option add *Radiobutton*disabledForeground 	gray50
	    		option add *Menubutton*disabledForeground 	gray50
			option add *Menu*disabledForeground       	gray50

			option add *Button*font				$cfont(small)
			option add *HighlightThickness			0
			option add *font              			$cfont(small)
			option add *Message*font      			$cfont(big)
			option add *Listbox*font      			$cfont(big)
			option add *Entry*font        			$cfont(big)
			option add *Entry*background        		${color}1
			option add *Label*font        			$cfont(small)
			option add *Menu*font        			$cfont(big)
			option add *Scale*troughColor        		gray75

			option add *Text*selectBackground        	gray25
			option add *Text*selectForeground        	gray75
			option add *Text*selectBorderWidth       	0


		    }
		    "Linux" {

		    set _db(mod,a) Control
			set prefs(cecfont)  "small-font"
			if {$prefs(cecfont) == "small-font"} {
			    set cfont(big) "-*-helvetica-bold-r-normal--10-*-*-*-*-*-*-*"
			    set cfont(small) "-*-helvetica-medium-r-normal--10-*-*-*-*-*-*-*"
			} else {
			    set cfont(big) {-adobe-helvetica-bold-o-*-*-18-*-75-75-*-*-*-*}
			    set cfont(small) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}
			}
			
			set cfont(man) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}			
			option add *background        			${color}2

			option add *Button*background 			${color}3
	    		option add *Checkbutton*background 		${color}2
	    		option add *Radiobutton*background 		${color}2
	    		option add *Menubutton*background 		${color}3
			option add *Menu*background        		${color}2

			option add *Button*BorderWidth	  		2
			option add *Checkbutton*BorderWidth	  	2
			option add *Radiobutton*BorderWidth	  	2
			option add *Menubutton*BorderWidth	  	2

			option add *Button*activeBackground		${color}4
	    		option add *Checkbutton*activeBackground 	${color}4
	    		option add *Radiobutton*activeBackground 	${color}4
	    		option add *Menubutton*activeBackground 	${color}4
			option add *Menu*activeBackground       	${color}3

			option add *Button*font				$cfont(small) 
			option add *HighlightThickness			0
			option add *font              			"helvetica 10"
			option add *Message*font      			"helvetica 10 bold"
			option add *Listbox*font      			"courrier 10"
			option add *Entry*font        			"courrier 10"
			option add *Entry*background        		${color}1
			option add *Label*font        			$cfont(small)
			option add *Menu*font        			"$cfont(big)"
			option add *Scale*troughColor        		gray75

			option add *Text*selectBackground        	gray25
			option add *Text*selectForeground        	gray75
			option add *Text*selectBorderWidth       	0

		}
	        "Darwin" {

		    set _db(mod,a) Control
			set prefs(cecfont)  "small-font"
			if {$prefs(cecfont) == "small-font"} {
			    set cfont(big) "-*-helvetica-bold-r-normal--10-*-*-*-*-*-*-*"
			    set cfont(small) "-*-helvetica-medium-r-normal--10-*-*-*-*-*-*-*"
			} else {
			    set cfont(big) {-adobe-helvetica-bold-o-*-*-18-*-75-75-*-*-*-*}
			    set cfont(small) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}
			}
			
			set cfont(man) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}			
			option add *background        			${color}2

			option add *Button*background 			${color}3
	    		option add *Checkbutton*background 		${color}2
	    		option add *Radiobutton*background 		${color}2
	    		option add *Menubutton*background 		${color}3
			option add *Menu*background        		${color}2

			option add *Button*BorderWidth	  		2
			option add *Checkbutton*BorderWidth	  	2
			option add *Radiobutton*BorderWidth	  	2
			option add *Menubutton*BorderWidth	  	2

			option add *Button*activeBackground		${color}4
	    		option add *Checkbutton*activeBackground 	${color}4
	    		option add *Radiobutton*activeBackground 	${color}4
	    		option add *Menubutton*activeBackground 	${color}4
			option add *Menu*activeBackground       	${color}3

			option add *Button*font				$cfont(small) 
			option add *HighlightThickness			0
			option add *font              			"helvetica 10"
			option add *Message*font      			"helvetica 10 bold"
			option add *Listbox*font      			"courrier 10"
			option add *Entry*font        			"courrier 10"
			option add *Entry*background        		${color}1
			option add *Label*font        			$cfont(small)
			option add *Menu*font        			"$cfont(big)"
			option add *Scale*troughColor        		gray75

			option add *Text*selectBackground        	gray25
			option add *Text*selectForeground        	gray75
			option add *Text*selectBorderWidth       	0

		}
		
		    "MacOS" {
   	
		    set _db(mod,a) Command
			set prefs(cecfont)  "small-font"
			if {$prefs(cecfont) == "small-font"} {
			    set cfont(big) "Chicago 12"
			    set cfont(small) "geneva 9"
			} else {
			    set cfont(big) "Chicago 12"
			    set cfont(small) "geneva 9"
			}
			
		    if $prefs(override,looks) {
#			set cfont(man) {-*-helvetica-bold-o-normal--14-*-*-*-*-*-*-*}			
			option add *Frame*background        			${color}2

			option add *Toplevel*background 			${color}1
			option add *Button*background 			${color}2
	    	option add *Checkbutton*background 		${color}2
	    	option add *Radiobutton*background 		${color}2
#    		option add *Menubutton*background 		${color}2
#			option add *Menu*background        		${color}2

			option add *Button*BorderWidth	  		2
			option add *Checkbutton*BorderWidth	  	2
			option add *Radiobutton*BorderWidth	  	2
			option add *Menubutton*BorderWidth	  	2

			option add *Button*activeBackground		${color}4
	    	option add *Checkbutton*activeBackground 	${color}4
	    	option add *Radiobutton*activeBackground 	${color}4
#    		option add *Menubutton*activeBackground 	${color}4
#			option add *Menu*activeBackground       	${color}3

			option add *Button*font				$cfont(small) 
			option add *HighlightThickness			0
#			option add *font              			"geneva 9"
			option add *Checkbutton*font              "geneva 9"
			option add *Radiobutton*font              "geneva 9"
			option add *Message*font      			"geneva 9"
			option add *Listbox*font      			"monaco 9"
			option add *Entry*font        			"monaco 9"
			option add *Entry*background        		${color}1
			option add *Label*font        			$cfont(small)
#			option add *Menu*font        			"$cfont(big)"
			option add *Scale*troughColor        		gray75

			option add *Text*selectBackground        	gray25
			option add *Text*selectForeground        	gray75
			option add *Text*selectBorderWidth       	0

		    }
		    }
		   }
		   
	   
	  

    array set windowNames {
	.first "Welcome to Cecilia"
	.pre Grapher
	.edit Editor
	.csound-reference "Csound Manual"
	.help "Cecilia Help"
	. Main
	.win Tools
	.vslide "Vertical Sliders"
	.inserter "Code inserter"
	.scatt "Scatter params"
	.noise "Noise params"
	.drunk "DrunkWalk params"
	.sine "Sine params"
	.saw "Waveform params"
	.comp "Compression params"
	.norm "Normalize params"
	.fileselect "File selector"
     }
    
    set graphidx 0
    set longnom 0
    set typeList(cec_irateSlider) {}

    array set couleur {
	
	1   \#20DD00	2   \#0000FF  3   \#FFA500		
	4   \#008b00	5   \#FF00FF  6   \#CD3700	    
	7   \#68228b	8   \#00688b  9   \#2f4f4f
	10  \#cd1076	11  \#8b6914  12  \#458b74
	13  \#8b4513	14  \#4169e1  15  \#8b7d6b
	16  \#000080	17  \#7cfc00  18  \#483d8b
	19  \#ffd700	20  \#838b8b  21  \#8b1a1a
	22  \#7FFF00	23  \#8b2323  24  \#8b7355
	25  \#458b74	26  \#fa8072  27  \#8b3e2f
	28  \#008b8b	29  \#458b00  30  \#a020f0
	
	current \#000000	active  \#000000
	fg	\#FFFFFF	kill    \#FF0000
	
    }
    
    array set helpLine {
    
        bReset          "Resets the Analog driver"
        bRewind         "Rewinds the event file"
        bStop           "Stops the performance (esc)"
        bPause          "Pauses the performance (spacebar)"
        bPlay           "Initiates (or continues) the performance (spacebar)"
        bCue            "Cues for performance and waits for signal"

        LPrefPath       "Path or creator code of this helper"
        LPrefFolder     "Path of this directory"
        bPrefSet        "Click to set this helper"
        LPrefPLAY       "Favorite soundfile player"
        LPrefEDIT       "Favorite soundfile editor"
        LPrefTEXT       "Favorite text editor"
        LPrefCSND       "Csound binary to use with Cecilia"
        LPrefHTML       "Favorite HTML viewer"
        LPrefMIDI       "Favorite MIDI editor"
        LPrefCONV       "Favorite soundfile converter"
        LPrefSFDIR      "Where to put output soundfiles"
        LPrefSADIR      "Where to put (and look for) analysis files"
        LPrefSSDIR      "Where to look for input soundfiles"
        LPrefMODIR      "Where to look for user-defined modules"
        LPrefTMPDIR     "Where to put temporary files"
        LPrefCOL        "Set the base color for Cecilia"
        bPrefSync       "Click to sync folders to environment variables (when defined)"
        bPrefCancel     "Click to close the window without saving changes"
        bPrefOK         "Click to save any changes (tagged blue) and close the window"
        bPrefKeys       "Change key shortcuts for Play-Stop-Pause"
        bPrefCol        "Choose Cecilia color scheme"

        LWinModule      "Information about the current module"
        LWinNoModule    "Use the File/New... submenu to load a module"
        LWinOut         "Information about the soundfile to be written"
        tWinOutRMode    "Selects DAC output"
        tWinOutDMode    "Selects disk output"
        LWinOutSpk      "Highlights when realtime DAC is enabled"
        LWinOutName     "Name of the soundfile to be written"
        LWinOutDur      "Duration, in seconds, of the written soundfile"
        oWinOutSR       "Sampling rate of the soundfile to be written"
        oWinOutKR       "Control rate of the orchestra"
        oWinOutKSM      "Samples per control iteration of the orchestra"
        oWinOutGEN      "Size of Cecilia-generated GEN functions"
        LWinOutAmp      "Amplitude Information about the written soundfile"
        rWinOutChn      "Number of output channels in the orchestra"

        bWinEdit        "Opens the soundfile with the chosen editor"
        bWinPlay        "Plays the soundfile with the chosen player"
        bWinSend        "Sets the last output file as input file"

        LWinIn          "Information about the input file(s)"
        LWinInInfo      "Information about the file"
        bWinInSelect    "Selects a soundfile for input"
        sWinOffset      "Offsets the beggining of the soundfile"

        LWinHelp        "Super-usefull information appears here..."

        cArea           "Graph edition area (B1 to create point; B3 to delete)"
        sScrollX        "Adjusts the X-view"
        sScrollY        "Adjusts the Y-view"
        sZoomX          "Zooms the X-axis (clumsy)"
        sZoomY          "Zooms the Y-axis (clumsy)"
        sRealtime       "Realtime control of the parameter"
        bGraphMode      "Toggles the parameter between graph and slider modes"
        bGraphSelect    "Select the control parameter for edition"
        bGraphCheck     "Toggles the graph visibility on and off"
        bGraphRtslider  "Send realtime control data to Extended Csound"
        bGraphUtils     "Adjusts the grid intensity"
        bGraphSlider    "Adjusts the init parameter"
        bGraphTools     "Toolbar for graph data processings"

        bEditSelect     "Toggles the associated panel visibility on and off"
        bEditEdit       "Text editing area"
        bEditView       "Text viewing area"
        bEditHandle     "Drag to resize viewing/editing area"

        bToolsDrunk     "Generates a drunk walk (right-button for parameters)"
        bToolsSquare    "Generates various waveforms (right-button for parameters)"
        bToolsRand      "Generates noise (right-button for parameters)"
        bToolsSines     "Generates sine waves (right-button for parameters)"
        bToolsScatt     "Scatters the selected graph (right-button for parameters)"
        bToolsNormal    "Normalizes/amplifies selected graph (right-button for parameters)"
        bToolsComp      "Compresses the selected graph (right-button for parameters)"
        bToolsCopy      "Copies the selected graph to the graph clipboard"
        bToolsCut       "Cuts the selected graph to the graph clipboard"
        bToolsPaste     "Pastes the clipboard onto the selected graph"
        bToolsReset     "Resets the selected graph to it's initial values"
        bToolsImp       "Imports a graph file (text) onto the selected graph"
        bToolsExp       "Exports the selected graph to a graph file (text)"
        bToolsUp1       "Nodges the selected graph up one pixel"
        bToolsDown1     "Nodges the selected graph down one pixel"

    }

    set path(win)   	.top
  #   set path(winNom)    $path(win).nom
    set path(winModule)    $path(win).module
    set path(winPrev)    $path(win).prev
    set path(trans)    	$path(win).trans
    set path(winIn)     $path(win).sin
    set path(winOut)    $path(win).sout
    set path(winOutNom) $path(winOut).output.field
    set path(winOutDUR) $path(winOut).output.dur
    set path(winOutSR)  $path(winOut).rates.sr
    set path(winOutKR) $path(winOut).rates.kr
    set path(winOutKSM) $path(winOut).rates.ksm
    set path(winOutGEN) $path(winOut).rates.gen
    set path(winOutAmp) $path(winOut).amps.samps
    set path(winHelp)   	$path(win).help.l

    set path(edit)	.edit
    set path(editHelp)   	$path(edit).help.l

    set path(graphHelp)   	.pre.help.l
    set path(prefs)         .preferences
    set path(prefHelp)       $path(prefs).help.l

    set path(top)	.pre.grap
    set path(gauche)    $path(top).gauche
    set path(droit)	$path(top).droit
    set path(bas)	$path(droit).bas
    set path(canvas)    $path(droit).canvas
    set path(rulerY)    $path(canvas).rulerY
    set path(rulerX)    $path(canvas).rulerX
    set path(scrollY)   $path(canvas).scrollY
    set path(scrollX)   $path(canvas).scrollX
    set path(area)      $path(canvas).area
    set path(hsli)      $path(bas).hsli
	set path(midi)      $path(hsli)
    set path(vsli)      .vslide.vsli
    set path(opti)      $path(bas).opti
    set path(togli)     $path(bas).togli
    set path(toggleopt) $path(togli).opt
    set path(toggleval) $path(togli).val
    set path(optionnam) $path(opti).nam
    set path(optionopt) $path(opti).opt
    set path(optionval) $path(opti).val
    set path(hsliopt)   $path(hsli).opt
    set path(hslinam)   $path(hsli).nam
    set path(hslisca)   $path(hsli).sca
    set path(hslival)   $path(hsli).val
    set path(hsliuni)   $path(hsli).uni
    set path(vsliopt)   $path(vsli).opt
    set path(vslinam)   $path(vsli).nam
    set path(vslival)   $path(vsli).val
    set path(vslisca)   $path(vsli).sca
    set path(vsliuni)   $path(vsli).uni
    set path(param)	$path(gauche).param
    set path(coor)	$path(gauche).coor
    set path(zoomX)	$path(gauche).zzz.a.x
    set path(zoomY)	$path(gauche).zzz.b.y
    set path(colorX)    $path(gauche).sss.a.x
    set path(colorY)    $path(gauche).sss.b.y
    set path(colorP)    $path(gauche).sss.c.p
    
    
    set limite(pad) 5
    set tableSize 8192
	
    array set nchnls { 1 mono 2 stereo 4 quad monaural 1 monoral 1 mono 1 stereo 2 quad 4 }
    
########Opcode database

    set opset [read [open [file join $ceclib doc ref.db] r]]
    array set opsDatabase $opset
#    set refLine(cec_graph) "quickref: ffgg"
#    set refHelp(cec_graph) [lindex $opsDatabase(cec_graph) 3]

    	foreach op [array names opsDatabase] {
		set opcode [lindex $opsDatabase($op) 0]
	    if [regexp ^\[0-9\] $opcode] {
		set scorerefLine($opcode) "quickref:   [lindex $opsDatabase($op) 1] $opcode [lindex $opsDatabase($op) 2]"
		set refHelp($opcode) [lindex $opsDatabase($op) 3]
	    } else {
		set refLine($opcode) "quickref:   [lindex $opsDatabase($op) 1] $opcode [lindex $opsDatabase($op) 2]"
		set refHelp($opcode) [lindex $opsDatabase($op) 3]
	    }
	}
    
    set tklist {list \
      cec_filein  cec_toggle cec_popup cec_slider cec_graph cec_separateur \
      cs_sound  cs_toggle cs_option cs_slider cs_graph cs_separateur }
    
 
    array set tkrefLine {
	csepar  ?name?
	cpopup  "cpopup name {val1 val2 ...} ?options?"
	ctoggle "ctoggle name ?options"
	cslider "cslider name ?options?"
	cgraph   "cgraph name ?options?"
	cfilein  "cfilein name ?options?"
    }
    
    array set scorerefLine {
	e    "e <end of score>"
	pik "pik this and that"
	sq "sequence"
	ran "random"
	ma "mask"
	pa "parameter"
	lin "line"
	log "log"
    }
    
    set son(path) ""
    set soundWriteName ""
    set module(path) ""
    set module(tempfile) ""
    set module(tags) {tk_interface info mono stereo quad score}
    set module(outtags) {orcOut scoreOut}
    set prefs(dir)	0
    set midifile ""
    set currentdir "$homedir"
    set soundName ""
    set module(nom)  ""
    set click(X) 0
    set click(Y) 1
    set soundOutInfo(duree) 0
    set soundOutInfo(possibleSR) [list 8000 11025 16000 22050 32000 44100 48000 50000 96000 other...]
	set soundOutInfo(possibleKR) [list 800 1600 2205 3200 4410 4800 5000 9600 other...]
    set soundOutInfo(possibleCHN) [list mono stereo quad]
    set soundOutInfo(possibleKSM) [list 1 5 10 25 50 100 240 320 441 480 882 other...]
    set soundOutInfo(possibleGEN) [list 128 256 512 1024 2048 4096 8192 16384 32768 65536]

	array set fDat {
		drunktype	rand	drunkpoints	50	drunkwalk	.15
		sinfreq		 1	sinamp		1	sinphase	0
		sinpoints	50	noiseamp	1.0	noisepoints	 50
		ampx		.01	ampy		.01	ampoints	10
		osctype	 q	sawamp	 1	sawfreq	 1
		sawwidth	 .5	inv	 	0	scaley		1
		scalex		.1	noisetype	rm	scatype	rnd
	}

    set dafold ""
    set nomModuleCourrant ""

    if {[winfo fpixels . 1i] > 90} {set dpi highres} {set dpi lowres}
    
    image create photo infor -file [file join $ceclib graphics $dpi info.gif]      

    makeInfoWindow	
    initGraph 

    wm withdraw .pre
    
    if {![info exists classNewId]} {set classNewId 0}
   
    makeEditWindow
    doFont

    setstate not

    ########## DO THE IRIX THING ############ 

    if {$tcl_platform(os) == "IRIX"} {lookUnix} 

    # init pseudo-random stuff
    set lastvalue [expr [string trimleft [clock format [clock seconds] -format %H%M%j%S] 0]%65536]
    
    ##############check for opening arguments (file name) ############
    if {[llength $argv] == 1} {
	set startup [open $argv r]
	set ro [read $startup]
	if {[lindex $ro 0] == "\<info\>" } {
	    parseModule $argv
	    showEditWindow	1
	    setBitbind on
	}
	if {[lindex $ro 0] == "\<snap\>" }  {
	    openGraph $argv
	    showEditWindow	0
	    setBitbind on
	}
	close $startup
    }


#    Mac debugging
#    console show
    set showconsole 0

    wm withdraw .temp
	bind .temp <ButtonRelease-1>  "wm withdraw .temp"

	wm deiconify .
    wm resizable . 0 0
    
    modebug "$_db(cecilia,version)"
    update

}

proc toggle_console {} {
	global showconsole
	if $showconsole {
		console hide
		set showconsole 0
	} else {
		console show
		set showconsole 1
	}
}




proc hey {} {
    foreach w {.edit .pre  .} { if [winfo ismapped $w] { wm deiconify $w ; raise $w } }
}


#proc buildhelper {} {
#	toplevel .helper
#	label .helper.l -justify left -width 80 -height 12 -font "helvetica 9"
#	pack .helper.l -fill both -expand t
#}


#------------optMenu process predefinition------------------
proc optMenu {w varName comm myfont color width height firstValue  args} {
    upvar #0 $varName var
    
    if ![info exists var] {
		set var $firstValue
    }
    menubutton $w -textvariable $varName -indicatoron 0 -menu $w.menu \
	    -relief raised  -padx 3p -pady 1p -highlightthickness 0 \
	    -anchor w -font $myfont  \
	    -borderwidth 2 -height $height -width $width
	   
    menu $w.menu -tearoff 0
    $w.menu add command -label $firstValue -font $myfont \
	    -command "[list set $varName $firstValue] ; $comm"
    foreach i $args {
	$w.menu add command -label $i -command "[list set $varName $i]; $comm" \
		-font $myfont 
	
    }
    return $w.menu
}

########################################################################


proc errFile4 {why args} {
	global  color errno lan cfont choix
	set errno 0
	set t [toplevel .message  -bd 0 ]
	wm geometry $t +300+250
	frame $t.fr   -bd 2 -relief groove
	message $t.fr.msg -aspect 1000 -justify center -font $cfont(small) -text $why 
	pack $t.fr.msg -side top -fill x -padx 10 -pady 10
	pack $t.fr -side top -fill x -pady 10 -padx 5
	set bou	[frame $t.bout -bd 2 -relief groove]
	set no 1
	foreach mes [join $args] {
	incr no
	button $bou.$no -text $mes -bd 3  -command "\
			grab release $t;catch {destroy $t}; \
			global choix; set choix [lindex [split $mes \(] 0]"
	pack $bou.$no -side left -expand 1 -pady 5 -padx 5
	}

	frame $bou.can   -bd 2 -relief sunken
	button $bou.can.cancel -text $lan(nom70) -bd 3 -width 8 -command "grab release $t;catch {destroy $t}; global choix; set choix false"
	pack $bou.can.cancel -padx 2 -pady 2
	pack $bou.can	  -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $bou -pady 10 -padx 5 -fill x -expand 1
	bind $t <Return> "$bou.can.cancel invoke"
	focus .message	
	grab set $t
	tkwait window $t
	return $choix
} 


proc errFile6 {{why "Erreur de selection"} } {
	global  color errno lan cfont
	set errno 0
	set t [toplevel .message  -bd 0 ]
	wm geometry $t +300+250
	frame $t.fr   -bd 2 -relief groove
	message $t.fr.msg -aspect 1000 -justify center -font $cfont(small) -text $why 
	pack $t.fr.msg -side top -fill x -padx 10 -pady 10
	pack $t.fr -side top -fill x -pady 10 -padx 5
	set bou	[frame $t.bout   -bd 2 -relief groove]
	frame $bou.can   -bd 2 -relief sunken
	
	button $bou.canc -text cancel  \
		 \
		 -bd 3 -width 8 -command "set errno cancel;grab release $t;catch {destroy $t}"
	button $bou.quit -text $lan(nom70b)  \
		 \
		 -bd 3 -width 8 -command "set errno no;grab release $t;catch {destroy $t}"
	pack $bou.quit -side left -expand 1 -anchor w -padx 5
  
	button $bou.can.cancel -text $lan(nom70a)  \
		 \
		 -bd 3 -width 8 -command "set errno yes;grab release $t;catch {destroy $t}"
	pack $bou.can.cancel -padx 2 -pady 2
	pack $bou.canc	  -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $bou.can	  -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $bou -pady 10 -padx 5 -fill x -expand 1
	
	bind $t <Return> "$bou.can.cancel invoke"
	focus .message	
	catch {grab set $t}
	tkwait window $t
} 



##########################################
#########BOITE MESSAGERIE-1
##########################################
proc errFile {{why "Erreur de selection"} } {
	global color errno lan cfont
	set errno 0
	set t [toplevel .message  -bd 0 ]
	wm geometry $t +300+250
	frame $t.fr   -bd 2 -relief groove
	message $t.fr.msg -aspect 1000 -justify center -font $cfont(small) -text $why 
	pack $t.fr.msg -side top -fill x -padx 10 -pady 10
	pack $t.fr -side top -fill x -pady 10 -padx 5
	set bou	[frame $t.bout   -bd 2 -relief groove]
	frame $bou.can   -bd 2 -relief sunken
	
	button $bou.quit -text OK  \
		 \
		 -bd 3 -width 8 -command "set errno 0;grab release $t;catch {destroy $t}"
	pack $bou.quit -side left -expand 1 -anchor w -padx 5
  
	button $bou.can.cancel -text $lan(nom70)  \
		 \
		 -bd 3 -width 8 -command "set errno 1;	grab release $t;catch {destroy $t}"
	pack $bou.can.cancel -padx 2 -pady 2
	pack $bou.can	  -side left -expand 1 -anchor e -padx 5 -pady 5
	pack $bou -pady 10 -padx 5 -fill x -expand 1
	
	bind $t <Return> "$bou.can.cancel invoke"
	focus .message	
	grab set $t
	tkwait window $t
	grab release $t
} 

##########################################
#########BOITE MESSAGERIE-2
##########################################
proc errFile2 {{why "Erreur de selection"} } {
	global  color cfont lan
	set t [toplevel .message  -bd 0 ]
	if {$why == ""} {set why "Hello sailor!"}
	wm geometry $t +400+300
	wm title $t "!"
	frame $t.fr   -bd 2 -relief groove
	message $t.fr.msg -aspect 1000 -justify center -font $cfont(small) -text $why 
	pack $t.fr.msg -side top -fill x -pady 10 -padx 10 
	pack $t.fr -side top -fill x -pady 10 -padx 5
	set bou	[frame $t.bout   -bd 2 -relief groove]
	frame $bou.can   -bd 2 -relief sunken
	button $bou.can.cancel -text OK! -bd 3 -width 8 -command "set errno 1;	grab release $t;catch {destroy $t}"
	pack $bou.can.cancel -padx 2 -pady 2
	pack $bou.can  -padx 5 -pady 5
	pack $bou -pady 10 -padx 5 -fill x -expand 1
	bind $t <Return> "$bou.can.cancel invoke"
	focus .message	
	tkwait visibility $t
	grab set $t
	tkwait window $t
	grab release $t
	
}

proc errFile1 {why} {
    global  color cfont lan
    set t [toplevel .speedo  -bd 0 ]
    if {$why == ""} {set why "Hello sailor!"}
    wm geometry $t 400x172+400+300
    wm title $t "Writing sound file..."
    frame $t.fr   -bd 2 -relief groove
    message $t.fr.msg -aspect 1000 -justify center -text "$why\n\nClick on timebar to KILL!" 
    pack $t.fr.msg -side top -fill x -pady 10 -padx 10 
    pack $t.fr -side top -fill x -pady 10 -padx 5
    set bou [frame $t.bout -bd 2 -relief groove]
    button $bou.cancel -bd 1 -bg ${color}4 -height 0 -command "CsoundStop;catch {destroy $t}"
    label $bou.lab -text "0.0 %" -bd 2
    pack $bou.cancel -side left -padx 2 -pady 2 -anchor w
    pack $bou.lab -side right -padx 2 -pady 2 -anchor e
    pack $bou -pady 10 -padx 5 -fill x -expand 1 -side left
    catch {tkwait visibility $t}
    moveCurs
}


proc moveCurs {} {
global curState path soundOutInfo nchnls soundName tcl_precision
    set tcl_precision 4
    set sco [read [open [pwd]/score.srt r]]	
    set las [ string range $sco [string last i $sco] end ]
    set time [expr ([lindex $las 3] + [lindex $las 4])*1.0]
    set si [expr $time * $soundOutInfo(sr)*$nchnls($soundOutInfo(nchnls)) *2]
    set na [string trim $soundName \"]
	while {$curState(.bPlay) == 1} {
	    after 500
	    if [file exists $na]  { 
		set prct [expr ([file size $na] / $si * 100.00)]
		.speedo.bout.cancel config -width [expr round($prct + 1)/2] 
		if {$prct > .01} {.speedo.bout.lab config -text "$prct %"}
	    }
	    update
    }
    set tcl_precision 4
    destroy .speedo
}



proc getAbout {} { wm deiconify .temp ; raise .temp }

proc showInfo {} {
    global path tcl_platform
    if {$tcl_platform(platform) == "unix"} {
     errFile2 "[$path(panel).info.t get 0.0 end]\n"
    } else {
    tk_dialog .info info [$path(panel).info.t get 0.0 end]\n {} 0 OK
    }
}

proc quitte {} {
    global prefs env tcl_platform
    
    if {[closureCheck] == 0} {return}
    if {[doCloseCheck] == 0} {return}
    cd $prefs(TMPDIR)
    set trash [glob -nocomplain -- [file join $prefs(TMPDIR) *.{orc,sco,CStemp}]]
    
    bug platform specific trash management

    # Platform-Specific Trashing
    switch --  $tcl_platform(platform) {
	macintosh 	{ 
	    foreach item $trash { 
		catch {
		    file rename -force $item [file join $env(TRASH_FOLDER)]
		} 
	    } 
	}
	
	windows 	{ if [file exists score.srt] {file delete score.srt} }
	unix		{    
	    foreach item  $trash { if [file writable $item] {catch {exec rm $item } } }
	    if {[file exists score.srt]&&[file writable score.srt]} {exec rm score.srt}
	}
    }
    
    bug platform specific processes management
    
    switch --  $tcl_platform(platform) {
	"macintosh" {catch {perf_quit}}
	"unix"      {catch {exec killall csound}}
	"windows"   {catch {AXCSRelease}}
    }
    
    bug saving prefs

    doPrefs
    exit
}


proc lookUnix {} {

    global path curState color helpLine tcl_platform  soundOutInfo

    .menubar config -bg ${color}3  -activebackground  ${color}3 
    .pre.intermenubar config -bg ${color}3  -activebackground  ${color}3 
    .pre.too config -bg ${color}4 

    foreach f {f0 f1 f3 f5 f7} {
	.pre.too.$f config -bg ${color}4 
    }

    $path(edit).menu config  -bg ${color}3  -activebackground  ${color}3 
    $path(winOut) config -height 1 -relief raised -bd 2 
    $path(winOut).l config -bg gray50
    $path(winOut).output config -relief flat -bd 0 
    
    grid config $path(winOut).rates.play  -pady 5
    grid config $path(winOut).rates.edit  -pady 5
    grid config $path(winOut).output.rmode -pady 5
    grid config $path(winOut).output.dmode  -pady 5

    $path(winOut).rates config -relief flat 
    grid config $path(winOut).output  -padx 6
    grid config $path(winOut).rates   -padx 6
    
    grid config $path(winOutGEN) -pady 6 -sticky ew

    foreach chn $soundOutInfo(possibleCHN) {
	$path(winOut).rates.nchnls.$chn  config  -bd 2  
    }    

}
    
