#This is the main tcl library for anything to do with audio

proc audio_add {} {
	catch {destroy .add}
	toplevel .add
	wm title .add {Add Audio Tracks}
	
	
	label .add.l -text {Track Name (Globals OK)} 
	entry .add.e -width 32 -font 7x14 
	button .add.ok -text {OK} -command {
		set tmp [glob -nocomplain [.add.e get]]
		foreach i $tmp {.audio.f.lb insert end $i}
		destroy .add
	}
	button .add.cancel -text {Cancel} -command {destroy .add}
	
	pack .add.l -side top
	pack .add.e -side top
	pack .add.ok -side left
	pack .add.cancel -side right
}


proc audio_remove {} {
	set victim [.audio.f.lb curselection]
	catch {.audio.f.lb delete $victim}
}

proc audio_removeall {} {
	.audio.f.lb delete 0 end
}

proc flip n {
	.audio.f.lb selection clear 0 end
	set above [expr $n - 1]
	set tmp [.audio.f.lb get $n]
	.audio.f.lb insert $above $tmp
	.audio.f.lb delete [expr $n + 1]
}

proc read_audio {} {
	catch {destroy .top}
	toplevel .top
	wm title .top "Read audio tracks"

	frame .top.path1
	label .top.path1.l -text "(optional) Rip Source: "
	entry .top.path1.source -width 15
	button .top.path1.peruse -text "Peruse" -command {
		peruse_block
		.top.path1.source delete 0 end
		.top.path1.source insert 0 $perusedfile
	}

	frame .top.path2
	label .top.path2.l -text "Rip Destination: "
	entry .top.path2.dest
	button .top.path2.peruse -text "Peruse" -command {
		peruse
		.top.path2.dest delete 0 end
		.top.path2.dest insert 0 $perused
	}
	
	frame .top.1 -border 0 -relief flat
	frame .top.2 -border 0 -relief flat 
	frame .top.3 -border 0 -relief flat 
	frame .top.4 -border 0 -relief flat 
	radiobutton .top.1.entire -text {Rip Entire Disk} -variable {rip} -value {all}
	radiobutton .top.2.track -text {Tracks:} -variable {rip} -value {track}
	radiobutton .top.3.custom -text {Custom Options} -variable {rip} -value {custom}
	button .top.4.ok -text {Do it} -command {
		set tmp "Ripping Audio"
		switch $rip {
			all {
				if {[.top.path1.source get] != ""} {
					set dp [list "cdparanoia -d [.top.path1.source get] -w -B 1-"]
				} else {
					set dp [list "cdparanoia -s -w -B 1-"]
				}
			}
			track {
				if {[.top.path1.source get] != ""} {
				set dp [list "cdparanoia -d [.top.path1.source get] -w -B [.top.2.from get]-[.top.2.to get]"]
				} else {
				set dp [list "cdparanoia -s -w -B [.top.2.from get]-[.top.2.to get]"]
				}
			}
			custom {
				set dp [list "cdparanoia [.top.3.opt get]"]
			}
		}
		if {[.top.path2.dest get] != ""} {
			set dp [concat [list "cd [.top.path2.dest get]"] $dp]
		}
		dispatch $dp $tmp
		destroy .top
	}
	button .top.4.dis -text {Not now.} -command {
		destroy .top
	}
	label .top.2.lfr -text {From:}
	entry .top.2.from -width 4 -font 7x14
	label .top.2.lto -text {To:}
	entry .top.2.to -width 4 -font 7x14
	entry .top.3.opt -width 20 -font 7x14

	pack .top.path1 -side top -fill x
	pack .top.path1.l .top.path1.source .top.path1.peruse -side left
	pack .top.path2 -side top -fill x
	pack .top.path2.l .top.path2.dest .top.path2.peruse -side left
	pack .top.1 -side top -fill x
	pack .top.2 -side top -fill x
	pack .top.3 -side top -fill x
	pack .top.4 -side top -fill x
	pack .top.1.entire -side left -anchor w
	pack .top.2.track -side left -anchor w
	pack .top.3.custom -side left -anchor w
	pack .top.4.ok -side left -expand 1
	pack .top.4.dis -side left -expand 1
	pack .top.2.lfr -side left -anchor e
	pack .top.2.from -side left -anchor e
	pack .top.2.lto -side left -anchor e
	pack .top.2.to -side left -anchor e
	pack .top.3.opt -side left -anchor e

	global rip
	set rip all
}

proc preview_audio {} {
	set track [.audio.f.lb curselection]
	set file [.audio.f.lb get $track]
	#catch {.audio.f.lb delete $victim}
	set cmd "mpg123"
	lappend cmd $file
	dispatch [list $cmd] "Previewing $track"
	destroy .top
}

