/*
cdcd - Command Driven CD player
Copyright (C) 1998-99 Tony Arcieri
Copyright (C) 2001 Fabrice BAUZAC

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cmdline.h"
#include "cmd_access.h"
#include "str.h"
#include "rlhist.h"

Execfunc cmd_access_remote, cmd_access_local, cmd_access_proxy,
  cmd_access_display, cmd_access_help, cmd_access_display, cmd_access_quit,
  cmd_access_cdcd;

struct Command access_cmds[] = {
  ALIAS("?", "help"),
  { "help", 0, "That's a stupid joke.", cmd_access_help, NULL, 0 },
  { "display", "", "Display the current access method.",
    cmd_access_display, NULL, 1 },
  { "remote", "", "Set the access method to REMOTE.",
    cmd_access_remote, NULL, 1 },
  { "local", "", "Set the access method to LOCAL.",
    cmd_access_local, NULL, 1 },
  { "proxy", "[ URL | \"off\" ]", "Sets the proxy to URL, or turn it off.",
    cmd_access_proxy, NULL, 1 },
  { "quit", "", "Quit cdcd.", cmd_access_quit, NULL, 0 },
  ALIAS("exit", "quit"),
  { "..", "", "Return to the main cdcd prompt.", cmd_access_cdcd, NULL, 0 },
  { 0, 0, 0, 0, 0, 0 }
};

int
cmd_access_local (char **argv)
{
  struct cddb_conf conf;
  struct cddb_serverlist list;
  struct cddb_server proxy;

  if (argv[1]) {
    puts ("Too many arguments");
    return 0;
  }
  
  cddb_read_serverlist (&conf, &list, &proxy);
  conf.conf_access = CDDB_ACCESS_LOCAL;
  cddb_write_serverlist (conf, list, proxy);

  return 0;
}

int
cmd_access_remote (char **argv)
{
  struct cddb_conf conf;
  struct cddb_serverlist list;
  struct cddb_server proxy;

  if (argv[1]) {
    puts ("Too many arguments");
    return 0;
  }
  
  cddb_read_serverlist (&conf, &list, &proxy);
  conf.conf_access = CDDB_ACCESS_REMOTE;
  cddb_write_serverlist (conf, list, proxy);

  return 0;
}

int
cmd_access_proxy (char **argv)
{
  struct cddb_conf conf;
  struct cddb_serverlist list;
  struct cddb_server proxy;
  struct cddb_host host;

  if (!argv[1] || argv[2]) {
    puts ("You must supply one argument.");
    return 0;
  }

  cddb_read_serverlist (&conf, &list, &proxy);

  if(!strcasecmp (argv[1], "off"))
    conf.conf_proxy = CDDB_PROXY_DISABLED;
  else {
    cddb_process_url (&host, argv[1]);
    conf.conf_proxy = CDDB_PROXY_ENABLED;
  }

  cddb_write_serverlist (conf, list, host.host_server);

  return 0;
}

int
cmd_access_help (char **argv)
{
  cmdhelp (access_cmds, argv, 0);
  return 0;
}

int
cmd_access_quit (char **argv)
{
  return XRET_QUIT;
}

int
cmd_access_cdcd (char **argv)
{
  return XRET_BACK;
}

int
cmd_access_display (char **argv)
{
  struct cddb_conf conf;
  struct cddb_serverlist list;
  struct cddb_server proxy;

  cddb_read_serverlist (&conf, &list, &proxy);

  printf ("cddb access is set to %s.\n",
	  conf.conf_access? "remote": "local");
  if (conf.conf_proxy == CDDB_PROXY_ENABLED)
    printf ("http proxy is enabled and set to http://%s:%d/.\n",
	    proxy.server_name, proxy.server_port);
  else
    puts ("http proxy is disabled.");

  return 0;
}

char *
access_command_matcher (const char *text, int state)
{
  return command_matcher (access_cmds, text, state);
}

int
cmd_access_mainloop ()
{
  return cmd_mainloop (access_command_matcher, "cdcd/access> ",
		       access_cmds);
}

void
init_cmd_access ()
{
  sort_commands (access_cmds);
}
