/****************************************************************************
                             Hyper's CD Catalog 
		A multiplatform qt and xml based catalog program
  
 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef FINDDIALOG_H
#define FINDDIALOG_H

#include <qvariant.h>
#include <qdialog.h>
#include <qobject.h>
#include <pcre.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QFrame;
class QLabel;
class QLineEdit;
class QListView;
class QListViewItem;
class QHBoxLayout;
class QVBoxLayout;
class QPushButton;
class CdCatMainWidget;
class findDialog;
class Node;
class PWw;

class seekEngine : public QObject 
 {
  Q_OBJECT
  private:
   int founded;
   PWw *pww; 
   pcre *re;
   char *patt;
   int  offsets[99];
   pcre_extra *hints;
   const char *error;
   int errptr;
   
   findDialog *fd;
   
   int  analyzeNode  (Node *n,Node *pa=NULL);
   void putNodeToList(Node *n);
   int  matchIt      (const char *txt);
   
  public: 
   seekEngine(findDialog *fdp);
   ~seekEngine(void);    
     
   int start_seek(void);     
   
  private:
   bool dirname;
   bool filename;
   bool comment;
   bool tartist;
   bool ttitle;
   bool talbum;
   bool tcomment; 
   bool content;
      
   bool allmedia;
   bool allowner;
   
   char media[128];
   char owner[128];
 };

/***********************************************************************/
 
class findDialog : public QDialog
{
    Q_OBJECT

public:
    findDialog(CdCatMainWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~findDialog();
    

    QFrame *input;
    QHBoxLayout *h1,*h2,*h3,*h4;
    QVBoxLayout *v1;
    CdCatMainWidget *mainw;
    QPushButton* buttonClose;
    QFrame* line1;
    QComboBox* cbOwner;
    QComboBox* cbSin;
    QPushButton* buttonCancel;
    QPushButton* buttonOk;
    QLabel* textLabel3;
    QLabel* textLabel1;
    QLabel* textLabel2;
    QLabel* textLabel5;
    QFrame* line2;
    QListView* resultsl;
    QLineEdit* leText;
    QCheckBox* cbComment;
    QCheckBox* cbFilename;
    QCheckBox* cbDirname;
    QCheckBox* cbTcomm;
    QCheckBox* cbAlbum;
    QCheckBox* cbTitle;
    QCheckBox* cbArtist;
    QCheckBox* cbCasesens;
    QCheckBox* cbEasy;
    QCheckBox* cbContent;

protected:
    int fillCBox(void);
    void closeEvent(QCloseEvent *ce);
    
    QGridLayout* FindDialogBaseLayout;
    QVBoxLayout* layout40;
    QGridLayout* layout39;
    QGridLayout* layout36;
    QGridLayout* layout37;
    QVBoxLayout* layout31;
    QHBoxLayout* layout17;
    QGridLayout* layout15;
    QHBoxLayout* layout30;
    QGridLayout* layout16;

protected slots:
    virtual void languageChange();
    int select (QListViewItem *i);
    int closee (void);
    int cancele(void);
    int seeke  (void);
    int saveState(void);
};

#endif // FINDDIALOG_H
