/****************************************************************************
                             Hyper's CD Catalog 
		A multiplatform qt and xml based catalog program
  
 Author    : Peter Deak (hyperr@freemail.hu)
 License   : GPL
 Copyright : (C) 2003 Peter Deak
****************************************************************************/

#ifndef COMMENTWIDGET_H
#define COMMENTWIDGET_H

#include <qwidget.h>
#include <qimage.h>
#include <qvariant.h>
#include <qdialog.h>
#include <qtoolbutton.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QPaintEvent;
class QPixmap;
class Node;
class QPushButton;
class QMultiLineEdit;
class QEvent;
class CdCatConfig;

int editNodeComment(Node *node,QWidget *parent);

class HQToolButton : public QToolButton
 {
  public:
   HQToolButton(QWidget *parent = 0);  
  protected:
   void enterEvent(QEvent *e);
   void leaveEvent(QEvent *e);
 };

class CommentWidget : public QWidget
 {
  Q_OBJECT
    
  public:

   CommentWidget(CdCatConfig * cc,QApplication *appl,QWidget *parent=0,const char *name=0,WFlags fl=0);

   CdCatConfig * cconfig;
   HQToolButton* ButtonEdit;
   HQToolButton* ButtonContent;
   void showNode(Node *node,int mod);
   
   
   Node *act;
   int  mode;
  signals:   
   void touchdb(); 
  protected:
   void enterEvent(QEvent *e);
   void leaveEvent(QEvent *e);
   void paintEvent(QPaintEvent *pe);
   void resizeEvent(QResizeEvent *re);
   void mouseMoveEvent(QMouseEvent *me);
   void mousePressEvent(QMouseEvent *me);
   void mouseReleaseEvent(QMouseEvent *me);
   
  private:
   int mx,my,ox,oy;
   QPixmap image13;  
   QApplication *app;
   
  public slots:
   int editC(void);
   int showC(void);
 };
 
//-------------------------------------------------------------------------------------
class commentEdit : public QDialog
{
    Q_OBJECT

public:
    commentEdit(QString cc,QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~commentEdit();

    QMultiLineEdit* teComm;
    QPushButton* buttonOk;
    QPushButton* buttonCancel;

public slots:
    virtual int pushOk();
    virtual int pushCancel();

protected:
    QGridLayout* CommentEditBaseLayout;
    QVBoxLayout* layout5;
    QHBoxLayout* layout4;

public:
    QString newc;    
    int OK;
    
protected slots:
    virtual void languageChange();
};

#endif // COMMENTEDIT_H
