/***************************************************************************
                          FoldersListView.cpp  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <iostream.h>
// QT includes
#include <qdir.h>
#include <qpixmap.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qapp.h>
#include <qfileinfo.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qlistview.h>
#include <qdragobject.h>

// KDE includes
#include <krun.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kpropsdlg.h>
#include <kopenwith.h>
#include <kmessagebox.h>
#include <klistview.h>
#include <kconfig.h>
#include <kapp.h>

// app includes
#include "FoldersListView.h"
#include "FolderItem.h"

FoldersListView::FoldersListView(QWidget *parent, const char *name):
 	KListView( parent, name ){	
	
	setDragEnabled(true);
	/////////////////////////
	setRootIsDecorated( true );
	header()->hide();
	setSorting( 0 );
  	setFrameStyle( Panel | Sunken );
  	setLineWidth( 2 );
  	addColumn( "Name" );
	setFocusPolicy(QWidget::ClickFocus);
	
	config = kapp->config();
	
	config->setGroup("Default Settings");	
	showHidden = config->readBoolEntry("Show Hidden Items in Source", true);
	
	/////////////////////////////////////////////////////////
	folderMenu = new QPopupMenu();
	folderMenu -> insertItem(BarIcon("bottom"),  i18n("&Add to Compilation List"),
		this ,SLOT(slotAddToCompilation()));
	indexOfTop = folderMenu -> insertItem(BarIcon("bookmark_add"), i18n("Add Folder to Top"), this ,SLOT(slotAddToTop()));
	folderMenu -> insertSeparator();
	folderMenu -> insertItem( i18n("Folder Properties"),   this ,SLOT(slotProperties()));
	folderMenu -> insertSeparator();
	folderMenu -> insertItem( BarIcon("reload"), i18n("Reload List"),   this ,SLOT(slotReload()));
	//folderMenu -> insertItem( i18n("List mode"), this ,SLOT(slotNewMode()));
	
	//////////////////////////////////////////////////////////////////////
	
	connect(  this, SIGNAL(doubleClicked(QListViewItem *)),
						this, SLOT(slotSelectFile(QListViewItem *)));
	connect(  this, SIGNAL(clicked(QListViewItem *)),
						this, SLOT(slotSelectFileConst(QListViewItem *)));
						
	/*connect(  this, SIGNAL(selectionChanged(QListViewItem *)),
						this, SLOT(slotSelectFile(QListViewItem *)));*/
	connect(	this, SIGNAL(returnPressed(QListViewItem *)),
						this, SLOT(slotSelectFile(QListViewItem *)));
						
	connect( this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
					 this, SLOT(slotMenu(QListViewItem*, const QPoint&, int)));
					
					
	rootDir = new FolderItem( this , "/", true, showHidden);
	// generate top list of directories
	topList = config->readListEntry("Top List");	
	if(topList.count() > 0){	
		for ( int i = 0; i < (int)topList.count(); i++){
			QString buff = topList[i];
	  		FolderItem *item = new FolderItem( this ,buff, true, showHidden);
	  		item->setText(0,buff);	
	  		item->setOpen( false);
		}
		rootDir->setOpen(false);
	}
	else
		rootDir->setOpen(true);
}
//==================================================
FoldersListView::~FoldersListView(){
}
//===========================================================
void FoldersListView::slotReload(){
	if ( !currentItem() ) return;
	FolderItem *d = dynamic_cast<FolderItem *>( currentItem()->parent());
  	if (d)
		d->reloadList();
}
//===========================================================
void FoldersListView::slotShowHidden(){
	showHidden = !showHidden;
	QListViewItem *item;
	for(item = firstChild(); item; item = item->nextSibling()){
		FolderItem * i = dynamic_cast<FolderItem *>(item);
		if(i){
	  		i->setShowHidden(showHidden);
	  		i->reloadList();
			i->setOpen(false);
		}
	}
	config->setGroup("Default Settings");	
	config->writeEntry("Show Hidden Items in Source", showHidden);
}
//============================================
void FoldersListView::slotProperties(){
	if ( !currentItem() )
		return;
  	KPropertiesDialog *propDlg = new KPropertiesDialog( KURL( currentFileName() ) );
  	connect( propDlg, SIGNAL( applied() ), this , SLOT( slotReload() ) );
}
//=============================================================
void FoldersListView::slotAddToCompilation(){
	if ( !currentItem() ) return;
	emit addToCompilation( currentFileName() );
}
//============================================================
QString FoldersListView::currentFileName(){
	if ( !currentItem() )
		return "";
	QListViewItem *item = currentItem();
	FolderItem *cur = dynamic_cast<FolderItem *> (item);
	
	return cur->getFilePath();
}
//=============================================
void FoldersListView::slotSelectFile(QListViewItem *item){
	if ( !item )
		return;
	FolderItem *ftf = dynamic_cast<FolderItem *>(item);
	if (!ftf)
		return;
	
	emit haveStatus("Parsing directory contense. Please wait...");
	emit processStarted();

	//QString path = ftf->getFilePath();
	ftf->setOpen(!ftf->isOpen());
		
	emit folderClicked(ftf);
	setSelected(item, true);
	emit processDone();
	emit haveStatus("Ready.");
		
}
//=============================================
void FoldersListView::slotSelectFileConst(QListViewItem *item){
	if ( !item )
		return;
	FolderItem *ftf = dynamic_cast<FolderItem *>(item);
	if (!ftf)
		return;
	
	emit haveStatus("Parsing directory contense. Please wait...");
	emit processStarted();

	//QString path = ftf->getFilePath();
		
	emit folderClicked(ftf);
	setSelected(item, true);
	emit processDone();
	emit haveStatus("Ready.");
}
//=============================================
QDragObject *FoldersListView::dragObject() const{
	
	QListViewItem *item = currentItem();
	if ( !item )
		return 0;
	
	FolderItem *cur = dynamic_cast<FolderItem *> (item);
	
	QDragObject *d = new QTextDrag(cur->getFilePath(), (QWidget *)this);
	const QPixmap *p = cur->pixmap(0);
	d->setPixmap(*p);
	return d;
}
//==============================================================
void FoldersListView::slotMenu(QListViewItem *item, const QPoint &point, int){
	if(!item)
		return;
	setSelected(item, true);
	
	FolderItem *ftf = dynamic_cast<FolderItem *>(item);
	if (!ftf)
		return;
	
	if(item == rootDir)
		folderMenu->setItemEnabled(indexOfTop, false);
	else if(isTopItem(currentFileName())){
		folderMenu->setItemEnabled(indexOfTop, true);
		folderMenu->changeItem(indexOfTop, i18n("Remove folder from top"));
	}
	else{
		folderMenu->setItemEnabled(indexOfTop, true);
		folderMenu->changeItem(indexOfTop, i18n("Add folder to Top"));
	}
	folderMenu ->popup( point);
}
//===============================================
void FoldersListView::slotAddToTop(){
	if(currentItem() == rootDir)
		return;
		
	QString buff = currentFileName();
	if(!isTopItem(buff)){
		topList.append(buff);
		FolderItem *item = new FolderItem( this , buff, true, showHidden);
		item->setText(0,buff);	
		item->setOpen(false);
		//item->setPixmap(0,BarIcon("bookmark", KIcon::SizeSmall ));
		ensureItemVisible(item);
		slotSelectFile(item);
	}
	else{
		topList.remove(buff);
		
		for(FolderItem *item = (FolderItem *)firstChild(); item; item = (FolderItem *)item->nextSibling()){
			if(item->getFilePath() == buff){
				takeItem(item );
				delete item;	
				break;
			}
		}
	}
}
//===============================================
void FoldersListView::saveTopList(){
	config->setGroup("Default Settings");	
	config->writeEntry("Top List", topList);
	
}

