/***************************************************************************
                          DriveInfoDialog.cpp  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// #include <iostream.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include "DriveInfoDialog.h"
#include "../../dialogs/dialogParts/DriveInfoPnl.h"
//=================================================
DriveInfoDialog::DriveInfoDialog( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "DriveInfoDialog" );
    resize( 316, 140 );
    setMaximumSize( QSize( 320, 140 ) );
    setCaption( tr( "Select Drive" ) );
    DriveInfoDialogLayout = new QVBoxLayout( this );
    DriveInfoDialogLayout->setSpacing( 5 );
    DriveInfoDialogLayout->setMargin( 9 );

    	devicePnl = new DriveInfoPnl( this, "devicePnl" );
	 devicePnl->setType(DriveInfoPnl::Target);
	 devicePnl->readOptions();
	devicePnl->closeTray();
	
    	devicePnl->setMinimumSize( QSize( 298, 0 ) );
    	devicePnl->setMaximumSize( QSize( 310, 130 ) );

    devicePnl->setUsrBtnTitle("&Load");
    devicePnl->setTitle("Please select source of the session");
	devicePnl->getUsrBtn()->setDefault( true );
	//devicePnl->getUsrBtn()->setAutoMask( true );
	
    devicePnl->getDetectBtn()->setText( tr( "&Cancel" ) );
     QToolTip::add(  devicePnl->getDetectBtn(), tr( "Cancel" ) );
     QWhatsThis::add(  devicePnl->getDetectBtn(), tr( "Use to stop loading CD session." ) );
	
	DriveInfoDialogLayout->addWidget( devicePnl );
    // connecting to the Drive Info Panel
	connect( devicePnl->getDetectBtn(), SIGNAL( clicked() ), this, SLOT( accept() ) );
	connect( devicePnl->getUsrBtn(), SIGNAL( clicked() ), this, SLOT( loadSlot() ) );
	connect( devicePnl->getUsrBtn(), SIGNAL( clicked() ), this, SLOT( accept() ) );
	
	if(!devicePnl->isReady())
		devicePnl->blockBtns(true);
	//exec();
}
//==========================================
DriveInfoDialog::~DriveInfoDialog(){
}
//==========================================
void DriveInfoDialog::loadSlot(){
	 devicePnl->saveOptions();
	emit load(devicePnl->getDriveName());
	//accept();
}