/***************************************************************************
                          AudioItem.cpp  -  description
                             -------------------
    begin                : Fri Nov 16 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

#include <qlistview.h>

#include <qdir.h>
#include <qstringlist.h>
#include <qapp.h>
#include <qdatetime.h>
#include <qfileinfo.h>

// QT includes
#include <kurl.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kmimemagic.h>
#include <kmimetype.h>

//#include <oggvorbis/vorbisInfo.h>

#include "AudioItem.h"
#include "CdboFileItem.h"

AudioItem::AudioItem(QListView * parent, QString path) : CdboFileItem(parent, path){
	
	sizeField = 2;
	nameField = 0;
	locationField = 3;
	modifiedField = 12;
	ownerField = 11;	
	
	init();
}

//==============================================
AudioItem::AudioItem(CdboFileItem * parent, QString path):CdboFileItem(parent, path){
	sizeField = 2;
	nameField = 0;
	locationField = 3;
	modifiedField = 12;
	ownerField = 11;
	
	init();
}	
//=================================================================
void AudioItem::init(){
	CdboFileItem::init();
	
	//KMimeMagic* mime = KMimeMagic::self();
	//QString mType1 = mime->findFileType(path)->mimeType();
	
	KMimeType::Ptr mimetype = KMimeType::findByURL(KURL(path));
	QString mType = mimetype->name().latin1();
	
	if(mType.find("x-mp3") != -1){
		setPixmap(1,UserIcon("ok", KIcon::SizeSmall ));
		setText(1," MP3");
		type = Mp3Type;
	}
	else if(mType.find("x-ogg") != -1){
		setPixmap(1,UserIcon("ok", KIcon::SizeSmall ));
		setText(1," Ogg");
		type = OggType;
	}
	else if(mType.find("x-wav") != -1 ||
			mType.find("x-aiff") != -1 ||
			mType.find("x-raw") != -1 ||
			mType.find("x-ulaw") != -1){
		setText(1,"Ready to burn");
		type = ReadyType;
	}
	else{
		//setText(0," Unrecognized");
		setPixmap(1,UserIcon("info", KIcon::SizeSmall ));
		setText(1,"Unsupported");
		type = UnrecognizedType;
	}
	setPixmap(nameField,BarIcon(KMimeType::iconForURL(path), KIcon::SizeSmall ));	
	
	//cerr << "\nname = " << name
	//	<< " \nmime->findFileType(name)->mimeType() = " << mType1
	//	<< "\nmimetype->name().latin1() = " << mType << "\n\n" << endl;
	
	
}
//=================================
/*void AudioItem::determineSize(){

}*/
//=======================================
AudioItem::~AudioItem(){
}