/***************************************************************************
                          AudioCompilationTreeView.cpp  -  description
                             -------------------
    begin                : Sun Nov 18 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>
// QT includes
#include <qdir.h>
#include <qstringlist.h>
#include <qcheckbox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qclipboard.h>
#include <qapp.h>
#include <qfileinfo.h>
#include <qdragobject.h>
#include <qevent.h>

// KDE includes
#include <kurl.h>
#include <klocale.h>
#include <kconfig.h>
#include <kapp.h>
#include <kio/job.h>
#include <kpropsdlg.h>
#include <kopenwith.h>
#include <kio/netaccess.h>
#include <kio/jobclasses.h>
#include <kmessagebox.h>
#include <klistview.h>
#include <kmimemagic.h>
#include <kdirsize.h>
#include <kfiledialog.h>

// CDBO includes
#include "AudioCompilationTreeView.h"
#include "CompilationTreeView.h"
#include "AudioItem.h"
#include "AudioPicker.h"
#include "../AudioEstimatePnl.h"
#include "../../dialogs/SettingsDialog.h"
#include "../../dialogs/NewCdDialog.h"
#include "../../dialogs/dialogWidgets/IsoOptPnl.h"

AudioCompilationTreeView::AudioCompilationTreeView( QWidget *parent, const char *name) :
		CompilationTreeView(parent, name){

	config = kapp->config();
	
	setAcceptDrops(true);
	setDropVisualizer(true);
	
	
	addColumn(  "Name"  );
    	addColumn(  "Convert from" );
    	addColumn(  "Time" );
    	addColumn(  "Location" );

    	
    	//setColumnAlignment(1, AlignRight);
    	setColumnAlignment(2, AlignHCenter);
    	
    	setColumnWidth(0,200);
    	setColumnWidth(1,100);
    	setColumnWidth(2,70);
    	setColumnWidth(4,220);
	


	updateSettings();
	/////////////////////////////////////////////////////////////////////////
	/*folderMenu = new QPopupMenu();
	folderMenu -> setCheckable(true);
	
	folderMenu -> insertItem( i18n("Folder Properties"),   this ,SLOT(slotProperties()));
	
	folderMenu -> insertSeparator();
	folderMenu -> insertItem(UserIcon("cross"), i18n("&Remove this file"), this ,SLOT(remove()));
	folderMenu -> insertItem( BarIcon("reload"), i18n("Reload Directory"),   this ,SLOT(slotReload()));
	folderMenu->setItemChecked(hiddenIndex, showHidden);
	
	folderMenu -> insertSeparator();	
	folderMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify Audio Settings"), this ,SLOT(compilSettingsSlot()));
	folderMenu ->insertItem(UserIcon("burn"), i18n("Create Audio CD"), this ,SLOT(createCD()));
	*/
	////////////////////////////////////////////////////////////////////////////
	fileMenu = new QPopupMenu();
	fileMenu -> setCheckable(true);
	
	fileMenu -> insertItem( i18n("File Properties"),   this ,SLOT(slotProperties()));
	fileMenu -> insertItem( i18n("Preview File With..."),
		this ,SLOT(openWithSlot()));	
	
	fileMenu -> insertSeparator();
	fileMenu->insertItem(UserIcon("cross"), i18n("&Remove this File"), this ,SLOT(remove()));
	fileMenu -> insertItem( BarIcon("reload"), i18n("Reload Directory"),   this ,SLOT(slotReload()));
	fileMenu->setItemChecked(hiddenFIndex, showHidden);
	
	fileMenu -> insertSeparator();
	fileMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify Audio Settings"), this ,SLOT(compilSettingsSlot()));
	fileMenu ->insertItem(UserIcon("burn"), i18n("Create Audio CD"), this ,SLOT(createCD()));
		
	////////////////////////////////////////////////////////////////////////////
	isoMenu = new QPopupMenu();
	//isoMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify ISO Image Properties"), this ,SLOT(slotProperties()));
	isoMenu ->insertItem(UserIcon("isoSetup"), i18n("Modify Audio Settings"), this ,SLOT(compilSettingsSlot()));
	isoMenu ->insertItem(UserIcon("burn"), i18n("Create Audio CD"), this ,SLOT(createCD()));
	isoMenu -> insertSeparator();
	haveItemsIndex = isoMenu -> insertItem(UserIcon("cross"), i18n("Remove &All Files"),   this ,SLOT(removeAll()));
	//////////////////////////////////////////////////////////////////////
	
	connect( this, SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)),
					 this, SLOT(popupMenuSlot(QListViewItem*, const QPoint&, int)));

}
//================================================
AudioCompilationTreeView::~AudioCompilationTreeView(){
}
void AudioCompilationTreeView::setEstimate(AudioEstimatePnl *e) {
	if(!e) return;
	
	estimate = e;
/*	connect(estimate->getRecalculateBtn(), SIGNAL(clicked ()),
						this, SLOT(recalculate()));
	connect(estimate, SIGNAL(recalculate ()),
						this, SLOT(recalculate()));
*/
}
//==============================================================
void AudioCompilationTreeView::updateSettings(){
	config->setGroup("Audio Read Options");
	cdboDtct = config->readBoolEntry("CDBO Audio Files Detection", true);
    	if(cdboDtct)
    		extList = QStringList::split(QRegExp(" "),
				config->readEntry("Supported Audio Extensions",
					".mp3 .aiff .au .wav .ogg .raw .cdr .sun"));
	reloadTop();
	
	QString title = "New Audio CD";
	//if(listFileName != "")
		//title += " (" + listFileName + ")";
	top->setText(0, title);
	top->setPixmap(0,BarIcon("cdrom_unmount", KIcon::SizeSmall ));
	
}
//==============================================================
void AudioCompilationTreeView::popupMenuSlot(QListViewItem *item, const QPoint &point, int){	
	if(!item || item == top){
		setSelected(top, true);
		//setCurrentItem(top);
		if(top->childCount() == 0)
			isoMenu->setItemEnabled(haveItemsIndex, false);
		else
			isoMenu->setItemEnabled(haveItemsIndex, true);
		
		isoMenu->setItemEnabled(createIsoIndex, true);
		fileMenu->setItemEnabled(createIsoIndexInFileMenu, true);	
		
		
		isoMenu->popup(point);
	}
	else{
		setSelected(item, true);
		fileMenu->popup( point);
	}
}

//---------------------------------------------------------------------------------------------
void AudioCompilationTreeView::compilSettingsSlot(){
	popUpSettings(SettingsDialog::AudioMP3);	
}


//=========================================
bool AudioCompilationTreeView::addItem(QString path){
	if(!canAccept(path))
		return false;
	
	top->setOpen(true);
	return true;
}

//================================
bool AudioCompilationTreeView::canAccept(QString path) {
	
	QFileInfo d( path );
	if(d.isDir()){
		if(!d.exists() || !d.isReadable()){
			KMessageBox::error(this,
				"Can not process: " +  path + "\n"\
				"Not a valid path! or possibly you do not\n" \
				"have enough privileges to add this item.");
			return false;
		}
		else{
			return pickAudioFromDir(path);
		}
	}
	if(fList.contains(path) > 0){
		KMessageBox::error(this,
				"Can not accept: " +  path + "\n"\
				"Item with same path is already on the list!");
		return false;
	}
	if(!d.exists() || !d.isReadable()){
		KMessageBox::error(this,
				"Can not accept: " +  path + "\n"\
				"Not a valid path! or possibly you do not\n" \
				"have enough privileges to add this item.");
		return false;
	}
	QString name = d.fileName();
	if(nameList.contains(name) > 0){
		KMessageBox::error(this,
				"Can not accept: '" +  d.fileName() + "'\n"\
				"Object with the same name is already on the list!");
		return false;
	}
	if(cdboDtct){
		bool valid = false;
      		for(int i =0; i < (int)extList.count(); i++){
      			if(path.find(extList[i].stripWhiteSpace(), -extList[i].length(), false) != -1){
      				valid = true;
      				break;
      			}
      		}
      		if(!valid){
      			KMessageBox::error(this,
      				"Can not accept: " +  path + "\n"\
      				"It does not end with recognized audio extension!");
      			return false;
      		}
      	}
      	else{
      		KMimeMagic* mime = KMimeMagic::self();
      		QString type = mime->findFileType(path)->mimeType();
      	
      		if(type.find("audio") == -1){
      			KMessageBox::error(this,
      				"Can not accept: " +  path + "\n"\
      				"It is not in audio formate! or possibly you do not\n" \
      				"have enough privileges to add this item.");
      			return false;
      		}
      	}

	int size = 0;
	size = (int)d.size();
	/*if(!estimate->add(size / 1024)){
       	KMessageBox::error(this,
       			"Can not accept: " +  path + "\n"\
       			"It's too big to fit on this CD!");
       	return false;
       }*/
	
	addFileItem( path, name);

	return true;	
}
//==============================================================
void AudioCompilationTreeView::addFileItem(QString path, QString name){
	AudioItem *fItem = new AudioItem( top, path);
	nameList.append(name);
	fList.append(path);
	ensureItemVisible(fItem);
	setSelected(fItem, true);
	saved = false;
	emitGotCaption();
}
//==============================================================
bool AudioCompilationTreeView::pickAudioFromDir(QString path){

	//////////////////////////////////////////////
	const KURL url(path);
	AudioPicker *job = AudioPicker::audioPickerJob(url);
	
	job->setName("AudioPickerProcess");
	
		
	emit longProcessStarted(job);
	emit haveStatus("Retrieving audio files from this directory. Please wait...");
	
	connect(job, SIGNAL(gotAudioFile(QString)),
		this, SLOT(addItem(QString) ));
	
	connect(job, SIGNAL(result ( KIO::Job *)),
		this, SLOT(audioPickerDone(KIO::Job *) ));
				
	
	emit processStarted();
	return false;
}
void AudioCompilationTreeView::resetTotal(){
	//estimate->reset();
}
//==============================
void AudioCompilationTreeView::subtractFromTotal(int size){
	//estimate->subtract(size);
}
//==============================================================
void AudioCompilationTreeView::recalculate(){
	/*estimate->reset();
	emit haveStatus("Recalculating image size. Please wait...");
     		
	QListViewItem *item;
	FileItem *fileItem;
	FolderItem *folderItem;
	
	for(item = top->firstChild(); item; item = item->nextSibling()){
		
		fileItem = dynamic_cast<FileItem *>(item);
		if(fileItem){
			QFileInfo d( fileItem->getFilePath() );
			
			if(!d.exists() || !d.isReadable()){
              		KMessageBox::error(this,
              				"Can not accept: " +  fileItem->getFilePath() + "\n"\
              				"This path is no longer valid! or possibly you do not\n"\
              				"have enough privileges to use this item.");
              		setCurrentItem(fileItem);
				remove();
				continue;
              	}
              	int size = (int)d.size();
              	
              	if(!estimate->add(size / 1024)){
       			KMessageBox::error(this,
       				"Can not accept: " +  fileItem->getFilePath() + "\n"\
       				"It's too big to fit on this CD!");
       			setCurrentItem(fileItem);
				remove();
				continue;
       		}
			
			fileItem->setFileSize(size);
		
		}
		else if((folderItem = dynamic_cast<FolderItem *>(item)) != NULL){
			
			QFileInfo d( folderItem->getFolderPath() );
			
			if(!d.exists() || !d.isReadable()){
              		KMessageBox::error(this,
              				"Can not accept: " + folderItem->getFolderPath() + "\n"\
              				"This path is no longer valid! or possibly you do not\n"\
              				"have enough privileges to use this item.");
              		setCurrentItem(folderItem);
				remove();
				continue;
              	}
      		
      		KDirSize *job = KDirSize::dirSizeJob(KURL(folderItem->getFolderPath()));
      		job->setName(folderItem->getFolderName());
      		emit processStarted();
      		emit longProcessStarted(job);
      		
      		map.insert(job->name(), folderItem);
      		connect(job, SIGNAL(result(KIO::Job *)),
      			this, SLOT(gotSize(KIO::Job *)));
      				
		}
		else
			continue;
	}
	if(map.isEmpty()){		
		emit processDone();
		emit haveStatus("Ready.");
	}*/
}

//===================================
void AudioCompilationTreeView::audioPickerDone(KIO::Job *j){
	if ( j->error() )
    		return;
    	
    	longProcessDone(j);
	emit processDone();
	emit haveStatus("Ready.");
}
//========================
void AudioCompilationTreeView::longProcessCanceled(QString id){
	emit processDone();
	emit haveStatus("Ready.");

}

//========================
void AudioCompilationTreeView::createCD(){
	if(isEmpty())
		return;
	return;//////////////////////////////////////////// ITS HERE //////////////////////////////////////////////////////
	config->setGroup("Default Settings");	
	
	if(config->readBoolEntry("Check Tmp Size", true)){
	
		int size = config->readNumEntry("tmp Size", -1);
	
		if(size == -1){
			int result = KMessageBox::warningContinueCancel(this,
					"Unable to determine temporary directory size!\n"\
					"Do you want to run 'Setting Dialog' to choose tmp directory?",
        				"Run Settings Dialog now?",
        				QString("Yes"));
    			switch(result) {
    				case KMessageBox::Continue:{
					popUpSettings(SettingsDialog::Defaults);
					return;
				}
    			}
		}
		else{
			/*if(size < (estimate->getTotal() / 1024)){
				KMessageBox::error(this,
					"Temprorary directory does not have enough space available\n" \
					"for storing disk image. Please remove some files from the list\n"\
					"or choose another location through 'Settings Dialog'.");
				return;
			}*/
		}
	}
	
	//config->setGroup("ISO Settings");	
	//config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	QFileInfo d(top->text(0));		
	if(d.exists()){
		int result = KMessageBox::warningContinueCancel(this,
			"File with the same name already exists!\n"\
			"Click 'Cancel' to run 'Setting Dialog' and\n"\
			"change ISO name Or overwrite existing one.",
        		"Overwrite existing?",
        		QString("&Overwrite"));
    		switch(result) {
    			case KMessageBox::Continue:
    				break;
    			default:{
				popUpSettings(SettingsDialog::Image);
				//return;
			}
    		}
    	}
	NewCdDialog *ncd = new NewCdDialog(&fList, cdboApp, "ncd" ) ;
       ncd->exec();
       delete ncd;
       updateSettings();
	
}

