/***************************************************************************
                          TargetTreeCntPanel.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qframe.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

//#include <qmainwindow.h>

#include <kiconloader.h>
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>
//#include <ktoolbar.h>

#include "TargetTreeCntPanel.h"
#include "../dialogs/dialogWidgets/IsoOptPnl.h"


/* 
 *  Constructs a TargetTreeCntPanel which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
TargetTreeCntPanel::TargetTreeCntPanel( QWidget* parent,  const char* name, bool withReload, WFlags fl )
   // : KToolBar( 0, QMainWindow::Left, true, name, true ){
	 : QWidget( parent, name, fl ){
    if ( !name )
		setName( "TargetTreeCntPanel" );
    resize( 34, 580 ); 
    setMaximumSize( QSize( 34, 3100 ) );
    setCaption( i18n( "Form1" ) );
    TargetTreeCntPanelLayout = new QHBoxLayout( this ); 
    TargetTreeCntPanelLayout->setSpacing( 0 );
    TargetTreeCntPanelLayout->setMargin( 0 );

    Frame4 = new QFrame( this, "Frame4" );
    Frame4->setMaximumSize( QSize( 32, 32767 ) );
    Frame4->setFrameShape( QFrame::StyledPanel );
    Frame4->setFrameShadow( QFrame::Raised );
    Frame4Layout = new QVBoxLayout( Frame4 ); 
    Frame4Layout->setSpacing( 1 );
    Frame4Layout->setMargin( 1 );

    /*expandTrgBtn = new QToolButton( Frame4, "expandTrgBtn" );
    expandTrgBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, expandTrgBtn->sizePolicy().hasHeightForWidth() ) );
    expandTrgBtn->setMinimumSize( QSize( 30, 31 ) );
    expandTrgBtn->setMaximumSize( QSize( 30, 31 ) );
    expandTrgBtn->setFocusPolicy( QToolButton::TabFocus );
    expandTrgBtn->setText( QString::null );
	expandTrgBtn->setPixmap( UserIcon("ftin", KIcon::SizeMedium ) );


    expandTrgBtn->setAutoRaise( TRUE );
    QToolTip::add(  expandTrgBtn, i18n( "Expand Tree" ) );
    Frame4Layout->addWidget( expandTrgBtn );
*/
    collapseTrgBtn = new QToolButton( Frame4, "collapseTrgBtn" );
    collapseTrgBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, collapseTrgBtn->sizePolicy().hasHeightForWidth() ) );
    collapseTrgBtn->setMinimumSize( QSize( 30, 31 ) );
    collapseTrgBtn->setMaximumSize( QSize( 30, 31 ) );
    collapseTrgBtn->setFocusPolicy( QToolButton::TabFocus );
    collapseTrgBtn->setText( QString::null );
    collapseTrgBtn->setPixmap( UserIcon("colapse", KIcon::SizeMedium ) );



    collapseTrgBtn->setAutoRaise( TRUE );
    QToolTip::add(  collapseTrgBtn, i18n( "Colapse tree" ) );
    Frame4Layout->addWidget( collapseTrgBtn );
	
    reloadBtn = new QToolButton( Frame4, "reloadBtn" );
    reloadBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, reloadBtn->sizePolicy().hasHeightForWidth() ) );
    reloadBtn->setMinimumSize( QSize( 30, 31 ) );
    reloadBtn->setMaximumSize( QSize( 30, 31 ) );
    reloadBtn->setFocusPolicy( QToolButton::TabFocus );
    reloadBtn->setText( QString::null );
	
	if(withReload){
    		reloadBtn->setPixmap( UserIcon("reload", KIcon::SizeMedium ) );
 		QToolTip::add(  reloadBtn, i18n( "Reload the tree" ) );
    		
	}
	else{
		reloadBtn->setPixmap( UserIcon("target", KIcon::SizeMedium ) );
    		QToolTip::add(  reloadBtn, i18n( "Import session from CD" ) );
	}
	
	reloadBtn->setAutoRaise( TRUE );
	Frame4Layout->addWidget( reloadBtn );

    Line1_2 = new QFrame( Frame4, "Line1_2" );
    Line1_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2 );

    deleteNodeBtn = new QToolButton( Frame4, "deleteNodeBtn" );
    deleteNodeBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, deleteNodeBtn->sizePolicy().hasHeightForWidth() ) );
    deleteNodeBtn->setMinimumSize( QSize( 30, 31 ) );
    deleteNodeBtn->setMaximumSize( QSize( 30, 31 ) );
    deleteNodeBtn->setFocusPolicy( QToolButton::TabFocus );
    deleteNodeBtn->setText( QString::null );
    //deleteNodeBtn->setPixmap( UserIcon("cross", KIcon::SizeMedium ) );
    deleteNodeBtn->setPixmap( BarIcon("edittrash", KIcon::SizeMedium ) );
    deleteNodeBtn->setAutoRaise( TRUE );

    Frame4Layout->addWidget( deleteNodeBtn );

    itemPropBtn = new QToolButton( Frame4, "itemPropBtn" );
    itemPropBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, itemPropBtn->sizePolicy().hasHeightForWidth() ) );
    itemPropBtn->setMinimumSize( QSize( 30, 31 ) );
    itemPropBtn->setMaximumSize( QSize( 30, 31 ) );
    itemPropBtn->setFocusPolicy( QToolButton::TabFocus );
    itemPropBtn->setText( QString::null );

    itemPropBtn->setPixmap( UserIcon("file_properties", KIcon::SizeMedium ) );

    itemPropBtn->setAutoRaise( TRUE );
    QToolTip::add(  itemPropBtn, i18n( "View folder properties" ) );
    Frame4Layout->addWidget( itemPropBtn );

    Line1_2_2_2 = new QFrame( Frame4, "Line1_2_2_2" );
    Line1_2_2_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2_2_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2_2_2 );

    isoPropBtn = new QToolButton( Frame4, "isoPropBtn" );
    isoPropBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, isoPropBtn->sizePolicy().hasHeightForWidth() ) );
    isoPropBtn->setMinimumSize( QSize( 30, 31 ) );
    isoPropBtn->setMaximumSize( QSize( 30, 31 ) );
    isoPropBtn->setFocusPolicy( QToolButton::TabFocus );
    isoPropBtn->setText( QString::null );
    isoPropBtn->setPixmap( UserIcon("isoSetup", KIcon::SizeMedium ) );

    isoPropBtn->setAutoRaise( TRUE );
    //QToolTip::add(  isoPropBtn, i18n( "Edit ISO-Image Settings" ) );
    Frame4Layout->addWidget( isoPropBtn );

    burnBtn = new QToolButton( Frame4, "burnBtn" );
    burnBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, burnBtn->sizePolicy().hasHeightForWidth() ) );
    burnBtn->setMinimumSize( QSize( 30, 31 ) );
    burnBtn->setMaximumSize( QSize( 30, 31 ) );
    burnBtn->setFocusPolicy( QToolButton::TabFocus );
    burnBtn->setText( QString::null );
    burnBtn->setPixmap( UserIcon("burn", KIcon::SizeMedium ) );

    burnBtn->setAutoRaise( TRUE );

    Frame4Layout->addWidget( burnBtn );

    createImgBtn = new QToolButton( Frame4, "createImgBtn" );
    createImgBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, createImgBtn->sizePolicy().hasHeightForWidth() ) );
    createImgBtn->setMinimumSize( QSize( 30, 31 ) );
    createImgBtn->setMaximumSize( QSize( 30, 31 ) );
    createImgBtn->setFocusPolicy( QToolButton::TabFocus );
    createImgBtn->setText( QString::null );
    createImgBtn->setPixmap( UserIcon("cdImageSm", KIcon::SizeMedium ) );

    createImgBtn->setAutoRaise( TRUE );
    QToolTip::add(  createImgBtn, i18n( "Create ISO Image" ) );
    Frame4Layout->addWidget( createImgBtn );

    Line1_2_2 = new QFrame( Frame4, "Line1_2_2" );
    Line1_2_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2_2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame4Layout->addItem( spacer );
    TargetTreeCntPanelLayout->addWidget( Frame4 );
    config = kapp->config(); 	

	QToolTip::add(  isoPropBtn, i18n( "Edit ISO-Image Settings" ) );	
    	if(withReload)
		QToolTip::add(  deleteNodeBtn, i18n( "Remove the branch selected Item belongs to." ) );
	else
		QToolTip::add(  deleteNodeBtn, i18n( "Remove selected directory." ) );
	
	QToolTip::add(  burnBtn, i18n( "Burn a New CD" ) );
    //checkIfAudio();
}

/*  
 *  Destroys the object and frees any allocated resources
 */
TargetTreeCntPanel::~TargetTreeCntPanel(){
}
#include "TargetTreeCntPanel.moc"
