/***************************************************************************
                          SrcTreeCntPanel.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "SrcTreeCntPanel.h"

#include <qframe.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <klocale.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kapp.h>


SrcTreeCntPanel::SrcTreeCntPanel( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl ){
    if ( !name )
	setName( "SrcTreeCntPanel" );
    resize( 34, 620 ); 
    setMaximumSize( QSize( 34, 3100 ) );
    setCaption( i18n( "Form1" ) );
    SrcTreeCntPanelLayout = new QHBoxLayout( this ); 
    SrcTreeCntPanelLayout->setSpacing( 0 );
    SrcTreeCntPanelLayout->setMargin( 0 );

    Frame4 = new QFrame( this, "Frame4" );
    Frame4->setFrameShape( QFrame::StyledPanel );
    Frame4->setFrameShadow( QFrame::Raised );
    Frame4Layout = new QVBoxLayout( Frame4 ); 
    Frame4Layout->setSpacing( 1 );
    Frame4Layout->setMargin( 1 );

    showHiddenBtn = new QToolButton( Frame4, "showHiddenBtn" );
    showHiddenBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, showHiddenBtn->sizePolicy().hasHeightForWidth() ) );
    showHiddenBtn->setMinimumSize( QSize( 30, 31 ) );
    showHiddenBtn->setMaximumSize( QSize( 30, 30 ) );
    showHiddenBtn->setFocusPolicy( QToolButton::TabFocus );

	showHiddenBtn->setPixmap( UserIcon("find", KIcon::SizeMedium ) );

    showHiddenBtn->setToggleButton( TRUE );
    showHiddenBtn->setAutoRaise( TRUE );
    showHiddenBtn->setToggleButton( TRUE );
	
	KConfig *config = kapp->config();
	config->setGroup("Default Settings");	
    //showHiddenBtn->setDown(config->readBoolEntry("Show Hidden Items in Source", true));

    if(config->readBoolEntry("Show Hidden Items in Source", true))
		showHiddenBtn->toggle();
    QToolTip::add(  showHiddenBtn, i18n( "Show Hidden Folders" ) );
    Frame4Layout->addWidget( showHiddenBtn );

    addToTopBtn = new QToolButton( Frame4, "addToTopBtn" );
    addToTopBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, addToTopBtn->sizePolicy().hasHeightForWidth() ) );
    addToTopBtn->setMinimumSize( QSize( 30, 31 ) );
    addToTopBtn->setMaximumSize( QSize( 30, 31 ) );
    addToTopBtn->setFocusPolicy( QToolButton::TabFocus );
    addToTopBtn->setText( QString::null );

    addToTopBtn->setPixmap( UserIcon("bookmark_add", KIcon::SizeMedium ) );
    addToTopBtn->setAutoRaise( TRUE );
    QToolTip::add(  addToTopBtn, i18n( "Add Folder to the Top of the Tree" ) );
    Frame4Layout->addWidget( addToTopBtn );

    reloadBtn = new QToolButton( Frame4, "reloadBtn" );
    reloadBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, reloadBtn->sizePolicy().hasHeightForWidth() ) );
    reloadBtn->setMinimumSize( QSize( 30, 31 ) );
    reloadBtn->setMaximumSize( QSize( 30, 31 ) );
    reloadBtn->setFocusPolicy( QToolButton::TabFocus );
    reloadBtn->setText( QString::null );
	

    reloadBtn->setPixmap( UserIcon("reload", KIcon::SizeMedium ) );
    reloadBtn->setAutoRaise( TRUE );
    QToolTip::add(  reloadBtn, i18n( "Reload the Tree" ) );
    Frame4Layout->addWidget( reloadBtn );

    Line1_2 = new QFrame( Frame4, "Line1_2" );
    Line1_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2 );

    showPropBtn = new QToolButton( Frame4, "showPropBtn" );
    showPropBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, showPropBtn->sizePolicy().hasHeightForWidth() ) );
    showPropBtn->setMinimumSize( QSize( 30, 31 ) );
    showPropBtn->setMaximumSize( QSize( 30, 31 ) );
    showPropBtn->setFocusPolicy( QToolButton::TabFocus );
    showPropBtn->setText( QString::null );


    showPropBtn->setPixmap( UserIcon("file_properties", KIcon::SizeMedium ) );
    showPropBtn->setAutoRaise( TRUE );
    QToolTip::add(  showPropBtn, i18n( "Display Folder Properties" ) );
    Frame4Layout->addWidget( showPropBtn );

    addToImageBtn = new QToolButton( Frame4, "addToImageBtn" );
    addToImageBtn->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)1, (QSizePolicy::SizeType)1, addToImageBtn->sizePolicy().hasHeightForWidth() ) );
    addToImageBtn->setMinimumSize( QSize( 30, 31 ) );
    addToImageBtn->setMaximumSize( QSize( 30, 31 ) );
    addToImageBtn->setFocusPolicy( QToolButton::TabFocus );
    addToImageBtn->setText( QString::null );
    addToImageBtn->setPixmap( UserIcon("bottom", KIcon::SizeMedium ) );
    addToImageBtn->setAutoRaise( TRUE );
    QToolTip::add(  addToImageBtn, i18n( "Add Folder to CD Image" ) );
    Frame4Layout->addWidget( addToImageBtn );

    Line1_2_2 = new QFrame( Frame4, "Line1_2_2" );
    Line1_2_2->setMaximumSize( QSize( 32, 32767 ) );
    Line1_2_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    Frame4Layout->addWidget( Line1_2_2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    Frame4Layout->addItem( spacer );
    SrcTreeCntPanelLayout->addWidget( Frame4 );
}

SrcTreeCntPanel::~SrcTreeCntPanel(){
    // no need to delete child widgets, Qt does it all for us
}
	
#include "SrcTreeCntPanel.moc"
