/***************************************************************************
                          SrcListPnl.cpp  -  description
                             -------------------
    begin                : Thu May 10 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* QT includes */
#include <qlayout.h>
#include <qstring.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qcheckbox.h>

#include <kfiledetailview.h>

 #include "SrcListPnl.h"
 #include "SrcListCntPanel.h"
#include "fileViews/FilesListView.h"

SrcListPnl::SrcListPnl(QWidget *parent, const char *name) : QWidget(parent, name){
	init();
}

SrcListPnl::~SrcListPnl(){
}
//----------------------------------------------------------------------------
void SrcListPnl::init(){
	QVBoxLayout *mainLayout = new QVBoxLayout(this, 2);
	
	srcList = new FilesListView( this, "srcFileList"  );
	srcList ->setFocusPolicy(QWidget::ClickFocus);
	mainLayout->addWidget(srcList);
	
	cntPnl = new SrcListCntPanel( this,"SrcListCntPanel" );
	cntPnl ->setFocusPolicy(QWidget::ClickFocus);	
	mainLayout->addWidget(cntPnl);
	
	srcList->setControlPanel(cntPnl);
	
	connect( cntPnl->getRefreshBtn(), SIGNAL(clicked()),
						srcList, SLOT(reloadListSlot()) );
	connect( cntPnl->getShowHiddenChk(), SIGNAL(clicked()),
						srcList, SLOT(checkShowHidden()) );
}
//================================
void SrcListPnl::showSrcListCntPanel(bool doShow){
	if(!doShow)
		cntPnl->hide();
	else
		cntPnl->show();

}

