/***************************************************************************
                          SrcListCntPanel.cpp  -  description
                             -------------------
    begin                : Thu May 10 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>


#include "SrcListCntPanel.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

#include <kcombobox.h>
#include <kapp.h>
#include <kconfig.h>
#include <klocale.h>

/*
 *  Constructs a SrcListCntPanel which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
SrcListCntPanel::SrcListCntPanel( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "SrcListCntPanel" );
	
	
    resize( 407, 63 ); 
    setMaximumSize( QSize( 32767, 65 ) );
    setCaption( i18n( "Form1" ) );
    SrcListCntPanelLayout = new QHBoxLayout( this ); 
    SrcListCntPanelLayout->setSpacing( 3 );
    SrcListCntPanelLayout->setMargin( 1 );

    GroupBox1 = new QGroupBox( this, "GroupBox1" );
    GroupBox1->setMinimumSize( QSize( 405, 60 ) );
    GroupBox1->setMaximumSize( QSize( 32767, 60 ) );
    GroupBox1->setTitle( i18n( "Filter shown files by:" ) );
    GroupBox1->setAlignment( int( QGroupBox::AlignBottom | QGroupBox::AlignHCenter ) );
    GroupBox1->setColumnLayout(0, Qt::Vertical );
    GroupBox1->layout()->setSpacing( 0 );
    GroupBox1->layout()->setMargin( 0 );
    GroupBox1Layout = new QHBoxLayout( GroupBox1->layout() );
    GroupBox1Layout->setAlignment( Qt::AlignTop );
    GroupBox1Layout->setSpacing( 5 );
    GroupBox1Layout->setMargin( 6 );

    showHiddenChk = new QCheckBox( GroupBox1, "showHiddenChk" );
    QFont showHiddenChk_font(  showHiddenChk->font() );
    showHiddenChk->setFont( showHiddenChk_font ); 
    showHiddenChk->setText( i18n( "&Show Hidden" ) );
	////////////////////////////////////////////////////////////////////////////////////////
    KConfig* config = kapp->config();
    config->setGroup("Default Settings");	
	bool  onStart = config->readBoolEntry("Show Hidden Files On List", true);
    	showHiddenChk->setChecked( onStart );

    QToolTip::add(  showHiddenChk, i18n( "Keep 'checked' to view hidden files." ) );
    GroupBox1Layout->addWidget( showHiddenChk );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    GroupBox1Layout->addItem( spacer );

    filterByCmb = new KComboBox( true, GroupBox1, "filterByCmb" );
    filterByCmb->setMinimumSize( QSize( 160, 25 ) );
    filterByCmb->setEditable( true );
    filterByCmb->setInsertionPolicy( QComboBox::AtTop );
    filterByCmb->setAutoCompletion( true );
    filterByCmb->setDuplicatesEnabled(false);
    static const char* fNames[] = { "*.bz2 *.tar *.gz *.tgz *.zip", "*.mp3 *.wav *.au *.ogg *.aiff *.raw", "*", 0 };
	filterByCmb->insertStrList( fNames, -1, 1 );
    QToolTip::add(  filterByCmb, i18n( "Enter text of the string to filter shown <b></b>files by. To list only files ending with \".cpp\" and all files ending with \".h\", you simply enter (\"*.cpp *.h\") or (\"*.cpp;*.h\") ." ) );
    GroupBox1Layout->addWidget( filterByCmb );

    refreshSrcListBtn = new QPushButton( GroupBox1, "refreshSrcListBtn" );
    refreshSrcListBtn->setMinimumSize( QSize( 100, 25 ) );
    QFont refreshSrcListBtn_font(  refreshSrcListBtn->font() );
    refreshSrcListBtn_font.setBold( TRUE );
    refreshSrcListBtn->setFont( refreshSrcListBtn_font ); 
    refreshSrcListBtn->setText( i18n( "&Reload" ) );
    QToolTip::add(  refreshSrcListBtn, i18n( "Reload the file list." ) );
    GroupBox1Layout->addWidget( refreshSrcListBtn );
    SrcListCntPanelLayout->addWidget( GroupBox1 );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
SrcListCntPanel::~SrcListCntPanel(){

}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool SrcListCntPanel::event( QEvent* ev )
{
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont showHiddenChk_font(  showHiddenChk->font() );
	showHiddenChk->setFont( showHiddenChk_font ); 
	QFont refreshSrcListBtn_font(  refreshSrcListBtn->font() );
	refreshSrcListBtn_font.setBold( TRUE );
	refreshSrcListBtn->setFont( refreshSrcListBtn_font ); 
    }
    return ret;
}

#include "SrcListCntPanel.moc"
