/***************************************************************************
                          IsoOptPnlBase.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "IsoOptPnlBase.h"

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

/* 
 *  Constructs a IsoOptPnlBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
IsoOptPnlBase::IsoOptPnlBase( QWidget* parent,  const char* name, WFlags fl )
    : QWidget( parent, name, fl )
{
    if ( !name )
	setName( "IsoOptPnlBase" );
    resize( 579, 449 ); 
    setMinimumSize( QSize( 300, 300 ) );
    setCaption( tr( "Form1" ) );

    isoOptTbs = new QTabWidget( this, "isoOptTbs" );
    isoOptTbs->setGeometry( QRect( 10, 10, 535, 417 ) ); 
    isoOptTbs->setMinimumSize( QSize( 535, 417 ) );
    isoOptTbs->setMaximumSize( QSize( 535, 417 ) );
    isoOptTbs->setTabShape( QTabWidget::Rounded );

    imageTab = new QWidget( isoOptTbs, "imageTab" );
    imageTabLayout = new QGridLayout( imageTab ); 
    imageTabLayout->setSpacing( 4 );
    imageTabLayout->setMargin( 7 );

    imagePnl = new QButtonGroup( imageTab, "imagePnl" );
    imagePnl->setMinimumSize( QSize( 0, 0 ) );
    imagePnl->setTitle( tr( "Image Settings" ) );

    TextLabel1 = new QLabel( imagePnl, "TextLabel1" );
    TextLabel1->setGeometry( QRect( 10, 140, 100, 22 ) ); 
    TextLabel1->setText( tr( "Image name:" ) );

    isoOptLbl = new QLabel( imagePnl, "isoOptLbl" );
    isoOptLbl->setGeometry( QRect( 10, 173, 180, 22 ) ); 
    isoOptLbl->setText( tr( "Custom 'mkisofs' options:" ) );

    extraOptTxt = new QLineEdit( imagePnl, "extraOptTxt" );
    extraOptTxt->setGeometry( QRect( 195, 173, 300, 22 ) ); 
    QToolTip::add(  extraOptTxt, tr( "Add custom mkisofs options." ) );

    noDeepChk = new QCheckBox( imagePnl, "noDeepChk" );
    noDeepChk->setGeometry( QRect( 250, 20, 204, 30 ) ); 
    noDeepChk->setMinimumSize( QSize( 0, 30 ) );
    noDeepChk->setText( tr( "&No deep directory relocation" ) );
    QToolTip::add(  noDeepChk, tr( "Do not use deep directory relocation,<br>and instead just pack directories in the way we see them." ) );

    followSymChk = new QCheckBox( imagePnl, "followSymChk" );
    followSymChk->setGeometry( QRect( 250, 110, 204, 30 ) ); 
    followSymChk->setMinimumSize( QSize( 0, 30 ) );
    followSymChk->setText( tr( "&Follow symbolic links" ) );
    QToolTip::add(  followSymChk, tr( "Follow symbolic links<br>when generating the filesystem." ) );

    rockRidgeChk = new QCheckBox( imagePnl, "rockRidgeChk" );
    rockRidgeChk->setGeometry( QRect( 10, 20, 200, 30 ) ); 
    rockRidgeChk->setMinimumSize( QSize( 0, 30 ) );
    rockRidgeChk->setText( tr( "&Rock Ridge" ) );
    QToolTip::add(  rockRidgeChk, tr( "Generate SUSP and RR records using the Rock Ridge protocol<br>to further describe the files on the iso9660 filesystem." ) );

    jolietChk = new QCheckBox( imagePnl, "jolietChk" );
    jolietChk->setGeometry( QRect( 10, 50, 189, 30 ) ); 
    jolietChk->setMinimumSize( QSize( 0, 30 ) );
    jolietChk->setText( tr( "&Joliet extension" ) );
    QToolTip::add(  jolietChk, tr( "Generate Joliet directory records<br>in addition to regular iso9660 file names." ) );

    relaxedNamesChk = new QCheckBox( imagePnl, "relaxedNamesChk" );
    relaxedNamesChk->setGeometry( QRect( 250, 50, 204, 30 ) ); 
    relaxedNamesChk->setMinimumSize( QSize( 0, 30 ) );
    relaxedNamesChk->setText( tr( "Rela&xed filenames" ) );
    QToolTip::add(  relaxedNamesChk, tr( "This options allows long (31<nobr> character)<br>filenames to begin with a period, include<br>lower case characters, and more<br>than one dot." ) );

    generateTablsChk = new QCheckBox( imagePnl, "generateTablsChk" );
    generateTablsChk->setGeometry( QRect( 250, 80, 204, 30 ) ); 
    generateTablsChk->setMinimumSize( QSize( 0, 30 ) );
    generateTablsChk->setText( tr( "&Generate TRANS.TBL files" ) );
    QToolTip::add(  generateTablsChk, tr( "Generate a file TRANS.TBL in each directory<br>on the CDROM, which can be used on non-Rock Ridge capable systems to help establish the correct file names." ) );

    imageNameTxt = new QLineEdit( imagePnl, "imageNameTxt" );
    imageNameTxt->setGeometry( QRect( 115, 140, 380, 22 ) ); 
    imageNameTxt->setText( tr( "cdboImage_<DATE>.iso" ) );
    QToolTip::add(  imageNameTxt, tr( "This name will be given to the new image.<br>Note that empty spaces will be replaced with underscores and .iso extension will be added if not present already." ) );

    appleChk = new QCheckBox( imagePnl, "appleChk" );
    appleChk->setGeometry( QRect( 10, 110, 93, 30 ) ); 
    appleChk->setMinimumSize( QSize( 0, 30 ) );
    appleChk->setText( tr( "Apple" ) );
    QToolTip::add(  appleChk, tr( "Create an ISO9660 CD with Apple's extensions.<br>Similar to the HFS option, except that the Apple Extensions are added to ISO9660 instead of creating an HFS hybrid volume." ) );

    hfsChk = new QCheckBox( imagePnl, "hfsChk" );
    hfsChk->setGeometry( QRect( 10, 80, 189, 30 ) ); 
    hfsChk->setMinimumSize( QSize( 0, 30 ) );
    hfsChk->setText( tr( "HFS" ) );
    QToolTip::add(  hfsChk, tr( "Create an ISO9660/HFS hybrid CD. This<b></b> option may be used only in conjunction with Probe option, located in Extras. It is recommended to use Apple option instead." ) );

    imageTabLayout->addMultiCellWidget( imagePnl, 1, 1, 0, 1 );

    cdda2wavPnl = new QButtonGroup( imageTab, "cdda2wavPnl" );
    cdda2wavPnl->setMinimumSize( QSize( 0, 0 ) );
    cdda2wavPnl->setMaximumSize( QSize( 2900, 32767 ) );
    cdda2wavPnl->setTitle( tr( "CD Type:" ) );
    cdda2wavPnl->setColumnLayout(0, Qt::Vertical );
    cdda2wavPnl->layout()->setSpacing( 0 );
    cdda2wavPnl->layout()->setMargin( 0 );
    cdda2wavPnlLayout = new QVBoxLayout( cdda2wavPnl->layout() );
    cdda2wavPnlLayout->setAlignment( Qt::AlignTop );
    cdda2wavPnlLayout->setSpacing( 7 );
    cdda2wavPnlLayout->setMargin( 10 );

    linuxRBtn = new QRadioButton( cdda2wavPnl, "linuxRBtn" );
    linuxRBtn->setText( tr( "&Linux" ) );
    linuxRBtn->setChecked( TRUE );
    QToolTip::add(  linuxRBtn, tr( "Linux type (\"Relaxed\")." ) );
    cdda2wavPnlLayout->addWidget( linuxRBtn );

    linwinRBtn = new QRadioButton( cdda2wavPnl, "linwinRBtn" );
    linwinRBtn->setText( tr( "Linux &  Windows" ) );
    QToolTip::add(  linwinRBtn, tr( "Chose this type if you want your CD to work on most OS." ) );
    cdda2wavPnlLayout->addWidget( linwinRBtn );

    customRBtn = new QRadioButton( cdda2wavPnl, "customRBtn" );
    customRBtn->setText( tr( "Custom" ) );
    QToolTip::add(  customRBtn, tr( "Custom CD type -- you create your own CD." ) );
    cdda2wavPnlLayout->addWidget( customRBtn );

    Line3 = new QFrame( cdda2wavPnl, "Line3" );
    Line3->setFrameStyle( QFrame::HLine | QFrame::Sunken );
    cdda2wavPnlLayout->addWidget( Line3 );

    hybridChk = new QCheckBox( cdda2wavPnl, "hybridChk" );
    hybridChk->setMinimumSize( QSize( 0, 30 ) );
    hybridChk->setText( tr( "&ISO 9960/HFS hybrid" ) );
    QToolTip::add(  hybridChk, tr( "ISO 9960/HFS hybrid." ) );
    cdda2wavPnlLayout->addWidget( hybridChk );

    imageTabLayout->addWidget( cdda2wavPnl, 0, 0 );

    sessionPropertiesPnl = new QButtonGroup( imageTab, "sessionPropertiesPnl" );
    sessionPropertiesPnl->setEnabled( TRUE );
    sessionPropertiesPnl->setTitle( tr( "Session Properties" ) );
    sessionPropertiesPnl->setColumnLayout(0, Qt::Vertical );
    sessionPropertiesPnl->layout()->setSpacing( 0 );
    sessionPropertiesPnl->layout()->setMargin( 0 );
    sessionPropertiesPnlLayout = new QGridLayout( sessionPropertiesPnl->layout() );
    sessionPropertiesPnlLayout->setAlignment( Qt::AlignTop );
    sessionPropertiesPnlLayout->setSpacing( 7 );
    sessionPropertiesPnlLayout->setMargin( 10 );

    singleSesRBtn = new QRadioButton( sessionPropertiesPnl, "singleSesRBtn" );
    singleSesRBtn->setText( tr( "&Single-Session" ) );
    QToolTip::add(  singleSesRBtn, tr( "Create a stand alone ISO Image or CD." ) );

    sessionPropertiesPnlLayout->addWidget( singleSesRBtn, 0, 0 );

    multiSesRBtn = new QRadioButton( sessionPropertiesPnl, "multiSesRBtn" );
    multiSesRBtn->setText( tr( "&Multi-Session" ) );
    QToolTip::add(  multiSesRBtn, tr( "Create ISO Image that is a part of a <b></b>multi-session CD." ) );

    sessionPropertiesPnlLayout->addWidget( multiSesRBtn, 0, 1 );

    forceRRChk = new QCheckBox( sessionPropertiesPnl, "forceRRChk" );
    forceRRChk->setText( tr( "Force Rock Ridge" ) );
    QToolTip::add(  forceRRChk, tr( "Do not use the automatic Rock Ridge attributes recognition for previous <b></b>sessions." ) );
	
    sessionPropertiesPnlLayout->addMultiCellWidget( forceRRChk, 4, 4, 0, 1 );

    checkOldNamesChk = new QCheckBox( sessionPropertiesPnl, "checkOldNamesChk" );
    checkOldNamesChk->setText( tr( "Check old sessions names" ) );
    QToolTip::add(  checkOldNamesChk, tr( "Check all filenames imported from old session for compliance with actual mkisofs iso9660 file naming <b></b>rules." ) );

    sessionPropertiesPnlLayout->addMultiCellWidget( checkOldNamesChk, 3, 3, 0, 1 );

    chkOldSesChk = new QCheckBox( sessionPropertiesPnl, "chkOldSesChk" );
    chkOldSesChk->setText( tr( "Check old sessions" ) );
    QToolTip::add(  chkOldSesChk, tr( "Check all old sessions for compliance with actual mkisofs iso9660 file naming <b></b>rules." ) );

    sessionPropertiesPnlLayout->addMultiCellWidget( chkOldSesChk, 2, 2, 0, 1 );

    Line7 = new QFrame( sessionPropertiesPnl, "Line7" );
    Line7->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    sessionPropertiesPnlLayout->addMultiCellWidget( Line7, 1, 1, 0, 1 );

    imageTabLayout->addWidget( sessionPropertiesPnl, 0, 1 );
    isoOptTbs->insertTab( imageTab, tr( "Settings" ) );

    extrasTab = new QWidget( isoOptTbs, "extrasTab" );
    extrasTabLayout = new QVBoxLayout( extrasTab ); 
    extrasTabLayout->setSpacing( 4 );
    extrasTabLayout->setMargin( 7 );

    GroupBox6_2 = new QGroupBox( extrasTab, "GroupBox6_2" );
    GroupBox6_2->setTitle( tr( "Specialized Options" ) );

    probeChk = new QCheckBox( GroupBox6_2, "probeChk" );
    probeChk->setGeometry( QRect( 11, 22, 170, 30 ) ); 
    probeChk->setMinimumSize( QSize( 165, 30 ) );
    probeChk->setText( tr( "Probe" ) );
    QToolTip::add(  probeChk, tr( "Search the contents of files for all<br>known Apple/Unix file formats. May negatively reflect on performance. " ) );

    multivoluemedChk = new QCheckBox( GroupBox6_2, "multivoluemedChk" );
    multivoluemedChk->setGeometry( QRect( 11, 58, 140, 30 ) );
    multivoluemedChk->setMinimumSize( QSize( 0, 30 ) );
    multivoluemedChk->setMaximumSize( QSize( 152, 32767 ) );
    multivoluemedChk->setText( tr( "Multi-Volumed Set" ) );
    QToolTip::add(  multivoluemedChk, tr( "Use if this CD is a part of CD set." ) );

    volumeSetSizeLbl = new QLabel( GroupBox6_2, "volumeSetSizeLbl" );
    volumeSetSizeLbl->setGeometry( QRect( 150, 58, 112, 30 ) );
    volumeSetSizeLbl->setMinimumSize( QSize( 0, 30 ) );
    volumeSetSizeLbl->setText( tr( "Set size:" ) );
    volumeSetSizeLbl->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    volumeSetSizeSpn = new QSpinBox( GroupBox6_2, "volumeSetSizeSpn" );
    volumeSetSizeSpn->setGeometry( QRect( 267, 58, 40, 30 ) ); 
    volumeSetSizeSpn->setMinimumSize( QSize( 40, 30 ) );
    volumeSetSizeSpn->setMaximumSize( QSize( 35, 32767 ) );
    volumeSetSizeSpn->setMinValue( 0 );
    QToolTip::add(  volumeSetSizeSpn, tr( " Sets the volume set size." ) );

    volumeSetSequenceSpn = new QSpinBox( GroupBox6_2, "volumeSetSequenceSpn" );
    volumeSetSequenceSpn->setGeometry( QRect( 466, 58, 40, 30 ) ); 
    volumeSetSequenceSpn->setMinimumSize( QSize( 40, 30 ) );
    volumeSetSequenceSpn->setMaximumSize( QSize( 40, 30 ) );
    volumeSetSequenceSpn->setMinValue( 0 );
    QToolTip::add(  volumeSetSequenceSpn, tr( "Sets the volume set sequence number." ) );

    volumeSetSequenceLbl = new QLabel( GroupBox6_2, "volumeSetSequenceLbl" );
    volumeSetSequenceLbl->setGeometry( QRect( 335, 58, 125, 30 ) );
    volumeSetSequenceLbl->setMinimumSize( QSize( 0, 30 ) );
    volumeSetSequenceLbl->setText( tr( "Set sequence #:" ) );

    omitVersionChk = new QCheckBox( GroupBox6_2, "omitVersionChk" );
    omitVersionChk->setGeometry( QRect( 183, 22, 170, 30 ) );
    omitVersionChk->setMinimumSize( QSize( 0, 30 ) );
    omitVersionChk->setMaximumSize( QSize( 195, 32767 ) );
    omitVersionChk->setText( tr( "Omit version number" ) );
    QToolTip::add(  omitVersionChk, tr( "Omit version numbers from ISO9660 file names." ) );

    hideRRChk = new QCheckBox( GroupBox6_2, "hideRRChk" );
    hideRRChk->setGeometry( QRect( 366, 22, 140, 30 ) );
    hideRRChk->setMinimumSize( QSize( 0, 30 ) );
    hideRRChk->setText( tr( "Hide RR_MOVED" ) );
    QToolTip::add(  hideRRChk, tr( "Rename  the  directory<br>RR_MOVED to .rr_moved in the Rock Ridge tree." ) );
    extrasTabLayout->addWidget( GroupBox6_2 );

    filenamePnl = new QButtonGroup( extrasTab, "filenamePnl" );
    filenamePnl->setMaximumSize( QSize( 32767, 115 ) );
    filenamePnl->setTitle( tr( "Filename Options" ) );
    filenamePnl->setColumnLayout(0, Qt::Vertical );
    filenamePnl->layout()->setSpacing( 0 );
    filenamePnl->layout()->setMargin( 0 );
    filenamePnlLayout = new QGridLayout( filenamePnl->layout() );
    filenamePnlLayout->setAlignment( Qt::AlignTop );
    filenamePnlLayout->setSpacing( 0 );
    filenamePnlLayout->setMargin( 10 );

    beginPeriodChk = new QCheckBox( filenamePnl, "beginPeriodChk" );
    beginPeriodChk->setMinimumSize( QSize( 0, 30 ) );
    beginPeriodChk->setText( tr( "Allow filenames to begin with a period" ) );
    QToolTip::add(  beginPeriodChk, tr( "Allow ISO9660 filenames to begin with a period." ) );

    filenamePnlLayout->addMultiCellWidget( beginPeriodChk, 1, 2, 0, 0 );

    untransFNmamesChk = new QCheckBox( filenamePnl, "untransFNmamesChk" );
    untransFNmamesChk->setMinimumSize( QSize( 0, 30 ) );
    untransFNmamesChk->setText( tr( "Allow untranslated filenames" ) );
    QToolTip::add(  untransFNmamesChk, tr( "Allows \"Untranslated\" filenames,<br>completely violating the iso9660 standards. Overrides all other filename options. Use with extreme care." ) );

    filenamePnlLayout->addWidget( untransFNmamesChk, 0, 0 );

    longFNamesChk = new QCheckBox( filenamePnl, "longFNamesChk" );
    longFNamesChk->setMinimumSize( QSize( 0, 30 ) );
    longFNamesChk->setText( tr( "Allow long filenames" ) );
    QToolTip::add(  longFNamesChk, tr( "Allow full 31 character filenames." ) );

    filenamePnlLayout->addWidget( longFNamesChk, 3, 0 );

    omitTrailChk = new QCheckBox( filenamePnl, "omitTrailChk" );
    omitTrailChk->setMinimumSize( QSize( 0, 30 ) );
    omitTrailChk->setText( tr( "Allow trailing period" ) );
    QToolTip::add(  omitTrailChk, tr( "Allow trailing period on<br>files that do not have a period." ) );

    filenamePnlLayout->addWidget( omitTrailChk, 0, 1 );

    multiDotChk = new QCheckBox( filenamePnl, "multiDotChk" );
    multiDotChk->setMinimumSize( QSize( 0, 30 ) );
    multiDotChk->setText( tr( "Allow multidot filenames" ) );
    QToolTip::add(  multiDotChk, tr( "This <b></b>options allows more than one dot to appear in iso9660 filenames. " ) );

    filenamePnlLayout->addMultiCellWidget( multiDotChk, 2, 3, 1, 1 );

    lowercaseChk = new QCheckBox( filenamePnl, "lowercaseChk" );
    lowercaseChk->setMinimumSize( QSize( 0, 30 ) );
    lowercaseChk->setText( tr( "Allow lower case filenames" ) );
    QToolTip::add(  lowercaseChk, tr( "This options allows lower case characters<br>to appear in iso9660 filenames." ) );

    filenamePnlLayout->addWidget( lowercaseChk, 1, 1 );
    extrasTabLayout->addWidget( filenamePnl );

    bootPnl = new QGroupBox( extrasTab, "bootPnl" );
    bootPnl->setTitle( tr( "'ElTorito'  - Bootable CD Options" ) );

    biLbl = new QLabel( bootPnl, "biLbl" );
    biLbl->setGeometry( QRect( 10, 60, 80, 30 ) ); 
    biLbl->setText( tr( "Boot image:" ) );

    bcLbl = new QLabel( bootPnl, "bcLbl" );
    bcLbl->setGeometry( QRect( 10, 100, 90, 30 ) ); 
    bcLbl->setText( tr( "Boot catalog:" ) );

    bootCatalogLbl = new QLabel( bootPnl, "bootCatalogLbl" );
    bootCatalogLbl->setGeometry( QRect( 110, 100, 360, 30 ) ); 
    bootCatalogLbl->setMinimumSize( QSize( 0, 30 ) );
    bootCatalogLbl->setMaximumSize( QSize( 32767, 30 ) );
    bootCatalogLbl->setFrameShape( QLabel::Box );
    bootCatalogLbl->setFrameShadow( QLabel::Raised );
    bootCatalogLbl->setText( tr( "" ) );
    QToolTip::add(  bootCatalogLbl, tr( "Specify boot catalog to be used when creating bootable CD. This file is <b>required</b> to make a bootable CD." ) );

    bootLbl = new QLabel( bootPnl, "bootLbl" );
    bootLbl->setGeometry( QRect( 110, 60, 360, 30 ) ); 
    bootLbl->setMinimumSize( QSize( 0, 30 ) );
    bootLbl->setMaximumSize( QSize( 32767, 30 ) );
    bootLbl->setFrameShape( QLabel::Box );
    bootLbl->setFrameShadow( QLabel::Raised );
    bootLbl->setText( tr( "" ) );
    QToolTip::add(  bootLbl, tr( "Specify boot image file. This file is <b>required</b> to make a bootable CD." ) );

    bootBrowseBtn = new QPushButton( bootPnl, "bootBrowseBtn" );
    bootBrowseBtn->setGeometry( QRect( 480, 60, 28, 30 ) ); 
    bootBrowseBtn->setMinimumSize( QSize( 28, 30 ) );
    bootBrowseBtn->setMaximumSize( QSize( 28, 30 ) );
    bootBrowseBtn->setText( tr( "..." ) );
    QToolTip::add(  bootBrowseBtn, tr( "Open file dialog." ) );

    bootCatalogBrowseBtn = new QPushButton( bootPnl, "bootCatalogBrowseBtn" );
    bootCatalogBrowseBtn->setGeometry( QRect( 480, 100, 28, 30 ) ); 
    bootCatalogBrowseBtn->setMinimumSize( QSize( 28, 30 ) );
    bootCatalogBrowseBtn->setMaximumSize( QSize( 28, 30 ) );
    bootCatalogBrowseBtn->setText( tr( "..." ) );
    QToolTip::add(  bootCatalogBrowseBtn, tr( "Open file dialog." ) );

    bootableChk = new QCheckBox( bootPnl, "bootableChk" );
    bootableChk->setGeometry( QRect( 20, 30, 120, 21 ) ); 
    bootableChk->setText( tr( "Bootable CD" ) );
    QToolTip::add(  bootableChk, tr( "Create bootable CD. Please note that both<b></b> boot image and catalog must be present in order to make bootable CD." ) );
    extrasTabLayout->addWidget( bootPnl );
    isoOptTbs->insertTab( extrasTab, tr( "Extras" ) );

    lablesTab = new QWidget( isoOptTbs, "lablesTab" );
    lablesTabLayout = new QVBoxLayout( lablesTab ); 
    lablesTabLayout->setSpacing( 4 );
    lablesTabLayout->setMargin( 7 );

    GroupBox2_2 = new QGroupBox( lablesTab, "GroupBox2_2" );
    GroupBox2_2->setTitle( tr( "Labels" ) );

    TextLabel1_2_2 = new QLabel( GroupBox2_2, "TextLabel1_2_2" );
    TextLabel1_2_2->setGeometry( QRect( 10, 20, 100, 31 ) ); 
    TextLabel1_2_2->setText( tr( "Application ID:" ) );

    TextLabel1_4 = new QLabel( GroupBox2_2, "TextLabel1_4" );
    TextLabel1_4->setGeometry( QRect( 10, 60, 80, 31 ) ); 
    TextLabel1_4->setText( tr( "Volume ID:" ) );

    TextLabel1_3_2_2_2 = new QLabel( GroupBox2_2, "TextLabel1_3_2_2_2" );
    TextLabel1_3_2_2_2->setGeometry( QRect( 10, 260, 100, 31 ) ); 
    TextLabel1_3_2_2_2->setText( tr( "Copyright Info:" ) );

    TextLabel1_3_2_2 = new QLabel( GroupBox2_2, "TextLabel1_3_2_2" );
    TextLabel1_3_2_2->setGeometry( QRect( 10, 220, 80, 31 ) ); 
    TextLabel1_3_2_2->setText( tr( "Preparer ID:" ) );

    Line1 = new QFrame( GroupBox2_2, "Line1" );
    Line1->setGeometry( QRect( 8, 147, 491, 21 ) ); 
    Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    TextLabel1_3_2 = new QLabel( GroupBox2_2, "TextLabel1_3_2" );
    TextLabel1_3_2->setGeometry( QRect( 10, 180, 80, 31 ) ); 
    TextLabel1_3_2->setText( tr( "Publisher ID:" ) );

    preparerIdTxt = new QLineEdit( GroupBox2_2, "preparerIdTxt" );
    preparerIdTxt->setGeometry( QRect( 110, 220, 391, 31 ) ); 
    QToolTip::add(  preparerIdTxt, tr( "This should describe the preparer of the CDROM,<br>usually with a mailing address and phone number." ) );

    publisherIdTxt = new QLineEdit( GroupBox2_2, "publisherIdTxt" );
    publisherIdTxt->setGeometry( QRect( 110, 180, 391, 31 ) ); 
    QToolTip::add(  publisherIdTxt, tr( "This should describe the publisher of the CDROM,<br>usually with a mailing address and phone number." ) );

    copyrightTxt = new QLineEdit( GroupBox2_2, "copyrightTxt" );
    copyrightTxt->setGeometry( QRect( 110, 260, 391, 31 ) ); 
    QToolTip::add(  copyrightTxt, tr( QString::fromUtf8( "Copyright information, often the name of a file<br>on the disc containing the copy­right notice." ) ) );

    volumeSetTxt = new QLineEdit( GroupBox2_2, "volumeSetTxt" );
    volumeSetTxt->setGeometry( QRect( 141, 100, 360, 31 ) ); 
    QToolTip::add(  volumeSetTxt, tr( "The Volume Set Name." ) );

    TextLabel1_3_2_3 = new QLabel( GroupBox2_2, "TextLabel1_3_2_3" );
    TextLabel1_3_2_3->setGeometry( QRect( 10, 100, 120, 31 ) ); 
    TextLabel1_3_2_3->setText( tr( "Volume Set Name:" ) );

    applicationIdTxt = new QLineEdit( GroupBox2_2, "applicationIdTxt" );
    applicationIdTxt->setGeometry( QRect( 121, 20, 380, 31 ) ); 
    QToolTip::add(  applicationIdTxt, tr( "The application identifier should describe the application<br>that will be on the disc." ) );

    volumeIdTxt = new QLineEdit( GroupBox2_2, "volumeIdTxt" );
    volumeIdTxt->setGeometry( QRect( 101, 60, 400, 31 ) ); 
    QToolTip::add(  volumeIdTxt, tr( "The Volume Identifier." ) );
    lablesTabLayout->addWidget( GroupBox2_2 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    lablesTabLayout->addItem( spacer );
    isoOptTbs->insertTab( lablesTab, tr( "Labels" ) );

    // signals and slots connections
    connect( linuxRBtn, SIGNAL( clicked() ), this, SLOT( linuxTypeSlot() ) );
    connect( linwinRBtn, SIGNAL( clicked() ), this, SLOT( linWinTypeSlot() ) );
    connect( customRBtn, SIGNAL( clicked() ), this, SLOT( customTypeSlot() ) );
    connect( hybridChk, SIGNAL( clicked() ), this, SLOT( hybridSlot() ) );
    connect( bootBrowseBtn, SIGNAL( clicked() ), this, SLOT( browseBootSlot() ) );
    connect( bootableChk, SIGNAL( clicked() ), this, SLOT( bootableSlot() ) );
    connect( multivoluemedChk, SIGNAL( clicked() ), this, SLOT( multivolSlot() ) );
    connect( filenamePnl, SIGNAL( clicked(int) ), this, SLOT( filenameChangeSlot(int) ) );
    connect( relaxedNamesChk, SIGNAL( clicked() ), this, SLOT( relaxedFilenamesSlot() ) );
    connect( bootCatalogBrowseBtn, SIGNAL( clicked() ), this, SLOT( bootCatalogBrowseSlot() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
IsoOptPnlBase::~IsoOptPnlBase()
{
    // no need to delete child widgets, Qt does it all for us
}

void IsoOptPnlBase::bootCatalogBrowseSlot()
{
    qWarning( "IsoOptPnlBase::bootCatalogBrowseSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::bootableSlot()
{
    qWarning( "IsoOptPnlBase::bootableSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::browseBootSlot()
{
    qWarning( "IsoOptPnlBase::browseBootSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::customTypeSlot()
{
    qWarning( "IsoOptPnlBase::customTypeSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::filenameChangeSlot(int)
{
    qWarning( "IsoOptPnlBase::filenameChangeSlot(int): Not implemented yet!" );
}

void IsoOptPnlBase::hybridSlot()
{
    qWarning( "IsoOptPnlBase::hybridSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::linWinTypeSlot()
{
    qWarning( "IsoOptPnlBase::linWinTypeSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::linuxTypeSlot()
{
    qWarning( "IsoOptPnlBase::linuxTypeSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::multivolSlot()
{
    qWarning( "IsoOptPnlBase::multivolSlot(): Not implemented yet!" );
}

void IsoOptPnlBase::relaxedFilenamesSlot()
{
    qWarning( "IsoOptPnlBase::relaxedFilenamesSlot(): Not implemented yet!" );
}

