/***************************************************************************
                          IsoOptPnl.h  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//#include <iostream.h>

#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qtooltip.h>
#include <qimage.h>

#include <kiconloader.h>
#include <kconfig.h>
#include <kapp.h>
#include <ksimpleconfig.h>
#include <kfiledialog.h>
#include <klocale.h>

#include "IsoOptPnl.h"
#include "IsoOptPnlBase.h"

/*
 *  Constructs a IsoOptPnlBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
IsoOptPnl::IsoOptPnl( QWidget* parent,  const char* name, WFlags fl )
    : IsoOptPnlBase( parent, name, fl ){
    	
    	bootBrowseBtn->setPixmap( UserIcon("fileopen", KIcon::SizeMedium ) );
    	bootCatalogBrowseBtn->setPixmap( UserIcon("fileopen", KIcon::SizeMedium ) );
	
	config = kapp->config();
    	readOptions();
    	
    	connect( singleSesRBtn, SIGNAL( clicked() ), this, SLOT( sessionChangedSlot() ) );
    	connect( multiSesRBtn, SIGNAL( clicked() ), this, SLOT( sessionChangedSlot() ) );
}

IsoOptPnl::~IsoOptPnl(){
}
//=====================================
void IsoOptPnl::saveOptions(){
	config->setGroup("ISO Settings");		
	if(linuxRBtn->isChecked())
		config->writeEntry("ISO Type",IsoOptPnl::LinuxISO);
	else if(linwinRBtn->isChecked())
		config->writeEntry("ISO Type",IsoOptPnl::LinWinISO);
	//else if(audioRBtn->isChecked())
	//	config->writeEntry("ISO Type",IsoOptPnl::AudioISO);
	else{
		config->writeEntry("ISO Type",IsoOptPnl::CustomISO);
		
		config->writeEntry("Rock Ridge", rockRidgeChk->isChecked());
		config->writeEntry("Joliet", jolietChk->isChecked());
		config->writeEntry("Relaxed File Names", relaxedNamesChk->isChecked());
		
		config->writeEntry("Begin Period File", beginPeriodChk->isChecked());
      		config->writeEntry("Untrans File Names", untransFNmamesChk->isChecked());
      		config->writeEntry("Long File Names", longFNamesChk->isChecked());
      		config->writeEntry("Omit Trailing Period", omitTrailChk->isChecked());
      		config->writeEntry("Multidot File Names", multiDotChk->isChecked());
      		config->writeEntry("Lower Case File Names", lowercaseChk->isChecked());	
      		config->writeEntry("Deep Dir Relocation", noDeepChk->isChecked());		
	}
	
	if(hybridChk->isChecked()){
	 	config->writeEntry("Hybrid",true);
	 	config->writeEntry("HFS", hfsChk->isChecked());
	 	config->writeEntry("Apple", appleChk->isChecked());
	 	config->writeEntry("Probe",probeChk->isChecked());
	 }
	 else
	 	config->writeEntry("Hybrid",false);
	 	
	config->writeEntry("Generate Tbl", generateTablsChk->isChecked());
     	config->writeEntry("Follow Sym Links", followSymChk->isChecked());
	 	
     	if(singleSesRBtn->isChecked())
		config->writeEntry("Session Type","Single");
     	else
     		config->writeEntry("Session Type","Multi-Session");
     		
     	config->writeEntry("Check old sessions", chkOldSesChk->isChecked());
     	config->writeEntry("Check old sessions names", checkOldNamesChk->isChecked());
     	config->writeEntry("Force Rock Ridge", forceRRChk->isChecked());
     	
     		
	 if(multivoluemedChk->isChecked()){
	 	config->writeEntry("Multivolumed Set",true);
	 	config->writeEntry("Volume Set Size", volumeSetSizeSpn->value());
	 	config->writeEntry("Volume Set Sequence", volumeSetSequenceSpn->value());
	 }
	else
	 	config->writeEntry("Multivolumed Set",false);
		
	config->writeEntry("Omit Version",omitVersionChk->isChecked());
	config->writeEntry("Hide RR",hideRRChk->isChecked());
	
	if(bootableChk->isChecked()){
		config->writeEntry("Bootable", true);
		config->writeEntry("Boot Catalog",bootCatalogLbl->text());
     		config->writeEntry("Boot Image",bootLbl->text());
	}
	else
		config->writeEntry("Bootable", false);
		
	config->writeEntry("Application ID", applicationIdTxt->text());
	config->writeEntry("Volume ID", volumeIdTxt->text());
	config->writeEntry("Publisher ID", publisherIdTxt->text());
	config->writeEntry("Preparer ID", preparerIdTxt->text());
	config->writeEntry("Copyright", copyrightTxt->text());
	config->writeEntry("Volume Set Name", volumeSetTxt->text());
	 	
	config->writeEntry("Custom ISO Options", extraOptTxt->text());
	
	QString buff = imageNameTxt->text();
	
	if(buff && buff != ""){
		if(buff.find(".iso", -4, false) == -1)
			buff = buff.stripWhiteSpace() + ".iso";
		buff = buff.simplifyWhiteSpace();
		buff.replace(QRegExp(" "), "_");
		config->writeEntry("Custom ISO Name", buff);
	}
	else
		config->writeEntry("Custom ISO Name", "cdboImage_<DATE>.iso");
	config->sync();
}
//=====================================
void IsoOptPnl::readOptions(){
	//////////////////////////////////////////////
    	config->setGroup("ISO Settings");		
    	
	int type = config->readNumEntry("ISO Type", IsoOptPnl::LinWinISO);
	switch(type){
		case IsoOptPnl::LinuxISO:{
			linuxRBtn->setChecked(true);
			linuxTypeSlot();
			break;
		}
		case IsoOptPnl::LinWinISO:{
			linwinRBtn->setChecked(true);
			linWinTypeSlot();
			break;
		}
		/*case IsoOptPnl::AudioISO:{
			audioRBtn->setChecked(true);
			audioTypeSlot();
			break;
		}*/
		default:{
			customRBtn->setChecked(true);
			customTypeSlot();
			
			rockRidgeChk->setChecked(config->readBoolEntry("Rock Ridge", false));
			jolietChk->setChecked(config->readBoolEntry("Joliet", false));
			relaxedNamesChk->setChecked(config->readBoolEntry("Relaxed File Names", false));
			
			beginPeriodChk->setChecked(config->readBoolEntry("Begin Period File", false));
			untransFNmamesChk->setChecked(config->readBoolEntry("Untrans File Names", false));
			longFNamesChk->setChecked(config->readBoolEntry("Long File Names", false));
			omitTrailChk->setChecked(config->readBoolEntry("Do Not Omit Trailing Period", false));
			multiDotChk->setChecked(config->readBoolEntry("Multidot File Names", false));
			lowercaseChk->setChecked(config->readBoolEntry("Lower Case File Names", false));		
			noDeepChk->setChecked(config->readBoolEntry("Deep Dir Relocation", false));
			break;
		}
	}
	
	bool b = config->readBoolEntry("Hybrid", false);
	hybridChk->setChecked(b);
	hybridSlot();
	if(b){
		hfsChk->setChecked(config->readBoolEntry("HFS", false));
	 	appleChk->setChecked(config->readBoolEntry("Apple", false));
	 	probeChk->setChecked(config->readBoolEntry("Probe", false));
	}
	
	generateTablsChk->setChecked(config->readBoolEntry("Generate Tbl", false));
     followSymChk->setChecked( config->readBoolEntry("Follow Sym Links", false));
	
	if(config->readEntry("Session Type", "Single") ==  "Single")
		singleSesRBtn->setChecked(true);
     	else
     		multiSesRBtn->setChecked(true);
     		
     	chkOldSesChk->setChecked( config->readBoolEntry("Check old sessions", false));
     	checkOldNamesChk->setChecked( config->readBoolEntry("Check old sessions names", false));
     	forceRRChk->setChecked( config->readBoolEntry("Force Rock Ridge", false));
	sessionChangedSlot();
	
	b = config->readBoolEntry("Multivolumed Set", false);
	multivoluemedChk->setChecked(b);
	multivolSlot();
	if(b){
		volumeSetSizeSpn->setValue(config->readNumEntry("Volume Set Size", 0));
		volumeSetSequenceSpn->setValue(config->readNumEntry("Volume Set Sequence", 0));
	}
	
	omitVersionChk->setChecked(config->readBoolEntry("Omit Version", false));
	hideRRChk->setChecked(config->readBoolEntry("Hide RR", true));
	
	b = config->readBoolEntry("Bootable", false);
	bootableChk->setChecked(b);
	bootableSlot();
	if(b){
		bootCatalogLbl->setText(config->readEntry("Boot Catalog", ""));
     		bootLbl->setText(config->readEntry("Boot Image", ""));
	}
	
	applicationIdTxt->setText(config->readEntry("Application ID"));
	volumeIdTxt->setText(config->readEntry("Volume ID"));
	publisherIdTxt->setText(config->readEntry("Publisher ID"));
	preparerIdTxt->setText(config->readEntry("Preparer ID"));
	copyrightTxt->setText(config->readEntry("Copyright"));
	volumeSetTxt->setText(config->readEntry("Volume Set Name"));
	
	extraOptTxt->setText(config->readEntry("Custom ISO Options"));
	imageNameTxt->setText(config->readEntry("Custom ISO Name", "cdboImage_<DATE>.iso"));
}
//=====================================
void IsoOptPnl::applyDefaults(){
	
	bootLbl->setText("");
	bootCatalogLbl->setText("");
	appleChk->setChecked(false);
     hfsChk->setChecked(false);
     generateTablsChk->setChecked(false);
     followSymChk->setChecked(false);
     probeChk->setChecked(false);
	
	KSimpleConfig *config = (KSimpleConfig *)(kapp->config());
	config->deleteGroup("ISO Settings");
	readOptions();
}
//=====================================
void IsoOptPnl::linuxTypeSlot(){
	extrasTab->setEnabled(true);
	lablesTab->setEnabled(true);
	hybridChk->setEnabled(true);
	 imagePnl->setEnabled(true);
	setClickable(false);
	rockRidgeChk->setChecked(true);
   	jolietChk->setChecked(false);
	noDeepChk->setChecked(false);
    relaxedNamesChk->setChecked(true);
	relaxedFilenamesSlot();
	extraOptTxt->setEnabled(true);
	isoOptLbl->setEnabled(true);
	generateTablsChk->setEnabled(true);
	untransFNmamesChk->setChecked(false);
     omitTrailChk->setChecked(false);
}
//=====================================
void IsoOptPnl::linWinTypeSlot(){
	extrasTab->setEnabled(true);
	lablesTab->setEnabled(true);
	hybridChk->setEnabled(true);
	 imagePnl->setEnabled(true);
	setClickable(false);
	rockRidgeChk->setChecked(true);
   	jolietChk->setChecked(true);
     noDeepChk->setChecked(true);
     relaxedNamesChk->setChecked(false);
     relaxedFilenamesSlot();
	extraOptTxt->setEnabled(true);
	isoOptLbl->setEnabled(true);
	generateTablsChk->setEnabled(true);
	untransFNmamesChk->setChecked(false);
     omitTrailChk->setChecked(false);
}
//=====================================
void IsoOptPnl::customTypeSlot(){
	extrasTab->setEnabled(true);
	lablesTab->setEnabled(true);
	 imagePnl->setEnabled(true);
	setClickable(true);
	hybridChk->setEnabled(true);
	extraOptTxt->setEnabled(true);
	isoOptLbl->setEnabled(true);
	generateTablsChk->setEnabled(true);
}
//=====================================
void IsoOptPnl::hybridSlot(){
	bool b = hybridChk->isChecked();
	appleChk->setEnabled(b);
     hfsChk->setEnabled(b);
     probeChk->setEnabled(b);
     if(!b){
		appleChk->setChecked(false);
	     hfsChk->setChecked(false);
     		probeChk->setChecked(false);
	}
}
//=====================================
void IsoOptPnl::multivolSlot(){
	bool b = multivoluemedChk->isChecked();
	volumeSetSizeSpn->setEnabled(b);
     volumeSetSequenceSpn->setEnabled(b);
     volumeSetSequenceLbl->setEnabled(b);
     volumeSetSizeLbl->setEnabled(b);
}
//=======================================
void IsoOptPnl::bootableSlot(){
	bool b = bootableChk->isChecked();
	bootCatalogLbl->setEnabled(b);
	bootCatalogBrowseBtn->setEnabled(b);
	bootBrowseBtn->setEnabled(b);
     bootLbl->setEnabled(b);
     biLbl->setEnabled(b);
     bcLbl->setEnabled(b);
}
/*/=====================================
void IsoOptPnl::audioTypeSlot(){
	setClickable(false);
	
	
	
	rockRidgeChk->setChecked(false);
   	jolietChk->setChecked(false);
     noDeepChk->setChecked(false);
     relaxedNamesChk->setChecked(false);
     relaxedFilenamesSlot();
     untransFNmamesChk->setChecked(false);
     omitTrailChk->setChecked(false);

	hybridChk->setEnabled(false);
	hybridChk->setChecked(false);
	hybridSlot();
	extrasTab->setEnabled(false);
	lablesTab->setEnabled(false);
	extraOptTxt->setEnabled(false);
	isoOptLbl->setEnabled(false);
     generateTablsChk->setEnabled(false);
     imagePnl->setEnabled(false);
}*/
//=====================================
void IsoOptPnl::setClickable(bool yes){
	rockRidgeChk->setEnabled(yes);
   	jolietChk->setEnabled(yes);
     noDeepChk->setEnabled(yes);
     relaxedNamesChk->setEnabled(yes);
     filenamePnl->setEnabled(yes);
}
//=======================================
void IsoOptPnl::relaxedFilenamesSlot(){
	bool b = relaxedNamesChk->isChecked();
	beginPeriodChk->setChecked(b);
     //untransFNmamesChk->setChecked(b);
     longFNamesChk->setChecked(b);
     //omitTrailChk->setChecked(b);
     multiDotChk->setChecked(b);
     lowercaseChk->setChecked(b);
}
//========================================
void IsoOptPnl::browseBootSlot(){
	QString buff = bootCatalogLbl->text();
	if(!buff.isNull() && buff != "")
		buff = buff.left(buff.findRev("/", -2));
	else{
		config->setGroup("Default Settings");	
		buff = config->readEntry("Tmp Dir", QDir::homeDirPath());
	}
	
	QString fileToOpen = KFileDialog::getOpenFileName(buff,
				"*|All files",
				this,
				"Boot image");
	if(fileToOpen.isNull() || fileToOpen == "")
		return;
	bootLbl->setText( fileToOpen );
	QToolTip::add(  bootLbl,
		i18n( "Boot image file used:\n" +  fileToOpen +
			"\nPlease note that this file will be\n" +\
			" located in '/boot/' directory of this CD.") );
}
//========================================
void IsoOptPnl::bootCatalogBrowseSlot(){
	QString buff = bootCatalogLbl->text();
	if(!buff.isNull() && buff != "")
		buff = buff.left(buff.findRev("/", -2));
	else{
		config->setGroup("Default Settings");	
		buff = config->readEntry("Tmp Dir", QDir::homeDirPath());
	}
	
	QString fileToOpen = KFileDialog::getOpenFileName(buff,
				"*|All files",
				this,
				"Catalog file");
	if(fileToOpen.isNull() || fileToOpen == "")
		return;
	bootCatalogLbl->setText( fileToOpen );
	QToolTip::add(  bootLbl,
		i18n( "Boot catalog file used:\n" +  fileToOpen +
			"\nPlease note that this file will be file  will  be\n" +\
			"inserted into the output tree so be sure the\n"\
			"specified filename does not conflict with an existing\n"\
			"file, as it will be excluded.") );
}
//========================================
void IsoOptPnl::filenameChangeSlot(int){
	if(beginPeriodChk->isChecked() && longFNamesChk->isChecked() &&
						multiDotChk->isChecked() && lowercaseChk->isChecked())
		relaxedNamesChk->setChecked(true);
	
	else
		relaxedNamesChk->setChecked(false);
}
//========================================
void IsoOptPnl::sessionChangedSlot(){
	if(singleSesRBtn->isChecked()){
		chkOldSesChk->setEnabled(false);
     		checkOldNamesChk->setEnabled(false);
     		forceRRChk->setEnabled(false);
     	}
     	else{
     		chkOldSesChk->setEnabled(true);
     		checkOldNamesChk->setEnabled(true);
     		forceRRChk->setEnabled(true);
     	}
}