/***************************************************************************
                          MainDialogBase.cpp  -  description
                             -------------------
    begin                : Sat May 5 2001
    copyright            : (C) 2001 by Alexy Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "MainDialogBase.h"

#include <qcheckbox.h>
#include <qframe.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

#include <klocale.h>
#include <kiconloader.h>


/* 
 *  Constructs a MainDialogBase which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
MainDialogBase::MainDialogBase( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl ){
    if ( !name )
	setName( "MainDialogBase" );
    resize( 360, 500 ); 
    setMinimumSize( QSize( 360, 500 ) );
    setMaximumSize( QSize( 360, 500 ) );
    setCaption( i18n( "Main Dailog" ) );

    GroupBox3 = new QGroupBox( this, "GroupBox3" );
    GroupBox3->setGeometry( QRect( 10, 10, 340, 430 ) ); 
    GroupBox3->setMinimumSize( QSize( 340, 430 ) );
    GroupBox3->setMaximumSize( QSize( 340, 440 ) );
    GroupBox3->setFrameShape( QGroupBox::Box );
    GroupBox3->setFrameShadow( QGroupBox::Sunken );
    GroupBox3->setTitle( i18n( "Choose the Action" ) );

    Line1_2 = new QFrame( GroupBox3, "Line1_2" );
    Line1_2->setGeometry( QRect( 10, 170, 320, 20 ) ); 
    Line1_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    Line1_3 = new QFrame( GroupBox3, "Line1_3" );
    Line1_3->setGeometry( QRect( 10, 250, 320, 20 ) ); 
    Line1_3->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    Line1 = new QFrame( GroupBox3, "Line1" );
    Line1->setGeometry( QRect( 10, 90, 320, 20 ) ); 
    Line1->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    Line1_3_2 = new QFrame( GroupBox3, "Line1_3_2" );
    Line1_3_2->setGeometry( QRect( 10, 330, 320, 20 ) ); 
    Line1_3_2->setFrameStyle( QFrame::HLine | QFrame::Sunken );

    MusicCdLbl = new QLabel( GroupBox3, "MusicCdLbl" );
    MusicCdLbl->setGeometry( QRect( 120, 190, 210, 60 ) ); 
    QPalette pal;
    QColorGroup cg;
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 227, 227, 227) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    MusicCdLbl->setPalette( pal );
    QFont MusicCdLbl_font(  MusicCdLbl->font() );
    MusicCdLbl_font.setBold( TRUE );
    MusicCdLbl->setFont( MusicCdLbl_font ); 
    MusicCdLbl->setFrameShape( QLabel::StyledPanel );
    MusicCdLbl->setFrameShadow( QLabel::Sunken );
    MusicCdLbl->setText( i18n( "Create a new music CD." ) );
    MusicCdLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );

    configureLbl = new QLabel( GroupBox3, "configureLbl" );
    configureLbl->setGeometry( QRect( 120, 350, 210, 60 ) );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 227, 227, 227) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
     configureLbl->setPalette( pal );
    QFont configureLbl_font(  configureLbl->font() );
    configureLbl_font.setBold( TRUE );
    configureLbl->setFont( configureLbl_font );
    configureLbl->setFrameShape( QLabel::StyledPanel );
    configureLbl->setFrameShadow( QLabel::Sunken );
    configureLbl->setLineWidth( 1 );
    configureLbl->setMargin( 9 );
    configureLbl->setText( tr( "Configure properties and defaults." ) );
    configureLbl->setTextFormat( QLabel::AutoText );
    configureLbl->setScaledContents( FALSE );
    configureLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );
    configureLbl->setIndent( -1 );

    cdCopyLbl = new QLabel( GroupBox3, "cdCopyLbl" );
    cdCopyLbl->setGeometry( QRect( 120, 30, 210, 60 ) ); 
     cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 227, 227, 227) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    cdCopyLbl->setPalette( pal );
    QFont cdCopyLbl_font(  cdCopyLbl->font() );
    cdCopyLbl_font.setBold( TRUE );
    cdCopyLbl->setFont( cdCopyLbl_font ); 
    cdCopyLbl->setFrameShape( QLabel::StyledPanel );
    cdCopyLbl->setFrameShadow( QLabel::Sunken );
    cdCopyLbl->setText( i18n( "Copy music or data CD." ) );
    cdCopyLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );

    newCdLbl = new QLabel( GroupBox3, "newCdLbl" );
    newCdLbl->setGeometry( QRect( 120, 110, 210, 60 ) ); 
     cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 227, 227, 227) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    newCdLbl->setPalette( pal );
    QFont newCdLbl_font(  newCdLbl->font() );
    newCdLbl_font.setBold( TRUE );
    newCdLbl->setFont( newCdLbl_font ); 
    newCdLbl->setFrameShape( QLabel::StyledPanel );
    newCdLbl->setFrameShadow( QLabel::Sunken );
    newCdLbl->setMargin( 9 );
    newCdLbl->setText( i18n( "Burn a new CD from image file." ) );
    newCdLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );

    eraseCdLbl = new QLabel( GroupBox3, "eraseCdLbl" );
    eraseCdLbl->setGeometry( QRect( 120, 270, 210, 60 ) ); 
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 227, 227, 227) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setActive( cg );
    cg.setColor( QColorGroup::Foreground, black );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, black );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setInactive( cg );
    cg.setColor( QColorGroup::Foreground, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Button, QColor( 200, 200, 200) );
    cg.setColor( QColorGroup::Light, white );
    cg.setColor( QColorGroup::Midlight, QColor( 230, 230, 230) );
    cg.setColor( QColorGroup::Dark, QColor( 100, 100, 100) );
    cg.setColor( QColorGroup::Mid, QColor( 133, 133, 133) );
    cg.setColor( QColorGroup::Text, black );
    cg.setColor( QColorGroup::BrightText, QColor( 244, 244, 244) );
    cg.setColor( QColorGroup::ButtonText, QColor( 128, 128, 128) );
    cg.setColor( QColorGroup::Base, white );
    cg.setColor( QColorGroup::Background, QColor( 54, 121, 173) );
    cg.setColor( QColorGroup::Shadow, black );
    cg.setColor( QColorGroup::Highlight, QColor( 90, 181, 107) );
    cg.setColor( QColorGroup::HighlightedText, white );
    pal.setDisabled( cg );
    eraseCdLbl->setPalette( pal );
    QFont eraseCdLbl_font(  eraseCdLbl->font() );
    eraseCdLbl_font.setBold( TRUE );
    eraseCdLbl->setFont( eraseCdLbl_font ); 
    eraseCdLbl->setFrameShape( QLabel::StyledPanel );
    eraseCdLbl->setFrameShadow( QLabel::Sunken );
    eraseCdLbl->setText( i18n( "Erase CD-RW ...." ) );
    eraseCdLbl->setAlignment( int( QLabel::WordBreak | QLabel::AlignCenter ) );

    cdCopyBtn = new QPushButton( GroupBox3, "cdCopyBtn" );
    cdCopyBtn->setGeometry( QRect( 10, 30, 100, 60 ) ); 
    cdCopyBtn->setText( QString::null );
   	cdCopyBtn->setPixmap( UserIcon("copyCD") );
   	//cdCopyBtn->setPixmap( UserIcon("copyNew") );
    QToolTip::add(  cdCopyBtn, i18n( "Open copy dialog" ) );

    cdImageBtn = new QPushButton( GroupBox3, "cdImageBtn" );
    cdImageBtn->setGeometry( QRect( 10, 110, 100, 60 ) ); 
    cdImageBtn->setText( QString::null );
	
    	cdImageBtn->setPixmap( UserIcon("imageToCD") );

    QToolTip::add(  cdImageBtn, i18n( "Open new CD dialog" ) );

    musicCDBtn = new QPushButton( GroupBox3, "musicCDBtn" );
    musicCDBtn->setGeometry( QRect( 10, 190, 100, 60 ) ); 
    musicCDBtn->setText( QString::null );
    musicCDBtn->setPixmap( UserIcon("musicCD") );
    QToolTip::add(  musicCDBtn, i18n( "Not implemented" ) );

    eraseCdBtn = new QPushButton( GroupBox3, "eraseCdBtn" );
    eraseCdBtn->setGeometry( QRect( 10, 270, 100, 60 ) ); 
    eraseCdBtn->setText( QString::null );
    	eraseCdBtn->setPixmap( UserIcon("eraseCD") );
    QToolTip::add(  eraseCdBtn, i18n( "Open erase dialog" ) );

    configureBtn = new QPushButton( GroupBox3, "configureBtn" );
    configureBtn->setGeometry( QRect( 10, 350, 100, 60 ) ); 
    configureBtn->setText( QString::null );
    //configureBtn->setPixmap( UserIcon("setup") );
    configureBtn->setPixmap( UserIcon("package_utilities") );
    QToolTip::add(  configureBtn, i18n( "Open settings dialog" ) );

    doOnStartChk = new QCheckBox( this, "doOnStartChk" );
    doOnStartChk->setGeometry( QRect( 20, 450, 130, 21 ) ); 
    doOnStartChk->setText( i18n( "Run on startup" ) );
    doOnStartChk->setChecked( TRUE );
    QToolTip::add(  doOnStartChk, i18n( "&Keep this cheked if you want to start with this dialog next time." ) );

    exitBtn = new QPushButton( this, "exitBtn" );
    exitBtn->setGeometry( QRect( 270, 450, 81, 31 ) ); 
    exitBtn->setText( i18n( "&Dismiss" ) );
    QToolTip::add(  exitBtn, i18n( "Close this dailog" ) );

    cancelBtn = new QPushButton( this, "cancelBtn" );
    cancelBtn->setGeometry( QRect( 170, 450, 80, 31 ) ); 
    QFont cancelBtn_font(  cancelBtn->font() );
    cancelBtn_font.setBold( TRUE );
    cancelBtn->setFont( cancelBtn_font ); 
    cancelBtn->setText( i18n( "&Cancel" ) );
    cancelBtn->setDefault( FALSE );
    QToolTip::add(  cancelBtn, i18n( "Cancel" ) );

    // signals and slots connections
    connect( cdCopyBtn, SIGNAL( clicked() ), this, SLOT( copyCdSlot() ) );
    connect( cdImageBtn, SIGNAL( clicked() ), this, SLOT( newCdSlot() ) );
    connect( musicCDBtn, SIGNAL( clicked() ), this, SLOT( musicSlot() ) );
    connect( eraseCdBtn, SIGNAL( clicked() ), this, SLOT( eraseCdSlot() ) );
    connect( configureBtn, SIGNAL( clicked() ), this, SLOT( configureSlot() ) );
    connect( cancelBtn, SIGNAL( clicked() ), this, SLOT( cancelSlot() ) );
    connect( exitBtn, SIGNAL( clicked() ), this, SLOT( exitSlot() ) );

    // tab order
    setTabOrder( cancelBtn, exitBtn );
    setTabOrder( exitBtn, cdCopyBtn );
    setTabOrder( cdCopyBtn, cdImageBtn );
    setTabOrder( cdImageBtn, musicCDBtn );
    setTabOrder( musicCDBtn, eraseCdBtn );
    setTabOrder( eraseCdBtn, configureBtn );
    setTabOrder( configureBtn, doOnStartChk );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
MainDialogBase::~MainDialogBase()
{
    // no need to delete child widgets, Qt does it all for us
}

/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool MainDialogBase::event( QEvent* ev )
{
    bool ret = QDialog::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
	QFont MusicCdLbl_font(  MusicCdLbl->font() );
	MusicCdLbl_font.setBold( TRUE );
	MusicCdLbl->setFont( MusicCdLbl_font ); 
	QFont configureLbl_font(  configureLbl->font() );
	configureLbl_font.setBold( TRUE );
	configureLbl->setFont( configureLbl_font ); 
	QFont cdCopyLbl_font(  cdCopyLbl->font() );
	cdCopyLbl_font.setBold( TRUE );
	cdCopyLbl->setFont( cdCopyLbl_font ); 
	QFont newCdLbl_font(  newCdLbl->font() );
	newCdLbl_font.setBold( TRUE );
	newCdLbl->setFont( newCdLbl_font ); 
	QFont eraseCdLbl_font(  eraseCdLbl->font() );
	eraseCdLbl_font.setBold( TRUE );
	eraseCdLbl->setFont( eraseCdLbl_font ); 
	QFont cancelBtn_font(  cancelBtn->font() );
	cancelBtn_font.setBold( TRUE );
	cancelBtn->setFont( cancelBtn_font ); 
    }
    return ret;
}

void MainDialogBase::cancelSlot()
{
    qWarning( "MainDialogBase::cancelSlot(): Not implemented yet!" );
}

void MainDialogBase::configureSlot()
{
    qWarning( "MainDialogBase::configureSlot(): Not implemented yet!" );
}

void MainDialogBase::copyCdSlot()
{
    qWarning( "MainDialogBase::copyCdSlot(): Not implemented yet!" );
}

void MainDialogBase::eraseCdSlot()
{
    qWarning( "MainDialogBase::eraseCdSlot(): Not implemented yet!" );
}

void MainDialogBase::exitSlot()
{
    qWarning( "MainDialogBase::exitSlot(): Not implemented yet!" );
}

void MainDialogBase::musicSlot()
{
    qWarning( "MainDialogBase::musicSlot(): Not implemented yet!" );
}

void MainDialogBase::newCdSlot()
{
    qWarning( "MainDialogBase::newCdSlot(): Not implemented yet!" );
}

#include "MainDialogBase.moc"
