/***************************************************************************
                          cdbakeovenview.cpp  -  description
                             -------------------
    begin                : Fri May 18 23:05:50 EDT 2001
    copyright            : (C) 2001 by Alex Podolsky
    email                : alexpod@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <iostream.h>

/* QT includes */
#include <qpainter.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qgrid.h>
#include <qevent.h>
#include <qdir.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qwidgetstack.h>
//#include <qlistview.h>

/* KDE includes */
#include <kcontainer.h>
#include <kmainwindow.h>
#include <kprogress.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kapp.h>
#include <kconfig.h>
#include <kcursor.h>

/* cdbakeoven includes */
#include "cdbakeovenview.h"
#include "cdbakeoven.h"
#include "NewCdCompilationView.h"
#include "NewAudioCdCompilationView.h"
#include "NewAdvancedCdCompilationView.h"
#include "CdboCompilationView.h"
#include "dialogs/dialogWidgets/IsoOptPnl.h"
#include "widgets/SrcListPnl.h"
#include "widgets/SrcTreeCntPanel.h"
#include "widgets/fileViews/FilesListView.h"
#include "widgets/fileViews/FoldersListView.h"
#include "widgets/fileViews/CompilationTreeView.h"
#include "widgets/fileViews/AudioCompilationTreeView.h"
#include "widgets/fileViews/DataCompilationTreeView.h"
#include "widgets/fileViews/AdvancedCompilationTreeView.h"

#define CDBO_DATA_VIEW 101
#define CDBO_AUDIO_VIEW 102
#define CDBO_ADVANCED_VIEW 103

CDBakeOvenView::CDBakeOvenView(QWidget *parent, const char *name) : QSplitter(parent, name){
	
	this->setOrientation(QSplitter::Vertical);
	initView();
	initRegConnections();
	config = kapp->config();
	config->setGroup("General Options");
	activeType = config->readNumEntry("Active View Type", CDBO_DATA_VIEW);
	newActive();

}

CDBakeOvenView::~CDBakeOvenView(){
}

void CDBakeOvenView::initView(){

////////////////////////// TOP ////////////////////////////////////////////////

	QGrid *top = new QGrid(2,this, "top");

    	
// -------------------- SrcTreeCntPanel ------------------------
	srcCont = new SrcTreeCntPanel(top);
	srcCont->resize(10,10);

// -------------------- SrcSplitter ------------------------		
	QSplitter *srcSplitter = new QSplitter( top );
	
// -------------------- srcTree ------------------------
	srcTree = new FoldersListView(srcSplitter,"srcTree");
	srcTree ->setFocusPolicy(QWidget::ClickFocus);
	
// -------------------- SrcListCntPanel ------------------------
	listPnl = new SrcListPnl( srcSplitter,"SrcListPn" );
	listPnl ->setFocusPolicy(QWidget::ClickFocus);


////////////////////////// BUTTOM ////////////////////////////////////////////////

    	buttomViewHolder = new QWidgetStack(this, "buttom");
    	
	compilView = new NewCdCompilationView((CDBakeOvenApp *)parentWidget(),
		buttomViewHolder, "dataView");
    	
    	buttomViewHolder->addWidget(compilView, CDBO_DATA_VIEW);
    	
    	audioCompilView = new NewAudioCdCompilationView((CDBakeOvenApp *)parentWidget(),
    		buttomViewHolder, "audioView");
    	
    	buttomViewHolder->addWidget(audioCompilView, CDBO_AUDIO_VIEW);
    	
    	
    	advancedCompilView = new NewAdvancedCdCompilationView((CDBakeOvenApp *)parentWidget(),
    		buttomViewHolder, "advancedView");
    	
    	buttomViewHolder->addWidget(advancedCompilView, CDBO_ADVANCED_VIEW);
    	/**/
    	
}
//=====================================
bool CDBakeOvenView::queryClose(){
	config->setGroup("General Options");
	config->writeEntry("Active View Type", activeType);
	switch(activeType){
		case CDBO_DATA_VIEW:
			return ((CompilationTreeView *)compilView->getView())->saveAndRemove();
		case CDBO_AUDIO_VIEW:
			return ((CompilationTreeView *)audioCompilView->getView())->saveAndRemove();
		case CDBO_ADVANCED_VIEW:
			return advancedCompilView->getCompilView()->saveAndRemove();
	}
	return true;
}
//=====================================
 bool CDBakeOvenView::newActive(){
 	switch(activeType){
		case CDBO_DATA_VIEW:
			return showData();
		case CDBO_AUDIO_VIEW:
			return showAudio();
		case CDBO_ADVANCED_VIEW:
			return showAdvanced();
	}
	return true;
}
//=====================================
 bool CDBakeOvenView::showAudio(){	 	
 	if(!disconnectActive())
 		return false;
	buttomViewHolder->raiseWidget(CDBO_AUDIO_VIEW);
	connectAudio();
	activeType = CDBO_AUDIO_VIEW;
	return true;
 } 	
 //=====================================
 bool CDBakeOvenView::showData(){	 	
 	if(!disconnectActive())
 		return false;
 	buttomViewHolder->raiseWidget(CDBO_DATA_VIEW);
	connectData();
	activeType = CDBO_DATA_VIEW;
	return true;
 }
  //=====================================
 bool CDBakeOvenView::showAdvanced(){	
	if(!disconnectActive())
 		return false;
 	buttomViewHolder->raiseWidget(CDBO_ADVANCED_VIEW);
	connectAdvanced();
	activeType = CDBO_ADVANCED_VIEW;
	return true;
 }

//=====================================
bool CDBakeOvenView::disconnectActive(){
	switch(activeType){
		case CDBO_AUDIO_VIEW:{
			if(!((CompilationTreeView *)audioCompilView->getView())->saveAndRemove())
				return false;
			disconnectAudio();
			return true;
		}
		case CDBO_DATA_VIEW:{
			if(!((CompilationTreeView *)compilView->getView())->saveAndRemove())
				return false;
			disconnectData();
			return true;
		}
		case CDBO_ADVANCED_VIEW:{
			if(!advancedCompilView->getCompilView()->saveAndRemove())
				return false;
			disconnectAdvanced();
			return true;
		}
	}
	return true;
 }
 //=====================================



 ////////////////////////////////////////////////////////////////
 //////////////////////////  SLOTS & SIGNALS //////////////////////////
 //////////////////////////  ///////////////////////////// //////////////////////////
void CDBakeOvenView::initRegConnections(){	
					
	connect(srcTree, SIGNAL(processStarted()),
						((CDBakeOvenApp *)parentWidget()), SLOT(startShowProgress()));
	connect(srcTree, SIGNAL(processDone()),
						((CDBakeOvenApp *)parentWidget()), SLOT(stopShowProgress()));
	connect(srcTree, SIGNAL(haveStatus(const QString &)),
						((CDBakeOvenApp *)parentWidget()), SLOT(slotStatusMsg(const QString &)));		

						
	connect( srcCont->getShowPropBtn(), SIGNAL(clicked()),
						srcTree, SLOT(slotProperties()) );
	connect( srcCont->getReloadBtn(), SIGNAL(clicked()),
						srcTree, SLOT(slotReload()) );
	connect( srcCont->getShowHiddenBtn(), SIGNAL(clicked()),
						srcTree, SLOT(slotShowHidden()) );
						
	connect( srcCont->getAddToCompilation(), SIGNAL(clicked()),
						srcTree, SLOT(slotAddToCompilation()) );
	connect( srcCont->getAddToTopBtn(), SIGNAL(clicked()),
						srcTree, SLOT(slotAddToTop()) );
	connect( srcTree, SIGNAL(folderClicked(FolderItem *)),
						listPnl->getFilestLst(), SLOT(loadDir(FolderItem *)) );
	connect( listPnl->getFilestLst(), SIGNAL(folderClicked(QListViewItem *)),
						srcTree, SLOT(slotSelectFile(QListViewItem *)) );
						
						
	//////////////////BUTTOM///////////////////////							
						
	
	connect(compilView->getView(), SIGNAL(processStarted()),
						this, SLOT(startLongProcess()));
	connect(compilView->getView(), SIGNAL(processDone()),
						this, SLOT(stopLongProcess()));
						
	connect(audioCompilView->getView(), SIGNAL(processStarted()),
						this, SLOT(startLongProcess()));
	connect(audioCompilView->getView(), SIGNAL(processDone()),
						this, SLOT(stopLongProcess()));
	
	connect(advancedCompilView->getView(), SIGNAL(processStarted()),
						this, SLOT(startLongProcess()));
	connect(advancedCompilView->getView(), SIGNAL(processDone()),
						this, SLOT(stopLongProcess()));
	
}				

//==============================
void CDBakeOvenView::connectData(){		
	//////////////////// VIEW /////////////////////////		
	
	connect( srcTree, SIGNAL(addToCompilation(QString)),
						compilView->getView(), SLOT(addItem(QString )) );
	connect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						compilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						compilView->getView(), SLOT(saveAndRemove()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						compilView->getView(), SLOT(saveRemoveAndLoad(QString)));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						compilView->getView(), SLOT(save()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						compilView->getView(), SLOT(saveAs()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(settingsChanged()),
						compilView->getView(), SLOT(updateSettings()));
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	connect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						compilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	connect(compilView->getView(), SIGNAL(processStarted()),
						parentWidget(), SLOT(startShowProgress()));
	connect(compilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	connect(compilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	connect(compilView->getView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));
	
	connect(compilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	connect(compilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));			

						
}
//==============================
void CDBakeOvenView::disconnectData(){		
	//////////////////// VIEW /////////////////////////		
	
	disconnect( srcTree, SIGNAL(addToCompilation(QString)),
						compilView->getView(), SLOT(addItem(QString )) );
	disconnect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						compilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						compilView->getView(), SLOT(saveAndRemove()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						compilView->getView(), SLOT(saveRemoveAndLoad(QString)));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						compilView->getView(), SLOT(save()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						compilView->getView(), SLOT(saveAs()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(settingsChanged()),
						compilView->getView(), SLOT(updateSettings()));	
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	disconnect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						compilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	disconnect(compilView->getView(), SIGNAL(processStarted()),
						parentWidget(), SLOT(startShowProgress()));
	disconnect(compilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	disconnect(compilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	disconnect(compilView->getView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));
	
	disconnect(compilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	disconnect(compilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));		
}
//==============================
void CDBakeOvenView::connectAudio(){		
	//////////////////// VIEW /////////////////////////		
	
	connect( srcTree, SIGNAL(addToCompilation(QString)),
						audioCompilView->getView(), SLOT(addItem(QString )) );
	connect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						audioCompilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						audioCompilView->getView(), SLOT(saveAndRemove()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						audioCompilView->getView(), SLOT(saveRemoveAndLoad(QString)));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						audioCompilView->getView(), SLOT(save()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						audioCompilView->getView(), SLOT(saveAs()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(settingsChanged()),
						audioCompilView->getView(),  SLOT(updateSettings()));
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	connect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						audioCompilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	connect(audioCompilView->getView(), SIGNAL(processStarted()),
						parentWidget(), SLOT(startShowProgress()));
	connect(audioCompilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	connect(audioCompilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	
	connect(audioCompilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	connect(audioCompilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));		
	connect(audioCompilView->getView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));	
						
}
//==============================
void CDBakeOvenView::disconnectAudio(){		
	//////////////////// VIEW /////////////////////////		
	
	disconnect( srcTree, SIGNAL(addToCompilation(QString)),
						audioCompilView->getView(), SLOT(addItem(QString )) );
	disconnect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						audioCompilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						audioCompilView->getView(), SLOT(saveAndRemove()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						audioCompilView->getView(), SLOT(saveRemoveAndLoad(QString)));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						audioCompilView->getView(), SLOT(save()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						audioCompilView->getView(), SLOT(saveAs()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(settingsChanged()),
						audioCompilView->getView(),  SLOT(updateSettings()));
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	disconnect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						audioCompilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	disconnect(audioCompilView->getView(), SIGNAL(processStarted()),
						parentWidget(), SLOT(startShowProgress()));
	disconnect(audioCompilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	disconnect(audioCompilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	
	disconnect(audioCompilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	disconnect(audioCompilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));		
	disconnect(audioCompilView->getView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));	

						
}
//==============================
void CDBakeOvenView::connectAdvanced(){		
	//////////////////// VIEW /////////////////////////		
	
	connect( srcTree, SIGNAL(addToCompilation(QString)),
						advancedCompilView->getView(), SLOT(addOneItem(QString )) );
	connect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						advancedCompilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						advancedCompilView->getCompilView(), SLOT(saveAndRemove()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						advancedCompilView->getCompilView(), SLOT(saveRemoveAndLoad(QString)));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						advancedCompilView->getCompilView(), SLOT(save()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						advancedCompilView->getCompilView(), SLOT(saveAs()));
	connect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(loadSession()),
						advancedCompilView->getCompilView(), SLOT(loadSession()));
	connect(parentWidget(),  SIGNAL(settingsChanged()),
						advancedCompilView->getView(),  SLOT(updateSettings()));
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	connect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						advancedCompilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	connect(advancedCompilView->getView(), SIGNAL(processStarted()),
						parentWidget(),  SLOT(startShowProgress()));
	connect(advancedCompilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	connect(advancedCompilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	connect(advancedCompilView->getCompilView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));
	
	connect(advancedCompilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	connect(advancedCompilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));
						
}
//==============================
void CDBakeOvenView::disconnectAdvanced(){
//////////////////// VIEW /////////////////////////		
	
	disconnect( srcTree, SIGNAL(addToCompilation(QString)),
						advancedCompilView->getView(), SLOT(addOneItem(QString )) );
	disconnect( listPnl->getFilestLst(), SIGNAL(addToCompilation(QString)),
						advancedCompilView->getView(), SLOT(addMultipleItems(QString )) );					
			////////////////////////////////
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList()),
						advancedCompilView->getCompilView(), SLOT(saveAndRemove()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(newList(QString)),
						advancedCompilView->getCompilView(), SLOT(saveRemoveAndLoad(QString)));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveList()),
						advancedCompilView->getCompilView(), SLOT(save()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(saveListAs()),
						advancedCompilView->getCompilView(), SLOT(saveAs()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(loadSession()),
						advancedCompilView->getCompilView(), SLOT(loadSession()));
	disconnect(((CDBakeOvenApp *)parentWidget()),  SIGNAL(settingsChanged()),
						advancedCompilView->getView(), SLOT(updateSettings()));
						
/////////////////////PROCESSES & OUTPUT///////////////////////////
		
	disconnect(parentWidget(),  SIGNAL(longProcessCanceled(QString)),
						advancedCompilView->getView(), SLOT(longProcessCanceled(QString)));
						
		
	disconnect(advancedCompilView->getView(), SIGNAL(processStarted()),
						parentWidget(),  SLOT(startShowProgress()));
	disconnect(advancedCompilView->getView(), SIGNAL(processDone()),
						parentWidget(), SLOT(stopShowProgress()));
						
	disconnect(advancedCompilView->getView(), SIGNAL(haveStatus(const QString &)),
						parentWidget(), SLOT(slotStatusMsg(const QString &)));
	connect(advancedCompilView->getCompilView(), SIGNAL(gotCaption(const QString &, bool)),
						parentWidget(), SLOT(setCaption(const QString &, bool)));
	
	disconnect(advancedCompilView->getView(), SIGNAL(longProcessStarted(KIO::Job *)),
						parentWidget(), SLOT(addJob(KIO::Job *)));
	disconnect(advancedCompilView->getView(), SIGNAL(longProcessDone(KIO::Job *)),
						parentWidget(), SLOT(removeJob(KIO::Job *)));
						
}
//==============================
void CDBakeOvenView::saveOptions(){
	compilView->saveOptions();
	audioCompilView->saveOptions();
	advancedCompilView->saveOptions();
	srcTree->saveTopList();
}

//==============================
void CDBakeOvenView::showSrcControl(bool doShow){
	if(!doShow)
		srcCont->hide();
	else
		srcCont->show();
}
//==============================
void CDBakeOvenView::showTargetControl(bool doShow){
	((CdboCompilationView* )buttomViewHolder->visibleWidget())->showTargetControl(doShow);
}
//==============================
void CDBakeOvenView::showEstimate(bool doShow){
	((CdboCompilationView* )buttomViewHolder->visibleWidget())->showEstimate(doShow);
}
//==============================
void CDBakeOvenView::showFilterPnl(bool doShow){
	listPnl->showSrcListCntPanel(doShow);
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenView::startLongProcess(){
	enableParts(false);
}
//---------------------------------------------------------------------------------------------
void CDBakeOvenView::stopLongProcess(){
	enableParts(true);
}

//---------------------------------------------------------------------------------------------
void CDBakeOvenView::enableParts(bool yes){
	/*if(!yes){
  		this->setCursor(KCursor::waitCursor());*/
  		/*srcCont->setCursor(KCursor::waitCursor());
		
  		srcTree->setCursor(KCursor::waitCursor());
  		listPnl->setCursor(KCursor::waitCursor());
  		buttomViewHolder->setCursor(KCursor::waitCursor());*/
	/*}
	else{
		this->unsetCursor();*/
		/*srcCont->unsetCursor();
  		listPnl->unsetCursor();
  		buttomViewHolder->unsetCursor();
  		srcTree->unsetCursor();*/
	//}
	this->setEnabled(yes);
	/*srcCont->setEnabled(yes);
  	listPnl->setEnabled(yes);
  	buttomViewHolder->visibleWidget()->setEnabled(yes);
  	srcTree->setEnabled(yes);*/
  	((CDBakeOvenApp *)parentWidget())->cancelOperationBtn->setEnabled(!yes);
}