/*
 * KON2 - Kanji ON Console -
 * Copyright (C) 1992-1996 Takashi MANABE (manabe@papilio.tutics.tut.ac.jp)
 *
 * CCE - Console Chinese Environment -
 * Copyright (C) 1998-1999 Rui He (herui@cs.duke.edu)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * 
 */

/* defs.h -- global definition */

#ifndef DEFS_H
#define DEFS_H

#undef FALSE
#undef TRUE
typedef	enum {FALSE, TRUE} bool;

#define	FAILURE	(-1)
#define SUCCESS	(0)

#define CCE_VER   "0.36-05052000"
#define VERSION "Version " CCE_VER " (May 2000)"

/* memory handling libraries */

static inline u_char  PortInb(unsigned short port)
{
        u_char  _rval;

        __asm__ volatile ("inb %1,%0"
                :"=a" (_rval)
                :"d" ((u_short) port));

        return(_rval);
}

static inline void PortOutw(u_short value, u_short port)
{
    __asm__ ("outw %0,%1"
	     ::"a" ((u_short) value),
	     "d" ((u_short) port));
}

static inline void PortOutb(char value, u_short port)
{
    __asm__ ("outb %0,%1"
	     ::"a" ((char) value),
	     "d" ((u_short) port));
}

static inline void bzero2(void *head, int n)
{
    __asm__ ("pushl %%ecx\n"
                 "pushl %%edi\n"
             "cld\n\t"
             "rep\n\t"
             "stosb\n"
                "popl %%edi\n"
             "popl %%ecx\n"
             ::"a" (0),
             "c" (n),
             "D" ((long)head)
             );
}

static inline void wzero(void *head, int n)
{
        __asm__ ("pushl %%ecx\n"
                 "pushl %%edi\n"
                 "cld\n\t"
                "rep\n\t"
                "stosw"
                "popl %%edi\n"
                "popl %%ecx\n"
                ::"a" (0),
                "c" (n>>1),
                "D" ((long)head)
                );
}

static inline void lzero(void *head, int n)
{
    __asm__ ("pushl %%ecx\n"
             "pushl %%edi\n"
             "cld\n\t"
	     "rep\n\t"
	     "stosl\n"
             "popl %%edi\n"
             "popl %%ecx\n"
	     ::"a" (0),
	     "c" (n>>2),
	     "D" ((long)head)
             );
}

static inline void bmove(void *dst, void *src, int n)
{
    __asm__ ("pushl %%ecx\n"
             "pushl %%esi\n"
             "pushl %%edi\n"
             "cld\n\t"
	     "rep\n\t"
	     "movsb\n\t"
             "popl %%edi\n"
             "popl %%esi\n"
             "popl %%ecx\n"
	     ::"c" (n),
	     "D" ((long)dst),
	     "S" ((long)src)
	     );
}

static inline void brmove(void *dst, void *src, int n)
{
    __asm__ ("pushl %%ecx\n"
             "pushl %%esi\n"
             "pushl %%edi\n"
             "std\n\t"
	     "rep\n\t"
	     "movsb\n\t"
             "popl %%edi\n"
             "popl %%esi\n"
             "popl %%ecx\n"
	     ::"c" (n),
	     "D" ((long)dst),
	     "S" ((long)src)
	     );
}

static inline void wmove(void *dst, void *src, int n)
{
        __asm__ ("pushl %%ecx\n"
             "pushl %%esi\n"
             "pushl %%edi\n"
                 "cld\n\t"
                "rep\n\t"
                "movsw\n\t"
             "popl %%edi\n"
             "popl %%esi\n"
                "popl %%ecx\n"
                ::"c" (n>>1),
                "D" ((long)dst),
                "S" ((long)src)
                );
}

static inline void lmove(void *dst, void *src, int n)
{
        __asm__ ("pushl %%ecx\n"
             "pushl %%esi\n"
             "pushl %%edi\n"
                 "cld\n\t"
                "rep\n\t"
                "movsl\n\t"
             "popl %%edi\n"
             "popl %%esi\n"
                "popl %%ecx\n"
                ::"c" (n>>2),
                "D" ((long)dst),
                "S" ((long)src)
                );
}

static inline void SafeFree(void **p)
{
        if (*p) 
        {
                free(*p);
                *p = NULL;
        }
}

#endif
