#include "support.h"
#include "conf.h"
#include "main.h"

int		debug = 0;
double          zoom_factor = 1.0;

preferences pref = {
  ""
};

void
save_config(void)
{
  char path[120];

  sprintf(path, "%s/global/lastbook", prog_name);
  gnome_config_set_string(path, pref.lastbook);

  sprintf(path, "%s/global/fixed_dir", prog_name);
  gnome_config_set_string(path, pref.fixeddir);

  sprintf(path, "%s/global/nextpage", prog_name);
  gnome_config_set_int(path, pref.nextpage);

  sprintf(path, "%s/global/prevpage", prog_name);
  gnome_config_set_int(path, pref.prevpage);

  sprintf(path, "%s/global/nrpages", prog_name);
  gnome_config_set_int(path, pref.nrpages);

  sprintf(path, "%s/startup/width", prog_name);
  gnome_config_set_int(path, pref.initwidth);

  sprintf(path, "%s/startup/height", prog_name);
  gnome_config_set_int(path, pref.initheight);

  sprintf(path, "%s/global/nav_pos", prog_name);
  gnome_config_set_int(path, pref.nav_pos);

  sprintf(path, "%s/global/nav_hor", prog_name);
  gnome_config_set_int(path, pref.nav_hor);

  sprintf(path, "%s/global/dirmode", prog_name);
  gnome_config_set_int(path, pref.dirmode);

  sprintf(path, "%s/global/nav_hidden", prog_name);
  gnome_config_set_int(path, pref.nav_hidden);

  gnome_config_sync();
}


void
load_config(void)
{
  char path[120], *p;
  int def;

  sprintf(path, "%s/global/lastbook=", prog_name);
  strcpy(pref.lastbook, p = gnome_config_get_string_with_default(path, &def));
  g_free(p);

  sprintf(path, "%s/global/fixed_dir=", prog_name);
  strcpy(pref.fixeddir, p = gnome_config_get_string_with_default(path, &def));
  g_free(p);

  sprintf(path, "%s/global/nextpage=0", prog_name);
  pref.nextpage = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/prevpage=0", prog_name);
  pref.prevpage = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nrpages=1", prog_name);
  pref.nrpages = gnome_config_get_int_with_default(path, &def);
    
  sprintf(path, "%s/startup/width=480", prog_name);
  pref.initwidth = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/startup/height=640", prog_name);
  pref.initheight = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_pos=%d", prog_name, NAV_SE);
  pref.nav_pos = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_hor=%d", prog_name, FALSE);
  pref.nav_hor = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/dirmode=0", prog_name);
  pref.dirmode = gnome_config_get_int_with_default(path, &def);

  sprintf(path, "%s/global/nav_hidden=0", prog_name);
  pref.nav_hidden = gnome_config_get_int_with_default(path, &def);

  if (pref.dirmode == DIRM_FIXED)		// fixed startup directory
    strncpy(pref.lastbook, pref.fixeddir, sizeof(pref.lastbook));
}


void
show_config(GtkWidget *ref)
{
  GtkWidget *w;
  char bff[20];

  w = lookup_widget(ref, "conf_goto_entry");
  gtk_entry_set_text(GTK_ENTRY(w), pref.fixeddir);

  switch (pref.nextpage) {
    case 0: w = lookup_widget(ref, "fwd_top_rbtn"); break;
    case 1: w = lookup_widget(ref, "fwd_btm_rbtn"); break;
    case 2: w = lookup_widget(ref, "fwd_stay_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.prevpage) {
    case 0: w = lookup_widget(ref, "back_top_rbtn"); break;
    case 1: w = lookup_widget(ref, "back_btm_rbtn"); break;
    case 2: w = lookup_widget(ref, "back_stay_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.nrpages) {
    case 1: w = lookup_widget(ref, "conf_1page_rbtn"); break;
    case 2: w = lookup_widget(ref, "conf_2page_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  sprintf(bff, "%d", pref.initwidth);
  w = lookup_widget(ref, "conf_w_entry");
  gtk_entry_set_text(GTK_ENTRY(w), bff);

  sprintf(bff, "%d", pref.initheight);
  w = lookup_widget(ref, "conf_h_entry");
  gtk_entry_set_text(GTK_ENTRY(w), bff);

  switch (pref.dirmode) {
    case 0: w = lookup_widget(ref, "conf_prevdir_rbtn"); break;
    case 1: w = lookup_widget(ref, "conf_goto_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  switch (pref.nav_pos) {
    case NAV_NE: w = lookup_widget(ref, "conf_nav_ne_rbtn"); break;
    case NAV_SE: w = lookup_widget(ref, "conf_nav_se_rbtn"); break;
    case NAV_NW: w = lookup_widget(ref, "conf_nav_nw_rbtn"); break;
    case NAV_SW: w = lookup_widget(ref, "conf_nav_sw_rbtn"); break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);

  w = lookup_widget(ref, "conf_nav_hide_cbtn");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), pref.nav_hidden);

  printf("sh: %d\n", pref.nav_hor);
  switch (pref.nav_hor) {
    case FALSE:
      w = lookup_widget(ref, "conf_nav_vert_rbtn"); 
      break;
    case TRUE:
      w = lookup_widget(ref, "conf_nav_hor_rbtn");
      break;
  }
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(w), TRUE);
}


void
parse_config(GtkWidget *ref)
{
  GtkWidget *w;

  w = lookup_widget(ref, "conf_goto_entry");
  strncpy(pref.fixeddir,
		gtk_entry_get_text(GTK_ENTRY(w)),
		sizeof(pref.fixeddir));

  w = lookup_widget(ref, "fwd_top_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nextpage = 0;
  else {
    w = lookup_widget(ref, "fwd_btm_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.nextpage = 1;
    else
      pref.nextpage = 2;
  }

  w = lookup_widget(ref, "back_top_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.prevpage = 0;
  else {
    w = lookup_widget(ref, "back_btm_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.prevpage = 1;
    else
      pref.prevpage = 2;
  }

  w = lookup_widget(ref, "conf_1page_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nrpages = 1;
  else
    pref.nrpages = 2;

  w = lookup_widget(ref, "conf_w_entry");
  pref.initwidth = atol(gtk_entry_get_text(GTK_ENTRY(w)));

  w = lookup_widget(ref, "conf_h_entry");
  pref.initheight = atol(gtk_entry_get_text(GTK_ENTRY(w)));

  w = lookup_widget(ref, "conf_prevdir_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.dirmode = 0;
  else
    pref.dirmode = 1;

  w = lookup_widget(ref, "conf_nav_nw_rbtn");
  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
    pref.nav_pos = NAV_NW;
  else {
    w = lookup_widget(ref, "conf_nav_ne_rbtn");
    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
      pref.nav_pos = NAV_NE;
    else {
      w = lookup_widget(ref, "conf_nav_se_rbtn");
      if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
        pref.nav_pos = NAV_SE;
      else
        pref.nav_pos = NAV_SW;
    }
  }
  
  w = lookup_widget(ref, "conf_nav_hide_cbtn");
  pref.nav_hidden = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
  if (pref.nav_hidden)
    gtk_widget_hide(nav_window);
  else
    gtk_widget_show(nav_window);

  w = lookup_widget(ref, "conf_nav_hor_rbtn");
  pref.nav_hor = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w));
  printf("parse: %d\n", pref.nav_hor);
}
