#!/bin/sh

set -eu

cat << EOF
/**
 * @file qdisk-o.h
 * Automatically generated by "$0 $1", do not edit!
 * @author Marko Mkel (msmakela@nic.funet.fi)
 */

/*
 * Copyright  2002-2003 Marko Mkel
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

EOF

for i in 20 64 16
do
	echo "/** code for the cbm-$i */"
	echo "static const unsigned char $1_$i[] = {"
	xa $1.s -Icbm -Dhost=$i >&-
	od -w12 -t x1 a.o65 | sed -ne 's/ \(..\)/ 0x\1,/g;s/^[0-9]* /  /p'
	echo "};"
done

rm a.o65
