;;; @file cbm2/rom.s
;;; Useful CBM Model II or B series KERNAL file handling routines
;;; @author Marko Mkel (msmakela@nic.funet.fi)

utilstart = $0600
;;; this is not a PET
pet = 0

;;; file handling routines
;readst	= $ffb7			; read the status of last operation
setlfs	= $ffba			; set default file parameters
;setnam	= $ffbd			; set default file name (incompatible)
open	= $ffc0			; open file with default parameters and name
close	= $ffc3			; close file
chkout	= $ffc9			; redirect standard output to file .X
clrchn	= $ffcc			; clear input/output redirections
chrout	= $ffd2			; write .A to standard output
stop	= $ffe1			; check for STOP key
chkin	= $ffc6			; redirect standard input to file .X
chrin	= $ffcf			; read .A from standard input

;;; zero page locations
fnadr	= $90			; start address and bank of file name (3 bytes)
status	= $9c			; i/o operation status
fnlen	= $9d			; file name length
	;; macro => read the status to .A
#define READST lda status
	;; macro => set the file parameters
#define SETLFS jsr setlfs
	;; macro => set the file name (length in .A)
#define SETNAM(n) sta fnlen:\
	ldx #<n:stx fnadr:ldx #>n:stx fnadr+1:ldx #15:stx fnadr+2
	;; macro => set an empty file name (.A=0)
#define SETNAM0 sta fnlen
	;; macro => store device number if necessary
#define STDEV stx device
	;; macro => set the file parameters, preserving the device number
#define SETLFSD device=*+1:ldx #0:jsr setlfs
