#!/usr/local/bin/perl
#  install.pl - the CBB install utility
#              This script installs CBB
#
#  Written by Curtis Olson.  Started October 11, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@me.umn.edu
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: install.pl,v 1.5 2000/01/05 20:38:03 curt Exp $


package CBB;

require "common.pl";


# ----------------------------------------------------------------------------
# List all the CBB pieces
# ----------------------------------------------------------------------------

# tcl execs
@tcl_execs = ("cbb", "dialog4duplicate");

# tcl includes
@tcl_incs = ("balloon.tcl", "balance.tcl", "bindings.tcl", "categories.tcl", 
             "common.tcl", "file.tcl", "filebox.tcl", "help.tcl", "init.tcl", 
             "main.tcl", "menu.tcl", "prefs.tcl", "reports.tcl", "splits.tcl",
	     "undo.tcl"); 

# languages supported
@languages = ("english.tcl", "french.tcl", "german.tcl");

# perl execs
@perl_execs = ("wrapper.pl");

# perl includes
@perl_incs = ("categories.pl", "common.pl", "engine.pl", "export.pl", 
		"file.pl", "import.pl", "log.pl", "memorized.pl", 
		"reports.pl");

# reports
@reports = ("ave-by-cat.pl", "by-cat.pl", "by-payee.pl", "miss-check.pl",
	    "shrt-by-cat.pl", "txn-list.pl", "uncleared-txn.pl");

@reports_conf = ("reports.conf");

# graphs
@perl_graphs = ("cat-col.pl", "cat-pie.pl", "cat2-col.pl", "desc-pie.pl",
		"txn-list.pl");

@tcl_graphs = ("descpie", "graphbal", "graphcol", "graphcolpos", "graphpie");

@graphs_conf = ("graphs.conf");

# image files
@image_files = ("author.xbm", "cbb.xbm", "mini-cross.gif",
		"mini-exclam.gif", "splash-32.gif");

# other files
@other_files = ("default.cat", "extern.conf");

# contributed stuff
@perl_contrib = ("change.pl", "conv-french-qif.pl", "emacs-edb", "emacs-forms", 
		 "fetch-latest.pl", "importcat.README", "importcat.pl", 
		 "invest.pl", "loan.gnuplot", "loan.pl", "loan_recur.pl",
		 "mym_to_cbb.pl", "recur.pl", "term.pl",
		 "trimold.pl", "txn.README", "txn", "upgrade-splits.pl", 
		 "yearend.pl");

# possible browsers
# @browsers = ("netscape", "Mosaic", "mosaic", "rmosaic", "glimpse",
# 	     "amaya", "chimera", "lynx");


# ----------------------------------------------------------------------------
# Derive basic directories, and paths
# ----------------------------------------------------------------------------

if ( $ENV{"OS"} ne "Windows_NT" ) {
    # get home directory
    @pw = getpwuid($<);
}

$HOME = $ENV{HOME}
     || $ENV{LOGDIR}
     || $pw[7]
     || "/";
#    || die "No home directory";

$home_dir = &file_dirname($HOME);
$home_base = &file_basename($HOME);
 
# default paths
$def_perlpath = "";
$perlpath = "";

@perl_poss = ("/usr/local/bin/perl", "/usr/bin/perl");

$def_wishpath = "";
$wishpath = "";

@wish_poss = ("/usr/local/bin/wish4.2", "/usr/bin/wish4.2", 
	      "/usr/bin/X11/wish4.2", "/usr/local/bin/wish4.1", 
              "/usr/bin/wish4.1",
              "/usr/bin/X11/wish4.1", "/usr/local/bin/wish4.0",
              "/usr/bin/wish4.0", "/usr/bin/X11/wish4.0",
              "/usr/bin/wish", "/usr/bin/X11/wish",
              "/usr/local/bin/wish");

$bindir = "";
$libdir = "";
$dest_bindir = "";
$dest_libdir = "";

$def_bindir = &which("cbb");
$pos = rindex($def_bindir, "/");
$def_bindir = substr($def_bindir, 0, $pos);
if ( $def_bindir eq "" ) {
    $def_bindir = "/usr/local/bin";
}
$def_bindir .= "/";

$def_libdir = "";

$def_version = "Version";
$def_icon = "cbb.xbm";
$def_man = "docs/cbb-man";


# ----------------------------------------------------------------------------
# Out of all of this we want to determine a $bindir and $libdir.  We also may
# have an optional $dest_bindir and $dest_libdir which is a temporary install
# location.  It is used for packaging up CBB so that it can be installed in
# a temporary location, packaged up, and later installed in it's real location.
#
# $PREFIX is used to define $bindir and $libdir.  $DESTDIR is used to define
# $dest_bindir and $dest_libdir
#
# The command line options --prefix and --destdir will override the environment
# variables $PREFIX and $DESTDIR
#
# If $destdir is not defined, it is set to the value of $prefix
#
# If neither are defined, an interactive (non-package building) session is
# assumed, and the user will be prompted for the install directories
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# process environmental variables
# ----------------------------------------------------------------------------

if ( defined($ENV{"PREFIX"}) ) {
    $prefix = $ENV{"PREFIX"};
    print "PREFIX=$prefix\n";
    $bindir = "$prefix/bin";
    $libdir = "$prefix/lib/cbb";
}

if ( defined($ENV{"DESTDIR"}) ) {
    $destdir = $ENV{"DESTDIR"};
    print "DESTDIR=$destdir\n";
}


# ----------------------------------------------------------------------------
# process command line arguments, these definitions will override any
# environment variable
# ----------------------------------------------------------------------------

while ($arg = shift(@ARGV)) {
    if ( $arg =~ m/^--/ ) {
	if ( $arg =~ m/^--perlpath$/ ) {
	    $perlpath = shift(@ARGV);
	} elsif ( $arg =~ m/^--wishpath$/ ) {
	    $wishpath = shift(@ARGV);
	} elsif ( $arg =~ m/^--prefix$/ ) {
	    $prefix = shift(@ARGV);
	} elsif ( $arg =~ m/^--destdir$/ ) {
	    $destdir = shift(@ARGV);
	} elsif ( $arg =~ m/^--bindir$/ ) {
	    $bindir = shift(@ARGV);
	} elsif ( $arg =~ m/^--libdir$/ ) {
	    $libdir = shift(@ARGV);
	} elsif ( $arg =~ m/^--help$/ ) {
	    &usage();
	} else {
	    &usage();
	}
    } else {
	&usage();
    }
}

if ( defined($prefix) ) {
    $bindir = "$prefix/bin" if ($bindir eq "");
    $libdir = "$prefix/lib/cbb" if ($libdir eq "");

    if ( !defined($destdir) ) {
	$destdir = $prefix;
    }
    $dest_bindir = "$destdir/bin";
    $dest_libdir = "$destdir/lib/cbb";
}


# ----------------------------------------------------------------------------
# Derive the current version
# ----------------------------------------------------------------------------

open( VERSION, "$def_version" ) || die "Cannot open file:  $def_version\n";
$version = <VERSION>;
chop($version);


# ----------------------------------------------------------------------------
# Print welcome
# ----------------------------------------------------------------------------

print "\nInstalling and Configuring CBB $version:\n\n";
print "Press ^C at any time to abort.\n\n";

print "    NOTE:  You may use ~ and ~user to specify a home directory as\n";
print "           part of an installation file name or path.\n\n";


# ----------------------------------------------------------------------------
# Verify we have specified (or prompt for) the location of the prerequisites
# ----------------------------------------------------------------------------

foreach $tmp (@perl_poss) {
    if ( (-e $tmp) && ($def_perlpath eq "") ) {
	$def_perlpath = $tmp;
    }
}

while ( $perlpath eq "" ) {
    print "What is the name of your perl binary? [$def_perlpath] ";
    $perlpath = <STDIN>;
    chop($perlpath);

    if ( $perlpath eq "" ) {
	$perlpath = $def_perlpath;
    }

    # psuedo-glob
    if ( ($perlpath =~ m/~\//) || ($perlpath =~ m/~$/) ) {
        # ~/blah form
        $perlpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $perlpath =~ s/~/$home_dir/;
    }

    if ( ! -e $perlpath ) {
	$perlpath = "";
    }
}
print "    Using $perlpath\n\n";

foreach $tmp (@wish_poss) {
    if ( (-e $tmp) && ($def_wishpath eq "") ) {
	$def_wishpath = $tmp;
	break;
    }
}

while ( $wishpath eq "" ) {
    print "What is the name of your wish (tk4.x) binary [$def_wishpath] ";
    $wishpath = <STDIN>;
    chop($wishpath);

    if ( $wishpath eq "" ) {
	$wishpath = $def_wishpath;
    }

    # psuedo-glob
    if ( ($wishpath =~ m/~\//) || ($wishpath =~ m/~$/) ) {
        # ~/blah form
        $wishpath =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $wishpath =~ s/~/$home_dir/;
    }

    if ( ! -e $wishpath ) {
	$wishpath = "";
    }
}
print "    Using $wishpath\n\n";


# check for a web browser
# 
# $def_browser = "no-browser";
# 
# &my_print_init();
# &my_print("Looking for web browsers:  ");
# 
# foreach $browser (@browsers) {
#     &my_print("$browser ");
#     $temp = &which($browser);
#     $pos = rindex($temp, "/");
#     $temp = substr($temp, 0, $pos);
#     # print "'$temp'\n";
#     if ( $temp ne "" ) {
# 	if ( $def_browser eq "no-browser" ) {
# 	    $def_browser = $browser;
# 	    # print "choosing $def_browser\n";
# 	    break;
# 	}
#     }
# }
# print "\n\n";
# 
# if ( $def_browser eq "" ) {
#     print "Warning:  cannot find a web browser.  CBB uses this for online help.\n"
# } else {
#     print "    Found $def_browser.  CBB will use this for online help.\n\n";
# }


# ----------------------------------------------------------------------------
# Verify we have specified (or prompt for) the install directories
# ----------------------------------------------------------------------------

while ( $bindir eq "" ) {
    print "Where should the binaries be installed? [$def_bindir] ";
    $bindir = <STDIN>;
    chop($bindir);

    if ( $bindir eq "" ) {
	$bindir = $def_bindir;
    }

    # psuedo-glob
    if ( ($bindir =~ m/~\//) || ($bindir =~ m/~$/) ) {
	# ~/blah form
	$bindir =~ s/~/$HOME/;
    } else {
	# ~user/blah from
	$bindir =~ s/~/$home_dir/;
    }

    if ( ! -e $bindir || ! -d $bindir ) {
	print "    $bindir does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    # ok
	} else {
	    print "\n";
	    die "Very well, I'll wait until you do it yourself. ;)\n";
	}
    }

    if ( $bindir =~ m/wish$/ ) {
	print "    Warning:  CBB cannot run with wish, it requires bin.\n";
	print "    See the README file for more information.\n";
	$bindir = "";
    }
}

print "    Using $bindir\n\n";

# derive a default $libdir from $bindir
$tmp = $bindir;
if ( substr($tmp, length($tmp) - 1) eq "/" ) {
    chop($tmp);
}

$def_libdir = &file_dirname($tmp) . "lib/cbb/";

while ( $libdir eq "" ) {
    print "Where should the support files be installed? [$def_libdir] ";
    $libdir = <STDIN>;
    chop($libdir);

    if ( $libdir eq "" ) {
	$libdir = $def_libdir;
    }

    # psuedo-glob
    if ( ($libdir =~ m/~\//) || ($libdir =~ m/~$/) ) {
        # ~/blah form
        $libdir =~ s/~/$HOME/;
    } else {
        # ~user/blah from
        $libdir =~ s/~/$home_base/;
    }

    if ( ! -e $libdir || ! -d $libdir ) {
	print "    $libdir does not exist.  Should I create it? [y] ";
	$result = <STDIN>;
	chop($result);
	if ( ($result =~ /^[Yy]/) || ($result eq "") ) {
	    # ok
	} else {
	    print "\n";
	    die "Very well, I'll wait until you do it yourself. ;)\n";
	}
    }

    if ( $libdir =~ m/wish$/ ) {
	print "    Warning:  CBB cannot run with wish, it requires lib.\n";
	print "    See the README file for more information.\n";
	$libdir = "";
    }
}

print "    Using $libdir\n\n";

print "\n";

# These have to be set here if the user never specified a prefix or destdir
$dest_bindir = $bindir if ($dest_bindir eq "");
$dest_libdir = $libdir if ($dest_libdir eq "");

# make $dest_bindir and $dest_libdir if needed
if ( ! -e $dest_bindir || ! -d $dest_bindir ) {
    print "    Creating $dest_bindir\n";
    $status = system( "mkdir -p $dest_bindir" );
    if ( $status ) {
	$code = $status / 256;
	print"\'mkdir -p $dest_bindir\' failed with an exit code of ";
	print"$code.\n";
	exit( $code );
    }
    chmod(0755, $dest_bindir);
}
if ( ! -e $dest_libdir || ! -d $dest_libdir ) {
    print "    Creating $dest_libdir\n";
    $status = system( "mkdir -p $dest_libdir" );
    if ( $status ) {
	$code = $status / 256;
	print"\'mkdir -p $dest_libdir\' failed with an exit code of ";
	print"$code.\n";
	exit( $code );
    }
    chmod(0755, $dest_libdir);
}

print "    prefix = $prefix\n";
print "    destdir = $destdir\n";
print "    bindir = $bindir\n";
print "    libdir = $libdir\n";
print "    dest_bindir = $dest_bindir\n";
print "    dest_libdir = $dest_libdir\n";
print "\n";

# languages path
$languagepath = "$libdir/languages";
if ( ! -e "$dest_libdir/languages" || ! -d "$dest_libdir/languages" ) {
    system( "mkdir -p $dest_libdir/languages" );
    chmod(0755, "$dest_libdir/languages");
}

# report path
$reportpath = "$libdir/reports";
if ( ! -e "$dest_libdir/reports" || ! -d "$dest_libdir/reports" ) {
    system( "mkdir -p $dest_libdir/reports" );
    chmod(0755, "$dest_libdir/reports");
}

# graph path
$graphpath = "$libdir/graphs";
if ( ! -e "$dest_libdir/graphs" || ! -d "$dest_libdir/graphs" ) {
    system( "mkdir -p $dest_libdir/graphs" );
    chmod(0755, "$dest_libdir/graphs");
}

# images path
$imagespath = "$libdir/images";
if ( ! -e "$dest_libdir/images" || ! -d "$dest_libdir/images" ) {
    system( "mkdir -p $dest_libdir/images" );
    chmod(0755, "$dest_libdir/images");
}

# contrib path
$contribpath = "$libdir/contrib";
if ( ! -e "$dest_libdir/contrib" || ! -d "$dest_libdir/contrib" ) {
    system( "mkdir -p $dest_libdir/contrib" );
    chmod(0755, "$dest_libdir/contrib");
}

# cbb-man path
$cbbman_path = "$libdir/docs/cbb-man";
if ( ! -e "$dest_libdir/docs/cbb-man" || ! -d "$dest_libdir/docs/cbb-man" ) {
    system( "mkdir -p $dest_libdir/docs/cbb-man" );
    chmod(0755, "$dest_libdir/docs/cbb-man");
}

# cbb-man icon path
$iconpath = "$cbbman_path/icons.png";
if ( ! -e "$dest_libdir/docs/cbb-man/icons.png" || 
    ! -d "$dest_libdir/docs/cbb-man/icons.png" ) {
    system( "mkdir -p $dest_libdir/docs/cbb-man/icons.png" );
    chmod(0755, "$dest_libdir/docs/cbb-man/icons.png");
}


print "    Installing to $dest_bindir\n";
print "    Installing to $dest_libdir\n";
print "    Installing to $dest_libdir/" . "languages/\n";
print "    Installing to $dest_libdir/" . "reports/\n";
print "    Installing to $dest_libdir/" . "graphs/\n";
print "    Installing to $dest_libdir/" . "images/\n";
print "    Installing to $dest_libdir/" . "contrib/\n";
print "    Installing to $dest_libdir/" . "docs/cbb-man/\n";
print "    Installing to $dest_libdir/" . "docs/cbb-man/icons.png/\n";
print "\n";


# ----------------------------------------------------------------------------
# Now ... install CBB!
# ----------------------------------------------------------------------------

# install tcl executables

print ( "Now installing CBB:\n" );

&my_print_init();
&my_print("\nInstalling executables:  ");

foreach $file ( @tcl_execs ) {
    &install($file, $dest_bindir, "tcl", 0755);
    &my_print("$file ");
}


# install perl executables

foreach $file (@perl_execs) {
    &install($file, $dest_libdir, "perl", 0755);
    &my_print("$file ");
}


# install perl includes

&my_print_init();
&my_print("\n\nInstalling perl includes:  ");

foreach $file (@perl_incs) {
    &install($file, $dest_libdir, "perl", 0644);
    &my_print("$file ");
}


# install languages

&my_print_init();
&my_print("\n\nInstalling language translation files:  ");

foreach $file (@languages) {
    &install("languages/$file", $dest_libdir, "perl", 0755);
    &my_print("$file ");
}


# install reports

&my_print_init();
&my_print("\n\nInstalling report files:  ");

foreach $file (@reports_conf) {
    &install("reports/$file", $dest_libdir, "text", 0644);
    &my_print("$file ");
}

foreach $file (@reports) {
    &install("reports/$file", $dest_libdir, "perl", 0755);
    &my_print("$file ");
}


# install graphs

&my_print_init();
&my_print("\n\nInstalling graph files:  ");

foreach $file (@graphs_conf) {
    &install("graphs/$file", $dest_libdir, "text", 0644);
    &my_print("$file ");
}

foreach $file (@perl_graphs) {
    &install("graphs/$file", $dest_libdir, "perl", 0755);
    &my_print("$file ");
}

foreach $file (@tcl_graphs) {
    &install("graphs/$file", $dest_libdir, "tcl", 0755);
    &my_print("$file ");
}


# install tcl includes

&my_print_init();
&my_print("\n\nInstalling tcl includes:  ");

foreach $file (@tcl_incs) {
    &install($file, $dest_libdir, "tcl", 0644);
    &my_print("$file ");
}


# install image files

&my_print_init();
&my_print("\n\nInstalling image files:  ");

foreach $file (@image_files) {
    &install("images/$file", $dest_libdir, "text", 0644);
    &my_print("$file ");
}


# install other files

&my_print_init();
&my_print("\n\nInstalling other files:  ");

foreach $file (@other_files) {
    &install($file, $dest_libdir, "text", 0644);
    &my_print("$file ");
}


&my_print_init();
&my_print("\n\nInstalling other contributed stuff:  ");

foreach $file (@perl_contrib) {
    &install("contrib/$file", $dest_libdir, "perl", 0755);
    &my_print("$file ");
}


# install online man files

&my_print_init();
&my_print("\n\nInstalling CBB online manual:  ");

&install("docs/cbb-man.txt", $dest_libdir, "text", 0644);
&my_print("cbb-man.txt ");

foreach $file (`ls $def_man/*.html`) {
    $file = &file_basename($file);
    chop($file);

    &install("docs/cbb-man/$file", $dest_libdir, "html", 0644);
    &my_print("$file ");
}

# print "\nready to install from $def_man/*.png\n";
foreach $file (`ls $def_man/img*.png`) {
    # print "-> $file";
    $file = &file_basename($file);
    chop($file);
    &my_print("$file ");

    system("cp ./$def_man/$file $dest_libdir/docs/cbb-man/$file");
    chmod(0644, "$dest_libdir/docs/cbb-man/$file") || 
	die "Cannot chmod $dest_libdir/docs/cbb-man/$file";
}


foreach $file (`ls $def_man/icons.png/*.png`) {
    $file = &file_basename($file);
    chop($file);
    &my_print("$file ");

    system("cp ./$def_man/icons.png/$file $dest_libdir/docs/cbb-man/icons.png/$file");
    chmod(0644, "$dest_libdir/docs/cbb-man/icons.png/$file") || 
	die "Cannot chmod $dest_libdir/docs/cbb-man/icons.png/$file";
}


# ----------------------------------------------------------------------------
# Print closing remarks
# ----------------------------------------------------------------------------

print "\n\nInstallation successful!\n";
print "\n";
print "Make sure '$bindir' is in your \$PATH, \n";
print "then type 'cbb' and have fun!\n";
print "\n";
print "The CBB manual is available online via the 'Help' menu.\n";
print "\n";
print "Please send comments and suggestions to 'curt\@me.umn.edu'\n";
print "Remember to visit the CBB web page at ";
print "'http://www.menet.umn.edu/~curt/cbb/'\n";


# ----------------------------------------------------------------------------
# Supporting functions
# ----------------------------------------------------------------------------

# Print usage and exit
sub usage {
    print "Usage:  $0 [ args ]\n";
    print "\n";
    print "  General Options\n";
    print "\n";
    print "\t--help: display this usage message\n";
    print "\n";
    print "\t--perlpath <path>:  Full pathname to perl interpreter\n";
    print "\t--wishpath <path>:  Full pathname to wish interpreter\n";
    print "\t--bindir <dir>:  Directory to install executables\n";
    print "\t--libdir <dir>:  Directory to install support files\n";
    print "\n";
    print "  Packaging Maintainer Options\n";
    print "\n";
    print "\t--prefix <dir>:  Root directory where CBB will eventually be\n";
    print "\t\tinstalled and run from ... this is where CBB thinks it lives.\n";
    print "\t--destdir <dir>:  Root directory where CBB will actually be\n";
    print "\t\tinstalled right now for package building purposes.  It is\n";
    print "\t\tassumed that once the package is installed, CBB will reside\n";
    print "\t\tin the --prefix directory.\n";

    exit(0);
}


# a function to duplicate the unix/shell command "which" since it may not
# always be available
sub which {
    my($file) = @_;
    my(@PATHS) = split(/:/, $ENV{PATH});

    foreach $path (@PATHS) {
	# print "Checking $path\n";
	if ( (-e "$path/$file") && ($path ne ".") ) {
	    return "$path/$file";
	}
    }

    return "";
}


# install a file
sub install {
    my($file, $path, $type, $perms) = @_;

    # print ( "Creating $path/$file from ./$file\n" );

    open( IN, "<./$file" ) || die "Cannot open ./$file";
    open( OUT, ">$path/$file" ) || die "Cannot create $path/$file";

    if ( $type eq "tcl" ) {
	$junk = <IN>;	# ignore first line
	print( OUT "#!$wishpath -f\n" );
    } elsif ( $type eq "perl" ) {
	$junk = <IN>;	# ignore first line
	print( OUT "#!$perlpath\n" );
    }

    while ( <IN> ) {
	if ( $type eq "tcl" ) {
	    s/^ *set lib_path.*$/set lib_path \"$libdir\"/;
	    s/\"Version <not_installed>.*\"/\"$version\"/;
# 	    s/\s+exec netscape.*$/exec $def_browser \$lib_path\/docs\/cbb-man\/cbb-man.html \&/;
            # " a comment
	} elsif ( $type eq "perl" ) {
	    s/^ *\$CBB::cbb_incl_dir = .*$/\$CBB::cbb_incl_dir = \"$libdir\";/;
	    s/^ *\$reportpath = .*$/\$reportpath = \"$reportpath\";/;
	    s/^ *\$graphpath = .*$/\$graphpath = \"$graphpath\";/;
	    s/\"Version <not_installed>.*\"/\"$version\"/;
            # " a comment
	} elsif ( $type eq "html" ) {
	    s/\/usr\/lib.+\/icons.png\//$iconpath\//g;
	}

	print( OUT $_ );
    }

    close( IN );
    close( OUT );

    chmod($perms, "$path/$file") || die "Cannot chmod $perms $path/$file";
}


sub my_print_init {
    $first_line = 1;
    $cur_len = 0;
}


sub my_print {
    my($line) = $_[0];

    if ( length($line) + $cur_len < 75 ) {
        print $line;
    } else {
	$cur_len = 0;
	if ( $first_line ) {
	    print "\n$line";
	} else {
	    print "\n    $line";
	}
    }

    $first_line = 0;
    $cur_len += length($line);
}
