/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.4.0. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#ifndef C2BCITERVIEW_H
#define C2BCITERVIEW_H

#include "c2bCiterModel.h"

#include <QTableView>


class c2bCiterView : public QTableView
{

    Q_OBJECT

public:
    c2bCiterView(QWidget* parentw = 0);
    ~c2bCiterView();

    c2bCiterModel::State currentState() const;
    void reloadModel(QAbstractItemModel* citations, const QStringList& bibtex_files, const c2bCiterModel::State& state);
    void updateCurrentIndex(const QModelIndex& i);


protected:
    void keyPressEvent(QKeyEvent* qevent);
    void keyboardSearch(const QString& search);
    void resizeEvent(QResizeEvent* qevent);


private:
    bool _filter_mode;
    c2bCiterModel* _modelP;
    void updateFormat(const c2bCiterModel::Format& format);
    void updateViewport();

};

#endif
