#
#   Copyright (C) 1998, 1999 Loic Dachary
#
#   This program is free software; you can redistribute it and/or modify it
#   under the terms of the GNU General Public License as published by the
#   Free Software Foundation; either version 2, or (at your option) any
#   later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
#
# 
# $Header: /cvsroot/catalog/catalog/t/mysql.pl,v 1.8 2001/07/11 10:28:08 loic Exp $
#
#
# Copy and modify configuration files for test
#
sub conftest_db {
    my($mysql_conf) = load_config("conf/mysql.conf");
    $mysql_conf->{'base'} = 'test';
    $mysql_conf->{'host'} = 'localhost';
    $mysql_conf->{'port'} = '7777';
    my($cwd) = getcwd();
    $mysql_conf->{'unix_port'} = "$cwd/t/tmp/db.sock";
    $mysql_conf->{'user'} = undef;
    $mysql_conf->{'passwd'} = undef;
    mysql_conf2opt($mysql_conf);
    mysql_conf2dsn($mysql_conf);
    $mysql_conf->{'hook'} = undef;
    unload_config($mysql_conf, "conf/mysql.conf", "t/conf/mysql.conf");
}

sub sys {
    my ($cmd) = @_;
    print "$cmd\n";
    my $status = system($cmd);
    warn "Command ``$cmd'' failed\n" if $status != 0;
    return $status;
}

sub mysql_version {
    my($mysql_conf) = @_;

    my($cmd) = "$mysql_conf->{home}/bin/mysql_config";
    if(-x $cmd) {
	$version = `$cmd --version`;
	$version =~ s/(\d)\.(\d\d).*/$1$2/s;
    } else {
	$version = "300";
    }

    return $version;
}

sub rundb {
    conftest_db();
    my($mysql_conf) = load_config("t/conf/mysql.conf");
    my(@paths) = map { "$mysql_conf->{home}/$_/mysqld" } qw(libexec sbin bin);
    my($mysqld) = grep { -x $_ } @paths;
    error("mysqld not found in @paths") unless(-f $mysqld && -x $mysqld);
    sys("kill -15 `cat t/tmp/db.pid`") if -f "t/tmp/db.pid";
    sys("rm -fr t/tmp/db");
    mkdir("t/tmp/db", 0777) or die "mkdir t/tmp/db: $!";
    my($mysql_opt) = "--port $mysql_conf->{'port'} --socket $mysql_conf->{'unix_port'}";
    #
    # In MySQL 3.23 running a server as root requires the --user=root flag
    #
    if(mysql_version($mysql_conf) > 322 && $< == 0) {
	$mysql_opt .= " --user=root ";
    }
    my($cwd) = getcwd();
    my($cmd) = "$mysqld  --tmpdir=/tmp --skip-grant-table --datadir=$cwd/t/tmp/db --pid-file $cwd/t/tmp/db.pid";
    $cmd .= " $mysql_opt > /dev/null 2>&1 &";
    sys($cmd);
    #
    # Wait a bit for the server to start
    #
    foreach (1..5) {
	last if(-f "t/tmp/db.pid");
	sleep(1);
    }
    sys("$mysql_conf->{'home'}/bin/mysql $mysql_opt -e 'create database test'");
}

sub stopdb {
    #
    # If in verbose mode, it is very likely that we want to keep the
    # database daemon alive to query what was done. It will be killed
    # and started again when running another test.
    #
    return if($ENV{'TEST_VERBOSE'});
    if(-f "t/tmp/db.pid") {
	sys("kill -15 `cat t/tmp/db.pid`");
	foreach (1..5) {
	    last if(! -f "t/tmp/db.pid");
	    sleep(1);
	}
    }
}

sub cleandb {
    unlink "t/conf/mysql.conf";
}

END {
	stopdb();
}

1;
