/* data.c
 * Copyright (C) 2000-2001 Christopher R. Gabriel <cgabriel@softwarelibero.org>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "cappuccino.h"

void 
load_data(void) {
  FILE *fp;
  gchar *fname=NULL;
  gchar *buff=NULL;
  gint inttmp;
  gint usedefaults=1;

  /* First we look for $HOME/.cappuccino */
  fname=malloc(256);
  buff=malloc(256);
  if(fname==NULL || buff==NULL) {
      g_print("Malloc problem(s).\n");
  } else {
    /* Load data from .cappuccino */
	  snprintf(fname,255,"%s/.cappuccino",getenv("HOME"));
    if ((fp=fopen(fname,"r"))) {

      init_values();
      usedefaults=0;

	    while (fgets(buff,255,fp)!=NULL) {
    		buff[strlen(buff)-1]=0;
        if (strncmp(buff,"title=",6)==0) {
          strncpy(title,(buff+6),35);
          continue;
        }
        if (sscanf(buff,"row%d=",&inttmp)==1) {
          if (inttmp>=0 && inttmp<=5)
            strncpy(rows[inttmp],(buff+5),25);
          continue;
        }
        if (sscanf(buff,"dur%d=",&inttmp)==1) {
          if (inttmp>=0 && inttmp<=5)
            cycles[inttmp]=atoi((buff+5));
          continue;
        }
        if (strncmp(buff,"final=",6)==0) {
          strncpy(final,(buff+6),35);
          continue;
        }
        if (strncmp(buff,"loops=",6)==0) {
          loops=atoi((buff+6));
          continue;
        }
        if (strncmp(buff,"lastact=",8)==0) {
          lastaction=atoi((buff+8));
          continue;
        }
      }
    }
  }

  if (usedefaults) {
    /* If not found then we set defaults values */
    strcpy(title, "Don't touch for _any_ reason");
    strcpy(rows[0], "Preprocessing module");
    strcpy(rows[1], "Verifying module");
    strcpy(rows[2], "Compiling module");
    strcpy(rows[3], "Stripping module");
    strcpy(rows[4], "Installing module");
    strcpy(rows[5], "");
    cycles[0]=6;
    cycles[1]=4;
    cycles[2]=8;
    cycles[3]=4;
    cycles[4]=6; 
    cycles[5]=0;
    loops=9;
    lastaction=4;
    strcpy (final, "Now, it's time to work!");
  }

}


void 
init_values(void) {
  gint i;

  for (i=0;i<6;i++) {
    rows[i][0]='\0';
    cycles[i]=0;
  }
  title[0]='\0';
  final[0]='\0';
  loops=0;
  lastaction=0;
}

