/* callbacks.c
 * Copyright (C) 2000-2001 Christopher R. Gabriel <cgabriel@softwarelibero.org>
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "cappuccino.h"

gint verita = FALSE;
gint doppiociclo = 0;
gint start = 0;
gint whatidx = -1;
gint modnum = 1;
gint nclick = 0;
gint remember=1;

GtkWidget *config;

void 
on_buttok_clicked(GtkButton *button,gpointer user_data)
{
  /* Get values */
  config_get_values();
  
  /* Destroy config */
  destroy_config();

}


void 
on_buttapp_clicked(GtkButton *button,gpointer user_data)
{

  /* Get values */
  config_get_values();
  
}


void 
on_buttcan_clicked(GtkButton *button, gpointer user_data)
{
  destroy_config();
}


/* I have to count the THREE clicks on the window */
gint 
canvas_event(GnomeCanvas *c, GdkEvent *event, gpointer data)
{
  gint rit=FALSE;
  if (event->type==GDK_BUTTON_PRESS) {
    if (!config) {
      if (++nclick>=3) {
        if (modnum<=loops) {
          config = create_config();
          gtk_widget_show (config);
        }
        nclick=0;
      }
    }  
    rit=TRUE;
  }
  return rit;
    
}

void 
on_config_destroyed (GtkWidget *w,gpointer data) {
  destroy_config();
}

void 
destroy_config(void) {
  gtk_widget_destroy(config);
  (GtkWidget *) config=NULL;
}

gint 
update_progressbar(gpointer data)
{
  gchar sentence[128];
  gfloat val;

  if (!progressbar1) return FALSE;
  
  val = gtk_progress_get_value(GTK_PROGRESS(progressbar1));
  val +=1 ;
  
  if ( (val > 100) || (!start)) {
    start = 1;
    
    if ((whatidx<0) || (++doppiociclo >= cycles[whatidx])) {
      if (++whatidx > lastaction) {
        whatidx = 0;
        modnum++;
      }
      if (modnum <= loops) {
        
        gnome_canvas_item_set (gnoca, "text", title, NULL);
        sprintf(sentence, _("%s #%d"), rows[whatidx], modnum);
        gnome_canvas_item_set (gnoca2, "text", sentence, NULL);
        
      } else {

        gnome_canvas_item_set(gnoca, "text", final, "y",60.0,NULL);
        gnome_canvas_item_set(gnoca2, "text", "", NULL);
        verita = FALSE;

        /* When we reach final step, no configuration change can be made... 
         * YOU HAVE TO WORK! :)
         */
        if (config) {
          GtkWidget *widgtemp;
	        widgtemp = gtk_object_get_data(GTK_OBJECT(config), "buttok");
          gtk_widget_set_sensitive(widgtemp,FALSE);
	        widgtemp = gtk_object_get_data(GTK_OBJECT(config), "buttapp");
          gtk_widget_set_sensitive(widgtemp,FALSE);
        }
        
      }
      
      gtk_progress_set_activity_mode (GTK_PROGRESS(progressbar1), verita);
      
      verita=!verita;
      doppiociclo=0;
    }
    
    if (modnum <= loops) {
      val = 0;
    } else {
      val = 200;
    }   
  }
  
  gtk_progress_set_value (GTK_PROGRESS(progressbar1), val);
  gtk_widget_draw(progressbar1, NULL);
  
  return TRUE;
}

void 
config_get_values(void) {
  GtkWidget *widgtemp;
  gchar *strtemp;
  gint inttemp;
  gint i;
  gchar simarray[30];
  lastaction=0;

  /* Get title */
	widgtemp = gtk_object_get_data(GTK_OBJECT(config), "cptitle");
	strtemp=gtk_entry_get_text(GTK_ENTRY(widgtemp));
  strcpy(title,strtemp);

  for (i=0;i<6;i++) {

    if (!lastaction) {
      /* Get Rows 0..5 */
      sprintf(simarray,"sent%d",i+1);
  	  widgtemp = gtk_object_get_data(GTK_OBJECT(config), simarray);
    	strtemp=gtk_entry_get_text(GTK_ENTRY(widgtemp));
      strcpy(rows[i],strtemp);

       /* Get Durations 0..5 */
      sprintf(simarray,"sentc%d",i+1);
      widgtemp = gtk_object_get_data(GTK_OBJECT(config), simarray);
      inttemp=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widgtemp));
      cycles[i]=inttemp;

      if (strlen(rows[i])==0) {
        cycles[i]=0;
        lastaction=i-1;
      }

    } else {
      strcpy(rows[i],"");
      cycles[i]=0;
    }

  }

  /* Get # of loops */
  widgtemp = gtk_object_get_data(GTK_OBJECT(config), "ncycles" );
  inttemp=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widgtemp));
  loops=inttemp;

  /* Get final sentence */
	widgtemp = gtk_object_get_data(GTK_OBJECT(config), "lastone");
	strtemp=gtk_entry_get_text(GTK_ENTRY(widgtemp));
  strcpy(final,strtemp);

  /* Shoud I have to remember this changes....till next time? */
  if (remember) 
    save_to_file();

  verita = FALSE;
  doppiociclo = 99;
  start = 0;
  whatidx = -1;
  modnum = 1;

}

void 
on_remyes_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		remember=1;
	else
		remember=0;
}

void 
on_remno_toggled(GtkToggleButton *togglebutton, gpointer user_data)
{
	if (GTK_TOGGLE_BUTTON (togglebutton)->active)
		remember=0;
	else
		remember=1;
}

void 
save_to_file() {
  FILE *fp;
  gchar *fname;
  int i;

  fname=malloc(256);
  if(fname==NULL) {
      g_print("Can't' save changes. Malloc problem.\n");
  } else {
	  snprintf(fname,255,"%s/.cappuccino",getenv("HOME"));
    /* You're creating your own cappuccino. Greetings! */
    if ((fp=fopen(fname,"w"))) {
      fprintf(fp,"#----------------------------------------------------------\n");
      fprintf(fp,"# ---------------- DO NOT EDIT THIS FILE ------------------\n");
      fprintf(fp,"# This file is created by cappuccino, editing it may result\n");
      fprintf(fp,"# in problems or even crash of cappuccino\n");
      fprintf(fp,"#----------------------------------------------------------\n");
      fprintf(fp,"title=%s\n",title);
      for (i=0;i<6;i++) {
        fprintf(fp,"row%d=%s\n",i,rows[i]);
        fprintf(fp,"dur%d=%d\n",i,cycles[i]);
      }
      fprintf(fp,"loops=%d\n",loops);    
      fprintf(fp,"final=%s\n",final);    
      fprintf(fp,"lastact=%d\n",lastaction);    
      fclose(fp);
    } else {
      g_print("Can't open $HOME/.cappuccino for writing\n");
    }
  }
}


