#ifndef OPTIONS_XML_H
#define OPTIONS_XML_H

#include <qdict.h>
#include <qdom.h>
#include <qstring.h>

class COptionsXML
{
private:
   QDict<QString> m_Variables;

protected:
   virtual void DeclareVariables() = 0;
   void DeclareVariable(const QString &name, const QString &defvalue);

   COptionsXML();

public:
   virtual ~COptionsXML();

   virtual void SetXML(const QDomNode &);
   virtual void GetXML(QDomNode &) const;

   QString Get(const QString &name) const;
   int GetInt(const QString &name) const;
   bool GetBool(const QString &name) const;
   void Set(const QString &name, const QString &value);
   void Set(const QString &name, int value);
   void Set(const QString &name, bool value);
};

#endif
