
#include "FTPListen.h"



CFTPListen::CFTPListen(Q_UINT16 port, QObject *parent, const char *name, int backlog)
	: QServerSocket(port, backlog, parent, name)
{

}

CFTPListen::CFTPListen(const QHostAddress &address, Q_UINT16 port, QObject *parent, const char *name, int backlog)
	: QServerSocket(address, port, backlog, parent, name)
{

}

CFTPListen::CFTPListen(QObject *parent, const char *name)
	: QServerSocket(parent, name)
{

}

// protected

/** \brief A new incoming connection has arrived.

  This function is overloaded from QServerSocket; it is called when a new
  connection arrives at the listing port.

  It will simply take the socket number and queue it.

*/

void CFTPListen::newConnection(int socket)
{
   qDebug("CFTPListen::newConnection(%d)", socket);
   m_Sockets.append(socket);
   emit ConnectionEstablished();
}


// public

/** \brief Get first socket from queue

  This function will return the first socket ID from the backlog
  queue. If there is no socket waiting, NULL is returned.
  Note: the socket is removed from the internal queue.
*/
int CFTPListen::FetchSocket()
{
   int Ret = -1;

   if (m_Sockets.count() > 0) {
     Ret = m_Sockets.first();
     m_Sockets.remove(m_Sockets.begin());
   }
   return Ret;
}

