#include <assert.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <qkeycode.h>
#include <qmenubar.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qpixmap.h>
#include <qworkspace.h>

#include "CamStreamApp.h"
#include "CamStreamMainWindow.h"
#include "CamWindow.h"

#include "NewViewer.h"
#include "WebCamViewer.h"


/**
  \class CCamStreamMainWindow
  \brief Name says it all: main window, with menu bar, etc.
  
  This is the main widget class of the application; It does several things:
  
  * manages the main menu and the Frames of the various subclasses. 
  * handles new and disappearing devices. 
  
  There is only one instance of this object, ever.
*/



/**
  \brief Constructor
*/
CCamStreamMainWindow::CCamStreamMainWindow()
	: QMainWindow(0, "camstreams")
{
   QPopupMenu *file, *filenew, *window;
   QMenuBar *pMenu;
   QPixmap BackgroundPix;

   // Create main workspace, with a nice background
   if (!BackgroundPix.load(ICON_DIR "/canvas.png")) {
     qWarning("Failed to load " ICON_DIR "/canvas.png!");
     BackgroundPix.fill(lightGray);
   }
   Workspace = new QWorkspace(this); // Just a placeholder for all the windows
   assert(Workspace != NULL);
   Workspace->setBackgroundPixmap(BackgroundPix);

   /* Create menus */
   filenew = new QPopupMenu();
   filenew->insertItem("&Viewer...",   this, SLOT(FileOpenNewViewer()), CTRL + Key_V);
   filenew->insertItem("&Encoder...",  this, SLOT(FileOpenNewEncoder()), CTRL + Key_S);
   filenew->insertItem("&Receiver...", this, SLOT(FileOpenNewReceiver()), CTRL + Key_R);
   
   file = new QPopupMenu();
   file->insertItem("&New...", filenew, CTRL + Key_N);
   file->insertItem("E&xit", CamApp, SLOT(quit()), CTRL + Key_Q);

   window = new QPopupMenu();
   window->insertItem("&Cascade", Workspace, SLOT(cascade()));
   window->insertItem("&Tile",    Workspace, SLOT(tile()));

   pMenu = menuBar();
   pMenu->insertItem("&File", file);
   pMenu->insertItem("&Window", window);

   setCentralWidget(Workspace);

#if 0
   // Add devices on command line as viewers
   m = CamApp->argc();
   for (i = 1; i < m; i++) {
      const char *dev;

      dev = CamApp->argv()[i];
      fd = open(dev, O_RDONLY);
      if (fd < 0) {
        QMessageBox mb;
        QString message;
        
        message.sprintf("Failed to open video device: %s" , dev);
        mb.critical(0, "Failure", message);
      }
      else {
        pCam = new CCamWidget(fd, Workspace);
        AddCam(pCam);
      }
   }
#endif
}

CCamStreamMainWindow::~CCamStreamMainWindow()
{
}

// private slots

/* Menu functions */

/** 
  \brief Show dialog to open new viewer frame
  
  This function will pop-up a small dialog where the user can select
  a (detected) video device, and an initial size.
 */
void CCamStreamMainWindow::FileOpenNewViewer()
{
   CNewViewer *pDlg;
   CVideoDevice *pDev;
   CCamWindow *pWindow;

   pDlg = new CNewViewer(CamApp->VideoDevices);
   if (pDlg->exec() == QDialog::Accepted) {
     pDev = pDlg->GetVideoDevice();
#if TRACE_CANVAS_OPEN
     QSize ls = pDlg->GetInitialSize();
     printf("Opening %s, requested size = %dx%d\n", (const char *)pDev->GetNodeName(), ls.width(), ls.height());
#endif
     pWindow = new CWebCamViewer(pDev, ls, Workspace);
     if (pWindow == NULL) {
       qWarning("Could not create WebCamViewer object (out of memory?)");
     }
     else
       pWindow->show();
   }
   delete pDlg;
}


void CCamStreamMainWindow::FileOpenNewEncoder()
{}

void CCamStreamMainWindow::FileOpenNewReceiver()
{}


