/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: module.pmod,v 1.6.2.1 2004/01/23 18:45:01 vida Exp $
 */

#include <camas/globals.h>

//! file: module.pmod
//!   Adressbook handler
//! cvs_version: $Id: module.pmod,v 1.6.2.1 2004/01/23 18:45:01 vida Exp $

//! method: int|array(array(string)) impabook(string file)
//!  Returns address book from "magic" filters
//! returns:
//!  0 if not suitable parser were found
//!  an array of array of string each array contains one type of field
//!  for example surnames. Inside this array you have all the surnames 
//!  in this address books.
array(string) typeofabook(string file) {
  string first_line = file[0..search(file, "\n")];
  if (sscanf(first_line, "%*s\t%*s") == 2)
    return ({ "csv", "\t" });
  if (sscanf(first_line, "%*s;%*s;%*s") >=2)
    return ({ "csv", ";" });
  if(sscanf(first_line, "%*s,%*s,%*s") >=2)
    return ({ "csv", "," });
  if(sscanf(file, "dn:%*s"))
    return ({ "ldif" });
  return 0;	// Unknown format :)
}

//! method: object get_currentaddressbook(object id)
//!  Returns the current addressbook module from user's choice in the interface.
object get_currentaddrbook(object id)
{
  array addrbooks = id->conf->get_providers("camas_addressbook");
  object current_addrbook;
  object fallback_addrbook = addrbooks[0];
  foreach(addrbooks, object addrbook)
  {
    if(addrbook->get_name() == CSESSION->selectedaddrbook)
    {
      current_addrbook = addrbook;
      break;
    }
    if(addrbook->isdefault())
      fallback_addrbook = addrbook;
  }
  // fallback
  if(!current_addrbook)
  {
    current_addrbook = fallback_addrbook;
    CSESSION->selectedaddrbook = current_addrbook->get_name();
  }
  return current_addrbook;
}

//
//! method: array(mapping(int:array(string))) get(mapping(int:string) variables2search, object id, array(mapping(int:array(string)) content, void|int or_search, void|int wildcardsearch)
//!   get every entries matching the given values in the variables2search mapping in a generic way. This module is in this file because it is generic and used
//!   by several Caudium modules.
//! arg: mapping(int:string) variables2search
//!  A mapping indexed by internal attributes value (internals means name will be replaced by cn later) and 
//!  containing for each key the value it must have. If several attributes are provided we simply make an AND
//! arg: object id
//!  Caudium id object
//! arg: void|int or_search
//!  Is this search and'ed or or'ed ?. By default attributes are and'ed
//! arg: void|int wildcardsearch 
//!  For a given attribute, do we search words matching a part of the search filter (wildcard type search) 
//!  or only the words matching ?
//! arg: array(mapping(int:array(string)) all
//!  The content of this addressbook to filter. This option is here for other addressbook to use this
//!  function
//! returns:
//!  Every entries present on this addressbook that match the given criterias
//!  An empty string if none match
array(mapping(int:array(string))) get(mapping(int:string) variables2search, object id, array(mapping(int:array(string))) all, void|int or_search, 
    void|int wildcardsearch)
{
  array(mapping(int:array(string))) matches = ({ });
  //write(sprintf("variables2search=%O\n", variables2search));
  foreach(all, mapping contact)
  {
    //write("Searching in new contact ----------------------");
    int match = 1;
    if(or_search)
      match = 0;
    foreach(indices(variables2search), int index)
    {
      if(!contact[index])
      {
        //write(sprintf("contact[%d] is NULL", index));
        if(!or_search)
        {
          //write("don't match");
          match = 0;
        }
      }
      else
        foreach(contact[index], string val)
        {
          /* write(sprintf("Looking up contact[%d] (%s) for %s...", index, 
              val, variables2search[index])); */
          val = lower_case(val);
          string var2search = lower_case(variables2search[index]);
          if(or_search)
          {
            if(wildcardsearch)
            {
              if(has_value(val, var2search))
              {
                //write("match");
                match = 1;
                break;
              }
            }
            else
            {
              if(val == var2search)
              {
                //write("match");
                match = 1;
                break;
              }
            }
            //write("don't match");
          }
          else
          {
            if(wildcardsearch)
            {
              if(!has_value(val, var2search))
              {
                //write("don't match");
                match = 0;
                break;
              }
            }
            else
            {
              if(val != var2search)
              {
                //write("don't match");
                match = 0;
                break;
              }
            }
            //write("match");
          }
        }
    }
    if(match)
      matches += ({ contact });
  }
  //write(sprintf("Number of matches result: %d\n", sizeof(matches)));
  return matches;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

