/*
 * $Id: compat.h,v 1.7 2003/09/25 15:37:46 jmmv Exp $
 *
 * buildtool
 * Copyright (c) 2003 Julio M. Merino Vidal
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef BT_COMPAT_H

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif

#include <assert.h>
#include <unistd.h>

#ifndef _DIAGASSERT
#define _DIAGASSERT assert
#endif

#ifndef HAVE_GETMODE
mode_t getmode(const void *, mode_t);
#endif

#ifndef HAVE_SETMODE
void *setmode(const char *);
#endif

#ifndef HAVE_SYS_SIGLIST
extern const char * const sys_siglist[];
#endif

#ifndef HAVE_SYS_SIGNAME
extern const char * const sys_signame[];
#endif

#ifndef HAVE_OPTRESET
extern char *compat_optarg;
extern int compat_optind;
extern int compat_optopt;
extern int compat_opterr;
extern int compat_optreset;
int compat_getopt(int, char * const [], const char *);
#define opterr compat_opterr
#define optint compat_optind
#define optopt compat_optopt
#define optreset compat_optreset
#define optarg compat_optarg
#define getopt compat_getopt
#endif

#endif /* BT_COMPAT_H */
