#ifndef ORIGINAL_SOURCE

/*
 * This is a quick and dirty replacement for some BSD specific functions.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <syslog.h>
#include <errno.h>
#include <string.h>

#include "bsdport.h"

u_int32_t
arc4random (void)
{
	static int fd = -1;
	u_int32_t res;

	if (fd == -1) {
		fd = open ("/dev/urandom", O_RDONLY);
		if (fd<0) {
			syslog (LOG_NOTICE, "Can't open /dev/urandom: %s",
				strerror (errno));
			return 1500000;
			/* All right, this isn't a random number.  But
			 * the *only* use of this function in this
			 * ftpd is to determine how many microseconds
			 * to sleep if the requested login doesn't
			 * exist.  I think it is better to sleep a
			 * fixed number of seconds than to die
			 * stupidly.  -- David Madore */
		}
	}
	if (read (fd, &res, sizeof(res)) < sizeof(res)) {
		syslog (LOG_NOTICE, "Can't read /dev/urandom: %s",
			strerror (errno));
		close (fd);
		fd = -1;
		return 1500000;
	}
	return res;
}

int
strvis (char *dst, char *src, int flag)
{
	int i,j;

	j = 0;
	for (i=0 ; src[i] ; i++) {
		if ( ((src[i]>32)&&(src[i]<127)) ||
		     (src[i]==32) || (src[i]==9) || (src[i]==10) ||
		     (src[i]==8) || (src[i]==7) || (src[i]==13) )
			dst[j++] = src[i];
		else {
			dst[j++] = '\\';
			dst[j++] = '0'+((((unsigned int)src[i])/0100)&7);
			dst[j++] = '0'+((((unsigned int)src[i])/010)&7);
			dst[j++] = '0'+((((unsigned int)src[i]))&7);
		}
	}
	dst[j] = 0;
	return j; /* number of characters in dst */
}

#endif
