Name: brltty
Version: 4.2
Release: 1

Group: System Environment/Daemons
License: GPL
Vendor: The BRLTTY Team
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: /bin/sh
BuildRequires: /bin/ln
BuildRequires: /usr/bin/ld
BuildRequires: /sbin/ldconfig
BuildRequires: /usr/bin/ranlib
BuildRequires: /usr/bin/ar
BuildRequires: /usr/bin/awk
BuildRequires: /usr/bin/bison
BuildRequires: /usr/bin/install
BuildRequires: glibc-devel
BuildRequires: Pyrex
BuildRequires: tcl
BuildRequires: gcc-java

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc

AutoProv: 1

AutoReq: 1
Requires: /bin/sh

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.

%package -n brlapi
Version: 0.5.5
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.

%package -n brlapi-caml
Version: 0.5.5
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Caml bindings for BrlAPI.
%description -n brlapi-caml
This package provides the Caml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Caml application
which directly accesses a refreshable braille display.

%package -n brlapi-java
Version: 0.5.5
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.

%package -n brlapi-python
Version: 0.5.5
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.

%package -n brlapi-tcl
Version: 0.5.5
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.

%package -n brlapi-devel
Version: 0.5.5
Group: Development/System
License: LGPL

AutoProv: 1

AutoReq: 1
Requires: brlapi = 0.5.5

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.

%prep
# %setup -n %{name}-%{version}
%setup -n brltty-4.2

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-flite --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --without-curses --without-x --with-braille-driver=-tt
make

directory="doc"
mkdir -p "${directory}"
for file in `find . \( -path "./${directory}" -o -path ./Documents \) -prune -o \( -name 'README*' -o -name '*.patch' -o -name '*.txt' -o -name '*.html' -o -name '*.sgml' -o \( -path "./Bootdisks/*" -type f -perm +ugo=x \) \) -print`
do
   mkdir -p "${directory}/${file%/*}"
   cp -rp "${file}" "${directory}/${file}"
done

%install
make install
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"

%clean
rm -fr "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_bindir}/vstp
%{_libdir}/brltty
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/*
%doc Documents/Manual-BRLTTY/English/*.{sgml,txt,html}
%doc LICENSE-GPL
%doc Documents/ChangeLog Documents/TODO
%doc doc/*
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%{_bindir}/xbrlapi
%doc Documents/Manual-BrlAPI/English/*.{sgml,txt,html}

%files -n brlapi-caml
/usr/lib/ocaml/brlapi

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-python
/usr/lib/python2.6/site-packages/[bB]rlapi[-.]*

%files -n brlapi-tcl
/usr/lib/tcl8.5/brlapi-0.5.5/libbrlapi_tcl.so
/usr/lib/tcl8.5/brlapi-0.5.5/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc Documents/BrlAPIref

%changelog
* Mon May  0 2010 Dave Mielke <dave@mielke.cc> 4.2
+  Ending a cut operation beyond the right edge of the screen has been fixed.
+  Key/character insertion works with newer versions of Xorg.
+  The braille driver help files have been converted to plain text.
+  Multiple instances of brltty may not use the same PID file.
+  The keypad keyboard key table provides a braille input mode.
+  The working directory is no longer set to the data directory.
+  The writable directory is created if it doesn't already exist.
+  USB I/O via libusb1 is supported.
+  The Metec braille driver has been added.
+  The eSpeak speech driver has been added.
+  The AtSpi2 screen driver has been added.
+  A BrlAPI client for Window-Eyes has been developed.
+  Albatross braille driver changes:
      Converted to use key tables.
      USB support has been added.
+  Alva braille driver changes:
      Converted to use key tables.
+  Baum braille driver changes:
      Converted to use key tables.
      Vario Pro wheels are supported.
      For Vario Pro models, only update the text cells which have changed.
+  CombiBraille braille driver changes:
      Converted to use key tables.
+  FreedomScientific braille driver changes:
      Converted to use key tables.
      Bluetooth support has been added.
      The Focus Blue is supported.
      Rockers and bumper bars are recognized as distinct keys.
+  HandyTech braille driver changes:
      Converted to use key tables.
      Pressing two routing keys simultaneously immediately cuts the selected text.
      Newer models which use the USB HID interface are supported.
      The InputMode= parameter has been removed.
+  HIMS braille driver changes:
      Converted to use key tables.
+  Papenmeier braille driver changes:
      Converted to use key tables.
      The DebugReads= and DebugWrites= parameters have been removed.
      Support for the configuration file has been removed (now uses key tables).
+  Pegasus braille driver changes:
      Converted to use key tables.
+  Seika braille driver changes:
      Converted to use key tables.
+  Voyager braille driver changes:
      Converted to use key tables.
+  BrlAPI changes:
      Key event support has been added.
      Various client fixes for the Windows environment.
      Various fixes for when threads aren't available.
      No more extraneous connection to localhost when using a TCP/IP host name.
      A fix to exception handling within the Python bindings.
+  ExternalSpeech speech driver changes:
      Two-letter driver identification code changed to "xs" (from "es").
+  AtSpi screen driver changes:
      Static linking is supported.
      A problem causing crashes on 64-bit platforms has been resolved.
+  Windows screen driver changes:
      Significant reductions in memory usage.
      Better handling of unreadable screens.
      Better handling of the Alt+Tab window.
+  DOS changes:
      Log records are written to the file "brltty.log".
      The TSI braille driver stays at 9600 baud.
+  Key table changes:
      Add the following directives:
         assign, context, hide, hotkey, ifkey, map, note, superimpose, title.
      Add the \{name} variable name expansion syntax.
      Add the ! immediate key syntax.
      A command may have more than one modifier.
      The line command modifiers are supported.
      Keyboard key table names are now prefixed with "kbd-".
      The ktbtest tool has been added.
+  Linux changes:
      USB device inspection is more efficient.
      Fixes to keyboard connect/disconnect monitoring.
      Fixes to key event handling.
      PCM and MIDI support defaults to ALSA (instead of to OSS).
+  Windows changes:
      Improved conversion of Windows errors to system errors (errno values).
      Bluetooth support has been added.
      Text table autoselection has been fixed.
      Text table editing (ttbtest -e) is supported.
+  Build changes:
      --enable-usb-support changed to --with-usb-package[=package,...].
      --disable-usb-support changed to --without-usb-package.
      --enable-bluetooth-support changed to --with-bluetooth-package[=package,...].
      --disable-bluetooth-support changed to --without-bluetooth-package.
+  Text tables updated:
      hu, sk.
+  Contraction tables updated:
      de-kurzschrift, en-us-g2, zh-tw.

