#ifndef _KDESCOREEDITOR2_CPP_
#define _KDESCOREEDITOR2_CPP_

#include "kdeScoreEditor2.h"

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <iostream.h>
#include <math.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>

#include <qbitmap.h>
#include <qpopupmenu.h>
#include <qsplitter.h>
#include <qscrollview.h>

#include "part.h"
#include "track.h"
#include "song.h"
#include "lyrics.h"

#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeEditorScrollBar.h"
#include "kdeEditInfo.h"
#include "kdeEditorMenuBar.h"
#include "kdeScoreContent2.h"
#include "brahmsResources.h"

#include "qtScoreAddons.h"

#define YTOP 12

extern Song * sonG;


enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS, ID_TOOL_LYR };
enum { ID_OPTIONS_NOTEBAR, ID_OPTIONS_AUTHOR, ID_OPTIONS_AUX, ID_OPTIONS_NEXT, ID_OPTIONS_STN,
       ID_OPTIONS_SIN, ID_OPTIONS_LYRICS, ID_OPTIONS_VOLUMES, ID_OPTIONS_NOOVERLAP, ID_OPTIONS_TUPLETS, ID_OPTIONS_HORIZONTAL_BEAMS, ID_OPTIONS_BEAMS_EXCEED_BREAKS };



#define SCROLLHEIGHT 120
#define INFOHEIGHT 100
#define MINWIDTH 720


	   //the 0 should become a pointer to KdeMainEditor:
KdeScoreEditor2::KdeScoreEditor2(QWidget * parent) : KMainWindow(parent, "ScoreEditor"), PrScoreEditor() {
  run();
}

KdeScoreEditor2::KdeScoreEditor2(Part * p, QWidget * parent) : KMainWindow(parent, "ScoreEditor"), PrScoreEditor(p) {
  run();
}

KdeScoreEditor2::KdeScoreEditor2(Track * t, QWidget * parent) : KMainWindow(parent, "ScoreEditor"), PrScoreEditor(t) {
  run();
}

KdeScoreEditor2::~KdeScoreEditor2() {

}

void KdeScoreEditor2::run() {


  // init
  //
  setCaption("Score Editor"); // TODO: part name

  _xoffset = 24;
  _score = 0;
  _tool = ID_TOOL_IN;
  _ybottom = YTOP + YDELTA*parts();
  _grid_id = ID_GRID_8;
  _res_id = ID_RES_16;
  _dyn_id = ID_DYN_F;
  _tupl_id = 1;
  _toolbarstate = true;
  _notebarstate = false;
  _buttonbarstate = true;
  _sliderstate = true;
  showIN = true;
  showTN = false;

  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);
  _notebar = new KdeEditorNoteBar(this,this);
  _buttonbar = new KdeEditorButtonBar(this,this);
  _scrollbar = new KdeEditorScrollBar(this,this);


  addToolBar( _toolbar ); _toolbar->setBarPos(KToolBar::Top); if (_toolbarstate) _toolbar->show(); else _toolbar->hide();
  addToolBar( _notebar ); _notebar->setBarPos(KToolBar::Top); if (_notebarstate) _notebar->show(); else _notebar->hide();
  addToolBar( _buttonbar ); _buttonbar->setBarPos(KToolBar::Top); if (_buttonbarstate) _buttonbar->show(); else _buttonbar->hide();
  addToolBar( _scrollbar ); _scrollbar->setBarPos(KToolBar::Bottom); if (_sliderstate) _scrollbar->show(); else _scrollbar->hide();

  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _gridmenu = new QPopupMenu( this );
  _resmenu  = new QPopupMenu( this );
  _dynamicsmenu = new QPopupMenu( this );
  _viewmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, _gridmenu, _dynamicsmenu, _viewmenu, _resmenu);
  _gridmenu->setItemChecked(_grid_id,TRUE);
  _resmenu->setItemChecked(_res_id,TRUE);
  _dynamicsmenu->setItemChecked(_dyn_id,TRUE);
  _viewmenu->setItemChecked(ID_VIEW_TOOLBAR, _toolbarstate);
  _viewmenu->setItemChecked(ID_VIEW_NOTEBAR , _notebarstate);
  _viewmenu->setItemChecked(ID_VIEW_BUTTONBAR, _buttonbarstate);
  _viewmenu->setItemChecked(ID_VIEW_SLIDER, _sliderstate);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_gridmenu,SIGNAL(activated(int)),SLOT(slotGridMenu(int)));
  connect(_resmenu,SIGNAL(activated(int)),SLOT(slotResMenu(int)));
  connect(_dynamicsmenu,SIGNAL(activated(int)),SLOT(slotDynMenu(int)));
  connect(_viewmenu,SIGNAL(activated(int)),SLOT(slotViewMenu(int)));

  _toolmenu = new QPopupMenu( this );
  _toolmenu->insertItem( i18n("Insert Notes"), ID_TOOL_IN );
  _toolmenu->insertItem( i18n("Add Note Symbols"), ID_TOOL_ANS );
  _toolmenu->insertItem( i18n("Add System Symbols"), ID_TOOL_AOS );
  _toolmenu->insertItem( i18n("Add Lyrics"), ID_TOOL_LYR );
  _toolmenu->setAccel(ALT+Key_N,ID_TOOL_IN);
  _toolmenu->setAccel(ALT+Key_A,ID_TOOL_ANS);
  _toolmenu->setAccel(ALT+Key_S,ID_TOOL_AOS);
  _toolmenu->setAccel(ALT+Key_L,ID_TOOL_LYR);

  _toolmenu->setCheckable(true);
  _toolmenu->setItemChecked(_tool, true);
  connect(_toolmenu,SIGNAL(activated(int)),SLOT(toolMenu(int)));

  _tupletmenu = new QPopupMenu( this );
  char * txt = new char[12];
  for (int i=0; i<11; i++) {
    sprintf(txt, " %d ", i);
    _tupletmenu->insertItem( i18n(txt), i );
  }
  _tupletmenu->setItemChecked( _tupl_id, TRUE );
  connect(_tupletmenu,SIGNAL(activated(int)),SLOT(tupletsMenu(int)));

  _optionsmenu = new QPopupMenu( this );
  _optionsmenu->insertItem( i18n("Show Tracknames"), ID_OPTIONS_STN );
  _optionsmenu->insertItem( i18n("Show Instrumentnames"), ID_OPTIONS_SIN );
  _optionsmenu->insertSeparator();
  _optionsmenu->insertItem( i18n("Truncate Overlap"), ID_OPTIONS_NOOVERLAP );
  _optionsmenu->insertItem( i18n("Horizontal Beams"), ID_OPTIONS_HORIZONTAL_BEAMS );
  _optionsmenu->insertItem( i18n("Beams Exceed Breaks"), ID_OPTIONS_BEAMS_EXCEED_BREAKS );
  _optionsmenu->insertSeparator();
  _optionsmenu->insertItem( i18n("Tuplet Base"), _tupletmenu );
  _optionsmenu->setItemChecked(ID_OPTIONS_SIN, showIN);
  _optionsmenu->setItemChecked(ID_OPTIONS_STN, showTN);
  _optionsmenu->setItemChecked(ID_OPTIONS_NOOVERLAP, noOverlap());
  _optionsmenu->setItemChecked(ID_OPTIONS_HORIZONTAL_BEAMS, horizontalBeams());
  _optionsmenu->setItemChecked(ID_OPTIONS_BEAMS_EXCEED_BREAKS, beamsExceedBreaks());
  connect(_optionsmenu,SIGNAL(activated(int)),SLOT(optionsMenu(int)));

  menuBar()->insertItem(i18n("Tools"),_toolmenu);
  menuBar()->insertItem(i18n("Options"),_optionsmenu);


  //
  // Contents:
  // =========

  setMinimumWidth(MINWIDTH);
  setMinimumHeight(SCROLLHEIGHT*2 + INFOHEIGHT + 20);

  _area = new QWidget( this );
  _area->setMinimumHeight(SCROLLHEIGHT + INFOHEIGHT);
  _area->setGeometry(0, 0, MINWIDTH, SCROLLHEIGHT + INFOHEIGHT);
  setCentralWidget(_area);

  _scroller = new QScrollView( _area, "Scroller", QFrame::Raised );
  _scroller->setHScrollBarMode(QScrollView::AlwaysOff);
  _scroller->setVScrollBarMode(QScrollView::AlwaysOn);
  _scroller->setGeometry(0, 0, _area->width(), _area->height() - INFOHEIGHT -1);

  _content = new KdeScoreContent2( _scroller, this, _toolbar, _notebar, _buttonbar );
  _content->setGeometry(0, 0, _scroller->width() - 20, SCROLLHEIGHT * 12);
  _scroller->addChild(_content);

  _info = new KdeEditInfo( _area, this );
  _info->setBackgroundMode( QWidget::PaletteMidlight );
  _info->setGeometry(0, _area->height() - INFOHEIGHT, _area->width(), INFOHEIGHT -1);

  update();
  setFocus();
  sonG->updateGui();
  _toolbar->update();

}

void KdeScoreEditor2::resizeEvent( QResizeEvent * re ) {
  KMainWindow::resizeEvent(re);

  // cout << "\narea: " << _area->geometry().left() << ", " << _area->geometry().top() << ", " << _area->geometry().width() << ", " << _area->geometry().height() << endl;
  // cout << "main: " << geometry().left() << ", " << geometry().top() << ", " << geometry().width() << ", " << geometry().height() << endl;

  _scroller->setGeometry(0, 0, _area->width(), _area->height() - INFOHEIGHT -1);
  _content->setGeometry(0, 0, _scroller->width() - 20, SCROLLHEIGHT * 12);
  _info->setGeometry(0, _area->height() - INFOHEIGHT, _area->width(), INFOHEIGHT -1);

}

int KdeScoreEditor2::editorWidth() const { return _content->width() -_xoffset; }

int KdeScoreEditor2::xoffset() { return _xoffset; }

QPainter * KdeScoreEditor2::score() { return _score; }

void KdeScoreEditor2::setScore(QPainter * p) { _score = p; }


bool KdeScoreEditor2::showInstrumentName() { return showIN; }

bool KdeScoreEditor2::showTrackName() { return showTN; }

void KdeScoreEditor2::update() {
  _content->repaint(FALSE);
  _info->repaint(FALSE);
  _buttonbar->setLength(lengthOrd(),dot(),tuplet()!=0);
  /*
  switch (lengthOrd()) {
  case 1: slotGridMenu(ID_GRID_1); break;
  case 2: slotGridMenu(ID_GRID_2); break;
  case 3: slotGridMenu(ID_GRID_4); break;
  case 4: slotGridMenu(ID_GRID_8); break;
  case 5: slotGridMenu(ID_GRID_16); break;
  case 6: slotGridMenu(ID_GRID_32); break;
  case 7: slotGridMenu(ID_GRID_64); break;
  default: slotGridMenu(ID_GRID_OFF); break;
  }*/
}

void KdeScoreEditor2::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeScoreEditor2::print() {
  _content->print();
}

void KdeScoreEditor2::settings() {
  _content->settings();
}

void KdeScoreEditor2::slotMenu(int i) {
  // cout << i << endl;
  _toolbar->commandCallback(i);
}

void KdeScoreEditor2::slotGridMenu(int i) {
  _gridmenu->setItemChecked(_grid_id,false);
  _grid_id = i;
  _gridmenu->setItemChecked(_grid_id,true);
  switch (i) {
  case ID_GRID_1: setGrid(1536); break;
  case ID_GRID_2: setGrid(768); break;
  case ID_GRID_4: setGrid(384); break;
  case ID_GRID_8: setGrid(192); break;
  case ID_GRID_16: setGrid(96); break;
  case ID_GRID_32: setGrid(48); break;
  case ID_GRID_64: setGrid(24); break;
  case ID_GRID_OFF: setGrid(0); break;
  }
}

void KdeScoreEditor2::slotResMenu(int i) {
  _resmenu->setItemChecked(_res_id,false);
  _res_id = i;
  _resmenu->setItemChecked(_res_id,true);
  switch (i) {
  case ID_RES_1: setPartResolution(1536); break;
  case ID_RES_2: setPartResolution(768); break;
  case ID_RES_4: setPartResolution(384); break;
  case ID_RES_8: setPartResolution(192); break;
  case ID_RES_16: setPartResolution(96); break;
  case ID_RES_32: setPartResolution(48); break;
  case ID_RES_64: setPartResolution(24); break;
  case ID_RES_OFF: setPartResolution(0); break;
  default: setPartResolution(0); break;
  }
}

void KdeScoreEditor2::slotDynMenu(int i) {
  _dynamicsmenu->setItemChecked(_dyn_id,false);
  _dyn_id = i;
  _dynamicsmenu->setItemChecked(_dyn_id,true);
  switch (i) {
  case ID_DYN_OFF: setVelocity(0); break;
  case ID_DYN_P: setVelocity(14); break;
  case ID_DYN_PP: setVelocity(28); break;
  case ID_DYN_PPP: setVelocity(42); break;
  case ID_DYN_MP: setVelocity(56); break;
  case ID_DYN_MF: setVelocity(70); break;
  case ID_DYN_F: setVelocity(86); break;
  case ID_DYN_FF: setVelocity(102); break;
  case ID_DYN_FFF: setVelocity(127); break;
  default: setVelocity(0); break;
  }
}

void KdeScoreEditor2::slotViewMenu(int i) {
  bool ch = _viewmenu->isItemChecked(i);
  ch = !ch;
  _viewmenu->setItemChecked(i,ch);
  switch(i) {
  case ID_VIEW_TOOLBAR:
    if (ch) _toolbar->show(); else _toolbar->hide();
    break;
  case ID_VIEW_NOTEBAR:
    if (ch) _notebar->show(); else _notebar->hide();
    break;
  case ID_VIEW_BUTTONBAR:
    if (ch) _buttonbar->show(); else _buttonbar->hide();
    break;
  case ID_VIEW_SLIDER:
    if (ch) _scrollbar->show(); else _scrollbar->hide();
    break;
  default:
    break;
  }
}


void KdeScoreEditor2::toolMenu(int i) {
  _toolmenu->setItemChecked(tool(),false);
  setTool(i);
  _toolmenu->setItemChecked(tool(),true);
  if (tool()==ID_TOOL_ANS)
    if (!showNEXT) optionsMenu(ID_OPTIONS_NEXT);
  if (tool()==ID_TOOL_AOS)
    if (!showAUX) optionsMenu(ID_OPTIONS_AUX);
}


void KdeScoreEditor2::setTool(int i) {
  _tool = i;
  _content->updateCursor();
}

int KdeScoreEditor2::tool() {
  return _tool;
}

int KdeScoreEditor2::tuplid() { return _tupl_id; }


void KdeScoreEditor2::tupletsMenu(int n) {
  _tupletmenu->setItemChecked(_tupl_id,false);
  _tupl_id = n;
  _tupletmenu->setItemChecked(_tupl_id,true);
}

void KdeScoreEditor2::optionsMenu(int n) {
  switch(n) {
  case ID_OPTIONS_AUX:
    //if (showAUX) { showAUX = false; options->setItemChecked(ID_OPTIONS_AUX,false); scoreAux->hide(); }
    //else { showAUX = true; options->setItemChecked(ID_OPTIONS_AUX,true); scoreAux->show(); }
    break;
  case ID_OPTIONS_NEXT:
    //if (showNEXT) { showNEXT = false; options->setItemChecked(ID_OPTIONS_NEXT,false); noteExt->hide(); }
    //else { showNEXT = true; options->setItemChecked(ID_OPTIONS_NEXT,true); noteExt->show(); }
    break;
  case ID_OPTIONS_STN:
    if (showTN==TRUE) showTN=FALSE;
    else showTN=TRUE;
    _optionsmenu->setItemChecked(ID_OPTIONS_STN,showTN);
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_SIN:
    if (showIN==TRUE) showIN=FALSE;
    else showIN=TRUE;
    _optionsmenu->setItemChecked(ID_OPTIONS_SIN,showIN);
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_NOOVERLAP:
    setNoOverlap(!noOverlap());
    _optionsmenu->setItemChecked(ID_OPTIONS_NOOVERLAP,noOverlap());
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_HORIZONTAL_BEAMS:
    setHorizontalBeams(!horizontalBeams());
    _optionsmenu->setItemChecked(ID_OPTIONS_HORIZONTAL_BEAMS, horizontalBeams());
    _content->repaint(FALSE);
    break;
  case ID_OPTIONS_BEAMS_EXCEED_BREAKS:
    setBeamsExceedBreaks(!beamsExceedBreaks());
    _optionsmenu->setItemChecked(ID_OPTIONS_BEAMS_EXCEED_BREAKS, beamsExceedBreaks());
    _content->repaint(FALSE);
    break;

  case ID_OPTIONS_LYRICS:
    //if (showLYR==true) { showLYR=false; yAux = 0; volGrabX1 = 0; }
    //else { showLYR = true; showVOL = false; yAux = 20; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    break;
  case ID_OPTIONS_VOLUMES:
    //if (showVOL==true) { showVOL=false; yAux = 0; volGrabX1 = 0; }
    //else { showVOL = true; showLYR = false; yAux = 64; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    break;
  }
}

void KdeScoreEditor2::keyPressEvent ( QKeyEvent * key ) {
  _content->keyPressEvent(key);
}

void KdeScoreEditor2::keyReleaseEvent ( QKeyEvent * key ) {
  _content->keyReleaseEvent(key);
}

KdeScoreContent2 * KdeScoreEditor2::content() { return _content; }

KdeEditInfo * KdeScoreEditor2::info() { return _info; }


// *****************************************************************************
//
// PAINT EVENT
// ===========
//

/*
void KdeScoreEditor2::paintEvent( QPaintEvent * ) {
  //_content->repaint(FALSE);
  //_info->repaint(FALSE);

  }*/

void KdeScoreEditor2::setCursorPosition(long ticks) {
  _content->moveCursor(ticks);
}




#endif
#include "kdeScoreEditor2.moc"
