#ifndef _PLAYER_CPP_
#define _PLAYER_CPP_

#include <iostream.h>
#include <string.h>

#include <libkmid/midiout.h>

#include "player.h"
#include "reference.h"
#include "part.h"
#include "track.h"
#include "note.h"
#include "midiEvent.h"
#include "song.h"
#include "table.h"
#include "element.h"
#include "scoreTrack.h"
#include "drumTrack.h"
#include "prProgress.h"
#include "prMainEditor.h"

#include "artsmidi.h"

extern int output;
extern PrMainEditor * mainEditor;

enum { KMID, ARTS };

Player::Player() : _song(0), devnum(0), playing(false), dispatcher(0) {
  init();
}

Player::Player(Song * s) : _song(s), devnum(0), playing(false), dispatcher(0) {
  init();
}

Player::~Player() {
  // TODO: delete devman; // causes a segfault invalid filedescriptor
  // delete dispatcher;
}



void Player::init() {
  if (output==KMID) {
    char * map_path = NULL;
    devman = new DeviceManager();
    devman->initManager();
    MidiMapper *map=new MidiMapper(map_path);
    devman->setMidiMap(map);
    char * line;
    devnum = devman->synthDevices() + devman->midiPorts(); // my AWE has 2 synths and 1 MIDI
    for (int i=0; i<devnum && i<MAXDEVNUM; i++) { devices[i] = strdup(devman->name(i)); line = devices[i]; line+=9; line[0]=0; }
  } else { // ARTS
    initArts();
  }
}

char * Player::device(int i) {
  char * dev = 0;
  if (output==KMID) {
    dev = devices[i];
  } else {
    dev = "aRts";
  }
  return dev;
}

int Player::devicenum() {
  int ret = 0;
  if (output==KMID) {
    ret = devnum;
  } else {
    ret = 1;
  }
  return ret;
}

void Player::play(PrProgress * progress, Part * part, long left, long right) {
  if (!playing) {
    playing = true;
    
    if (output==KMID) {
      //
      // KMID
      //
      
      int ntracks = 0;
      double progStep = 0;
      double progInd = 0;
      int progInd1 = 0;
      bool veto = false;
      
      if (right==0) progress = 0; // DOIT: calculate progStep for unspecified left+right values!
      else {
	progStep = 100.0/(right-left);
	if (progress!=0) progress->progress(0);
      }
      if (part!=0) {
	ntracks = 1;
      } else {
	ntracks = _song->size();
      }
      Track * tr[ntracks];
      Part * pt[ntracks];
      int stp[ntracks];
      
      if (part!=0) {
	pt[0] = part;
	// pt[0]->rewind();
	pt[0]->windPlayer(left);
	tr[0] = 0;
	stp[0] = 0;
      } else {
	for (int t=0; t<ntracks; t++) {
	  tr[t] = (Track*) _song->get(t);
	  pt[t] = (Part*) tr[t]->first();
	  // pt[t]->rewind();
	  if (pt[t]) {
	    pt[t]->windPlayer(left);
	    stp[t] = 0;
	    // if (tr[t]->isA()==SCORETRACK) devman->setDevice(((ScoreTrack*)tr[t])->channel(),((ScoreTrack*)tr[t])->output());
	    // if (tr[t]->isA()==DRUMTRACK) devman->setDevice(((DrumTrack*)tr[t])->channel(),((DrumTrack*)tr[t])->output());
	    if (tr[t]->isA()==SCORETRACK) {
	      if (((ScoreTrack*)tr[t])->output() < devnum)
		devman->setDeviceNumberForChannel(((ScoreTrack*)tr[t])->channel(),((ScoreTrack*)tr[t])->output());
	      else veto = true;
	    }
	    if (tr[t]->isA()==DRUMTRACK) {
	      if (((DrumTrack*)tr[t])->output() < devnum)
		devman->setDeviceNumberForChannel(((DrumTrack*)tr[t])->channel(),((DrumTrack*)tr[t])->output());
	      else veto = true;
	    }
	  }
	}
      }
      if (!veto) {
	devman->openDev();
	devman->initDev();
	devman->tmrSetTempo(100);
	devman->setVolumePercentage(100);
	// devman->tmrStart();
	// cout << "start playing" << endl;
	
	for (int t=0; t<ntracks; t++) {
	  if (tr[t]!=0) {
	    if (tr[t]->isA()==SCORETRACK) devman->chnPatchChange(((ScoreTrack*)tr[t])->channel(),((ScoreTrack*)tr[t])->program());
	    // cout << ((ScoreTrack*)tr[t])->channel() << " -> " << ((ScoreTrack*)tr[t])->program() << endl;
	    if (tr[t]->isA()==DRUMTRACK) devman->chnPatchChange(((DrumTrack*)tr[t])->channel(),((DrumTrack*)tr[t])->program());
	  }
	}
	int stop = 0;
	long pp = left;
	// long oldTimePos = 0;
	needSync = false;
	Note * note;
	MidiEvent * mev;
	// Element * el = 0;
	// Table * sus = new Table();
	// Reference * ref = 0;
	double tempo = _song->tempo()*0.01;
	
	while (stop<2) {
	  if (needSync) { devman->sync(); needSync = false; }
	  
	  for (int t=0; t<ntracks; t++) {
	    if (pt[t]) {
	      for (pt[t]->startMem();pt[t]->moreMem();) {
		if (pt[t]->memEndsAt(pp)) {
		  note = (Note*) pt[t]->mem();
		  wait(pp*tempo,left*tempo);
		  devman->noteOff(0,note->pitch(),note->vel());
		  // cout << "stop " << note << endl;
		  pt[t]->cutMem();
		} else {
		  pt[t]->incMem();
		}
	      }
	    }
	  }
	  
	  for (int t=0; t<ntracks; t++) {
	    if (pt[t]!=0) {
	      while (pt[t]->currentPlayerStartsAt(pp)) {
		if (pt[t]->currentPlayer(NOTE)) {
		  note = (Note*) pt[t]->currentPlayer();
		  wait(pp*tempo,left*tempo);
		  devman->noteOn(0,note->pitch(),note->vel());
		  // cout << "start " << note << endl;
		  pt[t]->rememberCurrentPlayer();
		} else if (pt[t]->currentPlayer(MIDIEVENT)) {
		  mev = (MidiEvent*) pt[t]->currentPlayer();
		  wait(pp*tempo,left*tempo);
		  switch (mev->code()) {
		  case 10: devman->keyPressure(mev->channel(), mev->value1(), mev->value2()); break; // Aftertouch, Poly Pressure
		  case 11: devman->chnController(mev->channel(), mev->value1(), mev->value2()); break; // Control Change
		  case 12: devman->chnPatchChange(mev->channel(), mev->value1()); break; // Program Change
		  case 13: devman->chnPressure(mev->channel(), mev->value1()); break; // Aftertouch, Channel Pressure
		  case 14: devman->chnPitchBender(mev->channel(), mev->value1(), mev->value2()); break; // Pitchbend
		  case 15: cout << "sysex msg" << endl; break;
		  }
		} else {
		  cout << "track " << t << *pt[t]->currentPlayer() << endl;
		}
		if (!pt[t]->currentPlayerInc()) stp[t]++;
	      }
	    }
	  }
	  stop = 1;
	  if ((right!=0) && (pp>=right)) {
	  } else {
	    for (int t=0; t<ntracks; t++) { if (stp[t]==0) stop = 0; }
	  }
	  
	  if (stop==1) {
	    stop = 2;
	    for (int t=0; t<ntracks; t++) {
	      pt[t]->startMem();
	      if (pt[t]->moreMem()) stop = 1;
	    }
	  }
	  pp++;
	  if (progress!=0) { progInd += progStep; if (int(progInd) > progInd1) { progress->progress(int(progInd)); progInd1 = int(progInd); } }
	}
	
	pp += 384;
	wait(pp*tempo,left*tempo);
	devman->sync();
	// cout << "stop playing" << endl;
	devman->tmrStop();
	devman->closeDev();
	
	for (int t=0; t<ntracks; t++) {
	  pt[t]->startMem();
	  if (pt[t]->moreMem()) {
	    pt[t]->clearMem();
	  }
	}
      }
      // cout << sus->length() << endl;
      // delete sus;

    } else {
      //
      // ARTS
      //
      playArts(progress, part, left, right);
      mainEditor->startTimer();
    }

    playing = false;
  }
}


void Player::wait(long timePos, long offset) {
  if (output==KMID) {
    if (oldTimePos!=timePos) {
      devman->wait(timePos-offset);
      oldTimePos=timePos;
    }
    needSync=true;
  }
}

using namespace Arts;

struct PlayerState {
  TimeStamp playTime;
  TimeStamp startTime;
  MidiManager midiManager;
  MidiPort midiPort;
  MidiClient midiClient;
  int stop;
  long pp;
  int ntracks;
  Track ** tr;
  Part ** pt;
  int * stp;
  long left;
  long right;
  double interval;
};


void Player::hit(int out, int ch, int freq, int vol) {
  if (output==KMID) {
    if (!playing) {
      playing = true;
      if (devnum>out) {
	devman->setDeviceNumberForChannel(ch, out);
	devman->openDev();
	devman->initDev();
	if (freq!=0) {
	  devman->tmrSetTempo(100);
	  devman->setVolumePercentage(100);
	  // devman->chnPatchChange(ch,0);
	  devman->wait(0);
	  devman->noteOn(ch,freq,vol);
	  devman->sync();
	  devman->wait(200);
	  devman->noteOff(ch,freq,vol);
	  devman->sync();
	  devman->tmrStop();
	}
	devman->closeDev();
      }
      playing = false;
    }
  } else {
    // ARTS: cout << "TODO: Player::hit" << endl;

    ps->playTime = ps->midiPort.time();
    // ps->midiPort.processCommand(MidiCommand(mcsProgram | ch, 0 /*=prg*/, 0));
    Arts::MidiEvent ev;
    ev.time = ps->playTime;
    ev.command = MidiCommand(mcsNoteOn|ch, freq, vol);
    ps->midiPort.processEvent(ev);
    // cout << "start "  << ev.time.sec << ", " << ev.time.usec << endl;
    
    ps->playTime.usec += 60*1000000/_song->tempo(); // 1/4 note
    ps->playTime.sec += ps->playTime.usec / 1000000;
    ps->playTime.usec %= 1000000;
    
    ev.time = ps->playTime;
    ev.command = MidiCommand(mcsNoteOff|ch, freq, 0);
    ps->midiPort.processEvent(ev);
    // cout << "stop "  << ev.time.sec << ", " << ev.time.usec << endl;
  }
}

void Player::quad(int out, int ch, int freq1, int freq2, int freq3, int freq4, int vol) {
  if (output==KMID) {
    if (!playing) {
      playing = true;
      if (devnum>out) {
	devman->setDeviceNumberForChannel(ch, out);
	devman->openDev();
	devman->initDev();
	devman->tmrSetTempo(100);
	devman->setVolumePercentage(100);
	//devman->chnPatchChange(ch,0);
	devman->wait(0);
	if (freq1!=0) devman->noteOn(ch,freq1,vol);
	if (freq2!=0) devman->noteOn(ch,freq2,vol);
	if (freq3!=0) devman->noteOn(ch,freq3,vol);
	if (freq4!=0) devman->noteOn(ch,freq4,vol);
	devman->sync();
	devman->wait(600);
	if (freq1!=0) devman->noteOff(ch,freq1,vol);
	if (freq2!=0) devman->noteOff(ch,freq2,vol);
	if (freq3!=0) devman->noteOff(ch,freq3,vol);
	if (freq4!=0) devman->noteOff(ch,freq4,vol);
	devman->sync();
	devman->tmrStop();
      }
      devman->closeDev();
      playing = false;
    }
  } else {
    // ARTS: cout << "TODO: Player::quad" << endl;
  }
}



// --------------------------------------------------------------------------------------



static float deltaT(TimeStamp a, TimeStamp b)
{
  return ((float)(a.sec - b.sec) + (float)(a.usec - b.usec)/1000000.0);
}


double Player::time() {
  return ((double)(ps->midiPort.time().sec - ps->startTime.sec) + (double)(ps->midiPort.time().usec - ps->startTime.usec)/1000000.0);
}

void Player::initArts() {
    ps = new PlayerState;
    bool veto = false;
    ps->midiManager = Arts::Reference("global:Arts_MidiManager");
    if (ps->midiManager.isNull()) { cout << "midiManager is null" << endl; veto = true; }
    ps->midiClient = ps->midiManager.addClient(mcdPlay, mctApplication, "Brahms", "brahms");
    if (ps->midiClient.isNull()) { cout << "midiClient is null" << endl; veto = true; }
    ps->midiPort = ps->midiClient.addOutputPort();
    if (ps->midiPort.isNull()) { cout << "midiOutputPort is null" << endl; veto = true; }
}

bool Player::playArts(PrProgress * progress, Part * part, long lft, long rgt) {

  ps->ntracks = _song->size();
  
  ps->tr = new (Track*)[ps->ntracks];
  ps->pt = new (Part*)[ps->ntracks];
  ps->stp = new int[ps->ntracks];
  ps->left = lft;
  ps->right = rgt;
  ps->interval = TIMERINTERVALL * 0.001;
  bool veto = false;

  if (part!=0) {
    ps->pt[0] = part;
    // ps->pt[0]->rewind();
    ps->pt[0]->windPlayer(ps->left);
    ps->tr[0] = 0;
    ps->stp[0] = 0;
  } else {
    for (int t=0; t<ps->ntracks; t++) {
      ps->tr[t] = (Track*) _song->get(t);
      ps->pt[t] = (Part*) ps->tr[t]->first();
      if (ps->pt[t]) {
	ps->pt[t]->windPlayer(ps->left);
	ps->stp[t] = 0;
	/*
	if (tr[t]->isA()==SCORETRACK) {
	  if (((ScoreTrack*)tr[t])->output() < devnum)
	  devman->setDeviceNumberForChannel(((ScoreTrack*)tr[t])->channel()],((ScoreTrack*)tr[t])->output());
	  else veto = true;
	}
	if (tr[t]->isA()==DRUMTRACK) {
	  if (((DrumTrack*)tr[t])->output() < devnum)
	  devman->setDeviceNumberForChannel(((DrumTrack*)tr[t])->channel()],((DrumTrack*)tr[t])->output());
	  else veto = true;
	  }*/
      }
    }
  }


  ps->playTime = ps->midiPort.time(); // + xy in order to avoid neglecting the first events...
  // ps->playTime.usec += 5000000;
  ps->playTime.sec += ps->playTime.usec / 1000000;
  ps->startTime = ps->playTime; // remember start time

  if (!veto) {

    for (int t=0; t<ps->ntracks; t++) {
      if (ps->tr[t]!=0) {
	if (ps->tr[t]->isA()==SCORETRACK) ps->midiPort.processCommand(MidiCommand(mcsProgram | ((ScoreTrack*)ps->tr[t])->channel(), ((ScoreTrack*)ps->tr[t])->program(), 0));
      }
    }
    
    /*
      for (int t=0; t<ntracks; t++) {
      if (ps->tr[t]!=0) {
      if (ps->tr[t]->isA()==SCORETRACK) devman->chnPatchChange(((ScoreTrack*)ps->tr[t])->channel(),((ScoreTrack*)ps->tr[t])->program());
      // cout << ((ScoreTrack*)ps->tr[t])->channel() << " -> " << ((ScoreTrack*)ps->tr[t])->program() << endl;
      if (ps->tr[t]->isA()==DRUMTRACK) devman->chnPatchChange(((DrumTrack*)ps->tr[t])->channel(),((DrumTrack*)ps->tr[t])->program());
      }
      }*/



    ps->stop = 0;
    ps->pp = ps->left;

  }
  return true;
}

bool Player::playQuantum() {
  
  TimeStamp midiTime = ps->midiPort.time();
  Arts::MidiEvent ev;
  Note * note;
  ::MidiEvent * mev;
  
  while(deltaT(ps->playTime,midiTime) < ps->interval) //0.300)
    {
      ev.time = ps->playTime;
      // cout << "                      " << ps->pp << endl;
	for (int t=0; t<ps->ntracks; t++) {
	  if (ps->pt[t]) {
	    for (ps->pt[t]->startMem();ps->pt[t]->moreMem();) {
	      if (ps->pt[t]->memEndsAt(ps->pp)) {
		note = (Note*) ps->pt[t]->mem();
		// wait(pp*tempo,left*tempo);
		// devman->noteOff(0,note->pitch(),note->vel());
		ev.command = MidiCommand(mcsNoteOff|((ScoreTrack*)ps->tr[t])->channel(), note->pitch(), note->vel());
		ps->midiPort.processEvent(ev);
		cout << "stop " << note << " at " << ps->pp << endl;
		ps->pt[t]->cutMem();
	      } else {
		ps->pt[t]->incMem();
	      }
	    }
	  }
	}
	for (int t=0; t<ps->ntracks; t++) {
	  if (ps->pt[t]!=0) {
	    while (ps->pt[t]->currentPlayerStartsAt(ps->pp)) {
	      if (ps->pt[t]->currentPlayer(NOTE)) {
		note = (Note*) ps->pt[t]->currentPlayer();
		// wait(pp*tempo,left*tempo);
		// devman->noteOn(0,note->pitch(),note->vel());
		ev.command = MidiCommand(mcsNoteOn|((ScoreTrack*)ps->tr[t])->channel(), note->pitch(), note->vel());
		ps->midiPort.processEvent(ev);
		// cout << "start "  << ev.time.sec << ", " << ev.time.usec << endl;
		cout << "start " << note << " at " << ps->pp << endl;
		ps->pt[t]->rememberCurrentPlayer();
	      } else if (ps->pt[t]->currentPlayer(MIDIEVENT)) {
		mev = (::MidiEvent*) ps->pt[t]->currentPlayer();
		if(mev->code() >= 10 && mev->code() <= 14) {
		  ev.command = MidiCommand((mev->code() << 4) | mev->channel(), mev->value1(), mev->value2());
		  ps->midiPort.processEvent(ev);
		}
	      } else {
		cout << "track " << t << *ps->pt[t]->currentPlayer() << endl;
	      }
	      // if (!ps->pt[t]->currentPlayerInc()) ps->stp[t]++;
	      Part * foo = ps->pt[t]->currentPlayerInc();
	      if (foo!=0) { ps->pt[t] = foo; }
	      else ps->stp[t]++;
	    }
	  }
	}
	ps->stop = 1;
	if ((ps->right!=0) && (ps->pp>=ps->right)) {
	} else {
	  for (int t=0; t<ps->ntracks; t++) { if (ps->stp[t]==0) ps->stop = 0; }
	}
	
	if (ps->stop==1) {
	  ps->stop = 2;
	  for (int t=0; t<ps->ntracks; t++) {
	    ps->pt[t]->startMem();
	    if (ps->pt[t]->moreMem()) ps->stop = 1;
	  }
	}
	ps->pp++;


	ps->playTime.usec += 60*1000000/(384*_song->tempo()); // 60000;   // 60ms
	ps->playTime.sec += ps->playTime.usec / 1000000;
	ps->playTime.usec %= 1000000;
    }
  return (ps->stop!=2);
}



#endif
