/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: selectionFrameAction.cpp,v 1.1 2001/07/25 07:17:45 mkretz Exp $ */

#include "selectionFrameAction.h"

#include <qwhatsthis.h>
#include "selectionFrame.h"

#include <ktoolbar.h>

SelectionFrameAction::SelectionFrameAction( const QString& text, int accel, const QObject *receiver, const char *member, QObject* parent, const char* name )
	: KAction( text, accel, parent, name ),
	m_reciever( receiver ),
	m_member( member )
{
}

SelectionFrameAction::~SelectionFrameAction()
{
}

int SelectionFrameAction::plug( QWidget *w, int index )
{
	if( !w->inherits( "KToolBar" ) )
		return -1;

	KToolBar *toolBar = (KToolBar *)w;
	
	int id = KAction::getToolButtonID();

	SelectionFrame *selectionframe = new SelectionFrame( toolBar, "ToolBar Label" );
	selectionframe->setFixedWidth( 72 );
	selectionframe->setBackgroundMode( QWidget::PaletteBackground );
	toolBar->insertWidget( id, 72, selectionframe, index );

	addContainer( toolBar, id );

	connect( toolBar, SIGNAL( destroyed() ), this, SLOT( slotDestroyed() ) );

	toolBar->setItemAutoSized( id, true );

	m_selectionframe = selectionframe;

	emit plugged();

	QWhatsThis::add( selectionframe, whatsThis() );

	return containerCount() - 1;
}

void SelectionFrameAction::unplug( QWidget *w )
{
	if ( !w->inherits( "KToolBar" ) )
		return;

	KToolBar *toolBar = (KToolBar *)w;

	int idx = findContainer( w );

	toolBar->removeItem( menuId( idx ) );

	removeContainer( idx );
	m_selectionframe = 0L;
}

#include "selectionFrameAction.moc"

// vim:tw=4:sw=4
