#!/bin/sh

# usage (local mode): mini-iso.sh <flavour>
# usage (fetch mode): mini-iso.sh <flavour> <FTP mirror> [yes|no]

# Goal: get boot floppies from the nearest FTP mirror, prepare them for the CD
# and create a netinst iso
# If an FTP mirrir is specified, the boot-floppy images will be downloaded from
# it first. FTP mirror string has the normal format, like
# http://ftp.at.debian.org/debian

# "yes" forces download of basedebs.tar. If omited, script will look for
# ./basedebs.tar and use it, if available. "no" tell not to use basedebs.tar.
# 
# Requirements: wget, mkisofs, CD-RW recorder

flavour=$1
suite=woody
arch=i386
wget="wget --non-verbose"

test -f common.sh && . ./common.sh

tmpdir=${tmpdir:-$HOME/.tmp}

mkdir -p $tmpdir 2>/dev/null || true

if [ "$2" ] ; then
   path=$2/dists/$suite/main/disks-$arch/current
   if [ -e resc2880${flavour}.bin ] ; then
      echo resc2880${flavour}.bin found, not downloading.
   else
      echo Downloading the boot image...
      $wget -O resc2880${flavour}.bin $path/images-2.88/$flavour/rescue.bin
   fi
   if [ -e drivers${flavour}.tgz ] ; then
      echo drivers${flavour}.tgz found, not downloading.
   else
      $wget -O drivers${flavour}.tgz $path/$flavour/drivers.tgz
   fi
   if [ -e xlp.tgz ] ; then
      echo xlp.tgz found, not downloading.
   else
      echo "Downloading language pack..."
      $wget $path/xlp.tgz
   fi
   if [ "$3" = "yes" -a ! -e basedebs.tar ] ; then
      $wget $path/../base-images-current/basedebs.tar || rm basedebs.tar
   fi
fi

# Base check

if test -e resc2880${flavour}.bin -a -e drivers${flavour}.tgz -a -e xlp.tgz ; then
   true
else
   echo Required files missing, aborting!
   cat $0 | head -n 15 | tail -n 13
   exit 1
fi

# CD mastering

CD=${tmpdir}/minicd-$$

BF=${CD}/dists/${suite}/main/disks-${arch}/current

mkdir -p ${CD}/boot
mkdir -p ${BF}/${flavour}
mkdir -p ${BF}/images-1.44/${flavour}

cp resc2880${flavour}.bin ${CD}/boot/rescue.bin
cp drivers${flavour}.tgz ${BF}/${flavour}/drivers.tgz

mkdir -p ${CD}/.disk
touch ${CD}/.disk/kernel_installable
touch ${CD}/.disk/info

if [ -e basedebs.tar -a "$3" != "no" ] ; then
   echo Found basedebs.tar, installing it...
   cp basedebs.tar $CD
   touch ${CD}/.disk/base_installable
fi

if [ "x${flavour}" != "x" ]; then
  ln -s ../../../../../../../boot/rescue.bin ${BF}/images-1.44/${flavour}/rescue.bin
else
  ln -s ../../../../../../boot/rescue.bin ${BF}/images-1.44/rescue.bin
fi

touch ${CD}/dists/${suite}/Release

if [ -f xlp.tgz ]; then
  mkdir -p ${CD}/.xlp
  gzip -dc xlp.tgz | ( cd ${CD}/.xlp; tar xf - )
fi

( cd ${CD}; mkisofs -R -b boot/rescue.bin -o ${CD}.iso . )

mv ${CD}.iso boot${flavour}.iso
rm -rf ${CD}
