
const XBEL_PUBLIC_ID="+//IDN python.org//DTD XML Bookmark Exchange Language 1.0//EN//XML";

var LOSE_BOOKMARKS_TOOLBAR="losetoolbarfolder";

var XBELToBookmarksService=
{
	RDFService	:	null,
	DataSource	:	null,
	Container	:	null,
	urlArc:null,

	/* Preferences */
	checkPublicID:true,
	merge:false,
	targetFolder:"NC:BookmarksRoot",
	xbelString:"",
	xbelDocument:"",

	icons:null,
	BookmarksToolbarFolder:null,
	XBELToolbarFolder:null,

	init:function(aFolderID,aXBELString,aMerge,aCheckPublicID)
	{
		this.checkPublicID=aCheckPublicID;
		this.merge=aMerge;
		this.targetFolder=aFolderID;
		this.xbelString=aXBELString;

		this.icons=[];
		this.BookmarksToolbarFolder=null;
		this.XBELToolbarFolder=null;
	},

	_initInternal:function()
	{
		this.RDFService = Components.classes["@mozilla.org/rdf/rdf-service;1"]
											.getService(Components.interfaces.nsIRDFService);
		this.Container = Components.classes["@mozilla.org/rdf/container;1"]
										.getService(Components.interfaces.nsIRDFContainer);
		this.DataSource=this.RDFService.GetDataSource( "rdf:bookmarks" );
		this.DataSource.QueryInterface(Components.interfaces.nsIBookmarksService);
		this.RDFCUtils = Components.classes['@mozilla.org/rdf/container-utils;1']
						.getService(Components.interfaces.nsIRDFContainerUtils);
		this.Container.Init(this.DataSource,this.RDFService.GetResource("NC:BookmarksRoot"));

		this.urlArc=this.RDFService.GetResource( "http://home.netscape.com/NC-rdf#URL");
		this.nameArc=this.RDFService.GetResource( "http://home.netscape.com/NC-rdf#Name");
		this.descArc=this.RDFService.GetResource("http://home.netscape.com/NC-rdf#Description");
		this.typeArc=this.RDFService.GetResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
		this.folderValue=this.RDFService.GetResource("http://home.netscape.com/NC-rdf#Folder");
	},


	rebuild:function()
	{
		var rv=null;
		this._initInternal();
		try{
			var target= this.RDFService.GetResource(this.targetFolder);
			if(!this.RDFCUtils.IsContainer(this.DataSource,target))
				return false;
			rv=this._strToDocument();
			if(rv) return rv;
			this.XBELToolbarFolder=this.getBookmarksToolbarFolder(this.xbelDocument);
			if(	!this.XBELToolbarFolder && 
				this.isToolbarFolderIn(this.targetFolder) && 
				!confirm(LOSE_BOOKMARKS_TOOLBAR))
				return "usercancel";
		}catch(e) {alert(e); return "error";}

		this.DataSource.beginUpdateBatch();
		this.killBookmarks();
		try
		{
			if(this.merge)
				this.mergeFolderContents(this.xbelDocument.documentElement,target);
			else
			{
				this.deleteFolderContents(target);
				this.buildFolderContents(this.xbelDocument.documentElement,target);
			}
			this.setBookmarksToolbarFolder();
			this.DataSource.transactionManager.clear();
		}
		catch(e)
		{
			this.reliveBookmarks();
			this.DataSource.endUpdateBatch();
			if(e) alert(e);
			return "error";
		}

		this.reliveBookmarks();
		this.DataSource.endUpdateBatch();

		while(this.icons.length>0)
		{
			var icon=this.icons.shift();
			this.DataSource.updateBookmarkIcon(icon[0], icon[1]);
		}
		return null;
	},

	mergeFolderContents:function(node,target)
	{
		var foldersets=[[node,target]];
		var folderset=null;

		while(foldersets.length > 0)
		{
			folderset=foldersets.shift();
			var childNodes=folderset[0].childNodes;
			var resource= folderset[1];
			var title="";
			var href="";
			var desc="";
			var keyword="";
			var id="";
			var icon="";

			if(this.RDFCUtils.IsContainer(this.DataSource,resource))
				this.Container.Init(this.DataSource, resource);
			else
				this.Container=this.RDFCUtils.MakeSeq(this.DataSource,resource);

			for(var i =0; i< childNodes.length; i++)
			{
				var element=childNodes[i];
				if(element.nodeType==1)
				{
					id=this.getProp(element,"id");
					if(!id) id="urn:anonymous";
					var oldResource=this.RDFService.GetResource(id);
					var oldDataExists= (this.Container.IndexOf(oldResource) > -1)

					switch(element.localName.toUpperCase())
					{
						case "BOOKMARK":
							title=this.getTitle(element);
							href=this.getProp(element,"href");
							desc=this.getDesc(element);
							keyword=this.getMetaInfo(element,keyword_NS);
							icon=this.getMetaInfo(element,icon_NS);

							if( oldDataExists ){
								this.changeBookmark(oldResource,title,href,keyword,desc);
							}
							else
							{
								var bookmark=this.getBookmarkByName(title);
								if(bookmark)
									this.changeBookmark(oldResource,title,href,keyword,desc);
								else
									this.createBookmark(id,title,href,keyword,desc,resource);
							}

							if(href && icon) this.icons.push([href,icon]);

							break;
						case "FOLDER":
							title=this.getTitle(element);
							desc=this.getDesc(element);
							var folder=null;
							if( oldDataExists )
								folder=oldResource;
							else
							{
								folder=this.getFolderByName(title);
								if(!folder)
								{
									folder=this.createFolder(id,title,desc,resource);
//									folder=this.DataSource.createFolderInContainer ( title , resource , 0 );
								}
							}

							this.changeFolder(folder,title,desc);
							foldersets.push([element,folder]);

							if(this.XBELToolbarFolder && id == this.XBELToolbarFolder)
								this.BookmarksToolbarFolder=folder;
							break;
						case "SEPARATOR":
							//if( ! oldDataExists )
							//	this.createSeparator(resource);
							break;
						default :
							break;
					}
				}
			}
		}
	},

	getBookmarkByName:function(aName)
	{
		var elements=this.Container.GetElements();
		
		while(elements.hasMoreElements())
		{
			var element=elements.getNext();
			element.QueryInterface(Components.interfaces.nsIRDFResource);
			if(this.DataSource.hasArcOut(element,this.urlArc))
			{
				var target=this.DataSource.GetTarget(element,this.nameArc,true);
				if(target && target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value == aName)
					return element;
			}
		}
		return null;
	},

	getFolderByName:function(aName)
	{
		var elements=this.Container.GetElements();
		while(elements.hasMoreElements())
		{
			var element=elements.getNext();
			element.QueryInterface(Components.interfaces.nsIRDFResource);
			if(this.RDFCUtils.IsContainer(this.DataSource,element))
			{
				var target=this.DataSource.GetTarget(element,this.nameArc,true);
				if(target && target.QueryInterface(Components.interfaces.nsIRDFLiteral).Value == aName)
					return element;
			}
		}
		return null;
	},

	getBookmarksToolbarFolder:function(targetDocument)
	{
		var metadata=targetDocument.getElementsByTagName("metadata");
		for(var i=0; i<metadata.length;i++)
		{
			var owner=metadata[i].getAttribute("owner");
			if(owner==toolbar_NS)
			{
				return this.getText(metadata[i]);
			}
		}
		return null;
	},

	isToolbarFolderIn:function( uri )
	{
		var personalArc=this.RDFService.GetResource("http://home.netscape.com/NC-rdf#BookmarksToolbarFolder");
		var trueVal=this.RDFService.GetLiteral("true");
		var BTF=this.DataSource.GetSource(personalArc,trueVal,true);
		if(!BTF) return false;
		var root=this.RDFService.GetResource(uri);
		
		return this.isBookmarkedResource(BTF,root);
	},
	
	setBookmarksToolbarFolder:function()
	{
		if(this.BookmarksToolbarFolder)
			this.DataSource.setBookmarksToolbarFolder(this.BookmarksToolbarFolder);
	},

	isBookmarkedResource:function(aResource,aRoot)
	{
		if(!aResource) return false;
		try{
			aResource.QueryInterface(Components.interfaces.nsIRDFResource);
			aRoot.QueryInterface(Components.interfaces.nsIRDFResource);

		}catch(e){return false;}

		var folders=[aRoot];
		var uri=aResource.Value;
		while(folders.length>0)
		{
			var folder=folders.shift();
			this.Container.Init(this.DataSource, folder);
			var elements=this.Container.GetElements();
			while(elements.hasMoreElements())
			{
				var element=elements.getNext();
				element.QueryInterface(Components.interfaces.nsIRDFResource);
				if(element.EqualsString ( uri ))
					return true;
				else if(this.RDFCUtils.IsContainer(this.DataSource,element))
					folders.push(element);
			}
			
		}
		return false;
	},

	buildFolderContents:function(node,target)
	{
		var foldersets=[[node,target]];
		var folderset=null;

		while(foldersets.length > 0)
		{
			folderset=foldersets.shift();
			var childNodes=folderset[0].childNodes;
			var resource= folderset[1];
			var title="";
			var href="";
			var desc="";
			var keyword="";
			var id="";
			for(var i =0; i< childNodes.length; i++)
			{
				var element=childNodes[i];
				if(element.nodeType==1)
				{
					id=this.getProp(element,"id");
					switch(element.localName.toUpperCase())
					{
						case "BOOKMARK":
							title=this.getTitle(element);
							href=this.getProp(element,"href");
							desc=this.getDesc(element);
							keyword=this.getMetaInfo(element,keyword_NS);
							icon=this.getMetaInfo(element,icon_NS);
							this.DataSource.createBookmarkInContainer(title,href,keyword,desc,"",null,resource,0);
							if(href && icon) this.icons.push([href,icon]);
							break;
						case "FOLDER":
							title=this.getTitle(element);
							var newresource=this.DataSource.createFolderInContainer(title,resource,0);
							foldersets.push([element,newresource]);
							if(this.XBELToolbarFolder && id==this.XBELToolbarFolder)
								this.BookmarksToolbarFolder=newresource;
							break;
						case "SEPARATOR":
							this.createSeparator(resource);
							break;
					}
				}
			}
		}
	},

	deleteFolderContents:function(target)
	{

		var folders=[target];
		while(folders.length>0)
		{
			var folder= folders.shift();
			folder.QueryInterface(Components.interfaces.nsIRDFResource);
			this.Container.Init(this.DataSource, folder);
			var elements=this.Container.GetElements();
			while(elements.hasMoreElements())
			{
				var temptarget=elements.getNext();
				this.Container.RemoveElement(temptarget,false);
				if(this.RDFCUtils.IsContainer(this.DataSource,temptarget))
					folders.push(temptarget);
				else this.Unassert(this.DataSource,temptarget);
			}
			if(folder.Value!=target.Value) 
					this.Unassert(this.DataSource,folder);
		}
	},

	getProp: function (element,prop)
	{
		return element.getAttribute(prop).replace(/\%3A/g,":");
	},

	getTitle: function (element)
	{
		try{
			var tagName=element.tagName.toUpperCase();
			if(	tagName !="FOLDER" && tagName !="BOOKMARK" &&tagName !="XBEL")
				throw "Error : Unexpected Error\n";
			var titles=element.getElementsByTagName("title");
			
			if(titles.length>0)
				return this.getText(titles[0]);
		}catch(e){if(e) alert(e);}
		return "No Title";
	},

	getDesc: function (element)
	{
		var str="";
		try{
			var tagName=element.tagName.toUpperCase();
			if(	tagName !="FOLDER" && tagName !="BOOKMARK" &&tagName !="XBEL")
				throw "Error : Unexpected Error\n";
			var descs=element.getElementsByTagName("desc");
			if(descs.length>0)
				str=this.getText(descs[0]);
		}catch(e){if(e) alert(e);}
		return str;
	},

	getMetaInfo: function (aElement,aOwner)
	{
		try{
			var tagName=aElement.tagName.toUpperCase();
			if(	tagName !="FOLDER" && tagName !="BOOKMARK" &&tagName !="XBEL")
				throw "Error : Unexpected Error\n";
			var infos=aElement.getElementsByTagName("info");
			if(infos.length< 1) return "";
			var metadata=infos[0].getElementsByTagName("metadata");
			for( var i=0; i<metadata.length;i++)
			{
				if(aOwner==this.getProp(metadata[i],"owner"))
					return this.getText(metadata[i]);
			}
		}catch(e){alert(e);}
		return "";
	},

	getText: function (element)
	{
		var str="";
		try{
			var textnodes=element.childNodes;
			for(var i=0; i<textnodes.length ; i++)
			{
				var textnode=textnodes[0];
				if(textnode.nodeType!=1)
					str += textnode.nodeValue;
			}
		}catch(e){alert(e);}
		return str;
	},

	changeBookmark: function (bookmark,name,url,keyword,desc)
	{
		this.Unassert(this.DataSource,bookmark);

		var keywordArc= this.RDFService.GetResource("http://home.netscape.com/NC-rdf#ShortcutURL");
		var dateArc= this.RDFService.GetResource("http://home.netscape.com/NC-rdf#BookmarkAddDate");

		var nameTarget= this.RDFService.GetLiteral(name);
		var urlTarget= this.RDFService.GetLiteral(url);
		var keywordTarget=this.RDFService.GetLiteral(keyword);
		var descTarget=this.RDFService.GetLiteral(desc);
		var dateTarget=this.RDFService.GetDateLiteral(this.getDate());

		this.DataSource.Assert(bookmark,this.nameArc,nameTarget,true);
		this.DataSource.Assert(bookmark,this.urlArc,urlTarget,true);
		this.DataSource.Assert(bookmark,keywordArc,keywordTarget,true);
		this.DataSource.Assert(bookmark,this.descArc,descTarget,true);
		this.DataSource.Assert(bookmark,dateArc,dateTarget,true);
	},

	changeFolder: function (folder,name,desc)
	{
		this.resetFolder(folder);

		var nameTarget= this.RDFService.GetLiteral(name);
		var descTarget=this.RDFService.GetLiteral(desc);

		this.DataSource.Assert(folder,this.nameArc,nameTarget,true);
		this.DataSource.Assert(folder,this.descArc,descTarget,true);
	},

	resetFolder: function (node)
	{
		var props=this.DataSource.ArcLabelsOut(node);
		while(props.hasMoreElements())
		{
 			var prop=props.getNext();
			prop.QueryInterface(Components.interfaces.nsIRDFResource);
			if(prop.Value.match(/Name|Description/))
			{
				var target=this.DataSource.GetTarget(node,prop,true);
				this.DataSource.Unassert(node,prop,target);
			}
		}
	},

	createBookmark: function (id,name,url,keyword,desc)
	{
		var keywordArc= this.RDFService.GetResource("http://home.netscape.com/NC-rdf#ShortcutURL");
		var dateArc= this.RDFService.GetResource("http://home.netscape.com/NC-rdf#BookmarkAddDate");

		var nameTarget= this.RDFService.GetLiteral(name);
		var urlTarget= this.RDFService.GetLiteral(url);
		var keywordTarget=this.RDFService.GetLiteral(keyword);
		var descTarget=this.RDFService.GetLiteral(desc);
		var dateTarget=this.RDFService.GetDateLiteral(this.getDate());

		//bookmark is a brand new resource.
		var bookmark=null;

		if(id) 
		{
			bookmark=this.RDFService.GetResource(id);
			if(this.DataSource.isBookmarkedResource(bookmark))
				bookmark=this.RDFService.GetAnonymousResource();
		}
		else	bookmark=this.RDFService.GetAnonymousResource();

		//Write New Data
		this.Container.AppendElement(bookmark);
		this.DataSource.Assert(bookmark,this.nameArc,nameTarget,true);
		this.DataSource.Assert(bookmark,this.urlArc,urlTarget,true);
		this.DataSource.Assert(bookmark,keywordArc,keywordTarget,true);
		this.DataSource.Assert(bookmark,this.descArc,descTarget,true);
		this.DataSource.Assert(bookmark,dateArc,dateTarget,true);
	},

	createFolder: function (id,name,desc,parent)
	{
	  var folder = this.DataSource.createFolderInContainer ( name , parent , 0 );
		if(desc)
		{
			var descTarget=this.RDFService.GetLiteral(desc);
			this.DataSource.Assert(folder,this.descArc,descTarget,true);
		}
		return folder;
	},

	createSeparator: function (parent)
	{
		var sep=this.DataSource.createSeparator();

		if(!parent) parent=this.RDFService.GetResource("NC:BookmarksRoot");
		//Init Container with Parent Folder
		if( ! parent.EqualsString ( this.Container.Resource.Value ) )
			this.Container.Init(this.DataSource,parent);
		this.Container.AppendElement(sep);
	},

	getDate: function ()
	{
		var date= ((new Date()).getTime())*1000;
		date=parseInt(date).toString();
		return date;
	},

// RDF wrapping functions
	Assert: function (ds,resource,arc,target)
	{
		var oldtarget=ds.GetTarget(resource,arc,true);
		if(oldtarget) ds.Change(resource,arc,oldtarget,target);
		else ds.Assert(resource,arc,target,true);
	},

	Unassert: function (ds,node)
	{
		var props=ds.ArcLabelsOut(node);
		while(props.hasMoreElements())
		{
 			var prop=props.getNext();
			var target=ds.GetTarget(node,prop,true);
			ds.Unassert(node,prop,target);
		}
	},

	killBookmarks:function()
	{
		var nsIWindowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1']
									.getService(Components.interfaces.nsIWindowMediator);
		var browserWindows=nsIWindowMediator.getZOrderDOMWindowEnumerator('navigator:browser',true);
		while(browserWindows.hasMoreElements())
		{
			try{
				var browserWindow=browserWindows.getNext();
				browserWindow.QueryInterface(Components.interfaces.nsIDOMWindowInternal);
				browserWindow.bookmarksftpService.unregObserver();
			}catch(e){alert(e)}
		}
	},

	reliveBookmarks:function()
	{
		var nsIWindowMediator = Components.classes['@mozilla.org/appshell/window-mediator;1']
									.getService(Components.interfaces.nsIWindowMediator);
		var browserWindows=nsIWindowMediator.getZOrderDOMWindowEnumerator('navigator:browser',true);
		while(browserWindows.hasMoreElements())
		{
			try{
				var browserWindow=browserWindows.getNext();
				browserWindow.QueryInterface(Components.interfaces.nsIDOMWindowInternal);
				browserWindow.bookmarksftpService.regObserver();
			}catch(e){alert(e)}
		}
	},

};
