/***************************************************************************
                          dlgaddbrowser.cpp  -  description
                             -------------------
    begin                : Sat Nov 16 2002
    copyright            : (C) 2002 by Ken Schenke
    email                : kschenke at users dot sourceforge dot net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the Free Software           *
 *   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA         *
 *   02110-1301, USA                                                       *
 *                                                                         *
 ***************************************************************************/

#include "dlgaddbrowser.h"
#include "browserlist.h"

#include <vector>

#include <QListWidget>

using namespace std;

/***************************************************************************
 *                                                                         *
 *   The BrowserAddItem class (derived from QTreeWidgetItem) represents an *
 *   item in the TreeWidget used in this dialog.  Really it is only used   *
 *   to store the ordinal representing the browser.                        *
 *                                                                         *
 ***************************************************************************/
 
class BrowserAddItem : public QTreeWidgetItem
{
public:
	BrowserAddItem(QTreeWidget *parent) : QTreeWidgetItem(parent) { };

	BRWSNUM ordinal;
};

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::DlgAddBrowser()                                        *
 *                                                                         *
 *   Parameters:                                                           *
 *      const vector<BrowserCfg> browsers                                  *
 *      QWidget *parent                                                    *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class constructor.  The first parameter contains a vector of the   *
 *      the browsers to display.                                           *
 *                                                                         *
 ***************************************************************************/

DlgAddBrowser::DlgAddBrowser(const std::vector<BrowserCfg> &browsers,
							 QWidget* parent)
	: QDialog(parent), m_browsers(browsers)
{
	QStringList headers;

	setupUi(this);

	headers << "Browser" << "Description";
	listBrowsers->setHeaderLabels(headers);

	ordinal = 0;
	refreshList();
	refreshButtons();
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::~DlgAddBrowser()                                       *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      Class destructor                                                   *
 *                                                                         *
 ***************************************************************************/

DlgAddBrowser::~DlgAddBrowser()
{
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::refreshButtons()                                       *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called whenever the state of the dialog box       *
 *      changes, i.e. the user clicks on a browser.  All it does is enable *
 *      disable the Add button.                                            *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::refreshButtons(void)
{
	QList<QTreeWidgetItem *> items = listBrowsers->selectedItems();

	buttonAdd->setEnabled(items.count() > 0);
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::refreshList()                                          *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function is called to populate the browser list.              *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::refreshList(void)
{
	vector<BrowserCfg>::const_iterator it;

	listBrowsers->clear();

	for(it=m_browsers.begin(); it!=m_browsers.end(); ++it)
	{
		BrowserAddItem *item = new BrowserAddItem(listBrowsers);
		item->setText(0, it->browser());
		item->setText(1, it->Descrip());
		item->ordinal = it->ordinal();
	}
}

/***************************************************************************
 *                                                                         *
 *   DlgAddBrowser::on_listBrowsers_itemSelectionChanged()                 *
 *                                                                         *
 *   Parameters:                                                           *
 *      None                                                               *
 *   Return:                                                               *
 *      None                                                               *
 *   Description:                                                          *
 *      This function (really a slot) is called to by the Qt framework     *
 *      the user selects (or deselects) an item in the browsers list.  The *
 *      selected item is passed as pItem or NULL if not item is selected.  *
 *                                                                         *
 ***************************************************************************/

void DlgAddBrowser::on_listBrowsers_itemSelectionChanged()
{
	// Enable or disable the Add button
	
	refreshButtons();

	BrowserAddItem *item;

	QList<QTreeWidgetItem *> items = listBrowsers->selectedItems();
	if(items.count() != 1)
		item = NULL;
	else
		item = static_cast<BrowserAddItem *>(items[0]);

	// If no item was selected, clear the current ordinal and return
	
	if(item == NULL)
	{
		ordinal = 0;
		return;
	}

	// Store the ordinal of the currently selected item
	
	ordinal = item->ordinal;
}
