/* $Id: datastore_db_private.h,v 1.15 2005/04/04 11:48:49 relson Exp $ */

/*****************************************************************************

NAME:

datastore_db_private.h - provide OO interface for datastore methods;
		       	 used for Berkeley DB transactional &
		       	 non-transactional support.

AUTHOR:
David Relson	<relson@osagesoftware.com> 2005

******************************************************************************/

#ifndef DATASTORE_DB_PRIVATE_H
#define DATASTORE_DB_PRIVATE_H

#define MAGIC_DBE 0xdbe
#define MAGIC_DBH 0xdb4

/** implementation internal type to keep track of databases
 * we have opened. */

#ifndef	ENABLE_SQLITE_DATASTORE
typedef struct {
    int		magic;
    char	*path;
    char	*name;
    int		fd;		/* file descriptor of data base file */
    dbmode_t	open_mode;	/* datastore open mode, DS_READ/DS_WRITE */
#ifdef	ENABLE_DB_DATASTORE	/* if Berkeley DB */
    DB		*dbp;		/* data base handle */
#endif
    bool	locked;
    bool	is_swapped;	/* set if CPU and data base endianness differ */
    bool	created;	/* if newly created; for datastore.c (to add .WORDLIST_VERSION) */
    dbe_t	*dbenv;		/* "parent" environment */
#ifdef	ENABLE_DB_DATASTORE	/* if Berkeley DB */
    DB_TXN	*txn;		/* transaction in progress or NULL */
#endif
    /** OO database methods */
    dsm_t	*dsm;
} dbh_t;
#endif

#define DBT_init(dbt)		(memset(&dbt, 0, sizeof(DBT)))

typedef	enum {
    P_ERROR = -1,	/* -1 for error */
    P_DISABLE = 0,	/*  0 for no transactions - 0 must mean P_DISABLE
			    for compatibility with dummy functions */
    P_ENABLE  = 1,	/*  1 for transactions */
    P_DONT_KNOW		/*  2 for don't know */
} probe_txn_t;

probe_txn_t probe_txn(bfpath *bfp);

#endif
