/* types.c -- types required to be certain sizes
 * Written by Charles Briscoe-Smith; refer to the file LEGAL for details.
 */

/* My appologies to readers for the huge amount of cruft in this file.
   I originally wrote it as part of a program to read and print .class
   files, and I don't have the will-power to do what needs doing and
   throw most of it away...  */

/* References are from "The Java Virtual Machine Specification",
   describing version 1.0.2 of the JVM.  */

/* Forward references */

typedef struct class_file_ class_file;
typedef struct member_info_ member_info;
typedef struct attr_info_ attr_info;
typedef union cp_info_ cp_info;

/* S4: types used in reading the class file */

typedef unsigned          char u1;
typedef unsigned     short int u2;
typedef unsigned      long int u4;
typedef unsigned long long int u8;

typedef   signed          char s1;
typedef   signed     short int s2;
typedef   signed      long int s4;
typedef   signed long long int s8;

/* S4.4.4/4.4.5: bit patterns for special float and double values */

typedef union { float f; u4 u; } u4f;
typedef union { double d; u8 u; } u8d;

#define u4float_pinf (0x7f800000UL)
#define u4float_ninf (0xff800000UL)
#define u4float_pnanmin (0x7f800001UL)
#define u4float_pnanmax (0x7fffffffUL)
#define u4float_nnanmin (0xff800001UL)
#define u4float_nnanmax (0xffffffffUL)
#define u4float_pzero (0x00000000UL)
#define u4float_nzero (0x80000000UL)
#define u8double_pinf (0x7ff0000000000000ULL)
#define u8double_ninf (0xfff0000000000000ULL)
#define u8double_pnanmin (0x7ff0000000000001ULL)
#define u8double_pnanmax (0x7fffffffffffffffULL)
#define u8double_nnanmin (0xfff0000000000001ULL)
#define u8double_nnanmax (0xffffffffffffffffULL)
#define u8double_pzero (0x0000000000000000ULL)
#define u8double_nzero (0x8000000000000000ULL)

/* S4.1: The class file */

struct class_file_ {
	u2 minor_version;
	u2 major_version;
	u2 const_count;
	cp_info *cp;
	u2 access;
	u2 this;
	u2 super;
	u2 iface_count;
	u2 *ifaces;
	u2 field_count;
	member_info *fields;
	u2 meth_count;
	member_info *meths;
	u2 attr_count;
	attr_info *attrs;
};

#define MAJOR_VERSION 45
#define MAX_MINOR_VERSION 3

/* S4.4: constant pool */

union cp_info_ {
	u2 u2;
	struct {
		u2 i1, i2;
	} u2x2;
	u4 u4;
	u1 *utf8;
};

#define CONSTANT_Utf8			1	/* u2x1 + utf8 */
#define CONSTANT_Integer		3	/* u4x1 */
#define CONSTANT_Float			4	/* u4x1 */
#define CONSTANT_Long			5	/* u4x2 */
#define CONSTANT_Double			6	/* u4x2 */
#define CONSTANT_Class			7	/* u2x1 */
#define CONSTANT_String			8	/* u2x1 */
#define CONSTANT_Fieldref		9	/* u2x2 */
#define CONSTANT_Methodref		10	/* u2x2 */
#define CONSTANT_InterfaceMethodref	11	/* u2x2 */
#define CONSTANT_NameAndType		12	/* u2x2 */

/* S4.1/4.5/4.6: access flags */

#define ACC_public		(0x0001)
#define ACC_private		(0x0002)
#define ACC_protected		(0x0004)
#define ACC_static		(0x0008)
#define ACC_final		(0x0010)
#define ACC_super		(0x0020)	/* in a class */
#define ACC_synchronized	(0x0020)	/* in a method */
#define ACC_volatile		(0x0040)
#define ACC_transient		(0x0080)
#define ACC_native		(0x0100)
#define ACC_interface		(0x0200)
#define ACC_abstract		(0x0400)

/* S4.5/4.6: fields/methods */

struct member_info_ {
	u2 access;
	u2 name;
	u2 descr;
	u2 attr_count;
	attr_info *attrs;
};

