/////////////////////////////////////////////////////////////////////////
// $Id: ia_opcodes.h,v 1.48 2010/04/18 09:21:24 sshwarts Exp $
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2008-2010 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA B 02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

bx_define_opcode(BX_IA_ERROR, &BX_CPU_C::BxError, NULL, 0)

bx_define_opcode(BX_IA_AAA, &BX_CPU_C::AAA, NULL, 0)
bx_define_opcode(BX_IA_AAD, &BX_CPU_C::AAD, NULL, 0)
bx_define_opcode(BX_IA_AAM, &BX_CPU_C::AAM, NULL, 0)
bx_define_opcode(BX_IA_AAS, &BX_CPU_C::AAS, NULL, 0)
bx_define_opcode(BX_IA_DAA, &BX_CPU_C::DAA, NULL, 0)
bx_define_opcode(BX_IA_DAS, &BX_CPU_C::DAS, NULL, 0)
bx_define_opcode(BX_IA_ADC_ALIb, &BX_CPU_C::ADC_ALIb, NULL, 0)
bx_define_opcode(BX_IA_ADC_AXIw, &BX_CPU_C::ADC_AXIw, NULL, 0)
bx_define_opcode(BX_IA_ADC_EAXId, &BX_CPU_C::ADC_EAXId, NULL, 0)
bx_define_opcode(BX_IA_ADC_EbGbM, &BX_CPU_C::ADC_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EbIbM, &BX_CPU_C::ADC_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EbIbR, &BX_CPU_C::ADC_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_ADC_EdGdM, &BX_CPU_C::ADC_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EdIdM, &BX_CPU_C::ADC_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EdIdR, &BX_CPU_C::ADC_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_ADC_EwGwM, &BX_CPU_C::ADC_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EwIwM, &BX_CPU_C::ADC_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_ADC_EwIwR, &BX_CPU_C::ADC_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_ADC_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADC_GbEbR, 0)
bx_define_opcode(BX_IA_ADC_GbEbR, &BX_CPU_C::ADC_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_ADC_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADC_GdEdR, 0)
bx_define_opcode(BX_IA_ADC_GdEdR, &BX_CPU_C::ADC_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_ADC_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADC_GwEwR, 0)
bx_define_opcode(BX_IA_ADC_GwEwR, &BX_CPU_C::ADC_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_ADD_ALIb, &BX_CPU_C::ADD_ALIb, NULL, 0)
bx_define_opcode(BX_IA_ADD_AXIw, &BX_CPU_C::ADD_AXIw, NULL, 0)
bx_define_opcode(BX_IA_ADD_EAXId, &BX_CPU_C::ADD_EAXId, NULL, 0)
bx_define_opcode(BX_IA_ADD_EbGbM, &BX_CPU_C::ADD_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EbIbM, &BX_CPU_C::ADD_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EbIbR, &BX_CPU_C::ADD_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_ADD_EdGdM, &BX_CPU_C::ADD_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EdIdM, &BX_CPU_C::ADD_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EdIdR, &BX_CPU_C::ADD_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_ADD_EwGwM, &BX_CPU_C::ADD_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EwIwM, &BX_CPU_C::ADD_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_ADD_EwIwR, &BX_CPU_C::ADD_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_ADD_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::ADD_GbEbR, 0)
bx_define_opcode(BX_IA_ADD_GbEbR, &BX_CPU_C::ADD_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_ADD_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::ADD_GdEdR, 0)
bx_define_opcode(BX_IA_ADD_GdEdR, &BX_CPU_C::ADD_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_ADD_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::ADD_GwEwR, 0)
bx_define_opcode(BX_IA_ADD_GwEwR, &BX_CPU_C::ADD_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_AND_ALIb, &BX_CPU_C::AND_ALIb, NULL, 0)
bx_define_opcode(BX_IA_AND_AXIw, &BX_CPU_C::AND_AXIw, NULL, 0)
bx_define_opcode(BX_IA_AND_EAXId, &BX_CPU_C::AND_EAXId, NULL, 0)
bx_define_opcode(BX_IA_AND_EbGbM, &BX_CPU_C::AND_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_AND_EbIbM, &BX_CPU_C::AND_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_AND_EbIbR, &BX_CPU_C::AND_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_AND_EdGdM, &BX_CPU_C::AND_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_AND_EdIdM, &BX_CPU_C::AND_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_AND_EdIdR, &BX_CPU_C::AND_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_AND_EwGwM, &BX_CPU_C::AND_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_AND_EwIwM, &BX_CPU_C::AND_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_AND_EwIwR, &BX_CPU_C::AND_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_AND_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::AND_GbEbR, 0)
bx_define_opcode(BX_IA_AND_GbEbR, &BX_CPU_C::AND_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_AND_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::AND_GdEdR, 0)
bx_define_opcode(BX_IA_AND_GdEdR, &BX_CPU_C::AND_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_AND_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::AND_GwEwR, 0)
bx_define_opcode(BX_IA_AND_GwEwR, &BX_CPU_C::AND_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_ARPL_EwGw, &BX_CPU_C::ARPL_EwGw, NULL, 0)
bx_define_opcode(BX_IA_BOUND_GdMa, &BX_CPU_C::BOUND_GdMa, NULL, 0)
bx_define_opcode(BX_IA_BOUND_GwMa, &BX_CPU_C::BOUND_GwMa, NULL, 0)
bx_define_opcode(BX_IA_BSF_GdEdR, &BX_CPU_C::BSF_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_BSF_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSF_GdEdR, 0)
bx_define_opcode(BX_IA_BSF_GwEwR, &BX_CPU_C::BSF_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_BSF_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSF_GwEwR, 0)
bx_define_opcode(BX_IA_BSR_GdEdR, &BX_CPU_C::BSR_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_BSR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::BSR_GdEdR, 0)
bx_define_opcode(BX_IA_BSR_GwEwR, &BX_CPU_C::BSR_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_BSR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::BSR_GwEwR, 0)
bx_define_opcode(BX_IA_BT_EdGdM, &BX_CPU_C::BT_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_BT_EdGdR, &BX_CPU_C::BT_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_BT_EdIbM, &BX_CPU_C::BT_EdIbM, NULL, 0)
bx_define_opcode(BX_IA_BT_EdIbR, &BX_CPU_C::BT_EdIbR, NULL, 0)
bx_define_opcode(BX_IA_BT_EwGwM, &BX_CPU_C::BT_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_BT_EwGwR, &BX_CPU_C::BT_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_BT_EwIbM, &BX_CPU_C::BT_EwIbM, NULL, 0)
bx_define_opcode(BX_IA_BT_EwIbR, &BX_CPU_C::BT_EwIbR, NULL, 0)
bx_define_opcode(BX_IA_BTC_EdGdM, &BX_CPU_C::BTC_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_BTC_EdGdR, &BX_CPU_C::BTC_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_BTC_EdIbM, &BX_CPU_C::BTC_EdIbM, NULL, 0)
bx_define_opcode(BX_IA_BTC_EdIbR, &BX_CPU_C::BTC_EdIbR, NULL, 0)
bx_define_opcode(BX_IA_BTC_EwGwM, &BX_CPU_C::BTC_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_BTC_EwGwR, &BX_CPU_C::BTC_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_BTC_EwIbM, &BX_CPU_C::BTC_EwIbM, NULL, 0)
bx_define_opcode(BX_IA_BTC_EwIbR, &BX_CPU_C::BTC_EwIbR, NULL, 0)
bx_define_opcode(BX_IA_BTR_EdGdM, &BX_CPU_C::BTR_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_BTR_EdGdR, &BX_CPU_C::BTR_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_BTR_EdIbM, &BX_CPU_C::BTR_EdIbM, NULL, 0)
bx_define_opcode(BX_IA_BTR_EdIbR, &BX_CPU_C::BTR_EdIbR, NULL, 0)
bx_define_opcode(BX_IA_BTR_EwGwM, &BX_CPU_C::BTR_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_BTR_EwGwR, &BX_CPU_C::BTR_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_BTR_EwIbM, &BX_CPU_C::BTR_EwIbM, NULL, 0)
bx_define_opcode(BX_IA_BTR_EwIbR, &BX_CPU_C::BTR_EwIbR, NULL, 0)
bx_define_opcode(BX_IA_BTS_EdGdM, &BX_CPU_C::BTS_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_BTS_EdGdR, &BX_CPU_C::BTS_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_BTS_EdIbM, &BX_CPU_C::BTS_EdIbM, NULL, 0)
bx_define_opcode(BX_IA_BTS_EdIbR, &BX_CPU_C::BTS_EdIbR, NULL, 0)
bx_define_opcode(BX_IA_BTS_EwGwM, &BX_CPU_C::BTS_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_BTS_EwGwR, &BX_CPU_C::BTS_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_BTS_EwIbM, &BX_CPU_C::BTS_EwIbM, NULL, 0)
bx_define_opcode(BX_IA_BTS_EwIbR, &BX_CPU_C::BTS_EwIbR, NULL, 0)
bx_define_opcode(BX_IA_CALL_EdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CALL_EdR, 0)
bx_define_opcode(BX_IA_CALL_EdR, &BX_CPU_C::CALL_EdR, NULL, 0)
bx_define_opcode(BX_IA_CALL_EwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CALL_EwR, 0)
bx_define_opcode(BX_IA_CALL_EwR, &BX_CPU_C::CALL_EwR, NULL, 0)
bx_define_opcode(BX_IA_CALL_Jd, &BX_CPU_C::CALL_Jd, NULL, 0)
bx_define_opcode(BX_IA_CALL_Jw, &BX_CPU_C::CALL_Jw, NULL, 0)
bx_define_opcode(BX_IA_CALL16_Ap, &BX_CPU_C::CALL16_Ap, NULL, 0)
bx_define_opcode(BX_IA_CALL16_Ep, &BX_CPU_C::CALL16_Ep, NULL, 0)
bx_define_opcode(BX_IA_CALL32_Ap, &BX_CPU_C::CALL32_Ap, NULL, 0)
bx_define_opcode(BX_IA_CALL32_Ep, &BX_CPU_C::CALL32_Ep, NULL, 0)
bx_define_opcode(BX_IA_CBW, &BX_CPU_C::CBW, NULL, 0)
bx_define_opcode(BX_IA_CDQ, &BX_CPU_C::CDQ, NULL, 0)
bx_define_opcode(BX_IA_CLC, &BX_CPU_C::CLC, NULL, 0)
bx_define_opcode(BX_IA_CLD, &BX_CPU_C::CLD, NULL, 0)
bx_define_opcode(BX_IA_CLFLUSH, &BX_CPU_C::CLFLUSH, NULL, BX_CPU_CLFLUSH)
bx_define_opcode(BX_IA_CLI, &BX_CPU_C::CLI, NULL, 0)
bx_define_opcode(BX_IA_CLTS, &BX_CPU_C::CLTS, NULL, 0)
bx_define_opcode(BX_IA_CMC, &BX_CPU_C::CMC, NULL, 0)
bx_define_opcode(BX_IA_CMP_ALIb, &BX_CPU_C::CMP_ALIb, NULL, 0)
bx_define_opcode(BX_IA_CMP_AXIw, &BX_CPU_C::CMP_AXIw, NULL, 0)
bx_define_opcode(BX_IA_CMP_EAXId, &BX_CPU_C::CMP_EAXId, NULL, 0)
bx_define_opcode(BX_IA_CMP_EbGbM, &BX_CPU_C::CMP_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EbIbM, &BX_CPU_C::CMP_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EbIbR, &BX_CPU_C::CMP_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_CMP_EdGdM, &BX_CPU_C::CMP_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EdIdM, &BX_CPU_C::CMP_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EdIdR, &BX_CPU_C::CMP_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_CMP_EwGwM, &BX_CPU_C::CMP_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EwIwM, &BX_CPU_C::CMP_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_CMP_EwIwR, &BX_CPU_C::CMP_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_CMP_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::CMP_GbEbR, 0)
bx_define_opcode(BX_IA_CMP_GbEbR, &BX_CPU_C::CMP_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_CMP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMP_GdEdR, 0)
bx_define_opcode(BX_IA_CMP_GdEdR, &BX_CPU_C::CMP_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_CMP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMP_GwEwR, 0)
bx_define_opcode(BX_IA_CMP_GwEwR, &BX_CPU_C::CMP_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_CMPXCHG_IBTS, &BX_CPU_C::CMPXCHG_IBTS, NULL, 0)
bx_define_opcode(BX_IA_CMPXCHG_XBTS, &BX_CPU_C::CMPXCHG_XBTS, NULL, 0)
bx_define_opcode(BX_IA_CWD, &BX_CPU_C::CWD, NULL, 0)
bx_define_opcode(BX_IA_CWDE, &BX_CPU_C::CWDE, NULL, 0)
bx_define_opcode(BX_IA_DEC_EbM, &BX_CPU_C::DEC_EbM, NULL, 0)
bx_define_opcode(BX_IA_DEC_EbR, &BX_CPU_C::DEC_EbR, NULL, 0)
bx_define_opcode(BX_IA_DEC_EdR, &BX_CPU_C::DEC_ERX, NULL, 0)
bx_define_opcode(BX_IA_DEC_EdM, &BX_CPU_C::DEC_EdM, NULL, 0)
bx_define_opcode(BX_IA_DEC_ERX, &BX_CPU_C::DEC_ERX, NULL, 0)
bx_define_opcode(BX_IA_DEC_EwR, &BX_CPU_C::DEC_RX, NULL, 0)
bx_define_opcode(BX_IA_DEC_EwM, &BX_CPU_C::DEC_EwM, NULL, 0)
bx_define_opcode(BX_IA_DEC_RX, &BX_CPU_C::DEC_RX, NULL, 0)
bx_define_opcode(BX_IA_DIV_ALEbR, &BX_CPU_C::DIV_ALEbR, NULL, 0)
bx_define_opcode(BX_IA_DIV_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::DIV_ALEbR, 0)
bx_define_opcode(BX_IA_DIV_AXEwR, &BX_CPU_C::DIV_AXEwR, NULL, 0)
bx_define_opcode(BX_IA_DIV_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::DIV_AXEwR, 0)
bx_define_opcode(BX_IA_DIV_EAXEdR, &BX_CPU_C::DIV_EAXEdR, NULL, 0)
bx_define_opcode(BX_IA_DIV_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::DIV_EAXEdR, 0)
bx_define_opcode(BX_IA_ENTER16_IwIb, &BX_CPU_C::ENTER16_IwIb, NULL, 0)
bx_define_opcode(BX_IA_ENTER32_IwIb, &BX_CPU_C::ENTER32_IwIb, NULL, 0)
bx_define_opcode(BX_IA_HLT, &BX_CPU_C::HLT, NULL, 0)
bx_define_opcode(BX_IA_IDIV_ALEbR, &BX_CPU_C::IDIV_ALEbR, NULL, 0)
bx_define_opcode(BX_IA_IDIV_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IDIV_ALEbR, 0)
bx_define_opcode(BX_IA_IDIV_AXEwR, &BX_CPU_C::IDIV_AXEwR, NULL, 0)
bx_define_opcode(BX_IA_IDIV_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IDIV_AXEwR, 0)
bx_define_opcode(BX_IA_IDIV_EAXEdR, &BX_CPU_C::IDIV_EAXEdR, NULL, 0)
bx_define_opcode(BX_IA_IDIV_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IDIV_EAXEdR, 0)
bx_define_opcode(BX_IA_IMUL_ALEbR, &BX_CPU_C::IMUL_ALEbR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::IMUL_ALEbR, 0)
bx_define_opcode(BX_IA_IMUL_AXEwR, &BX_CPU_C::IMUL_AXEwR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_AXEwR, 0)
bx_define_opcode(BX_IA_IMUL_EAXEdR, &BX_CPU_C::IMUL_EAXEdR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_EAXEdR, 0)
bx_define_opcode(BX_IA_IMUL_GdEdR, &BX_CPU_C::IMUL_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdR, 0)
bx_define_opcode(BX_IA_IMUL_GdEdIdR, &BX_CPU_C::IMUL_GdEdIdR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_GdEdIdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::IMUL_GdEdIdR, 0)
bx_define_opcode(BX_IA_IMUL_GwEwR, &BX_CPU_C::IMUL_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwR, 0)
bx_define_opcode(BX_IA_IMUL_GwEwIwR, &BX_CPU_C::IMUL_GwEwIwR, NULL, 0)
bx_define_opcode(BX_IA_IMUL_GwEwIwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::IMUL_GwEwIwR, 0)
bx_define_opcode(BX_IA_IN_ALDX, &BX_CPU_C::IN_ALDX, NULL, 0)
bx_define_opcode(BX_IA_IN_ALIb, &BX_CPU_C::IN_ALIb, NULL, 0)
bx_define_opcode(BX_IA_IN_AXDX, &BX_CPU_C::IN_AXDX, NULL, 0)
bx_define_opcode(BX_IA_IN_AXIb, &BX_CPU_C::IN_AXIb, NULL, 0)
bx_define_opcode(BX_IA_IN_EAXDX, &BX_CPU_C::IN_EAXDX, NULL, 0)
bx_define_opcode(BX_IA_IN_EAXIb, &BX_CPU_C::IN_EAXIb, NULL, 0)
bx_define_opcode(BX_IA_INC_EbM, &BX_CPU_C::INC_EbM, NULL, 0)
bx_define_opcode(BX_IA_INC_EbR, &BX_CPU_C::INC_EbR, NULL, 0)
bx_define_opcode(BX_IA_INC_EdR, &BX_CPU_C::INC_ERX, NULL, 0)
bx_define_opcode(BX_IA_INC_EdM, &BX_CPU_C::INC_EdM, NULL, 0)
bx_define_opcode(BX_IA_INC_ERX, &BX_CPU_C::INC_ERX, NULL, 0)
bx_define_opcode(BX_IA_INC_EwR, &BX_CPU_C::INC_RX, NULL, 0)
bx_define_opcode(BX_IA_INC_EwM, &BX_CPU_C::INC_EwM, NULL, 0)
bx_define_opcode(BX_IA_INC_RX, &BX_CPU_C::INC_RX, NULL, 0)
bx_define_opcode(BX_IA_INT_Ib, &BX_CPU_C::INT_Ib, NULL, 0)
bx_define_opcode(BX_IA_INT1, &BX_CPU_C::INT1, NULL, 0)
bx_define_opcode(BX_IA_INT3, &BX_CPU_C::INT3, NULL, 0)
bx_define_opcode(BX_IA_INTO, &BX_CPU_C::INTO, NULL, 0)
bx_define_opcode(BX_IA_IRET16, &BX_CPU_C::IRET16, NULL, 0)
bx_define_opcode(BX_IA_IRET32, &BX_CPU_C::IRET32, NULL, 0)
bx_define_opcode(BX_IA_JB_Jd, &BX_CPU_C::JB_Jd, NULL, 0)
bx_define_opcode(BX_IA_JB_Jw, &BX_CPU_C::JB_Jw, NULL, 0)
bx_define_opcode(BX_IA_JBE_Jd, &BX_CPU_C::JBE_Jd, NULL, 0)
bx_define_opcode(BX_IA_JBE_Jw, &BX_CPU_C::JBE_Jw, NULL, 0)
bx_define_opcode(BX_IA_JCXZ_Jb, &BX_CPU_C::JCXZ_Jb, NULL, 0)
bx_define_opcode(BX_IA_JECXZ_Jb, &BX_CPU_C::JECXZ_Jb, NULL, 0)
bx_define_opcode(BX_IA_JL_Jd, &BX_CPU_C::JL_Jd, NULL, 0)
bx_define_opcode(BX_IA_JL_Jw, &BX_CPU_C::JL_Jw, NULL, 0)
bx_define_opcode(BX_IA_JLE_Jd, &BX_CPU_C::JLE_Jd, NULL, 0)
bx_define_opcode(BX_IA_JLE_Jw, &BX_CPU_C::JLE_Jw, NULL, 0)
bx_define_opcode(BX_IA_JMP_Ap, &BX_CPU_C::JMP_Ap, NULL, 0)
bx_define_opcode(BX_IA_JMP_EdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::JMP_EdR, 0)
bx_define_opcode(BX_IA_JMP_EdR, &BX_CPU_C::JMP_EdR, NULL, 0)
bx_define_opcode(BX_IA_JMP_EwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::JMP_EwR, 0)
bx_define_opcode(BX_IA_JMP_EwR, &BX_CPU_C::JMP_EwR, NULL, 0)
bx_define_opcode(BX_IA_JMP_Jd, &BX_CPU_C::JMP_Jd, NULL, 0)
bx_define_opcode(BX_IA_JMP_Jw, &BX_CPU_C::JMP_Jw, NULL, 0)
bx_define_opcode(BX_IA_JMP16_Ep, &BX_CPU_C::JMP16_Ep, NULL, 0)
bx_define_opcode(BX_IA_JMP32_Ep, &BX_CPU_C::JMP32_Ep, NULL, 0)
bx_define_opcode(BX_IA_JNB_Jd, &BX_CPU_C::JNB_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNB_Jw, &BX_CPU_C::JNB_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNBE_Jd, &BX_CPU_C::JNBE_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNBE_Jw, &BX_CPU_C::JNBE_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNL_Jd, &BX_CPU_C::JNL_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNL_Jw, &BX_CPU_C::JNL_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNLE_Jd, &BX_CPU_C::JNLE_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNLE_Jw, &BX_CPU_C::JNLE_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNO_Jd, &BX_CPU_C::JNO_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNO_Jw, &BX_CPU_C::JNO_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNP_Jd, &BX_CPU_C::JNP_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNP_Jw, &BX_CPU_C::JNP_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNS_Jd, &BX_CPU_C::JNS_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNS_Jw, &BX_CPU_C::JNS_Jw, NULL, 0)
bx_define_opcode(BX_IA_JNZ_Jd, &BX_CPU_C::JNZ_Jd, NULL, 0)
bx_define_opcode(BX_IA_JNZ_Jw, &BX_CPU_C::JNZ_Jw, NULL, 0)
bx_define_opcode(BX_IA_JO_Jd, &BX_CPU_C::JO_Jd, NULL, 0)
bx_define_opcode(BX_IA_JO_Jw, &BX_CPU_C::JO_Jw, NULL, 0)
bx_define_opcode(BX_IA_JP_Jd, &BX_CPU_C::JP_Jd, NULL, 0)
bx_define_opcode(BX_IA_JP_Jw, &BX_CPU_C::JP_Jw, NULL, 0)
bx_define_opcode(BX_IA_JS_Jd, &BX_CPU_C::JS_Jd, NULL, 0)
bx_define_opcode(BX_IA_JS_Jw, &BX_CPU_C::JS_Jw, NULL, 0)
bx_define_opcode(BX_IA_JZ_Jd, &BX_CPU_C::JZ_Jd, NULL, 0)
bx_define_opcode(BX_IA_JZ_Jw, &BX_CPU_C::JZ_Jw, NULL, 0)
bx_define_opcode(BX_IA_LAHF, &BX_CPU_C::LAHF, NULL, 0)
bx_define_opcode(BX_IA_LAR_GvEw, &BX_CPU_C::LAR_GvEw, NULL, 0)
bx_define_opcode(BX_IA_LDS_GdMp, &BX_CPU_C::LDS_GdMp, NULL, 0)
bx_define_opcode(BX_IA_LDS_GwMp, &BX_CPU_C::LDS_GwMp, NULL, 0)
bx_define_opcode(BX_IA_LEA_GdM, &BX_CPU_C::LEA_GdM, NULL, 0)
bx_define_opcode(BX_IA_LEA_GwM, &BX_CPU_C::LEA_GwM, NULL, 0)
bx_define_opcode(BX_IA_LEAVE16, &BX_CPU_C::LEAVE16, NULL, 0)
bx_define_opcode(BX_IA_LEAVE32, &BX_CPU_C::LEAVE32, NULL, 0)
bx_define_opcode(BX_IA_LES_GdMp, &BX_CPU_C::LES_GdMp, NULL, 0)
bx_define_opcode(BX_IA_LES_GwMp, &BX_CPU_C::LES_GwMp, NULL, 0)
bx_define_opcode(BX_IA_LFS_GdMp, &BX_CPU_C::LFS_GdMp, NULL, 0)
bx_define_opcode(BX_IA_LFS_GwMp, &BX_CPU_C::LFS_GwMp, NULL, 0)
bx_define_opcode(BX_IA_LGDT_Ms, &BX_CPU_C::LGDT_Ms, NULL, 0)
bx_define_opcode(BX_IA_LGS_GdMp, &BX_CPU_C::LGS_GdMp, NULL, 0)
bx_define_opcode(BX_IA_LGS_GwMp, &BX_CPU_C::LGS_GwMp, NULL, 0)
bx_define_opcode(BX_IA_LIDT_Ms, &BX_CPU_C::LIDT_Ms, NULL, 0)
bx_define_opcode(BX_IA_LLDT_Ew, &BX_CPU_C::LLDT_Ew, NULL, 0)
bx_define_opcode(BX_IA_LMSW_Ew, &BX_CPU_C::LMSW_Ew, NULL, 0)
bx_define_opcode(BX_IA_LOOP16_Jb, &BX_CPU_C::LOOP16_Jb, NULL, 0)
bx_define_opcode(BX_IA_LOOPE16_Jb, &BX_CPU_C::LOOPE16_Jb, NULL, 0)
bx_define_opcode(BX_IA_LOOPNE16_Jb, &BX_CPU_C::LOOPNE16_Jb, NULL, 0)
bx_define_opcode(BX_IA_LOOP32_Jb, &BX_CPU_C::LOOP32_Jb, NULL, 0)
bx_define_opcode(BX_IA_LOOPE32_Jb, &BX_CPU_C::LOOPE32_Jb, NULL, 0)
bx_define_opcode(BX_IA_LOOPNE32_Jb, &BX_CPU_C::LOOPNE32_Jb, NULL, 0)
bx_define_opcode(BX_IA_LSL_GvEw, &BX_CPU_C::LSL_GvEw, NULL, 0)
bx_define_opcode(BX_IA_LSS_GdMp, &BX_CPU_C::LSS_GdMp, NULL, 0)
bx_define_opcode(BX_IA_LSS_GwMp, &BX_CPU_C::LSS_GwMp, NULL, 0)
bx_define_opcode(BX_IA_LTR_Ew, &BX_CPU_C::LTR_Ew, NULL, 0)
bx_define_opcode(BX_IA_MOV_ALOd, &BX_CPU_C::MOV_ALOd, NULL, 0)
bx_define_opcode(BX_IA_MOV_AXOd, &BX_CPU_C::MOV_AXOd, NULL, 0)
bx_define_opcode(BX_IA_MOV_CdRd, &BX_CPU_C::MOV_CdRd, NULL, 0)
bx_define_opcode(BX_IA_MOV_DdRd, &BX_CPU_C::MOV_DdRd, NULL, 0)
bx_define_opcode(BX_IA_MOV_EAXOd, &BX_CPU_C::MOV_EAXOd, NULL, 0)
bx_define_opcode(BX_IA_MOV_EbGbM, &BX_CPU_C::MOV_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EbIbM, &BX_CPU_C::MOV_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EbIbR, &BX_CPU_C::MOV_RLIb, NULL, 0)
bx_define_opcode(BX_IA_MOV_EdIdM, &BX_CPU_C::MOV_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EdIdR, &BX_CPU_C::MOV_ERXId, NULL, 0)
bx_define_opcode(BX_IA_MOV_ERXId, &BX_CPU_C::MOV_ERXId, NULL, 0)
bx_define_opcode(BX_IA_MOV_EwGwM, &BX_CPU_C::MOV_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EwIwM, &BX_CPU_C::MOV_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EwIwR, &BX_CPU_C::MOV_RXIw, NULL, 0)
bx_define_opcode(BX_IA_MOV_EwSwM, &BX_CPU_C::MOV_EwSwM, NULL, 0)
bx_define_opcode(BX_IA_MOV_EwSwR, &BX_CPU_C::MOV_EwSwR, NULL, 0)
bx_define_opcode(BX_IA_MOV_GbEbM, &BX_CPU_C::MOV_GbEbM, NULL, 0)
bx_define_opcode(BX_IA_MOV_GbEbR, &BX_CPU_C::MOV_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_MOV32_EdGdM, &BX_CPU_C::MOV32_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_MOV32_GdEdM, &BX_CPU_C::MOV32_GdEdM, NULL, 0)
bx_define_opcode(BX_IA_MOV_GdEdR, &BX_CPU_C::MOV_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_MOV_GwEwM, &BX_CPU_C::MOV_GwEwM, NULL, 0)
bx_define_opcode(BX_IA_MOV_GwEwR, &BX_CPU_C::MOV_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_MOV_OdAL, &BX_CPU_C::MOV_OdAL, NULL, 0)
bx_define_opcode(BX_IA_MOV_OdAX, &BX_CPU_C::MOV_OdAX, NULL, 0)
bx_define_opcode(BX_IA_MOV_OdEAX, &BX_CPU_C::MOV_OdEAX, NULL, 0)
bx_define_opcode(BX_IA_MOV_RdCd, &BX_CPU_C::MOV_RdCd, NULL, 0)
bx_define_opcode(BX_IA_MOV_RdDd, &BX_CPU_C::MOV_RdDd, NULL, 0)
bx_define_opcode(BX_IA_MOV_RdTd, &BX_CPU_C::MOV_RdTd, NULL, 0)
bx_define_opcode(BX_IA_MOV_RHIb, &BX_CPU_C::MOV_RHIb, NULL, 0)
bx_define_opcode(BX_IA_MOV_RLIb, &BX_CPU_C::MOV_RLIb, NULL, 0)
bx_define_opcode(BX_IA_MOV_RXIw, &BX_CPU_C::MOV_RXIw, NULL, 0)
bx_define_opcode(BX_IA_MOV_SwEw, &BX_CPU_C::MOV_SwEw, NULL, 0)
bx_define_opcode(BX_IA_MOV_TdRd, &BX_CPU_C::MOV_TdRd, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GdEbM, &BX_CPU_C::MOVSX_GdEbM, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GdEbR, &BX_CPU_C::MOVSX_GdEbR, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GdEwM, &BX_CPU_C::MOVSX_GdEwM, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GdEwR, &BX_CPU_C::MOVSX_GdEwR, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GwEbM, &BX_CPU_C::MOVSX_GwEbM, NULL, 0)
bx_define_opcode(BX_IA_MOVSX_GwEbR, &BX_CPU_C::MOVSX_GwEbR, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GdEbM, &BX_CPU_C::MOVZX_GdEbM, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GdEbR, &BX_CPU_C::MOVZX_GdEbR, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GdEwM, &BX_CPU_C::MOVZX_GdEwM, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GdEwR, &BX_CPU_C::MOVZX_GdEwR, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GwEbM, &BX_CPU_C::MOVZX_GwEbM, NULL, 0)
bx_define_opcode(BX_IA_MOVZX_GwEbR, &BX_CPU_C::MOVZX_GwEbR, NULL, 0)
bx_define_opcode(BX_IA_MUL_ALEbR, &BX_CPU_C::MUL_ALEbR, NULL, 0)
bx_define_opcode(BX_IA_MUL_ALEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::MUL_ALEbR, 0)
bx_define_opcode(BX_IA_MUL_AXEwR, &BX_CPU_C::MUL_AXEwR, NULL, 0)
bx_define_opcode(BX_IA_MUL_AXEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::MUL_AXEwR, 0)
bx_define_opcode(BX_IA_MUL_EAXEdR, &BX_CPU_C::MUL_EAXEdR, NULL, 0)
bx_define_opcode(BX_IA_MUL_EAXEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::MUL_EAXEdR, 0)
bx_define_opcode(BX_IA_NEG_EbM, &BX_CPU_C::NEG_EbM, NULL, 0)
bx_define_opcode(BX_IA_NEG_EbR, &BX_CPU_C::NEG_EbR, NULL, 0)
bx_define_opcode(BX_IA_NEG_EdM, &BX_CPU_C::NEG_EdM, NULL, 0)
bx_define_opcode(BX_IA_NEG_EdR, &BX_CPU_C::NEG_EdR, NULL, 0)
bx_define_opcode(BX_IA_NEG_EwM, &BX_CPU_C::NEG_EwM, NULL, 0)
bx_define_opcode(BX_IA_NEG_EwR, &BX_CPU_C::NEG_EwR, NULL, 0)
bx_define_opcode(BX_IA_NOP, &BX_CPU_C::NOP, NULL, 0)
bx_define_opcode(BX_IA_PAUSE, &BX_CPU_C::PAUSE, NULL, 0)
bx_define_opcode(BX_IA_NOT_EbM, &BX_CPU_C::NOT_EbM, NULL, 0)
bx_define_opcode(BX_IA_NOT_EbR, &BX_CPU_C::NOT_EbR, NULL, 0)
bx_define_opcode(BX_IA_NOT_EdM, &BX_CPU_C::NOT_EdM, NULL, 0)
bx_define_opcode(BX_IA_NOT_EdR, &BX_CPU_C::NOT_EdR, NULL, 0)
bx_define_opcode(BX_IA_NOT_EwM, &BX_CPU_C::NOT_EwM, NULL, 0)
bx_define_opcode(BX_IA_NOT_EwR, &BX_CPU_C::NOT_EwR, NULL, 0)
bx_define_opcode(BX_IA_OR_ALIb, &BX_CPU_C::OR_ALIb, NULL, 0)
bx_define_opcode(BX_IA_OR_AXIw, &BX_CPU_C::OR_AXIw, NULL, 0)
bx_define_opcode(BX_IA_OR_EAXId, &BX_CPU_C::OR_EAXId, NULL, 0)
bx_define_opcode(BX_IA_OR_EbGbM, &BX_CPU_C::OR_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_OR_EbIbM, &BX_CPU_C::OR_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_OR_EbIbR, &BX_CPU_C::OR_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_OR_EdGdM, &BX_CPU_C::OR_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_OR_EdIdM, &BX_CPU_C::OR_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_OR_EdIdR, &BX_CPU_C::OR_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_OR_EwGwM, &BX_CPU_C::OR_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_OR_EwIwM, &BX_CPU_C::OR_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_OR_EwIwR, &BX_CPU_C::OR_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_OR_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::OR_GbEbR, 0)
bx_define_opcode(BX_IA_OR_GbEbR, &BX_CPU_C::OR_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_OR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::OR_GdEdR, 0)
bx_define_opcode(BX_IA_OR_GdEdR, &BX_CPU_C::OR_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_OR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::OR_GwEwR, 0)
bx_define_opcode(BX_IA_OR_GwEwR, &BX_CPU_C::OR_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_OUT_DXAL, &BX_CPU_C::OUT_DXAL, NULL, 0)
bx_define_opcode(BX_IA_OUT_DXAX, &BX_CPU_C::OUT_DXAX, NULL, 0)
bx_define_opcode(BX_IA_OUT_DXEAX, &BX_CPU_C::OUT_DXEAX, NULL, 0)
bx_define_opcode(BX_IA_OUT_IbAL, &BX_CPU_C::OUT_IbAL, NULL, 0)
bx_define_opcode(BX_IA_OUT_IbAX, &BX_CPU_C::OUT_IbAX, NULL, 0)
bx_define_opcode(BX_IA_OUT_IbEAX, &BX_CPU_C::OUT_IbEAX, NULL, 0)
bx_define_opcode(BX_IA_POP_EdM, &BX_CPU_C::POP_EdM, NULL, 0)
bx_define_opcode(BX_IA_POP_EdR, &BX_CPU_C::POP_ERX, NULL, 0)
bx_define_opcode(BX_IA_POP_ERX, &BX_CPU_C::POP_ERX, NULL, 0)
bx_define_opcode(BX_IA_POP_EwM, &BX_CPU_C::POP_EwM, NULL, 0)
bx_define_opcode(BX_IA_POP_EwR, &BX_CPU_C::POP_RX, NULL, 0)
bx_define_opcode(BX_IA_POP_RX, &BX_CPU_C::POP_RX, NULL, 0)
bx_define_opcode(BX_IA_POP16_DS, &BX_CPU_C::POP16_DS, NULL, 0)
bx_define_opcode(BX_IA_POP16_ES, &BX_CPU_C::POP16_ES, NULL, 0)
bx_define_opcode(BX_IA_POP16_FS, &BX_CPU_C::POP16_FS, NULL, 0)
bx_define_opcode(BX_IA_POP16_GS, &BX_CPU_C::POP16_GS, NULL, 0)
bx_define_opcode(BX_IA_POP16_SS, &BX_CPU_C::POP16_SS, NULL, 0)
bx_define_opcode(BX_IA_POP32_DS, &BX_CPU_C::POP32_DS, NULL, 0)
bx_define_opcode(BX_IA_POP32_ES, &BX_CPU_C::POP32_ES, NULL, 0)
bx_define_opcode(BX_IA_POP32_FS, &BX_CPU_C::POP32_FS, NULL, 0)
bx_define_opcode(BX_IA_POP32_GS, &BX_CPU_C::POP32_GS, NULL, 0)
bx_define_opcode(BX_IA_POP32_SS, &BX_CPU_C::POP32_SS, NULL, 0)
bx_define_opcode(BX_IA_POPAD16, &BX_CPU_C::POPAD16, NULL, 0)
bx_define_opcode(BX_IA_POPAD32, &BX_CPU_C::POPAD32, NULL, 0)
bx_define_opcode(BX_IA_POPF_Fd, &BX_CPU_C::POPF_Fd, NULL, 0)
bx_define_opcode(BX_IA_POPF_Fw, &BX_CPU_C::POPF_Fw, NULL, 0)
bx_define_opcode(BX_IA_PUSH_EdM, &BX_CPU_C::PUSH_EdM, NULL, 0)
bx_define_opcode(BX_IA_PUSH_EdR, &BX_CPU_C::PUSH_ERX, NULL, 0)
bx_define_opcode(BX_IA_PUSH_ERX, &BX_CPU_C::PUSH_ERX, NULL, 0)
bx_define_opcode(BX_IA_PUSH_EwM, &BX_CPU_C::PUSH_EwM, NULL, 0)
bx_define_opcode(BX_IA_PUSH_EwR, &BX_CPU_C::PUSH_RX, NULL, 0)
bx_define_opcode(BX_IA_PUSH_Id, &BX_CPU_C::PUSH_Id, NULL, 0)
bx_define_opcode(BX_IA_PUSH_Iw, &BX_CPU_C::PUSH_Iw, NULL, 0)
bx_define_opcode(BX_IA_PUSH_RX, &BX_CPU_C::PUSH_RX, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_CS, &BX_CPU_C::PUSH16_CS, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_DS, &BX_CPU_C::PUSH16_DS, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_ES, &BX_CPU_C::PUSH16_ES, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_FS, &BX_CPU_C::PUSH16_FS, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_GS, &BX_CPU_C::PUSH16_GS, NULL, 0)
bx_define_opcode(BX_IA_PUSH16_SS, &BX_CPU_C::PUSH16_SS, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_CS, &BX_CPU_C::PUSH32_CS, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_DS, &BX_CPU_C::PUSH32_DS, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_ES, &BX_CPU_C::PUSH32_ES, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_FS, &BX_CPU_C::PUSH32_FS, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_GS, &BX_CPU_C::PUSH32_GS, NULL, 0)
bx_define_opcode(BX_IA_PUSH32_SS, &BX_CPU_C::PUSH32_SS, NULL, 0)
bx_define_opcode(BX_IA_PUSHAD16, &BX_CPU_C::PUSHAD16, NULL, 0)
bx_define_opcode(BX_IA_PUSHAD32, &BX_CPU_C::PUSHAD32, NULL, 0)
bx_define_opcode(BX_IA_PUSHF_Fd, &BX_CPU_C::PUSHF_Fd, NULL, 0)
bx_define_opcode(BX_IA_PUSHF_Fw, &BX_CPU_C::PUSHF_Fw, NULL, 0)
bx_define_opcode(BX_IA_RCL_Eb, &BX_CPU_C::RCL_Eb, NULL, 0)
bx_define_opcode(BX_IA_RCL_Ew, &BX_CPU_C::RCL_Ew, NULL, 0)
bx_define_opcode(BX_IA_RCR_Eb, &BX_CPU_C::RCR_Eb, NULL, 0)
bx_define_opcode(BX_IA_RCR_Ew, &BX_CPU_C::RCR_Ew, NULL, 0)
bx_define_opcode(BX_IA_REP_CMPSB_XbYb, &BX_CPU_C::REP_CMPSB_XbYb, NULL, 0)
bx_define_opcode(BX_IA_REP_CMPSD_XdYd, &BX_CPU_C::REP_CMPSD_XdYd, NULL, 0)
bx_define_opcode(BX_IA_REP_CMPSW_XwYw, &BX_CPU_C::REP_CMPSW_XwYw, NULL, 0)
bx_define_opcode(BX_IA_REP_INSB_YbDX, &BX_CPU_C::REP_INSB_YbDX, NULL, 0)
bx_define_opcode(BX_IA_REP_INSD_YdDX, &BX_CPU_C::REP_INSD_YdDX, NULL, 0)
bx_define_opcode(BX_IA_REP_INSW_YwDX, &BX_CPU_C::REP_INSW_YwDX, NULL, 0)
bx_define_opcode(BX_IA_REP_LODSB_ALXb, &BX_CPU_C::REP_LODSB_ALXb, NULL, 0)
bx_define_opcode(BX_IA_REP_LODSD_EAXXd, &BX_CPU_C::REP_LODSD_EAXXd, NULL, 0)
bx_define_opcode(BX_IA_REP_LODSW_AXXw, &BX_CPU_C::REP_LODSW_AXXw, NULL, 0)
bx_define_opcode(BX_IA_REP_MOVSB_XbYb, &BX_CPU_C::REP_MOVSB_XbYb, NULL, 0)
bx_define_opcode(BX_IA_REP_MOVSD_XdYd, &BX_CPU_C::REP_MOVSD_XdYd, NULL, 0)
bx_define_opcode(BX_IA_REP_MOVSW_XwYw, &BX_CPU_C::REP_MOVSW_XwYw, NULL, 0)
bx_define_opcode(BX_IA_REP_OUTSB_DXXb, &BX_CPU_C::REP_OUTSB_DXXb, NULL, 0)
bx_define_opcode(BX_IA_REP_OUTSD_DXXd, &BX_CPU_C::REP_OUTSD_DXXd, NULL, 0)
bx_define_opcode(BX_IA_REP_OUTSW_DXXw, &BX_CPU_C::REP_OUTSW_DXXw, NULL, 0)
bx_define_opcode(BX_IA_REP_SCASB_ALXb, &BX_CPU_C::REP_SCASB_ALXb, NULL, 0)
bx_define_opcode(BX_IA_REP_SCASD_EAXXd, &BX_CPU_C::REP_SCASD_EAXXd, NULL, 0)
bx_define_opcode(BX_IA_REP_SCASW_AXXw, &BX_CPU_C::REP_SCASW_AXXw, NULL, 0)
bx_define_opcode(BX_IA_REP_STOSB_YbAL, &BX_CPU_C::REP_STOSB_YbAL, NULL, 0)
bx_define_opcode(BX_IA_REP_STOSD_YdEAX, &BX_CPU_C::REP_STOSD_YdEAX, NULL, 0)
bx_define_opcode(BX_IA_REP_STOSW_YwAX, &BX_CPU_C::REP_STOSW_YwAX, NULL, 0)
bx_define_opcode(BX_IA_RETfar16, &BX_CPU_C::RETfar16, NULL, 0)
bx_define_opcode(BX_IA_RETfar16_Iw, &BX_CPU_C::RETfar16_Iw, NULL, 0)
bx_define_opcode(BX_IA_RETfar32, &BX_CPU_C::RETfar32, NULL, 0)
bx_define_opcode(BX_IA_RETfar32_Iw, &BX_CPU_C::RETfar32_Iw, NULL, 0)
bx_define_opcode(BX_IA_RETnear16, &BX_CPU_C::RETnear16, NULL, 0)
bx_define_opcode(BX_IA_RETnear16_Iw, &BX_CPU_C::RETnear16_Iw, NULL, 0)
bx_define_opcode(BX_IA_RETnear32, &BX_CPU_C::RETnear32, NULL, 0)
bx_define_opcode(BX_IA_RETnear32_Iw, &BX_CPU_C::RETnear32_Iw, NULL, 0)
bx_define_opcode(BX_IA_ROL_Eb, &BX_CPU_C::ROL_Eb, NULL, 0)
bx_define_opcode(BX_IA_ROL_Ew, &BX_CPU_C::ROL_Ew, NULL, 0)
bx_define_opcode(BX_IA_ROR_Eb, &BX_CPU_C::ROR_Eb, NULL, 0)
bx_define_opcode(BX_IA_ROR_Ew, &BX_CPU_C::ROR_Ew, NULL, 0)
bx_define_opcode(BX_IA_RCR_EdM, &BX_CPU_C::RCR_EdM, NULL, 0)
bx_define_opcode(BX_IA_RCL_EdM, &BX_CPU_C::RCL_EdM, NULL, 0)
bx_define_opcode(BX_IA_ROL_EdM, &BX_CPU_C::ROL_EdM, NULL, 0)
bx_define_opcode(BX_IA_ROR_EdM, &BX_CPU_C::ROR_EdM, NULL, 0)
bx_define_opcode(BX_IA_SAR_EdM, &BX_CPU_C::SAR_EdM, NULL, 0)
bx_define_opcode(BX_IA_SHL_EdM, &BX_CPU_C::SHL_EdM, NULL, 0)
bx_define_opcode(BX_IA_SHR_EdM, &BX_CPU_C::SHR_EdM, NULL, 0)
bx_define_opcode(BX_IA_RCR_EdR, &BX_CPU_C::RCR_EdR, NULL, 0)
bx_define_opcode(BX_IA_RCL_EdR, &BX_CPU_C::RCL_EdR, NULL, 0)
bx_define_opcode(BX_IA_ROL_EdR, &BX_CPU_C::ROL_EdR, NULL, 0)
bx_define_opcode(BX_IA_ROR_EdR, &BX_CPU_C::ROR_EdR, NULL, 0)
bx_define_opcode(BX_IA_SAR_EdR, &BX_CPU_C::SAR_EdR, NULL, 0)
bx_define_opcode(BX_IA_SHL_EdR, &BX_CPU_C::SHL_EdR, NULL, 0)
bx_define_opcode(BX_IA_SHR_EdR, &BX_CPU_C::SHR_EdR, NULL, 0)
bx_define_opcode(BX_IA_RSM, &BX_CPU_C::RSM, NULL, 0)
bx_define_opcode(BX_IA_SAHF, &BX_CPU_C::SAHF, NULL, 0)
bx_define_opcode(BX_IA_SALC, &BX_CPU_C::SALC, NULL, 0)
bx_define_opcode(BX_IA_SAR_Eb, &BX_CPU_C::SAR_Eb, NULL, 0)
bx_define_opcode(BX_IA_SAR_Ew, &BX_CPU_C::SAR_Ew, NULL, 0)
bx_define_opcode(BX_IA_SBB_ALIb, &BX_CPU_C::SBB_ALIb, NULL, 0)
bx_define_opcode(BX_IA_SBB_AXIw, &BX_CPU_C::SBB_AXIw, NULL, 0)
bx_define_opcode(BX_IA_SBB_EAXId, &BX_CPU_C::SBB_EAXId, NULL, 0)
bx_define_opcode(BX_IA_SBB_EbGbM, &BX_CPU_C::SBB_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EbIbM, &BX_CPU_C::SBB_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EbIbR, &BX_CPU_C::SBB_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_SBB_EdGdM, &BX_CPU_C::SBB_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EdIdM, &BX_CPU_C::SBB_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EdIdR, &BX_CPU_C::SBB_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_SBB_EwGwM, &BX_CPU_C::SBB_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EwIwM, &BX_CPU_C::SBB_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_SBB_EwIwR, &BX_CPU_C::SBB_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_SBB_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SBB_GbEbR, 0)
bx_define_opcode(BX_IA_SBB_GbEbR, &BX_CPU_C::SBB_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_SBB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SBB_GdEdR, 0)
bx_define_opcode(BX_IA_SBB_GdEdR, &BX_CPU_C::SBB_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_SBB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SBB_GwEwR, 0)
bx_define_opcode(BX_IA_SBB_GwEwR, &BX_CPU_C::SBB_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_SETB_EbM, &BX_CPU_C::SETB_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETB_EbR, &BX_CPU_C::SETB_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETBE_EbM, &BX_CPU_C::SETBE_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETBE_EbR, &BX_CPU_C::SETBE_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETL_EbM, &BX_CPU_C::SETL_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETL_EbR, &BX_CPU_C::SETL_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETLE_EbM, &BX_CPU_C::SETLE_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETLE_EbR, &BX_CPU_C::SETLE_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNB_EbM, &BX_CPU_C::SETNB_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNB_EbR, &BX_CPU_C::SETNB_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNBE_EbM, &BX_CPU_C::SETNBE_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNBE_EbR, &BX_CPU_C::SETNBE_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNL_EbM, &BX_CPU_C::SETNL_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNL_EbR, &BX_CPU_C::SETNL_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNLE_EbM, &BX_CPU_C::SETNLE_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNLE_EbR, &BX_CPU_C::SETNLE_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNO_EbM, &BX_CPU_C::SETNO_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNO_EbR, &BX_CPU_C::SETNO_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNP_EbM, &BX_CPU_C::SETNP_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNP_EbR, &BX_CPU_C::SETNP_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNS_EbM, &BX_CPU_C::SETNS_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNS_EbR, &BX_CPU_C::SETNS_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETNZ_EbM, &BX_CPU_C::SETNZ_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETNZ_EbR, &BX_CPU_C::SETNZ_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETO_EbM, &BX_CPU_C::SETO_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETO_EbR, &BX_CPU_C::SETO_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETP_EbM, &BX_CPU_C::SETP_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETP_EbR, &BX_CPU_C::SETP_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETS_EbM, &BX_CPU_C::SETS_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETS_EbR, &BX_CPU_C::SETS_EbR, NULL, 0)
bx_define_opcode(BX_IA_SETZ_EbM, &BX_CPU_C::SETZ_EbM, NULL, 0)
bx_define_opcode(BX_IA_SETZ_EbR, &BX_CPU_C::SETZ_EbR, NULL, 0)
bx_define_opcode(BX_IA_SGDT_Ms, &BX_CPU_C::SGDT_Ms, NULL, 0)
bx_define_opcode(BX_IA_SHL_Eb, &BX_CPU_C::SHL_Eb, NULL, 0)
bx_define_opcode(BX_IA_SHL_Ew, &BX_CPU_C::SHL_Ew, NULL, 0)
bx_define_opcode(BX_IA_SHLD_EdGdR, &BX_CPU_C::SHLD_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_SHLD_EdGdM, &BX_CPU_C::SHLD_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_SHLD_EwGwR, &BX_CPU_C::SHLD_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_SHLD_EwGwM, &BX_CPU_C::SHLD_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_SHR_Eb, &BX_CPU_C::SHR_Eb, NULL, 0)
bx_define_opcode(BX_IA_SHR_Ew, &BX_CPU_C::SHR_Ew, NULL, 0)
bx_define_opcode(BX_IA_SHRD_EdGdR, &BX_CPU_C::SHRD_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_SHRD_EdGdM, &BX_CPU_C::SHRD_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_SHRD_EwGwR, &BX_CPU_C::SHRD_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_SHRD_EwGwM, &BX_CPU_C::SHRD_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_SIDT_Ms, &BX_CPU_C::SIDT_Ms, NULL, 0)
bx_define_opcode(BX_IA_SLDT_Ew, &BX_CPU_C::SLDT_Ew, NULL, 0)
bx_define_opcode(BX_IA_SMSW_EwR, &BX_CPU_C::SMSW_EwR, NULL, 0)
bx_define_opcode(BX_IA_SMSW_EwM, &BX_CPU_C::SMSW_EwM, NULL, 0)
bx_define_opcode(BX_IA_STC, &BX_CPU_C::STC, NULL, 0)
bx_define_opcode(BX_IA_STD, &BX_CPU_C::STD, NULL, 0)
bx_define_opcode(BX_IA_STI, &BX_CPU_C::STI, NULL, 0)
bx_define_opcode(BX_IA_STR_Ew, &BX_CPU_C::STR_Ew, NULL, 0)
bx_define_opcode(BX_IA_SUB_ALIb, &BX_CPU_C::SUB_ALIb, NULL, 0)
bx_define_opcode(BX_IA_SUB_AXIw, &BX_CPU_C::SUB_AXIw, NULL, 0)
bx_define_opcode(BX_IA_SUB_EAXId, &BX_CPU_C::SUB_EAXId, NULL, 0)
bx_define_opcode(BX_IA_SUB_EbGbM, &BX_CPU_C::SUB_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EbIbM, &BX_CPU_C::SUB_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EbIbR, &BX_CPU_C::SUB_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_SUB_EdGdM, &BX_CPU_C::SUB_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EdIdM, &BX_CPU_C::SUB_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EdIdR, &BX_CPU_C::SUB_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_SUB_EwGwM, &BX_CPU_C::SUB_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EwIwM, &BX_CPU_C::SUB_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_SUB_EwIwR, &BX_CPU_C::SUB_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_SUB_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::SUB_GbEbR, 0)
bx_define_opcode(BX_IA_SUB_GbEbR, &BX_CPU_C::SUB_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_SUB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::SUB_GdEdR, 0)
bx_define_opcode(BX_IA_SUB_GdEdR, &BX_CPU_C::SUB_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_SUB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::SUB_GwEwR, 0)
bx_define_opcode(BX_IA_SUB_GwEwR, &BX_CPU_C::SUB_GwEwR, NULL, 0)
bx_define_opcode(BX_IA_SYSENTER, &BX_CPU_C::SYSENTER, NULL, BX_CPU_SYSENTER_SYSEXIT)
bx_define_opcode(BX_IA_SYSEXIT, &BX_CPU_C::SYSEXIT, NULL, BX_CPU_SYSENTER_SYSEXIT)
bx_define_opcode(BX_IA_TEST_ALIb, &BX_CPU_C::TEST_ALIb, NULL, 0)
bx_define_opcode(BX_IA_TEST_AXIw, &BX_CPU_C::TEST_AXIw, NULL, 0)
bx_define_opcode(BX_IA_TEST_EAXId, &BX_CPU_C::TEST_EAXId, NULL, 0)
bx_define_opcode(BX_IA_TEST_EbGbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbGbR, 0)
bx_define_opcode(BX_IA_TEST_EbGbR, &BX_CPU_C::TEST_EbGbR, NULL, 0)
bx_define_opcode(BX_IA_TEST_EbIbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::TEST_EbIbR, 0)
bx_define_opcode(BX_IA_TEST_EbIbR, &BX_CPU_C::TEST_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_TEST_EdGdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdGdR, 0)
bx_define_opcode(BX_IA_TEST_EdGdR, &BX_CPU_C::TEST_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_TEST_EdIdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::TEST_EdIdR, 0)
bx_define_opcode(BX_IA_TEST_EdIdR, &BX_CPU_C::TEST_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_TEST_EwGwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwGwR, 0)
bx_define_opcode(BX_IA_TEST_EwGwR, &BX_CPU_C::TEST_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_TEST_EwIwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::TEST_EwIwR, 0)
bx_define_opcode(BX_IA_TEST_EwIwR, &BX_CPU_C::TEST_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_VERR_Ew, &BX_CPU_C::VERR_Ew, NULL, 0)
bx_define_opcode(BX_IA_VERW_Ew, &BX_CPU_C::VERW_Ew, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EbGbM, &BX_CPU_C::XCHG_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EbGbR, &BX_CPU_C::XCHG_EbGbR, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EdGdM, &BX_CPU_C::XCHG_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EdGdR, &BX_CPU_C::XCHG_EdGdR, NULL, 0)
bx_define_opcode(BX_IA_XCHG_ERXEAX, &BX_CPU_C::XCHG_ERXEAX, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EwGwM, &BX_CPU_C::XCHG_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_XCHG_EwGwR, &BX_CPU_C::XCHG_EwGwR, NULL, 0)
bx_define_opcode(BX_IA_XCHG_RXAX, &BX_CPU_C::XCHG_RXAX, NULL, 0)
bx_define_opcode(BX_IA_XLAT, &BX_CPU_C::XLAT, NULL, 0)
bx_define_opcode(BX_IA_XOR_ALIb, &BX_CPU_C::XOR_ALIb, NULL, 0)
bx_define_opcode(BX_IA_XOR_AXIw, &BX_CPU_C::XOR_AXIw, NULL, 0)
bx_define_opcode(BX_IA_XOR_EAXId, &BX_CPU_C::XOR_EAXId, NULL, 0)
bx_define_opcode(BX_IA_XOR_EbGbM, &BX_CPU_C::XOR_EbGbM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EbIbM, &BX_CPU_C::XOR_EbIbM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EbIbR, &BX_CPU_C::XOR_EbIbR, NULL, 0)
bx_define_opcode(BX_IA_XOR_EdGdM, &BX_CPU_C::XOR_EdGdM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EdIdM, &BX_CPU_C::XOR_EdIdM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EdIdR, &BX_CPU_C::XOR_EdIdR, NULL, 0)
bx_define_opcode(BX_IA_XOR_EwGwM, &BX_CPU_C::XOR_EwGwM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EwIwM, &BX_CPU_C::XOR_EwIwM, NULL, 0)
bx_define_opcode(BX_IA_XOR_EwIwR, &BX_CPU_C::XOR_EwIwR, NULL, 0)
bx_define_opcode(BX_IA_XOR_GbEbM, &BX_CPU_C::LOAD_Eb, &BX_CPU_C::XOR_GbEbR, 0)
bx_define_opcode(BX_IA_XOR_GbEbR, &BX_CPU_C::XOR_GbEbR, NULL, 0)
bx_define_opcode(BX_IA_XOR_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::XOR_GdEdR, 0)
bx_define_opcode(BX_IA_XOR_GdEdR, &BX_CPU_C::XOR_GdEdR, NULL, 0)
bx_define_opcode(BX_IA_XOR_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::XOR_GwEwR, 0)
bx_define_opcode(BX_IA_XOR_GwEwR, &BX_CPU_C::XOR_GwEwR, NULL, 0)

bx_define_opcode(BX_IA_MONITOR, &BX_CPU_C::MONITOR, NULL, BX_CPU_MONITOR_MWAIT)
bx_define_opcode(BX_IA_MWAIT, &BX_CPU_C::MWAIT, NULL, BX_CPU_MONITOR_MWAIT)

bx_define_opcode(BX_IA_FWAIT, &BX_CPU_C::FWAIT, NULL, BX_CPU_X87)
#if BX_SUPPORT_FPU
bx_define_opcode(BX_IA_FLD_STi, &BX_CPU_C::FLD_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLD_SINGLE_REAL, &BX_CPU_C::FLD_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLD_DOUBLE_REAL, &BX_CPU_C::FLD_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLD_EXTENDED_REAL, &BX_CPU_C::FLD_EXTENDED_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FILD_WORD_INTEGER, &BX_CPU_C::FILD_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FILD_DWORD_INTEGER, &BX_CPU_C::FILD_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FILD_QWORD_INTEGER, &BX_CPU_C::FILD_QWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FBLD_PACKED_BCD, &BX_CPU_C::FBLD_PACKED_BCD, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FST_STi, &BX_CPU_C::FST_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSTP_STi, &BX_CPU_C::FST_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FST_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSTP_SINGLE_REAL, &BX_CPU_C::FST_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FST_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSTP_DOUBLE_REAL, &BX_CPU_C::FST_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSTP_EXTENDED_REAL, &BX_CPU_C::FSTP_EXTENDED_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIST_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISTP_WORD_INTEGER, &BX_CPU_C::FIST_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIST_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISTP_DWORD_INTEGER, &BX_CPU_C::FIST_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISTP_QWORD_INTEGER, &BX_CPU_C::FISTP_QWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FBSTP_PACKED_BCD, &BX_CPU_C::FBSTP_PACKED_BCD, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISTTP16, &BX_CPU_C::FISTTP16, NULL, BX_CPU_X87 | BX_CPU_SSE3)
bx_define_opcode(BX_IA_FISTTP32, &BX_CPU_C::FISTTP32, NULL, BX_CPU_X87 | BX_CPU_SSE3)
bx_define_opcode(BX_IA_FISTTP64, &BX_CPU_C::FISTTP64, NULL, BX_CPU_X87 | BX_CPU_SSE3)
bx_define_opcode(BX_IA_FNINIT, &BX_CPU_C::FNINIT, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNCLEX, &BX_CPU_C::FNCLEX, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FRSTOR, &BX_CPU_C::FRSTOR, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNSAVE, &BX_CPU_C::FNSAVE, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDENV, &BX_CPU_C::FLDENV, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNSTENV, &BX_CPU_C::FNSTENV, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDCW, &BX_CPU_C::FLDCW, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNSTCW, &BX_CPU_C::FNSTCW, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNSTSW, &BX_CPU_C::FNSTSW, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNSTSW_AX, &BX_CPU_C::FNSTSW_AX, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLD1, &BX_CPU_C::FLD1, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDL2T, &BX_CPU_C::FLDL2T, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDL2E, &BX_CPU_C::FLDL2E, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDPI, &BX_CPU_C::FLDPI, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDLG2, &BX_CPU_C::FLDLG2, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDLN2, &BX_CPU_C::FLDLN2, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FLDZ, &BX_CPU_C::FLDZ, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FADD_ST0_STj, &BX_CPU_C::FADD_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FADD_STi_ST0, &BX_CPU_C::FADD_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FADD_SINGLE_REAL, &BX_CPU_C::FADD_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FADD_DOUBLE_REAL, &BX_CPU_C::FADD_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIADD_WORD_INTEGER, &BX_CPU_C::FIADD_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIADD_DWORD_INTEGER, &BX_CPU_C::FIADD_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FMUL_ST0_STj, &BX_CPU_C::FMUL_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FMUL_STi_ST0, &BX_CPU_C::FMUL_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FMUL_SINGLE_REAL, &BX_CPU_C::FMUL_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FMUL_DOUBLE_REAL, &BX_CPU_C::FMUL_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIMUL_WORD_INTEGER , &BX_CPU_C::FIMUL_WORD_INTEGER , NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIMUL_DWORD_INTEGER, &BX_CPU_C::FIMUL_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUB_ST0_STj, &BX_CPU_C::FSUB_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUBR_ST0_STj, &BX_CPU_C::FSUBR_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUB_STi_ST0, &BX_CPU_C::FSUB_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUBR_STi_ST0, &BX_CPU_C::FSUBR_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUB_SINGLE_REAL, &BX_CPU_C::FSUB_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUBR_SINGLE_REAL, &BX_CPU_C::FSUBR_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUB_DOUBLE_REAL, &BX_CPU_C::FSUB_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSUBR_DOUBLE_REAL, &BX_CPU_C::FSUBR_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISUB_WORD_INTEGER, &BX_CPU_C::FISUB_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISUBR_WORD_INTEGER, &BX_CPU_C::FISUBR_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISUB_DWORD_INTEGER, &BX_CPU_C::FISUB_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FISUBR_DWORD_INTEGER, &BX_CPU_C::FISUBR_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIV_ST0_STj, &BX_CPU_C::FDIV_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIVR_ST0_STj, &BX_CPU_C::FDIVR_ST0_STj, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIV_STi_ST0, &BX_CPU_C::FDIV_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIVR_STi_ST0, &BX_CPU_C::FDIVR_STi_ST0, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIV_SINGLE_REAL, &BX_CPU_C::FDIV_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIVR_SINGLE_REAL, &BX_CPU_C::FDIVR_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIV_DOUBLE_REAL, &BX_CPU_C::FDIV_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDIVR_DOUBLE_REAL, &BX_CPU_C::FDIVR_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIDIV_WORD_INTEGER, &BX_CPU_C::FIDIV_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIDIVR_WORD_INTEGER, &BX_CPU_C::FIDIVR_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIDIV_DWORD_INTEGER, &BX_CPU_C::FIDIV_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FIDIVR_DWORD_INTEGER, &BX_CPU_C::FIDIVR_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOM_STi, &BX_CPU_C::FCOM_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOMP_STi, &BX_CPU_C::FCOM_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FUCOM_STi, &BX_CPU_C::FUCOM_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FUCOMP_STi, &BX_CPU_C::FUCOM_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOMI_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, NULL, BX_CPU_X87 | BX_CPU_P6)
bx_define_opcode(BX_IA_FCOMIP_ST0_STj, &BX_CPU_C::FCOMI_ST0_STj, NULL, BX_CPU_X87 | BX_CPU_P6)
bx_define_opcode(BX_IA_FUCOMI_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, NULL, BX_CPU_X87 | BX_CPU_P6)
bx_define_opcode(BX_IA_FUCOMIP_ST0_STj, &BX_CPU_C::FUCOMI_ST0_STj, NULL, BX_CPU_X87 | BX_CPU_P6)
bx_define_opcode(BX_IA_FCOM_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOMP_SINGLE_REAL, &BX_CPU_C::FCOM_SINGLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOM_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOMP_DOUBLE_REAL, &BX_CPU_C::FCOM_DOUBLE_REAL, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FICOM_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FICOMP_WORD_INTEGER, &BX_CPU_C::FICOM_WORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FICOM_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FICOMP_DWORD_INTEGER, &BX_CPU_C::FICOM_DWORD_INTEGER, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCMOV_ST0_STj, &BX_CPU_C::FCMOV_ST0_STj, NULL, BX_CPU_X87 | BX_CPU_P6)
bx_define_opcode(BX_IA_FCOMPP, &BX_CPU_C::FCOMPP, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FUCOMPP, &BX_CPU_C::FUCOMPP, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FXCH_STi, &BX_CPU_C::FXCH_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FNOP, &BX_CPU_C::FNOP, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FPLEGACY, &BX_CPU_C::FPLEGACY, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCHS, &BX_CPU_C::FCHS, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FABS, &BX_CPU_C::FABS, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FTST, &BX_CPU_C::FTST, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FXAM, &BX_CPU_C::FXAM, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FDECSTP, &BX_CPU_C::FDECSTP, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FINCSTP, &BX_CPU_C::FINCSTP, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FFREE_STi, &BX_CPU_C::FFREE_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FFREEP_STi, &BX_CPU_C::FFREEP_STi, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_F2XM1, &BX_CPU_C::F2XM1, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FYL2X, &BX_CPU_C::FYL2X, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FPTAN, &BX_CPU_C::FPTAN, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FPATAN, &BX_CPU_C::FPATAN, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FXTRACT, &BX_CPU_C::FXTRACT, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FPREM1, &BX_CPU_C::FPREM1, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FPREM, &BX_CPU_C::FPREM, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FYL2XP1, &BX_CPU_C::FYL2XP1, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSQRT, &BX_CPU_C::FSQRT, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSINCOS, &BX_CPU_C::FSINCOS, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FRNDINT, &BX_CPU_C::FRNDINT, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSCALE, &BX_CPU_C::FSCALE, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FSIN, &BX_CPU_C::FSIN, NULL, BX_CPU_X87)
bx_define_opcode(BX_IA_FCOS, &BX_CPU_C::FCOS, NULL, BX_CPU_X87)
#else
bx_define_opcode(BX_IA_FPU_ESC, &BX_CPU_C::FPU_ESC, NULL, 0)
#endif

// 486 new instructions
bx_define_opcode(BX_IA_CPUID, &BX_CPU_C::CPUID, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_BSWAP_RX, &BX_CPU_C::BSWAP_RX, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_BSWAP_ERX, &BX_CPU_C::BSWAP_ERX, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_INVD, &BX_CPU_C::INVD, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_WBINVD, &BX_CPU_C::WBINVD, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EbGbM, &BX_CPU_C::XADD_EbGbM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EbGbR, &BX_CPU_C::XADD_EbGbR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EdGdM, &BX_CPU_C::XADD_EdGdM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EdGdR, &BX_CPU_C::XADD_EdGdR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EwGwM, &BX_CPU_C::XADD_EwGwM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_XADD_EwGwR, &BX_CPU_C::XADD_EwGwR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EbGbM, &BX_CPU_C::CMPXCHG_EbGbM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EbGbR, &BX_CPU_C::CMPXCHG_EbGbR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EdGdM, &BX_CPU_C::CMPXCHG_EdGdM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EdGdR, &BX_CPU_C::CMPXCHG_EdGdR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EwGwM, &BX_CPU_C::CMPXCHG_EwGwM, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_CMPXCHG_EwGwR, &BX_CPU_C::CMPXCHG_EwGwR, NULL, BX_CPU_486)
bx_define_opcode(BX_IA_INVLPG, &BX_CPU_C::INVLPG, NULL, 0)
// 486 new instructions

// Pentium new instructions
bx_define_opcode(BX_IA_CMPXCHG8B, &BX_CPU_C::CMPXCHG8B, NULL, BX_CPU_PENTIUM)
bx_define_opcode(BX_IA_WRMSR, &BX_CPU_C::WRMSR, NULL, BX_CPU_PENTIUM)
bx_define_opcode(BX_IA_RDMSR, &BX_CPU_C::RDMSR, NULL, BX_CPU_PENTIUM)
bx_define_opcode(BX_IA_RDTSC, &BX_CPU_C::RDTSC, NULL, BX_CPU_PENTIUM)
// Pentium new instructions

// MMX
bx_define_opcode(BX_IA_PUNPCKLBW_PqQd, &BX_CPU_C::PUNPCKLBW_PqQd, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PUNPCKLWD_PqQd, &BX_CPU_C::PUNPCKLWD_PqQd, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PUNPCKLDQ_PqQd, &BX_CPU_C::PUNPCKLDQ_PqQd, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PACKSSWB_PqQq, &BX_CPU_C::PACKSSWB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPGTB_PqQq, &BX_CPU_C::PCMPGTB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPGTW_PqQq, &BX_CPU_C::PCMPGTW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPGTD_PqQq, &BX_CPU_C::PCMPGTD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PACKUSWB_PqQq, &BX_CPU_C::PACKUSWB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PUNPCKHBW_PqQq, &BX_CPU_C::PUNPCKHBW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PUNPCKHWD_PqQq, &BX_CPU_C::PUNPCKHWD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PUNPCKHDQ_PqQq, &BX_CPU_C::PUNPCKHDQ_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PACKSSDW_PqQq, &BX_CPU_C::PACKSSDW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVD_PqEdR, &BX_CPU_C::MOVD_PqEdR, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVD_PqEdM, &BX_CPU_C::MOVD_PqEdM, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVQ_PqQqR, &BX_CPU_C::MOVQ_PqQqR, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVQ_PqQqM, &BX_CPU_C::MOVQ_PqQqM, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPEQB_PqQq, &BX_CPU_C::PCMPEQB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPEQW_PqQq, &BX_CPU_C::PCMPEQW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PCMPEQD_PqQq, &BX_CPU_C::PCMPEQD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_EMMS, &BX_CPU_C::EMMS, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVD_EdPdR, &BX_CPU_C::MOVD_EdPdR, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVD_EdPdM, &BX_CPU_C::MOVD_EdPdM, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVQ_QqPqR, &BX_CPU_C::MOVQ_QqPqR, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_MOVQ_QqPqM, &BX_CPU_C::MOVQ_QqPqM, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLW_PqQq, &BX_CPU_C::PSRLW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLD_PqQq, &BX_CPU_C::PSRLD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLQ_PqQq, &BX_CPU_C::PSRLQ_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PMULLW_PqQq, &BX_CPU_C::PMULLW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBUSB_PqQq, &BX_CPU_C::PSUBUSB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBUSW_PqQq, &BX_CPU_C::PSUBUSW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PAND_PqQq, &BX_CPU_C::PAND_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDUSB_PqQq, &BX_CPU_C::PADDUSB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDUSW_PqQq, &BX_CPU_C::PADDUSW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PANDN_PqQq, &BX_CPU_C::PANDN_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRAW_PqQq, &BX_CPU_C::PSRAW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRAD_PqQq, &BX_CPU_C::PSRAD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PMULHW_PqQq, &BX_CPU_C::PMULHW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBSB_PqQq, &BX_CPU_C::PSUBSB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBSW_PqQq, &BX_CPU_C::PSUBSW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_POR_PqQq, &BX_CPU_C::POR_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDSB_PqQq, &BX_CPU_C::PADDSB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDSW_PqQq, &BX_CPU_C::PADDSW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PXOR_PqQq, &BX_CPU_C::PXOR_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLW_PqQq, &BX_CPU_C::PSLLW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLD_PqQq, &BX_CPU_C::PSLLD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLQ_PqQq, &BX_CPU_C::PSLLQ_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PMADDWD_PqQq, &BX_CPU_C::PMADDWD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBB_PqQq, &BX_CPU_C::PSUBB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBW_PqQq, &BX_CPU_C::PSUBW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSUBD_PqQq, &BX_CPU_C::PSUBD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDB_PqQq, &BX_CPU_C::PADDB_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDW_PqQq, &BX_CPU_C::PADDW_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PADDD_PqQq, &BX_CPU_C::PADDD_PqQq, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLW_PqIb, &BX_CPU_C::PSRLW_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRAW_PqIb, &BX_CPU_C::PSRAW_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLW_PqIb, &BX_CPU_C::PSLLW_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLD_PqIb, &BX_CPU_C::PSRLD_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRAD_PqIb, &BX_CPU_C::PSRAD_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLD_PqIb, &BX_CPU_C::PSLLD_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSRLQ_PqIb, &BX_CPU_C::PSRLQ_PqIb, NULL, BX_CPU_MMX)
bx_define_opcode(BX_IA_PSLLQ_PqIb, &BX_CPU_C::PSLLQ_PqIb, NULL, BX_CPU_MMX)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVQ_EqPqR, &BX_CPU_C::MOVQ_EqPqR, NULL, BX_CPU_MMX | BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_EqPqM, &BX_CPU_C::MOVQ_QqPqM, NULL, BX_CPU_MMX | BX_CPU_X86_64)
#endif
// MMX

bx_define_opcode(BX_IA_FEMMS, &BX_CPU_C::EMMS, NULL, BX_CPU_3DNOW)
#if BX_SUPPORT_3DNOW
bx_define_opcode(BX_IA_PF2ID_PqQq, &BX_CPU_C::PF2ID_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PF2IW_PqQq, &BX_CPU_C::PF2IW_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFACC_PqQq, &BX_CPU_C::PFACC_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFADD_PqQq, &BX_CPU_C::PFADD_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFCMPEQ_PqQq, &BX_CPU_C::PFCMPEQ_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFCMPGE_PqQq, &BX_CPU_C::PFCMPGE_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFCMPGT_PqQq, &BX_CPU_C::PFCMPGT_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFMAX_PqQq, &BX_CPU_C::PFMAX_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFMIN_PqQq, &BX_CPU_C::PFMIN_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFMUL_PqQq, &BX_CPU_C::PFMUL_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFNACC_PqQq, &BX_CPU_C::PFNACC_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFPNACC_PqQq, &BX_CPU_C::PFPNACC_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFRCP_PqQq, &BX_CPU_C::PFRCP_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFRCPIT1_PqQq, &BX_CPU_C::PFRCPIT1_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFRCPIT2_PqQq, &BX_CPU_C::PFRCPIT2_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFRSQIT1_PqQq, &BX_CPU_C::PFRSQIT1_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFRSQRT_PqQq, &BX_CPU_C::PFRSQRT_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFSUB_PqQq, &BX_CPU_C::PFSUB_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PFSUBR_PqQq, &BX_CPU_C::PFSUBR_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PI2FD_PqQq, &BX_CPU_C::PI2FD_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PI2FW_PqQq, &BX_CPU_C::PI2FW_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PMULHRW_PqQq, &BX_CPU_C::PMULHRW_PqQq, NULL, BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PSWAPD_PqQq, &BX_CPU_C::PSWAPD_PqQq, NULL, BX_CPU_3DNOW)
#endif
bx_define_opcode(BX_IA_PREFETCHW, &BX_CPU_C::NOP, NULL, BX_CPU_3DNOW | BX_CPU_X86_64)

// P6 new instructions
bx_define_opcode(BX_IA_CMOVB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVB_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVB_GdEdR, &BX_CPU_C::CMOVB_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVB_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVB_GwEwR, &BX_CPU_C::CMOVB_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVBE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVBE_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVBE_GdEdR, &BX_CPU_C::CMOVBE_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVBE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVBE_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVBE_GwEwR, &BX_CPU_C::CMOVBE_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVL_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVL_GdEdR, &BX_CPU_C::CMOVL_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVL_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVL_GwEwR, &BX_CPU_C::CMOVL_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVLE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVLE_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVLE_GdEdR, &BX_CPU_C::CMOVLE_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVLE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVLE_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVLE_GwEwR, &BX_CPU_C::CMOVLE_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNB_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNB_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNB_GdEdR, &BX_CPU_C::CMOVNB_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNB_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNB_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNB_GwEwR, &BX_CPU_C::CMOVNB_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNBE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNBE_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNBE_GdEdR, &BX_CPU_C::CMOVNBE_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNBE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNBE_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNBE_GwEwR, &BX_CPU_C::CMOVNBE_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNL_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNL_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNL_GdEdR, &BX_CPU_C::CMOVNL_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNL_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNL_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNL_GwEwR, &BX_CPU_C::CMOVNL_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNLE_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNLE_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNLE_GdEdR, &BX_CPU_C::CMOVNLE_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNLE_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNLE_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNLE_GwEwR, &BX_CPU_C::CMOVNLE_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNO_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNO_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNO_GdEdR, &BX_CPU_C::CMOVNO_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNO_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNO_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNO_GwEwR, &BX_CPU_C::CMOVNO_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNP_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNP_GdEdR, &BX_CPU_C::CMOVNP_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNP_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNP_GwEwR, &BX_CPU_C::CMOVNP_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNS_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNS_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNS_GdEdR, &BX_CPU_C::CMOVNS_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNS_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNS_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNS_GwEwR, &BX_CPU_C::CMOVNS_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNZ_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVNZ_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNZ_GdEdR, &BX_CPU_C::CMOVNZ_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNZ_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVNZ_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVNZ_GwEwR, &BX_CPU_C::CMOVNZ_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVO_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVO_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVO_GdEdR, &BX_CPU_C::CMOVO_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVO_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVO_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVO_GwEwR, &BX_CPU_C::CMOVO_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVP_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVP_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVP_GdEdR, &BX_CPU_C::CMOVP_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVP_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVP_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVP_GwEwR, &BX_CPU_C::CMOVP_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVS_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVS_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVS_GdEdR, &BX_CPU_C::CMOVS_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVS_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVS_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVS_GwEwR, &BX_CPU_C::CMOVS_GwEwR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVZ_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::CMOVZ_GdEdR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVZ_GdEdR, &BX_CPU_C::CMOVZ_GdEdR, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVZ_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::CMOVZ_GwEwR, BX_CPU_P6)
bx_define_opcode(BX_IA_CMOVZ_GwEwR, &BX_CPU_C::CMOVZ_GwEwR, NULL, BX_CPU_P6)

bx_define_opcode(BX_IA_RDPMC, &BX_CPU_C::RDPMC, NULL, BX_CPU_P6)
bx_define_opcode(BX_IA_UD2A, &BX_CPU_C::UndefinedOpcode, NULL, 0)
bx_define_opcode(BX_IA_UD2B, &BX_CPU_C::UndefinedOpcode, NULL, 0)
// P6 new instructions

// FXSAVE
bx_define_opcode(BX_IA_FXSAVE, &BX_CPU_C::FXSAVE, NULL, BX_CPU_FXSAVE_FXRSTOR)
bx_define_opcode(BX_IA_FXRSTOR, &BX_CPU_C::FXRSTOR, NULL, BX_CPU_FXSAVE_FXRSTOR)

// SSE
bx_define_opcode(BX_IA_LDMXCSR, &BX_CPU_C::LDMXCSR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_STMXCSR, &BX_CPU_C::STMXCSR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PREFETCH, &BX_CPU_C::PREFETCH, NULL, BX_CPU_SSE)
// SSE

// SSE
bx_define_opcode(BX_IA_ANDPS_VpsWps, &BX_CPU_C::ANDPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_ORPS_VpsWps, &BX_CPU_C::ORPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_XORPS_VpsWps, &BX_CPU_C::XORPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_ANDNPS_VpsWps, &BX_CPU_C::ANDNPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVUPS_VpsWpsR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVUPS_VpsWpsM, &BX_CPU_C::MOVUPS_VpsWpsM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVUPS_WpsVpsR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVUPS_WpsVpsM, &BX_CPU_C::MOVUPS_WpsVpsM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVSS_VssWssR, &BX_CPU_C::MOVSS_VssWssR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVSS_VssWssM, &BX_CPU_C::MOVSS_VssWssM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVSS_WssVssM, &BX_CPU_C::MOVSS_WssVssM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVHLPS_VpsWpsR, &BX_CPU_C::MOVHLPS_VpsWpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVLPS_VpsMq, &BX_CPU_C::MOVLPS_VpsMq, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVLPS_MqVps, &BX_CPU_C::MOVLPS_MqVps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVLHPS_VpsWpsR, &BX_CPU_C::MOVLHPS_VpsWpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVHPS_VpsMq, &BX_CPU_C::MOVHPS_VpsMq, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVHPS_MqVps, &BX_CPU_C::MOVHPS_MqVps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVAPS_VpsWpsR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVAPS_VpsWpsM, &BX_CPU_C::MOVAPS_VpsWpsM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVAPS_WpsVpsR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVAPS_WpsVpsM, &BX_CPU_C::MOVAPS_WpsVpsM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTPI2PS_VpsQqR, &BX_CPU_C::CVTPI2PS_VpsQqR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTPI2PS_VpsQqM, &BX_CPU_C::CVTPI2PS_VpsQqM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTSI2SS_VssEdR, &BX_CPU_C::CVTSI2SS_VssEdR, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTSI2SS_VssEdM, &BX_CPU_C::CVTSI2SS_VssEdM, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVNTPS_MpsVps, &BX_CPU_C::MOVNTPS_MpsVps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTTPS2PI_PqWps, &BX_CPU_C::CVTTPS2PI_PqWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTTSS2SI_GdWss, &BX_CPU_C::CVTTSS2SI_GdWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTPS2PI_PqWps, &BX_CPU_C::CVTPS2PI_PqWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CVTSS2SI_GdWss, &BX_CPU_C::CVTSS2SI_GdWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_UCOMISS_VssWss, &BX_CPU_C::UCOMISS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_COMISS_VpsWps, &BX_CPU_C::COMISS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MOVMSKPS_GdVRps, &BX_CPU_C::MOVMSKPS_GdVRps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_SQRTPS_VpsWps, &BX_CPU_C::SQRTPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_SQRTSS_VssWss, &BX_CPU_C::SQRTSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_RSQRTPS_VpsWps, &BX_CPU_C::RSQRTPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_RSQRTSS_VssWss, &BX_CPU_C::RSQRTSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_RCPPS_VpsWps, &BX_CPU_C::RCPPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_RCPSS_VssWss, &BX_CPU_C::RCPSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_ADDPS_VpsWps, &BX_CPU_C::ADDPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_ADDSS_VssWss, &BX_CPU_C::ADDSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MULPS_VpsWps, &BX_CPU_C::MULPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MULSS_VssWss, &BX_CPU_C::MULSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_SUBPS_VpsWps, &BX_CPU_C::SUBPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_SUBSS_VssWss, &BX_CPU_C::SUBSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MINPS_VpsWps, &BX_CPU_C::MINPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MINSS_VssWss, &BX_CPU_C::MINSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_DIVPS_VpsWps, &BX_CPU_C::DIVPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_DIVSS_VssWss, &BX_CPU_C::DIVSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MAXPS_VpsWps, &BX_CPU_C::MAXPS_VpsWps, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_MAXSS_VssWss, &BX_CPU_C::MAXSS_VssWss, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PSHUFW_PqQqIb, &BX_CPU_C::PSHUFW_PqQqIb, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PSHUFLW_VdqWdqIb, &BX_CPU_C::PSHUFLW_VdqWdqIb, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CMPPS_VpsWpsIb, &BX_CPU_C::CMPPS_VpsWpsIb, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_CMPSS_VssWssIb, &BX_CPU_C::CMPSS_VssWssIb, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PINSRW_PqEwIb, &BX_CPU_C::PINSRW_PqEwIb, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PEXTRW_GdPqIb, &BX_CPU_C::PEXTRW_GdPqIb, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_SHUFPS_VpsWpsIb, &BX_CPU_C::SHUFPS_VpsWpsIb, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PMOVMSKB_GdPRq, &BX_CPU_C::PMOVMSKB_GdPRq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PMINUB_PqQq, &BX_CPU_C::PMINUB_PqQq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PMAXUB_PqQq, &BX_CPU_C::PMAXUB_PqQq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PAVGB_PqQq, &BX_CPU_C::PAVGB_PqQq, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PAVGW_PqQq, &BX_CPU_C::PAVGW_PqQq, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PMULHUW_PqQq, &BX_CPU_C::PMULHUW_PqQq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_MOVNTQ_MqPq, &BX_CPU_C::MOVNTQ_MqPq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PMINSW_PqQq, &BX_CPU_C::PMINSW_PqQq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_PMAXSW_PqQq, &BX_CPU_C::PMAXSW_PqQq, NULL, BX_CPU_SSE)
bx_define_opcode(BX_IA_PSADBW_PqQq, &BX_CPU_C::PSADBW_PqQq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
bx_define_opcode(BX_IA_MASKMOVQ_PqPRq, &BX_CPU_C::MASKMOVQ_PqPRq, NULL, BX_CPU_SSE | BX_CPU_3DNOW)
// SSE

// SSE2
bx_define_opcode(BX_IA_MOVSD_VsdWsdR, &BX_CPU_C::MOVSD_VsdWsdR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVSD_VsdWsdM, &BX_CPU_C::MOVQ_VqWqM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVSD_WsdVsdM, &BX_CPU_C::MOVQ_WqVqM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPI2PD_VpdQqR, &BX_CPU_C::CVTPI2PD_VpdQqR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPI2PD_VpdQqM, &BX_CPU_C::CVTPI2PD_VpdQqM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEdR, &BX_CPU_C::CVTSI2SD_VsdEdR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTSI2SD_VsdEdM, &BX_CPU_C::CVTSI2SD_VsdEdM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTTPD2PI_PqWpd, &BX_CPU_C::CVTTPD2PI_PqWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTTSD2SI_GdWsd, &BX_CPU_C::CVTTSD2SI_GdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPD2PI_PqWpd, &BX_CPU_C::CVTPD2PI_PqWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTSD2SI_GdWsd, &BX_CPU_C::CVTSD2SI_GdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_UCOMISD_VsdWsd, &BX_CPU_C::UCOMISD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_COMISD_VpdWpd, &BX_CPU_C::COMISD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVMSKPD_GdVRpd, &BX_CPU_C::MOVMSKPD_GdVRpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SQRTPD_VpdWpd, &BX_CPU_C::SQRTPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SQRTSD_VsdWsd, &BX_CPU_C::SQRTSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_ADDPD_VpdWpd, &BX_CPU_C::ADDPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_ADDSD_VsdWsd, &BX_CPU_C::ADDSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MULPD_VpdWpd, &BX_CPU_C::MULPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MULSD_VsdWsd, &BX_CPU_C::MULSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPS2PD_VpsWps, &BX_CPU_C::CVTPS2PD_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPD2PS_VpdWpd, &BX_CPU_C::CVTPD2PS_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTSD2SS_VsdWsd, &BX_CPU_C::CVTSD2SS_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTSS2SD_VssWss, &BX_CPU_C::CVTSS2SD_VssWss, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTDQ2PS_VpsWdq, &BX_CPU_C::CVTDQ2PS_VpsWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPS2DQ_VdqWps, &BX_CPU_C::CVTPS2DQ_VdqWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTTPS2DQ_VdqWps, &BX_CPU_C::CVTTPS2DQ_VdqWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SUBPD_VpdWpd, &BX_CPU_C::SUBPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SUBSD_VsdWsd, &BX_CPU_C::SUBSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MINPD_VpdWpd, &BX_CPU_C::MINPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MINSD_VsdWsd, &BX_CPU_C::MINSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_DIVPD_VpdWpd, &BX_CPU_C::DIVPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_DIVSD_VsdWsd, &BX_CPU_C::DIVSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MAXPD_VpdWpd, &BX_CPU_C::MAXPD_VpdWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MAXSD_VsdWsd, &BX_CPU_C::MAXSD_VsdWsd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_UNPCKHPD_VpdWdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_UNPCKLPD_VpdWdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKHDQ_VdqWdq, &BX_CPU_C::UNPCKHPS_VpsWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKLDQ_VdqWdq, &BX_CPU_C::UNPCKLPS_VpsWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVAPD_VpdWpdR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVAPD_VpdWpdM, &BX_CPU_C::MOVAPS_VpsWpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVAPD_WpdVpdR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVAPD_WpdVpdM, &BX_CPU_C::MOVAPS_WpsVpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQA_VdqWdqR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQA_VdqWdqM, &BX_CPU_C::MOVAPS_VpsWpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQA_WdqVdqR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQA_WdqVdqM, &BX_CPU_C::MOVAPS_WpsVpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQU_VdqWdqR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQU_VdqWdqM, &BX_CPU_C::MOVUPS_VpsWpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQU_WdqVdqR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQU_WdqVdqM, &BX_CPU_C::MOVUPS_WpsVpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVHPD_MqVsd, &BX_CPU_C::MOVHPS_MqVps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVHPD_VsdMq, &BX_CPU_C::MOVHPS_VpsMq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVLPD_MqVsd, &BX_CPU_C::MOVLPS_MqVps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVLPD_VsdMq, &BX_CPU_C::MOVLPS_VpsMq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVNTDQ_MdqVdq, &BX_CPU_C::MOVNTPS_MpsVps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVNTPD_MpdVpd, &BX_CPU_C::MOVNTPS_MpsVps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVUPD_VpdWpdR, &BX_CPU_C::MOVAPS_VpsWpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVUPD_VpdWpdM, &BX_CPU_C::MOVUPS_VpsWpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVUPD_WpdVpdR, &BX_CPU_C::MOVAPS_WpsVpsR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVUPD_WpdVpdM, &BX_CPU_C::MOVUPS_WpsVpsM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_ANDNPD_VpdWpd, &BX_CPU_C::ANDNPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_ANDPD_VpdWpd, &BX_CPU_C::ANDPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_ORPD_VpdWpd, &BX_CPU_C::ORPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PAND_VdqWdq, &BX_CPU_C::ANDPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PANDN_VdqWdq, &BX_CPU_C::ANDNPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_POR_VdqWdq, &BX_CPU_C::ORPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PXOR_VdqWdq, &BX_CPU_C::XORPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_XORPD_VpdWpd, &BX_CPU_C::XORPS_VpsWps, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKLBW_VdqWdq, &BX_CPU_C::PUNPCKLBW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKLWD_VdqWdq, &BX_CPU_C::PUNPCKLWD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_UNPCKLPS_VpsWdq, &BX_CPU_C::UNPCKLPS_VpsWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PACKSSWB_VdqWdq, &BX_CPU_C::PACKSSWB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPGTB_VdqWdq, &BX_CPU_C::PCMPGTB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPGTW_VdqWdq, &BX_CPU_C::PCMPGTW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPGTD_VdqWdq, &BX_CPU_C::PCMPGTD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PACKUSWB_VdqWdq, &BX_CPU_C::PACKUSWB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKHBW_VdqWdq, &BX_CPU_C::PUNPCKHBW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKHWD_VdqWdq, &BX_CPU_C::PUNPCKHWD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_UNPCKHPS_VpsWdq, &BX_CPU_C::UNPCKHPS_VpsWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PACKSSDW_VdqWdq, &BX_CPU_C::PACKSSDW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKLQDQ_VdqWdq, &BX_CPU_C::PUNPCKLQDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PUNPCKHQDQ_VdqWdq, &BX_CPU_C::PUNPCKHQDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVD_VdqEdR, &BX_CPU_C::MOVD_VdqEdR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVD_VdqEdM, &BX_CPU_C::MOVSS_VssWssM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSHUFD_VdqWdqIb, &BX_CPU_C::PSHUFD_VdqWdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSHUFHW_VdqWdqIb, &BX_CPU_C::PSHUFHW_VdqWdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPEQB_VdqWdq, &BX_CPU_C::PCMPEQB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPEQW_VdqWdq, &BX_CPU_C::PCMPEQW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PCMPEQD_VdqWdq, &BX_CPU_C::PCMPEQD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVD_EdVdR, &BX_CPU_C::MOVD_EdVdR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVD_EdVdM, &BX_CPU_C::MOVD_EdVdM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVQ_VqWqR, &BX_CPU_C::MOVQ_VqWqR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVQ_VqWqM, &BX_CPU_C::MOVQ_VqWqM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CMPPD_VpdWpdIb, &BX_CPU_C::CMPPD_VpdWpdIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CMPSD_VsdWsdIb, &BX_CPU_C::CMPSD_VsdWsdIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVNTI_MdGd, &BX_CPU_C::MOVNTI_MdGd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PINSRW_VdqEwIb, &BX_CPU_C::PINSRW_VdqEwIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PEXTRW_GdUdqIb, &BX_CPU_C::PEXTRW_GdUdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SHUFPD_VpdWpdIb, &BX_CPU_C::SHUFPD_VpdWpdIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLW_VdqWdq, &BX_CPU_C::PSRLW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLD_VdqWdq, &BX_CPU_C::PSRLD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLQ_VdqWdq, &BX_CPU_C::PSRLQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDQ_PqQq, &BX_CPU_C::PADDQ_PqQq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDQ_VdqWdq, &BX_CPU_C::PADDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMULLW_VdqWdq, &BX_CPU_C::PMULLW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVQ_WqVqR, &BX_CPU_C::MOVQ_WqVqR, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVQ_WqVqM, &BX_CPU_C::MOVQ_WqVqM, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVDQ2Q_PqVRq, &BX_CPU_C::MOVDQ2Q_PqVRq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MOVQ2DQ_VdqQq, &BX_CPU_C::MOVQ2DQ_VdqQq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMOVMSKB_GdUdq, &BX_CPU_C::PMOVMSKB_GdUdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBUSB_VdqWdq, &BX_CPU_C::PSUBUSB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBUSW_VdqWdq, &BX_CPU_C::PSUBUSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMINUB_VdqWdq, &BX_CPU_C::PMINUB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDUSB_VdqWdq, &BX_CPU_C::PADDUSB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDUSW_VdqWdq, &BX_CPU_C::PADDUSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMAXUB_VdqWdq, &BX_CPU_C::PMAXUB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PAVGB_VdqWdq, &BX_CPU_C::PAVGB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRAW_VdqWdq, &BX_CPU_C::PSRAW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRAD_VdqWdq, &BX_CPU_C::PSRAD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PAVGW_VdqWdq, &BX_CPU_C::PAVGW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMULHUW_VdqWdq, &BX_CPU_C::PMULHUW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMULHW_VdqWdq, &BX_CPU_C::PMULHW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTTPD2DQ_VqWpd, &BX_CPU_C::CVTTPD2DQ_VqWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTPD2DQ_VqWpd, &BX_CPU_C::CVTPD2DQ_VqWpd, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_CVTDQ2PD_VpdWq, &BX_CPU_C::CVTDQ2PD_VpdWq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBSB_VdqWdq, &BX_CPU_C::PSUBSB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBSW_VdqWdq, &BX_CPU_C::PSUBSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMINSW_VdqWdq, &BX_CPU_C::PMINSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDSB_VdqWdq, &BX_CPU_C::PADDSB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDSW_VdqWdq, &BX_CPU_C::PADDSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMAXSW_VdqWdq, &BX_CPU_C::PMAXSW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLW_VdqWdq, &BX_CPU_C::PSLLW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLD_VdqWdq, &BX_CPU_C::PSLLD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLQ_VdqWdq, &BX_CPU_C::PSLLQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMULUDQ_PqQq, &BX_CPU_C::PMULUDQ_PqQq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMULUDQ_VdqWdq, &BX_CPU_C::PMULUDQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PMADDWD_VdqWdq, &BX_CPU_C::PMADDWD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSADBW_VdqWdq, &BX_CPU_C::PSADBW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MASKMOVDQU_VdqUdq, &BX_CPU_C::MASKMOVDQU_VdqUdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBB_VdqWdq, &BX_CPU_C::PSUBB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBW_VdqWdq, &BX_CPU_C::PSUBW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBD_VdqWdq, &BX_CPU_C::PSUBD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBQ_PqQq, &BX_CPU_C::PSUBQ_PqQq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSUBQ_VdqWdq, &BX_CPU_C::PSUBQ_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDB_VdqWdq, &BX_CPU_C::PADDB_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDW_VdqWdq, &BX_CPU_C::PADDW_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PADDD_VdqWdq, &BX_CPU_C::PADDD_VdqWdq, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLW_UdqIb, &BX_CPU_C::PSRLW_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRAW_UdqIb, &BX_CPU_C::PSRAW_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLW_UdqIb, &BX_CPU_C::PSLLW_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLD_UdqIb, &BX_CPU_C::PSRLD_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRAD_UdqIb, &BX_CPU_C::PSRAD_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLD_UdqIb, &BX_CPU_C::PSLLD_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLQ_UdqIb, &BX_CPU_C::PSRLQ_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSRLDQ_UdqIb, &BX_CPU_C::PSRLDQ_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLQ_UdqIb, &BX_CPU_C::PSLLQ_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_PSLLDQ_UdqIb, &BX_CPU_C::PSLLDQ_UdqIb, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_LFENCE, &BX_CPU_C::NOP, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_SFENCE, &BX_CPU_C::NOP, NULL, BX_CPU_SSE2)
bx_define_opcode(BX_IA_MFENCE, &BX_CPU_C::NOP, NULL, BX_CPU_SSE2)
// SSE2

// SSE3
bx_define_opcode(BX_IA_MOVDDUP_VpdWq, &BX_CPU_C::MOVDDUP_VpdWq, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_MOVSLDUP_VpsWps, &BX_CPU_C::MOVSLDUP_VpsWps, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_MOVSHDUP_VpsWps, &BX_CPU_C::MOVSHDUP_VpsWps, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_HADDPD_VpdWpd, &BX_CPU_C::HADDPD_VpdWpd, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_HADDPS_VpsWps, &BX_CPU_C::HADDPS_VpsWps, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_HSUBPD_VpdWpd, &BX_CPU_C::HSUBPD_VpdWpd, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_HSUBPS_VpsWps, &BX_CPU_C::HSUBPS_VpsWps, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_ADDSUBPD_VpdWpd, &BX_CPU_C::ADDSUBPD_VpdWpd, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_ADDSUBPS_VpsWps, &BX_CPU_C::ADDSUBPS_VpsWps, NULL, BX_CPU_SSE3)
bx_define_opcode(BX_IA_LDDQU_VdqMdq, &BX_CPU_C::LDDQU_VdqMdq, NULL, BX_CPU_SSE3)
// SSE3

// SSSE3
bx_define_opcode(BX_IA_PSHUFB_PqQq, &BX_CPU_C::PSHUFB_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDW_PqQq, &BX_CPU_C::PHADDW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDD_PqQq, &BX_CPU_C::PHADDD_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDSW_PqQq, &BX_CPU_C::PHADDSW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PMADDUBSW_PqQq, &BX_CPU_C::PMADDUBSW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBSW_PqQq, &BX_CPU_C::PHSUBSW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBW_PqQq, &BX_CPU_C::PHSUBW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBD_PqQq, &BX_CPU_C::PHSUBD_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGNB_PqQq, &BX_CPU_C::PSIGNB_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGNW_PqQq, &BX_CPU_C::PSIGNW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGND_PqQq, &BX_CPU_C::PSIGND_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PMULHRSW_PqQq, &BX_CPU_C::PMULHRSW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSB_PqQq, &BX_CPU_C::PABSB_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSW_PqQq, &BX_CPU_C::PABSW_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSD_PqQq, &BX_CPU_C::PABSD_PqQq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PALIGNR_PqQqIb, &BX_CPU_C::PALIGNR_PqQqIb, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSHUFB_VdqWdq, &BX_CPU_C::PSHUFB_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDW_VdqWdq, &BX_CPU_C::PHADDW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDD_VdqWdq, &BX_CPU_C::PHADDD_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHADDSW_VdqWdq, &BX_CPU_C::PHADDSW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PMADDUBSW_VdqWdq, &BX_CPU_C::PMADDUBSW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBSW_VdqWdq, &BX_CPU_C::PHSUBSW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBW_VdqWdq, &BX_CPU_C::PHSUBW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PHSUBD_VdqWdq, &BX_CPU_C::PHSUBD_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGNB_VdqWdq, &BX_CPU_C::PSIGNB_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGNW_VdqWdq, &BX_CPU_C::PSIGNW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PSIGND_VdqWdq, &BX_CPU_C::PSIGND_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PMULHRSW_VdqWdq, &BX_CPU_C::PMULHRSW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSB_VdqWdq, &BX_CPU_C::PABSB_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSW_VdqWdq, &BX_CPU_C::PABSW_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PABSD_VdqWdq, &BX_CPU_C::PABSD_VdqWdq, NULL, BX_CPU_SSSE3)
bx_define_opcode(BX_IA_PALIGNR_VdqWdqIb, &BX_CPU_C::PALIGNR_VdqWdqIb, NULL, BX_CPU_SSSE3)
// SSSE3

// SSE4.1
bx_define_opcode(BX_IA_PBLENDVB_VdqWdq, &BX_CPU_C::PBLENDVB_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_BLENDVPS_VpsWps, &BX_CPU_C::BLENDVPS_VpsWps, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_BLENDVPD_VpdWpd, &BX_CPU_C::BLENDVPD_VpdWpd, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PTEST_VdqWdq, &BX_CPU_C::PTEST_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMULDQ_VdqWdq, &BX_CPU_C::PMULDQ_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PCMPEQQ_VdqWdq, &BX_CPU_C::PCMPEQQ_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PACKUSDW_VdqWdq, &BX_CPU_C::PACKUSDW_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXBW_VdqWq, &BX_CPU_C::PMOVSXBW_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXBD_VdqWd, &BX_CPU_C::PMOVSXBD_VdqWd, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXBQ_VdqWw, &BX_CPU_C::PMOVSXBQ_VdqWw, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXWD_VdqWq, &BX_CPU_C::PMOVSXWD_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXWQ_VdqWd, &BX_CPU_C::PMOVSXWQ_VdqWd, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVSXDQ_VdqWq, &BX_CPU_C::PMOVSXDQ_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXBW_VdqWq, &BX_CPU_C::PMOVZXBW_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXBD_VdqWd, &BX_CPU_C::PMOVZXBD_VdqWd, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXBQ_VdqWw, &BX_CPU_C::PMOVZXBQ_VdqWw, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXWD_VdqWq, &BX_CPU_C::PMOVZXWD_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXWQ_VdqWd, &BX_CPU_C::PMOVZXWQ_VdqWd, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMOVZXDQ_VdqWq, &BX_CPU_C::PMOVZXDQ_VdqWq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMINSB_VdqWdq, &BX_CPU_C::PMINSB_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMINSD_VdqWdq, &BX_CPU_C::PMINSD_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMINUW_VdqWdq, &BX_CPU_C::PMINUW_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMINUD_VdqWdq, &BX_CPU_C::PMINUD_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMAXSB_VdqWdq, &BX_CPU_C::PMAXSB_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMAXSD_VdqWdq, &BX_CPU_C::PMAXSD_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMAXUW_VdqWdq, &BX_CPU_C::PMAXUW_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMAXUD_VdqWdq, &BX_CPU_C::PMAXUD_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PMULLD_VdqWdq, &BX_CPU_C::PMULLD_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PHMINPOSUW_VdqWdq, &BX_CPU_C::PHMINPOSUW_VdqWdq, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_ROUNDPS_VpsWpsIb, &BX_CPU_C::ROUNDPS_VpsWpsIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_ROUNDPD_VpdWpdIb, &BX_CPU_C::ROUNDPD_VpdWpdIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_ROUNDSS_VssWssIb, &BX_CPU_C::ROUNDSS_VssWssIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_ROUNDSD_VsdWsdIb, &BX_CPU_C::ROUNDSD_VsdWsdIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_BLENDPS_VpsWpsIb, &BX_CPU_C::BLENDPS_VpsWpsIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_BLENDPD_VpdWpdIb, &BX_CPU_C::BLENDPD_VpdWpdIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PBLENDW_VdqWdqIb, &BX_CPU_C::PBLENDW_VdqWdqIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PEXTRB_EbdVdqIb, &BX_CPU_C::PEXTRB_EbdVdqIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PEXTRW_EwdVdqIb, &BX_CPU_C::PEXTRW_EwdVdqIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PEXTRD_EdVdqIb, &BX_CPU_C::PEXTRD_EdVdqIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_EXTRACTPS_EdVpsIb, &BX_CPU_C::EXTRACTPS_EdVpsIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PINSRB_VdqEbIb, &BX_CPU_C::PINSRB_VdqEbIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_INSERTPS_VpsWssIb, &BX_CPU_C::INSERTPS_VpsWssIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_PINSRD_VdqEdIb, &BX_CPU_C::PINSRD_VdqEdIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_DPPS_VpsWpsIb, &BX_CPU_C::DPPS_VpsWpsIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_DPPD_VpdWpdIb, &BX_CPU_C::DPPD_VpdWpdIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_MPSADBW_VdqWdqIb, &BX_CPU_C::MPSADBW_VdqWdqIb, NULL, BX_CPU_SSE4_1)
bx_define_opcode(BX_IA_MOVNTDQA_VdqMdq, &BX_CPU_C::MOVNTDQA_VdqMdq, NULL, BX_CPU_SSE4_1)
// SSE4.1

// SSE4.2
bx_define_opcode(BX_IA_CRC32_GdEb, &BX_CPU_C::CRC32_GdEb, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_CRC32_GdEw, &BX_CPU_C::CRC32_GdEw, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_CRC32_GdEd, &BX_CPU_C::CRC32_GdEd, NULL, BX_CPU_SSE4_2)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_CRC32_GdEq, &BX_CPU_C::CRC32_GdEq, NULL, BX_CPU_SSE4_2 | BX_CPU_X86_64)
#endif
bx_define_opcode(BX_IA_PCMPGTQ_VdqWdq, &BX_CPU_C::PCMPGTQ_VdqWdq, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_PCMPESTRM_VdqWdqIb, &BX_CPU_C::PCMPESTRM_VdqWdqIb, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_PCMPESTRI_VdqWdqIb, &BX_CPU_C::PCMPESTRI_VdqWdqIb, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_PCMPISTRM_VdqWdqIb, &BX_CPU_C::PCMPISTRM_VdqWdqIb, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_PCMPISTRI_VdqWdqIb, &BX_CPU_C::PCMPISTRI_VdqWdqIb, NULL, BX_CPU_SSE4_2)
// SSE4.2

// MOVBE instruction
bx_define_opcode(BX_IA_MOVBE_GwEw, &BX_CPU_C::MOVBE_GwEw, NULL, BX_CPU_MOVBE)
bx_define_opcode(BX_IA_MOVBE_GdEd, &BX_CPU_C::MOVBE_GdEd, NULL, BX_CPU_MOVBE)
bx_define_opcode(BX_IA_MOVBE_EwGw, &BX_CPU_C::MOVBE_EwGw, NULL, BX_CPU_MOVBE)
bx_define_opcode(BX_IA_MOVBE_EdGd, &BX_CPU_C::MOVBE_EdGd, NULL, BX_CPU_MOVBE)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_MOVBE_GqEq, &BX_CPU_C::MOVBE_GqEq, NULL, BX_CPU_MOVBE | BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVBE_EqGq, &BX_CPU_C::MOVBE_EqGq, NULL, BX_CPU_MOVBE | BX_CPU_X86_64)
#endif
// MOVBE instruction

// POPCNT instruction
bx_define_opcode(BX_IA_POPCNT_GdEdR, &BX_CPU_C::POPCNT_GdEdR, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_POPCNT_GdEdM, &BX_CPU_C::LOAD_Ed, &BX_CPU_C::POPCNT_GdEdR, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_POPCNT_GwEwR, &BX_CPU_C::POPCNT_GwEwR, NULL, BX_CPU_SSE4_2)
bx_define_opcode(BX_IA_POPCNT_GwEwM, &BX_CPU_C::LOAD_Ew, &BX_CPU_C::POPCNT_GwEwR, BX_CPU_SSE4_2)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_POPCNT_GqEqR, &BX_CPU_C::POPCNT_GqEqR, NULL, BX_CPU_SSE4_2 | BX_CPU_X86_64)
bx_define_opcode(BX_IA_POPCNT_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::POPCNT_GqEqR, BX_CPU_SSE4_2 | BX_CPU_X86_64)
#endif
// POPCNT instruction

// XSAVE extensions
bx_define_opcode(BX_IA_XRSTOR, &BX_CPU_C::XRSTOR, NULL, BX_CPU_XSAVE)
bx_define_opcode(BX_IA_XSAVE, &BX_CPU_C::XSAVE, NULL, BX_CPU_XSAVE)
bx_define_opcode(BX_IA_XSETBV, &BX_CPU_C::XSETBV, NULL, BX_CPU_XSAVE)
bx_define_opcode(BX_IA_XGETBV, &BX_CPU_C::XGETBV, NULL, BX_CPU_XSAVE)

// AES instructions
bx_define_opcode(BX_IA_AESIMC_VdqWdq, &BX_CPU_C::AESIMC_VdqWdq, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_AESENC_VdqWdq, &BX_CPU_C::AESENC_VdqWdq, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_AESENCLAST_VdqWdq, &BX_CPU_C::AESENCLAST_VdqWdq, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_AESDEC_VdqWdq, &BX_CPU_C::AESDEC_VdqWdq, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_AESDECLAST_VdqWdq, &BX_CPU_C::AESDECLAST_VdqWdq, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_AESKEYGENASSIST_VdqWdqIb, &BX_CPU_C::AESKEYGENASSIST_VdqWdqIb, NULL, BX_CPU_AES_PCLMULQDQ)
bx_define_opcode(BX_IA_PCLMULQDQ_VdqWdqIb, &BX_CPU_C::PCLMULQDQ_VdqWdqIb, NULL, BX_CPU_AES_PCLMULQDQ)

#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_ADD_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADD_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::OR_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::ADC_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SBB_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::AND_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::SUB_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::XOR_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMP_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADD_GqEqR, &BX_CPU_C::ADD_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_GqEqR, &BX_CPU_C::OR_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_GqEqR, &BX_CPU_C::ADC_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_GqEqR, &BX_CPU_C::SBB_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_GqEqR, &BX_CPU_C::AND_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_GqEqR, &BX_CPU_C::SUB_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_GqEqR, &BX_CPU_C::XOR_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_GqEqR, &BX_CPU_C::CMP_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADD_RAXId, &BX_CPU_C::ADD_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_RAXId, &BX_CPU_C::OR_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_RAXId, &BX_CPU_C::ADC_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_RAXId, &BX_CPU_C::SBB_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_RAXId, &BX_CPU_C::AND_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_RAXId, &BX_CPU_C::SUB_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_RAXId, &BX_CPU_C::XOR_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_RAXId, &BX_CPU_C::CMP_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADD_EqGqM, &BX_CPU_C::ADD_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_EqGqM, &BX_CPU_C::OR_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_EqGqM, &BX_CPU_C::ADC_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_EqGqM, &BX_CPU_C::SBB_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_EqGqM, &BX_CPU_C::AND_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_EqGqM, &BX_CPU_C::SUB_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_EqGqM, &BX_CPU_C::XOR_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_EqGqM, &BX_CPU_C::CMP_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADD_EqIdM, &BX_CPU_C::ADD_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_EqIdM, &BX_CPU_C::OR_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_EqIdM, &BX_CPU_C::ADC_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_EqIdM, &BX_CPU_C::SBB_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_EqIdM, &BX_CPU_C::AND_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_EqIdM, &BX_CPU_C::SUB_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_EqIdM, &BX_CPU_C::XOR_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_EqIdM, &BX_CPU_C::CMP_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADD_EqIdR, &BX_CPU_C::ADD_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_OR_EqIdR, &BX_CPU_C::OR_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ADC_EqIdR, &BX_CPU_C::ADC_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SBB_EqIdR, &BX_CPU_C::SBB_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_AND_EqIdR, &BX_CPU_C::AND_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SUB_EqIdR, &BX_CPU_C::SUB_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XOR_EqIdR, &BX_CPU_C::XOR_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMP_EqIdR, &BX_CPU_C::CMP_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_TEST_EqGqR, &BX_CPU_C::TEST_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_TEST_EqGqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqGqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_TEST_RAXId, &BX_CPU_C::TEST_RAXId, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XCHG_EqGqR, &BX_CPU_C::XCHG_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XCHG_EqGqM, &BX_CPU_C::XCHG_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LEA_GqM, &BX_CPU_C::LEA_GqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV64_EdGdM, &BX_CPU_C::MOV64_EdGdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV64_GdEdM, &BX_CPU_C::MOV64_GdEdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_RAXOq, &BX_CPU_C::MOV_RAXOq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_OqRAX, &BX_CPU_C::MOV_OqRAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_EAXOq, &BX_CPU_C::MOV_EAXOq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_OqEAX, &BX_CPU_C::MOV_OqEAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_AXOq, &BX_CPU_C::MOV_AXOq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_OqAX, &BX_CPU_C::MOV_OqAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_ALOq, &BX_CPU_C::MOV_ALOq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_OqAL, &BX_CPU_C::MOV_OqAL, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_EqGqM, &BX_CPU_C::MOV_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_GqEqR, &BX_CPU_C::MOV_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_GqEqM, &BX_CPU_C::MOV_GqEqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_EqIdR, &BX_CPU_C::MOV_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_EqIdM, &BX_CPU_C::MOV_EqIdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_REP_MOVSQ_XqYq, &BX_CPU_C::REP_MOVSQ_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_REP_CMPSQ_XqYq, &BX_CPU_C::REP_CMPSQ_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_REP_STOSQ_YqRAX, &BX_CPU_C::REP_STOSQ_YqRAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_REP_LODSQ_RAXXq, &BX_CPU_C::REP_LODSQ_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_REP_SCASQ_RAXXq, &BX_CPU_C::REP_SCASQ_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPSB64_XbYb, &BX_CPU_C::CMPSB64_XbYb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPSW64_XwYw, &BX_CPU_C::CMPSW64_XwYw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPSD64_XdYd, &BX_CPU_C::CMPSD64_XdYd, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SCASB64_ALXb, &BX_CPU_C::SCASB64_ALXb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SCASW64_AXXw, &BX_CPU_C::SCASW64_AXXw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SCASD64_EAXXd, &BX_CPU_C::SCASD64_EAXXd, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LODSB64_ALXb, &BX_CPU_C::LODSB64_ALXb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LODSW64_AXXw, &BX_CPU_C::LODSW64_AXXw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LODSD64_EAXXd, &BX_CPU_C::LODSD64_EAXXd, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_STOSB64_YbAL, &BX_CPU_C::STOSB64_YbAL, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_STOSW64_YwAX, &BX_CPU_C::STOSW64_YwAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_STOSD64_YdEAX, &BX_CPU_C::STOSD64_YdEAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSB64_XbYb, &BX_CPU_C::MOVSB64_XbYb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSW64_XwYw, &BX_CPU_C::MOVSW64_XwYw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSD64_XdYd, &BX_CPU_C::MOVSD64_XdYd, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPSQ32_XqYq, &BX_CPU_C::CMPSQ32_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPSQ64_XqYq, &BX_CPU_C::CMPSQ64_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SCASQ32_RAXXq, &BX_CPU_C::SCASQ32_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SCASQ64_RAXXq, &BX_CPU_C::SCASQ64_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LODSQ32_RAXXq, &BX_CPU_C::LODSQ32_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LODSQ64_RAXXq, &BX_CPU_C::LODSQ64_RAXXq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_STOSQ32_YqRAX, &BX_CPU_C::STOSQ32_YqRAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_STOSQ64_YqRAX, &BX_CPU_C::STOSQ64_YqRAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSQ32_XqYq, &BX_CPU_C::MOVSQ32_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSQ64_XqYq, &BX_CPU_C::MOVSQ64_XqYq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CALL_Jq, &BX_CPU_C::CALL_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JMP_Jq, &BX_CPU_C::JMP_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JO_Jq, &BX_CPU_C::JO_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNO_Jq, &BX_CPU_C::JNO_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JB_Jq, &BX_CPU_C::JB_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNB_Jq, &BX_CPU_C::JNB_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JZ_Jq, &BX_CPU_C::JZ_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNZ_Jq, &BX_CPU_C::JNZ_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JBE_Jq, &BX_CPU_C::JBE_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNBE_Jq, &BX_CPU_C::JNBE_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JS_Jq, &BX_CPU_C::JS_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNS_Jq, &BX_CPU_C::JNS_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JP_Jq, &BX_CPU_C::JP_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNP_Jq, &BX_CPU_C::JNP_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JL_Jq, &BX_CPU_C::JL_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNL_Jq, &BX_CPU_C::JNL_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JLE_Jq, &BX_CPU_C::JLE_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JNLE_Jq, &BX_CPU_C::JNLE_Jq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ENTER64_IwIb, &BX_CPU_C::ENTER64_IwIb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LEAVE64, &BX_CPU_C::LEAVE64, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IRET64, &BX_CPU_C::IRET64, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_CqRq, &BX_CPU_C::MOV_CqRq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_DqRq, &BX_CPU_C::MOV_DqRq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_RqCq, &BX_CPU_C::MOV_RqCq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_RqDq, &BX_CPU_C::MOV_RqDq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHLD_EqGqR, &BX_CPU_C::SHLD_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHLD_EqGqM, &BX_CPU_C::SHLD_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHRD_EqGqR, &BX_CPU_C::SHRD_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHRD_EqGqM, &BX_CPU_C::SHRD_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_GqEqR, &BX_CPU_C::IMUL_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_GqEqIdR, &BX_CPU_C::IMUL_GqEqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_GqEqIdM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_GqEqIdR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVZX_GqEbM, &BX_CPU_C::MOVZX_GqEbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVZX_GqEwM, &BX_CPU_C::MOVZX_GqEwM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEbM, &BX_CPU_C::MOVSX_GqEbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEwM, &BX_CPU_C::MOVSX_GqEwM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEdM, &BX_CPU_C::MOVSX_GqEdM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVZX_GqEbR, &BX_CPU_C::MOVZX_GqEbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVZX_GqEwR, &BX_CPU_C::MOVZX_GqEwR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEbR, &BX_CPU_C::MOVSX_GqEbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEwR, &BX_CPU_C::MOVSX_GqEwR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVSX_GqEdR, &BX_CPU_C::MOVSX_GqEdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BSF_GqEqR, &BX_CPU_C::BSF_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BSF_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSF_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BSR_GqEqR, &BX_CPU_C::BSR_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BSR_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::BSR_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BT_EqGqM, &BX_CPU_C::BT_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTS_EqGqM, &BX_CPU_C::BTS_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTR_EqGqM, &BX_CPU_C::BTR_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTC_EqGqM, &BX_CPU_C::BTC_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BT_EqGqR, &BX_CPU_C::BT_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTS_EqGqR, &BX_CPU_C::BTS_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTR_EqGqR, &BX_CPU_C::BTR_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTC_EqGqR, &BX_CPU_C::BTC_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BT_EqIbM, &BX_CPU_C::BT_EqIbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTS_EqIbM, &BX_CPU_C::BTS_EqIbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTR_EqIbM, &BX_CPU_C::BTR_EqIbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTC_EqIbM, &BX_CPU_C::BTC_EqIbM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BT_EqIbR, &BX_CPU_C::BT_EqIbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTS_EqIbR, &BX_CPU_C::BTS_EqIbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTR_EqIbR, &BX_CPU_C::BTR_EqIbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BTC_EqIbR, &BX_CPU_C::BTC_EqIbR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_BSWAP_RRX, &BX_CPU_C::BSWAP_RRX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ROL_EqM, &BX_CPU_C::ROL_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ROR_EqM, &BX_CPU_C::ROR_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RCL_EqM, &BX_CPU_C::RCL_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RCR_EqM, &BX_CPU_C::RCR_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHL_EqM, &BX_CPU_C::SHL_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHR_EqM, &BX_CPU_C::SHR_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SAR_EqM, &BX_CPU_C::SAR_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ROL_EqR, &BX_CPU_C::ROL_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_ROR_EqR, &BX_CPU_C::ROR_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RCL_EqR, &BX_CPU_C::RCL_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RCR_EqR, &BX_CPU_C::RCR_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHL_EqR, &BX_CPU_C::SHL_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SHR_EqR, &BX_CPU_C::SHR_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SAR_EqR, &BX_CPU_C::SAR_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_NOT_EqM, &BX_CPU_C::NOT_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_NEG_EqM, &BX_CPU_C::NEG_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_NOT_EqR, &BX_CPU_C::NOT_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_NEG_EqR, &BX_CPU_C::NEG_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_TEST_EqIdM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::TEST_EqIdR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_TEST_EqIdR, &BX_CPU_C::TEST_EqIdR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MUL_RAXEqR, &BX_CPU_C::MUL_RAXEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MUL_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::MUL_RAXEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_RAXEqR, &BX_CPU_C::IMUL_RAXEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IMUL_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IMUL_RAXEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_DIV_RAXEqR, &BX_CPU_C::DIV_RAXEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_DIV_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::DIV_RAXEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IDIV_RAXEqR, &BX_CPU_C::IDIV_RAXEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_IDIV_RAXEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::IDIV_RAXEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_INC_EqM, &BX_CPU_C::INC_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_DEC_EqM, &BX_CPU_C::DEC_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_INC_EqR, &BX_CPU_C::INC_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_DEC_EqR, &BX_CPU_C::DEC_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CALL_EqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CALL_EqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CALL_EqR, &BX_CPU_C::CALL_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CALL64_Ep, &BX_CPU_C::CALL64_Ep, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JMP_EqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::JMP_EqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JMP_EqR, &BX_CPU_C::JMP_EqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JMP64_Ep, &BX_CPU_C::JMP64_Ep, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSHF_Fq, &BX_CPU_C::PUSHF_Fq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POPF_Fq, &BX_CPU_C::POPF_Fq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPXCHG_EqGqR, &BX_CPU_C::CMPXCHG_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPXCHG_EqGqM, &BX_CPU_C::CMPXCHG_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CDQE, &BX_CPU_C::CDQE, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CQO, &BX_CPU_C::CQO, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XADD_EqGqR, &BX_CPU_C::XADD_EqGqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XADD_EqGqM, &BX_CPU_C::XADD_EqGqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RETnear64_Iw, &BX_CPU_C::RETnear64_Iw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RETnear64, &BX_CPU_C::RETnear64, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RETfar64_Iw, &BX_CPU_C::RETfar64_Iw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RETfar64, &BX_CPU_C::RETfar64_Iw, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVO_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVO_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNO_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNO_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVB_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNB_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNB_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVZ_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVZ_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNZ_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNZ_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVBE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVBE_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNBE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNBE_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVS_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVS_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNS_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNS_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVP_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNP_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNP_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVL_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNL_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNL_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVLE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVLE_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNLE_GqEqM, &BX_CPU_C::LOAD_Eq, &BX_CPU_C::CMOVNLE_GqEqR, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVO_GqEqR, &BX_CPU_C::CMOVO_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNO_GqEqR, &BX_CPU_C::CMOVNO_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVB_GqEqR, &BX_CPU_C::CMOVB_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNB_GqEqR, &BX_CPU_C::CMOVNB_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVZ_GqEqR, &BX_CPU_C::CMOVZ_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNZ_GqEqR, &BX_CPU_C::CMOVNZ_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVBE_GqEqR, &BX_CPU_C::CMOVBE_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNBE_GqEqR, &BX_CPU_C::CMOVNBE_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVS_GqEqR, &BX_CPU_C::CMOVS_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNS_GqEqR, &BX_CPU_C::CMOVNS_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVP_GqEqR, &BX_CPU_C::CMOVP_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNP_GqEqR, &BX_CPU_C::CMOVNP_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVL_GqEqR, &BX_CPU_C::CMOVL_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNL_GqEqR, &BX_CPU_C::CMOVNL_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVLE_GqEqR, &BX_CPU_C::CMOVLE_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMOVNLE_GqEqR, &BX_CPU_C::CMOVNLE_GqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOV_RRXIq, &BX_CPU_C::MOV_RRXIq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH_EqM, &BX_CPU_C::PUSH_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH_EqR, &BX_CPU_C::PUSH_RRX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH_RRX, &BX_CPU_C::PUSH_RRX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POP_EqM, &BX_CPU_C::POP_EqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POP_EqR, &BX_CPU_C::POP_RRX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POP_RRX, &BX_CPU_C::POP_RRX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_XCHG_RRXRAX, &BX_CPU_C::XCHG_RRXRAX, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH64_Id, &BX_CPU_C::PUSH64_Id, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH64_FS, &BX_CPU_C::PUSH64_FS, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POP64_FS, &BX_CPU_C::POP64_FS, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_PUSH64_GS, &BX_CPU_C::PUSH64_GS, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_POP64_GS, &BX_CPU_C::POP64_GS, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LSS_GqMp, &BX_CPU_C::LSS_GqMp, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LFS_GqMp, &BX_CPU_C::LFS_GqMp, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LGS_GqMp, &BX_CPU_C::LGS_GqMp, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SGDT64_Ms, &BX_CPU_C::SGDT64_Ms, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SIDT64_Ms, &BX_CPU_C::SIDT64_Ms, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LGDT64_Ms, &BX_CPU_C::LGDT64_Ms, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LIDT64_Ms, &BX_CPU_C::LIDT64_Ms, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SWAPGS, &BX_CPU_C::SWAPGS, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_RDTSCP, &BX_CPU_C::RDTSCP, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_CMPXCHG16B, &BX_CPU_C::CMPXCHG16B, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LOOPNE64_Jb, &BX_CPU_C::LOOPNE64_Jb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LOOPE64_Jb, &BX_CPU_C::LOOPE64_Jb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_LOOP64_Jb, &BX_CPU_C::LOOP64_Jb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_JRCXZ_Jb, &BX_CPU_C::JRCXZ_Jb, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_EqVqR, &BX_CPU_C::MOVQ_EqVqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_EqVqM, &BX_CPU_C::MOVQ_WqVqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_PqEqR, &BX_CPU_C::MOVQ_PqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_PqEqM, &BX_CPU_C::MOVQ_PqQqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_VdqEqR, &BX_CPU_C::MOVQ_VdqEqR, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVQ_VdqEqM, &BX_CPU_C::MOVQ_VqWqM, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_MOVNTI_MqGq, &BX_CPU_C::MOVNTI_MqGq, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SYSCALL, &BX_CPU_C::SYSCALL, NULL, BX_CPU_X86_64)
bx_define_opcode(BX_IA_SYSRET, &BX_CPU_C::SYSRET, NULL, BX_CPU_X86_64)
#endif

// VMX
bx_define_opcode(BX_IA_VMXON_Mq, &BX_CPU_C::VMXON, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMXOFF, &BX_CPU_C::VMXOFF, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMCALL, &BX_CPU_C::VMCALL, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMLAUNCH, &BX_CPU_C::VMLAUNCH, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMRESUME, &BX_CPU_C::VMLAUNCH, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMCLEAR_Mq, &BX_CPU_C::VMCLEAR, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMPTRLD_Mq, &BX_CPU_C::VMPTRLD, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMPTRST_Mq, &BX_CPU_C::VMPTRST, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMREAD_EdGd, &BX_CPU_C::VMREAD, NULL, BX_CPU_VMX)
bx_define_opcode(BX_IA_VMWRITE_GdEd, &BX_CPU_C::VMWRITE, NULL, BX_CPU_VMX)
#if BX_SUPPORT_X86_64
bx_define_opcode(BX_IA_VMREAD_EqGq, &BX_CPU_C::VMREAD, NULL, BX_CPU_X86_64 | BX_CPU_VMX)
bx_define_opcode(BX_IA_VMWRITE_GqEq, &BX_CPU_C::VMWRITE, NULL, BX_CPU_X86_64 | BX_CPU_VMX)
#endif
bx_define_opcode(BX_IA_INVEPT, &BX_CPU_C::INVEPT, NULL, BX_CPU_X86_64 | BX_CPU_VMX)
bx_define_opcode(BX_IA_INVVPID, &BX_CPU_C::INVVPID, NULL, BX_CPU_X86_64 | BX_CPU_VMX)
// VMX
