-- automatically generated by BNF Converter
module Main where


import IO ( stdin, hGetContents )
import System ( getArgs, getProgName )

import LexBNF
import ParBNF
import SkelBNF
import PrintBNF
import AbsBNF


import ErrM

type ParseFun a = [Token] -> Err a

myLLexer = myLexer

runFile :: (Print a, Show a) => ParseFun a -> FilePath -> IO ()
runFile p f = readFile f >>= run p

run :: (Print a, Show a) => ParseFun a -> String -> IO ()
run p s = case (p (myLLexer s)) of
           Bad s    -> do  putStrLn "\nParse Failed...\n"
                           putStrLn s
           Ok  tree -> do putStrLn "\nParse Successful!"
                          putStrLn $ "\n[Abstract Syntax]\n\n" ++ show tree
                          putStrLn $ "\n[Linearized tree]\n\n" ++ printTree tree


main :: IO ()
main = do args <- getArgs
          case args of
            []  -> hGetContents stdin >>= run pGrammar
            [f] -> runFile pGrammar f
            _   -> do progName <- getProgName
                      putStrLn $ progName ++ ": excess arguments."
